/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.stat.StatLog;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class BufferedStatLog
implements StatLog {
    private final I2PAppContext _context;
    private final Log _log;
    private final StatEvent[] _events;
    private int _eventNext;
    private int _lastWrite;
    private int _flushFrequency;
    private final List<String> _statFilters;
    private String _lastFilters;
    private BufferedWriter _out;
    private String _outFile;
    private volatile boolean _filtersSpecified;
    private static final int BUFFER_SIZE = 1024;
    private static final boolean DISABLE_LOGGING = false;

    public BufferedStatLog(I2PAppContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(BufferedStatLog.class);
        this._events = new StatEvent[1024];
        for (int i = 0; i < 1024; ++i) {
            this._events[i] = new StatEvent();
        }
        this._eventNext = 0;
        this._lastWrite = this._events.length - 1;
        this._statFilters = new ArrayList<String>(10);
        this._flushFrequency = 500;
        this.updateFilters();
        I2PThread writer = new I2PThread(new StatLogWriter(), "StatLogWriter");
        writer.setDaemon(true);
        writer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addData(String scope, String stat, long value, long duration) {
        if (!this.shouldLog(stat)) {
            return;
        }
        StatEvent[] statEventArray = this._events;
        synchronized (this._events) {
            this._events[this._eventNext].init(scope, stat, value, duration);
            this._eventNext = (this._eventNext + 1) % this._events.length;
            if (this._eventNext == this._lastWrite) {
                this._lastWrite = (this._lastWrite + 1) % this._events.length;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("AddData next=" + this._eventNext + " lastWrite=" + this._lastWrite);
            }
            if (this._eventNext > this._lastWrite) {
                if (this._eventNext - this._lastWrite >= this._flushFrequency) {
                    this._events.notifyAll();
                }
            } else if (this._events.length - 1 - this._lastWrite + this._eventNext >= this._flushFrequency) {
                this._events.notifyAll();
            }
            // ** MonitorExit[var7_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldLog(String stat) {
        if (!this._filtersSpecified) {
            return false;
        }
        List<String> list = this._statFilters;
        synchronized (list) {
            return this._statFilters.contains(stat) || this._statFilters.contains("*");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilters() {
        Object tok;
        String val = this._context.getProperty("stat.logFilters");
        if (val != null) {
            if (this._lastFilters == null || !this._lastFilters.equals(val)) {
                tok = new StringTokenizer(val, ",");
                List<String> list = this._statFilters;
                synchronized (list) {
                    this._statFilters.clear();
                    while (((StringTokenizer)tok).hasMoreTokens()) {
                        this._statFilters.add(((StringTokenizer)tok).nextToken().trim());
                    }
                    this._filtersSpecified = !this._statFilters.isEmpty();
                }
            }
            this._lastFilters = val;
        } else {
            tok = this._statFilters;
            synchronized (tok) {
                this._statFilters.clear();
                this._filtersSpecified = false;
            }
        }
        String filename = this._context.getProperty("stat.logFile", "stats.log");
        File foo = new File(filename);
        if (!foo.isAbsolute()) {
            filename = new File(this._context.getRouterDir(), filename).getAbsolutePath();
        }
        if (this._outFile == null || !this._outFile.equals(filename)) {
            if (this._out != null) {
                try {
                    this._out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._outFile = filename;
            try {
                this._out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._outFile, true), "UTF-8"), 32768);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private class StatEvent {
        private long _time;
        private String _scope;
        private String _stat;
        private long _value;
        private long _duration;

        private StatEvent() {
        }

        public long getTime() {
            return this._time;
        }

        public String getScope() {
            return this._scope;
        }

        public String getStat() {
            return this._stat;
        }

        public long getValue() {
            return this._value;
        }

        public long getDuration() {
            return this._duration;
        }

        public void init(String scope, String stat, long value, long duration) {
            this._scope = scope;
            this._stat = stat;
            this._value = value;
            this._duration = duration;
            this._time = BufferedStatLog.this._context.clock().now();
        }
    }

    private class StatLogWriter
    implements Runnable {
        private final SimpleDateFormat _fmt = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");

        private StatLogWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int writeStart = -1;
            int writeEnd = -1;
            block7: while (true) {
                try {
                    while (true) {
                        StatEvent[] statEventArray = BufferedStatLog.this._events;
                        synchronized (statEventArray) {
                            if (BufferedStatLog.this._eventNext > BufferedStatLog.this._lastWrite) {
                                if (BufferedStatLog.this._eventNext - BufferedStatLog.this._lastWrite < BufferedStatLog.this._flushFrequency) {
                                    BufferedStatLog.this._events.wait(30000L);
                                }
                            } else if (BufferedStatLog.this._events.length - 1 - BufferedStatLog.this._lastWrite + BufferedStatLog.this._eventNext < BufferedStatLog.this._flushFrequency) {
                                BufferedStatLog.this._events.wait(30000L);
                            }
                            writeStart = (BufferedStatLog.this._lastWrite + 1) % BufferedStatLog.this._events.length;
                            writeEnd = BufferedStatLog.this._eventNext;
                            BufferedStatLog.this._lastWrite = writeEnd == 0 ? BufferedStatLog.this._events.length - 1 : writeEnd - 1;
                        }
                        if (writeStart == writeEnd) continue;
                        try {
                            if (BufferedStatLog.this._log.shouldLog(10)) {
                                BufferedStatLog.this._log.debug("writing " + writeStart + "->" + writeEnd);
                            }
                            this.writeEvents(writeStart, writeEnd);
                            continue block7;
                        }
                        catch (Exception e) {
                            BufferedStatLog.this._log.error("error writing " + writeStart + "->" + writeEnd, e);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeEvents(int start, int end) {
            try {
                BufferedStatLog.this.updateFilters();
                int cur = start;
                while (cur != end) {
                    String when = null;
                    SimpleDateFormat simpleDateFormat = this._fmt;
                    synchronized (simpleDateFormat) {
                        when = this._fmt.format(new Date(BufferedStatLog.this._events[cur].getTime()));
                    }
                    BufferedStatLog.this._out.write(when);
                    BufferedStatLog.this._out.write(" ");
                    if (BufferedStatLog.this._events[cur].getScope() == null) {
                        BufferedStatLog.this._out.write("noScope");
                    } else {
                        BufferedStatLog.this._out.write(BufferedStatLog.this._events[cur].getScope());
                    }
                    BufferedStatLog.this._out.write(" ");
                    BufferedStatLog.this._out.write(BufferedStatLog.this._events[cur].getStat());
                    BufferedStatLog.this._out.write(" ");
                    BufferedStatLog.this._out.write(Long.toString(BufferedStatLog.this._events[cur].getValue()));
                    BufferedStatLog.this._out.write(" ");
                    BufferedStatLog.this._out.write(Long.toString(BufferedStatLog.this._events[cur].getDuration()));
                    BufferedStatLog.this._out.write("\n");
                    cur = (cur + 1) % BufferedStatLog.this._events.length;
                }
                BufferedStatLog.this._out.flush();
            }
            catch (IOException ioe) {
                BufferedStatLog.this._log.error("Error writing out", ioe);
            }
        }
    }
}

