/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.KeyCertificate;
import net.i2p.data.Signature;

public class Certificate
extends DataStructureImpl {
    public static final Certificate NULL_CERT = new NullCert();
    protected int _type;
    protected byte[] _payload;
    public static final int CERTIFICATE_TYPE_NULL = 0;
    public static final int CERTIFICATE_TYPE_HASHCASH = 1;
    public static final int CERTIFICATE_TYPE_HIDDEN = 2;
    public static final int CERTIFICATE_TYPE_SIGNED = 3;
    public static final int CERTIFICATE_LENGTH_SIGNED_WITH_HASH = Signature.SIGNATURE_BYTES + 32;
    public static final int CERTIFICATE_TYPE_MULTIPLE = 4;
    public static final int CERTIFICATE_TYPE_KEY = 5;

    public static Certificate create(byte[] data, int off) throws DataFormatException {
        byte[] payload;
        int length;
        int type;
        try {
            type = data[off] & 0xFF;
            length = (int)DataHelper.fromLong(data, off + 1, 2);
            if (type == 0 && length == 0) {
                return NULL_CERT;
            }
            if (length == 0) {
                return new Certificate(type, null);
            }
            payload = new byte[length];
            System.arraycopy(data, off + 3, payload, 0, length);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new DataFormatException("not enough bytes", aioobe);
        }
        if (type == 5) {
            if (length == 4) {
                if (Arrays.equals(payload, KeyCertificate.Ed25519_PAYLOAD)) {
                    return KeyCertificate.ELG_Ed25519_CERT;
                }
                if (Arrays.equals(payload, KeyCertificate.ECDSA256_PAYLOAD)) {
                    return KeyCertificate.ELG_ECDSA256_CERT;
                }
            }
            try {
                return new KeyCertificate(payload);
            }
            catch (DataFormatException dfe) {
                throw new IllegalArgumentException(dfe);
            }
        }
        return new Certificate(type, payload);
    }

    public static Certificate create(InputStream in) throws DataFormatException, IOException {
        int type = (int)DataHelper.readLong(in, 1);
        int length = (int)DataHelper.readLong(in, 2);
        if (type == 0 && length == 0) {
            return NULL_CERT;
        }
        if (length == 0) {
            return new Certificate(type, null);
        }
        byte[] payload = new byte[length];
        int read = DataHelper.read(in, payload);
        if (read != length) {
            throw new DataFormatException("Not enough bytes for the payload (read: " + read + " length: " + length + ')');
        }
        if (type == 5) {
            if (length == 4) {
                if (Arrays.equals(payload, KeyCertificate.Ed25519_PAYLOAD)) {
                    return KeyCertificate.ELG_Ed25519_CERT;
                }
                if (Arrays.equals(payload, KeyCertificate.ECDSA256_PAYLOAD)) {
                    return KeyCertificate.ELG_ECDSA256_CERT;
                }
            }
            return new KeyCertificate(payload);
        }
        return new Certificate(type, payload);
    }

    public Certificate() {
    }

    public Certificate(int type, byte[] payload) {
        if (type < 0) {
            throw new IllegalArgumentException();
        }
        this._type = type;
        this._payload = payload;
    }

    public int getCertificateType() {
        return this._type;
    }

    public void setCertificateType(int type) {
        if (type < 0) {
            throw new IllegalArgumentException();
        }
        if (this._type != 0 && this._type != type) {
            throw new IllegalStateException("already set");
        }
        this._type = type;
    }

    public byte[] getPayload() {
        return this._payload;
    }

    public void setPayload(byte[] payload) {
        if (this._payload != null) {
            throw new IllegalStateException("already set");
        }
        this._payload = payload;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._type != 0 || this._payload != null) {
            throw new IllegalStateException("already set");
        }
        this._type = (int)DataHelper.readLong(in, 1);
        int length = (int)DataHelper.readLong(in, 2);
        if (length > 0) {
            this._payload = new byte[length];
            int read = this.read(in, this._payload);
            if (read != length) {
                throw new DataFormatException("Not enough bytes for the payload (read: " + read + " length: " + length + ")");
            }
        }
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._type < 0) {
            throw new DataFormatException("Invalid certificate type: " + this._type);
        }
        DataHelper.writeLong(out, 1, this._type);
        if (this._payload != null) {
            DataHelper.writeLong(out, 2, this._payload.length);
            out.write(this._payload);
        } else {
            DataHelper.writeLong(out, 2, 0L);
        }
    }

    public int writeBytes(byte[] target, int offset) {
        int cur = offset;
        DataHelper.toLong(target, cur, 1, this._type);
        ++cur;
        if (this._payload != null) {
            DataHelper.toLong(target, cur, 2, this._payload.length);
            System.arraycopy(this._payload, 0, target, cur += 2, this._payload.length);
            cur += this._payload.length;
        } else {
            DataHelper.toLong(target, cur, 2, 0L);
            cur += 2;
        }
        return cur - offset;
    }

    public int readBytes(byte[] source, int offset) throws DataFormatException {
        if (this._type != 0 || this._payload != null) {
            throw new IllegalStateException("already set");
        }
        if (source == null) {
            throw new DataFormatException("Cert is null");
        }
        if (source.length < offset + 3) {
            throw new DataFormatException("Cert is too small [" + source.length + " off=" + offset + "]");
        }
        int cur = offset;
        this._type = (int)DataHelper.fromLong(source, cur, 1);
        int length = (int)DataHelper.fromLong(source, ++cur, 2);
        cur += 2;
        if (length > 0) {
            if (length + cur > source.length) {
                throw new DataFormatException("Payload on the certificate is insufficient (len=" + source.length + " off=" + offset + " cur=" + cur + " payloadLen=" + length);
            }
            this._payload = new byte[length];
            System.arraycopy(source, cur, this._payload, 0, length);
            cur += length;
        }
        return cur - offset;
    }

    public int size() {
        return 3 + (this._payload != null ? this._payload.length : 0);
    }

    public KeyCertificate toKeyCertificate() throws DataFormatException {
        if (this._type != 5) {
            throw new DataFormatException("type");
        }
        return new KeyCertificate(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Certificate)) {
            return false;
        }
        Certificate cert = (Certificate)object;
        return this._type == cert.getCertificateType() && Arrays.equals(this._payload, cert.getPayload());
    }

    public int hashCode() {
        return this._type + DataHelper.hashCode(this._payload);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[Certificate: type: ");
        if (this.getCertificateType() == 0) {
            buf.append("Null");
        } else if (this.getCertificateType() == 5) {
            buf.append("Key");
        } else if (this.getCertificateType() == 1) {
            buf.append("HashCash");
        } else if (this.getCertificateType() == 2) {
            buf.append("Hidden");
        } else if (this.getCertificateType() == 3) {
            buf.append("Signed");
        } else {
            buf.append("Unknown type (").append(this.getCertificateType()).append(')');
        }
        if (this._payload == null) {
            buf.append(" payload: null");
        } else {
            buf.append(" payload size: ").append(this._payload.length);
            if (this.getCertificateType() == 1) {
                buf.append(" Stamp: ").append(DataHelper.getUTF8(this._payload));
            } else if (this.getCertificateType() == 3 && this._payload.length == CERTIFICATE_LENGTH_SIGNED_WITH_HASH) {
                buf.append(" Signed by hash: ").append(Base64.encode(this._payload, Signature.SIGNATURE_BYTES, 32));
            } else {
                int len = 32;
                if (len > this._payload.length) {
                    len = this._payload.length;
                }
                buf.append(" first ").append(len).append(" bytes: ");
                buf.append(DataHelper.toString(this._payload, len));
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private static final class NullCert
    extends Certificate {
        private static final int NULL_LENGTH = 3;
        private static final byte[] NULL_DATA = new byte[3];

        @Override
        public void setCertificateType(int type) {
            throw new RuntimeException("Data already set");
        }

        @Override
        public void setPayload(byte[] payload) {
            throw new RuntimeException("Data already set");
        }

        @Override
        public void readBytes(InputStream in) throws DataFormatException, IOException {
            throw new RuntimeException("Data already set");
        }

        @Override
        public void writeBytes(OutputStream out) throws IOException {
            out.write(NULL_DATA);
        }

        @Override
        public int writeBytes(byte[] target, int offset) {
            System.arraycopy(NULL_DATA, 0, target, offset, 3);
            return 3;
        }

        @Override
        public int readBytes(byte[] source, int offset) throws DataFormatException {
            throw new RuntimeException("Data already set");
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

