/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import freenet.support.CPUInformation.CPUID;
import freenet.support.CPUInformation.UnknownCPUException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.i2p.I2PAppContext;
import net.i2p.crypto.AESEngine;
import net.i2p.crypto.CryptixRijndael_Algorithm;
import net.i2p.crypto.CryptoCheck;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SystemVersion;

public class CryptixAESEngine
extends AESEngine {
    private static final CryptixRijndael_Algorithm _algo = new CryptixRijndael_Algorithm();
    private static final boolean USE_FAKE_CRYPTO = false;
    private static final int MIN_SYSTEM_AES_LENGTH = 704;
    private static final boolean USE_SYSTEM_AES = CryptixAESEngine.hasAESNI() && CryptoCheck.isUnlimited();

    private static boolean hasAESNI() {
        if (SystemVersion.isX86() && SystemVersion.is64Bit() && SystemVersion.isJava7() && !SystemVersion.isApache() && !SystemVersion.isGNU()) {
            try {
                return CPUID.getInfo().hasAES();
            }
            catch (UnknownCPUException e) {
                return false;
            }
        }
        return false;
    }

    public CryptixAESEngine(I2PAppContext context) {
        super(context);
    }

    @Override
    public void encrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int length) {
        this.encrypt(payload, payloadIndex, out, outIndex, sessionKey, iv, 0, length);
    }

    @Override
    public void encrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int ivOffset, int length) {
        block12: {
            if (payload == null) {
                throw new NullPointerException("invalid args to aes - payload");
            }
            if (out == null) {
                throw new NullPointerException("invalid args to aes - out");
            }
            if (sessionKey == null) {
                throw new NullPointerException("invalid args to aes - sessionKey");
            }
            if (iv == null) {
                throw new NullPointerException("invalid args to aes - iv");
            }
            if (payload.length < payloadIndex + length) {
                throw new IllegalArgumentException("Payload is too short");
            }
            if (out.length < outIndex + length) {
                throw new IllegalArgumentException("Output is too short");
            }
            if (length <= 0) {
                throw new IllegalArgumentException("Length is too small");
            }
            if (length % 16 != 0) {
                throw new IllegalArgumentException("Only lengths mod 16 are supported here");
            }
            if (USE_SYSTEM_AES && length >= 704) {
                try {
                    SecretKeySpec key = new SecretKeySpec(sessionKey.getData(), "AES");
                    IvParameterSpec ivps = new IvParameterSpec(iv, ivOffset, 16);
                    Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                    cipher.init(1, (Key)key, ivps, (SecureRandom)this._context.random());
                    cipher.doFinal(payload, payloadIndex, length, out, outIndex);
                    return;
                }
                catch (GeneralSecurityException gse) {
                    if (!this._log.shouldLog(30)) break block12;
                    this._log.warn("Java encrypt fail", gse);
                }
            }
        }
        int numblock = length / 16;
        DataHelper.xor(iv, ivOffset, payload, payloadIndex, out, outIndex, 16);
        this.encryptBlock(out, outIndex, sessionKey, out, outIndex);
        for (int x = 1; x < numblock; ++x) {
            DataHelper.xor(out, outIndex + (x - 1) * 16, payload, payloadIndex + x * 16, out, outIndex + x * 16, 16);
            this.encryptBlock(out, outIndex + x * 16, sessionKey, out, outIndex + x * 16);
        }
    }

    @Override
    public void decrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int length) {
        this.decrypt(payload, payloadIndex, out, outIndex, sessionKey, iv, 0, length);
    }

    @Override
    public void decrypt(byte[] payload, int payloadIndex, byte[] out, int outIndex, SessionKey sessionKey, byte[] iv, int ivOffset, int length) {
        block10: {
            if (iv == null || payload == null || payload.length <= 0 || sessionKey == null) {
                throw new IllegalArgumentException("bad setup");
            }
            if (out == null) {
                throw new IllegalArgumentException("out is null");
            }
            if (out.length - outIndex < length) {
                throw new IllegalArgumentException("out is too small (out.length=" + out.length + " outIndex=" + outIndex + " length=" + length);
            }
            if (USE_SYSTEM_AES && length >= 704) {
                try {
                    SecretKeySpec key = new SecretKeySpec(sessionKey.getData(), "AES");
                    IvParameterSpec ivps = new IvParameterSpec(iv, ivOffset, 16);
                    Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                    cipher.init(2, (Key)key, ivps, (SecureRandom)this._context.random());
                    cipher.doFinal(payload, payloadIndex, length, out, outIndex);
                    return;
                }
                catch (GeneralSecurityException gse) {
                    if (!this._log.shouldLog(30)) break block10;
                    this._log.warn("Java decrypt fail", gse);
                }
            }
        }
        int numblock = length / 16;
        if (length % 16 != 0) {
            ++numblock;
            if (this._log.shouldLog(30)) {
                this._log.warn("not %16 " + length, new Exception());
            }
        }
        byte[] prev = SimpleByteCache.acquire(16);
        byte[] cur = SimpleByteCache.acquire(16);
        System.arraycopy(iv, ivOffset, prev, 0, 16);
        for (int x = 0; x < numblock; ++x) {
            System.arraycopy(payload, payloadIndex, cur, 0, 16);
            this.decryptBlock(payload, payloadIndex, sessionKey, out, outIndex);
            payloadIndex += 16;
            for (int i = 0; i < 16; ++i) {
                int n = outIndex++;
                out[n] = (byte)(out[n] ^ prev[i]);
            }
            iv = prev;
            prev = cur;
            cur = iv;
        }
        SimpleByteCache.release(prev);
        SimpleByteCache.release(cur);
    }

    @Override
    public final void encryptBlock(byte[] payload, int inIndex, SessionKey sessionKey, byte[] out, int outIndex) {
        if (sessionKey.getPreparedKey() == null) {
            try {
                Object key = CryptixRijndael_Algorithm.makeKey(sessionKey.getData(), 16);
                sessionKey.setPreparedKey(key);
            }
            catch (InvalidKeyException ike) {
                this._log.log(50, "Invalid key", ike);
                throw new IllegalArgumentException("wtf, invalid key?  " + ike.getMessage());
            }
        }
        CryptixRijndael_Algorithm.blockEncrypt(payload, out, inIndex, outIndex, sessionKey.getPreparedKey());
    }

    @Override
    public final void decryptBlock(byte[] payload, int inIndex, SessionKey sessionKey, byte[] rv, int outIndex) {
        if (sessionKey.getPreparedKey() == null) {
            try {
                Object key = CryptixRijndael_Algorithm.makeKey(sessionKey.getData(), 16);
                sessionKey.setPreparedKey(key);
            }
            catch (InvalidKeyException ike) {
                this._log.log(50, "Invalid key", ike);
                throw new IllegalArgumentException("wtf, invalid key?  " + ike.getMessage());
            }
        }
        CryptixRijndael_Algorithm.blockDecrypt(payload, rv, inIndex, outIndex, sessionKey.getPreparedKey());
    }
}

