/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.util.Log;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

public class CertUtil {
    private static final int LINE_LENGTH = 64;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveCert(Certificate cert, File file) {
        OutputStream os = null;
        PrintWriter wr = null;
        try {
            byte[] buf = cert.getEncoded();
            os = new SecureFileOutputStream(file);
            wr = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            wr.println("-----BEGIN CERTIFICATE-----");
            String b64 = Base64.encode(buf, true);
            for (int i = 0; i < b64.length(); i += 64) {
                wr.println(b64.substring(i, Math.min(i + 64, b64.length())));
            }
            wr.println("-----END CERTIFICATE-----");
            wr.flush();
            if (wr.checkError()) {
                throw new IOException("Failed write to " + file);
            }
            boolean bl = true;
            return bl;
        }
        catch (CertificateEncodingException cee) {
            CertUtil.error("Error writing X509 Certificate " + file.getAbsolutePath(), cee);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            CertUtil.error("Error writing X509 Certificate " + file.getAbsolutePath(), ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getSubjectValue(X509Certificate cert, String type) {
        if (SystemVersion.isAndroid()) {
            CertUtil.error("Don't call this in Android", new UnsupportedOperationException("I did it"));
            return null;
        }
        type = type.toUpperCase(Locale.US);
        X500Principal p = cert.getSubjectX500Principal();
        String subj = p.getName();
        try {
            LdapName name = new LdapName(subj);
            for (Rdn rdn : name.getRdns()) {
                if (!type.equals(rdn.getType().toUpperCase(Locale.US))) continue;
                return (String)rdn.getValue();
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return null;
    }

    private static void error(String msg, Throwable t) {
        CertUtil.log(I2PAppContext.getGlobalContext(), 40, msg, t);
    }

    private static void log(I2PAppContext ctx, int level, String msg, Throwable t) {
        Log l = ctx.logManager().getLog(CertUtil.class);
        l.log(level, msg, t);
    }
}

