/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.stat.Frequency;
import net.i2p.stat.FrequencyStat;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

public class StatsGenerator {
    private RouterContext _context;
    private static final DecimalFormat _fmt = new DecimalFormat("###,##0.0##");
    private static final DecimalFormat _pct = new DecimalFormat("#0.00%");

    public StatsGenerator(RouterContext context) {
        this._context = context;
    }

    public void generateStatsPage(Writer out, boolean showAll) throws IOException {
        StringBuilder buf = new StringBuilder(16384);
        buf.append("<div class=\"joblog\"><form action=\"\">");
        buf.append("<select name=\"go\" onChange='location.href=this.value'>");
        out.write(buf.toString());
        buf.setLength(0);
        Map<String, SortedSet<String>> unsorted = this._context.statManager().getStatsByGroup();
        TreeMap<String, SortedSet<String>> groups = new TreeMap<String, SortedSet<String>>(new AlphaComparator());
        groups.putAll(unsorted);
        for (String group : groups.keySet()) {
            buf.append("<option value=\"#").append(group).append("\">");
            buf.append(this._(group)).append("</option>\n");
        }
        buf.append("</select> <input type=\"submit\" value=\"").append(this._("GO")).append("\" />");
        buf.append("</form>");
        buf.append(this._("Statistics gathered during this router's uptime")).append(" (");
        long uptime = this._context.router().getUptime();
        buf.append(DataHelper.formatDuration2(uptime));
        buf.append(").  ").append(this._("The data gathered is quantized over a 1 minute period, so should just be used as an estimate."));
        buf.append(' ').append(this._("These statistics are primarily used for development and debugging."));
        out.write(buf.toString());
        buf.setLength(0);
        for (Map.Entry entry : groups.entrySet()) {
            String group = (String)entry.getKey();
            Set stats = (Set)entry.getValue();
            buf.append("<h3><a name=\"");
            buf.append(group);
            buf.append("\">");
            buf.append(this._(group));
            buf.append("</a></h3>");
            buf.append("<ul>");
            out.write(buf.toString());
            buf.setLength(0);
            for (String stat : stats) {
                buf.append("<li><b><a name=\"");
                buf.append(stat);
                buf.append("\">");
                buf.append(stat);
                buf.append("</a></b><br>");
                if (this._context.statManager().isFrequency(stat)) {
                    this.renderFrequency(stat, buf);
                } else {
                    this.renderRate(stat, buf, showAll);
                }
                out.write(buf.toString());
                buf.setLength(0);
            }
            out.write("</ul><br>\n");
        }
        out.write("</div>");
        out.flush();
    }

    private void renderFrequency(String name, StringBuilder buf) {
        FrequencyStat freq = this._context.statManager().getFrequency(name);
        buf.append("<i>");
        buf.append(freq.getDescription());
        buf.append("</i><br>");
        if (freq.getEventCount() <= 0L) {
            buf.append(this._("No lifetime events")).append("<br>\n");
            return;
        }
        long uptime = this._context.router().getUptime();
        long[] periods = freq.getPeriods();
        Arrays.sort(periods);
        buf.append("<ul>");
        for (int i = 0; i < periods.length && periods[i] <= uptime; ++i) {
            buf.append("<li>");
            StatsGenerator.renderPeriod(buf, periods[i], this._("frequency"));
            Frequency curFreq = freq.getFrequency(periods[i]);
            buf.append(DataHelper.formatDuration2(Math.round(curFreq.getAverageInterval())));
            buf.append("; ");
            buf.append(this._("Rolling average events per period"));
            buf.append(": ");
            buf.append(StatsGenerator.num(curFreq.getAverageEventsPerPeriod()));
            buf.append("; ");
            buf.append(this._("Highest events per period"));
            buf.append(": ");
            buf.append(StatsGenerator.num(curFreq.getMaxAverageEventsPerPeriod()));
            buf.append("; ");
            buf.append(this._("Lifetime average events per period")).append(": ");
            buf.append(StatsGenerator.num(curFreq.getStrictAverageEventsPerPeriod()));
            buf.append("</li>\n");
        }
        buf.append("<li><b>").append(this._("Lifetime average frequency")).append(":</b> ");
        buf.append(DataHelper.formatDuration2(freq.getFrequency()));
        buf.append(" (");
        buf.append(this.ngettext("1 event", "{0} events", (int)freq.getEventCount()));
        buf.append(")</li></ul><br>\n");
    }

    private void renderRate(String name, StringBuilder buf, boolean showAll) {
        Rate curRate;
        RateStat rate = this._context.statManager().getRate(name);
        String d = rate.getDescription();
        if (!"".equals(d)) {
            buf.append("<i>");
            buf.append(d);
            buf.append("</i><br>");
        }
        if (rate.getLifetimeEventCount() <= 0L) {
            buf.append(this._("No lifetime events")).append("<br>\n");
            return;
        }
        long now = this._context.clock().now();
        long[] periods = rate.getPeriods();
        Arrays.sort(periods);
        buf.append("<ul>");
        for (int i = 0; i < periods.length && (curRate = rate.getRate(periods[i])).getLastCoalesceDate() > curRate.getCreationDate(); ++i) {
            buf.append("<li>");
            StatsGenerator.renderPeriod(buf, periods[i], this._("rate"));
            if (curRate.getLastEventCount() > 0L) {
                buf.append(this._("Average")).append(": ");
                buf.append(StatsGenerator.num(curRate.getAverageValue()));
                buf.append("; ");
                buf.append(this._("Highest average"));
                buf.append(": ");
                buf.append(StatsGenerator.num(curRate.getExtremeAverageValue()));
                buf.append("; ");
                if (showAll) {
                    buf.append("Highest total in a period: ");
                    buf.append(StatsGenerator.num(curRate.getExtremeTotalValue()));
                    buf.append("; ");
                }
                if (showAll && curRate.getLifetimeTotalEventTime() > 0L) {
                    buf.append("Saturation: ");
                    buf.append(StatsGenerator.pct(curRate.getLastEventSaturation()));
                    buf.append("; Saturated limit: ");
                    buf.append(StatsGenerator.num(curRate.getLastSaturationLimit()));
                    buf.append("; Peak saturation: ");
                    buf.append(StatsGenerator.pct(curRate.getExtremeEventSaturation()));
                    buf.append("; Peak saturated limit: ");
                    buf.append(StatsGenerator.num(curRate.getExtremeSaturationLimit()));
                    buf.append("; ");
                }
                buf.append(this.ngettext("There was 1 event in this period.", "There were {0} events in this period.", (int)curRate.getLastEventCount()));
                buf.append(' ');
                buf.append(this._("The period ended {0} ago.", DataHelper.formatDuration2(now - curRate.getLastCoalesceDate())));
            } else {
                buf.append(" <i>").append(this._("No events")).append("</i> ");
            }
            long numPeriods = curRate.getLifetimePeriods();
            if (numPeriods > 0L) {
                double avgFrequency = (double)curRate.getLifetimeEventCount() / (double)numPeriods;
                buf.append(" (").append(this._("Average event count")).append(": ");
                buf.append(StatsGenerator.num(avgFrequency));
                buf.append("; ").append(this._("Events in peak period")).append(": ");
                buf.append(curRate.getExtremeEventCount());
                buf.append(")");
            }
            if (curRate.getSummaryListener() != null) {
                buf.append(" <a href=\"graph?stat=").append(name).append('.').append(periods[i]);
                buf.append("\">").append(this._("Graph Data")).append("</a> - ");
                buf.append(" <a href=\"graph?stat=").append(name).append('.').append(periods[i]);
                buf.append("&amp;showEvents=true\">").append(this._("Graph Event Count")).append("</a>");
            }
            buf.append("</li>\n");
        }
        buf.append("<li><b>").append(this._("Lifetime average value")).append(":</b> ");
        buf.append(StatsGenerator.num(rate.getLifetimeAverageValue()));
        buf.append(" (");
        buf.append(this.ngettext("1 event", "{0} events", (int)rate.getLifetimeEventCount()));
        buf.append(")<br></li></ul><br>\n");
    }

    private static void renderPeriod(StringBuilder buf, long period, String name) {
        buf.append("<b>");
        buf.append(DataHelper.formatDuration2(period));
        buf.append(" ");
        buf.append(name);
        buf.append(":</b> ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double num) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String pct(double num) {
        DecimalFormat decimalFormat = _pct;
        synchronized (decimalFormat) {
            return _pct.format(num);
        }
    }

    private String _(String s) {
        return Messages.getString(s, this._context);
    }

    private String _(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    private String ngettext(String s, String p, int n) {
        return Messages.getString(n, s, p, (I2PAppContext)this._context);
    }

    private class AlphaComparator
    implements Comparator<String> {
        private AlphaComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            String lname = StatsGenerator.this._(lhs);
            String rname = StatsGenerator.this._(rhs);
            return Collator.getInstance().compare(lname, rname);
        }
    }
}

