/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Writer;
import java.text.Collator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.router.util.EventLog;
import net.i2p.router.web.CSSHelper;
import net.i2p.router.web.FormHandler;

public class EventLogHelper
extends FormHandler {
    protected Writer _out;
    private long _from;
    private long _age;
    private String _event = "all";
    private final Map<String, String> _xevents = new HashMap<String, String>(1 + _events.length / 2);
    private static final String ALL = "all";
    private static final String[] _events = new String[]{"aborted", EventLogHelper._x("Aborted startup"), "becameFloodfill", EventLogHelper._x("Enabled floodfill"), "changeIP", EventLogHelper._x("Changed IP"), "changePort", EventLogHelper._x("Changed port"), "clockShift", EventLogHelper._x("Clock shifted"), "crashed", EventLogHelper._x("Crashed"), "critical", EventLogHelper._x("Critical error"), "installed", EventLogHelper._x("Installed new version"), "installFailed", EventLogHelper._x("Install failed"), "network", EventLogHelper._x("Network error"), "newIdent", EventLogHelper._x("New router identity"), "disabledFloodfill", EventLogHelper._x("Disabled floodfill"), "oom", EventLogHelper._x("Out of memory error"), "reachability", EventLogHelper._x("Reachability change"), "rekeyed", EventLogHelper._x("New router identity"), "reseed", EventLogHelper._x("Reseeded router"), "softRestart", EventLogHelper._x("Soft restart"), "started", EventLogHelper._x("Started router"), "stopped", EventLogHelper._x("Stopped router"), "updated", EventLogHelper._x("Updated router"), "watchdog", EventLogHelper._x("Watchdog warning")};
    private static final long DAY = 86400000L;
    private static final long[] _times = new long[]{0L, 86400000L, 604800000L, 2592000000L, 31536000000L};

    @Override
    public void setContextId(String contextId) {
        super.setContextId(contextId);
        for (int i = 0; i < _events.length; i += 2) {
            this._xevents.put(_events[i], this._(_events[i + 1]));
        }
    }

    public void storeWriter(Writer out) {
        this._out = out;
    }

    public void setFrom(String s) {
        try {
            this._age = Long.parseLong(s);
            this._from = this._age > 0L ? this._context.clock().now() - this._age : 0L;
        }
        catch (NumberFormatException nfe) {
            this._age = 0L;
            this._from = 0L;
        }
    }

    public void setType(String s) {
        this._event = s;
    }

    public String getForm() {
        String nonce = CSSHelper.getNonce();
        try {
            this._out.write("<br><h3>" + this._("Display Events") + "</h3>");
            this._out.write("<form action=\"events\" method=\"POST\">\n<input type=\"hidden\" name=\"action\" value=\"save\">\n<input type=\"hidden\" name=\"nonce\" value=\"" + nonce + "\" >\n");
            this._out.write(this._("Events since") + ": <select name=\"from\">");
            for (int i = 0; i < _times.length; ++i) {
                this.writeOption(_times[i]);
            }
            this._out.write("</select><br>");
            this._out.write(this._("Event type") + ": <select name=\"type\">");
            TreeMap<Object, String> events = new TreeMap<Object, String>(Collator.getInstance());
            for (int i = 0; i < _events.length; i += 2) {
                events.put(this._xevents.get(_events[i]), _events[i]);
            }
            this.writeOption(this._("All events"), ALL);
            for (Map.Entry e : events.entrySet()) {
                this.writeOption((String)e.getKey(), (String)e.getValue());
            }
            this._out.write("</select><hr><div class=\"formaction\"><input type=\"submit\" class=\"accept\" value=\"" + this._("Filter events") + "\"></div></form>");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private void writeOption(String key, String val) throws IOException {
        this._out.write("<option value=\"");
        this._out.write(val);
        this._out.write("\"");
        if (val.equals(this._event)) {
            this._out.write(" selected=\"selected\"");
        }
        this._out.write(">");
        this._out.write(key);
        this._out.write("</option>\n");
    }

    private void writeOption(long age) throws IOException {
        this._out.write("<option value=\"");
        this._out.write(Long.toString(age));
        this._out.write("\"");
        if (age == this._age) {
            this._out.write(" selected=\"selected\"");
        }
        this._out.write(">");
        if (age == 0L) {
            this._out.write(this._("All events"));
        } else {
            this._out.write(DataHelper.formatDuration2(age));
        }
        this._out.write("</option>\n");
    }

    public String getEvents() {
        EventLog ev = this._context.router().eventLog();
        boolean isAll = ALL.equals(this._event);
        SortedMap<Long, String> events = isAll ? ev.getEvents(this._from) : ev.getEvents(this._event, this._from);
        String xev = this._xevents.get(this._event);
        if (xev == null) {
            xev = this._event;
        }
        xev = DataHelper.escapeHTML(xev);
        if (events.isEmpty()) {
            if (isAll) {
                if (this._age == 0L) {
                    return this._("No events found");
                }
                return this._("No events found in previous {0}", DataHelper.formatDuration2(this._age));
            }
            if (this._age == 0L) {
                return this._("No \"{0}\" events found", xev);
            }
            return this._("No \"{0}\" events found in previous {1}", xev, DataHelper.formatDuration2(this._age));
        }
        StringBuilder buf = new StringBuilder(2048);
        buf.append("<table><tr><th>");
        buf.append(this._("Time"));
        buf.append("</th><th>");
        if (isAll) {
            buf.append(this._("Event"));
            buf.append("</th><th>");
            buf.append(this._("Details"));
        } else {
            buf.append(xev);
        }
        buf.append("</th></tr>");
        SimpleDateFormat fmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2);
        String systemTimeZone = this._context.getProperty("i2p.systemTimeZone");
        if (systemTimeZone != null) {
            fmt.setTimeZone(TimeZone.getTimeZone(systemTimeZone));
        }
        ArrayList entries = new ArrayList(events.entrySet());
        Collections.reverse(entries);
        for (Map.Entry entry : entries) {
            long time = (Long)entry.getKey();
            String event = (String)entry.getValue();
            buf.append("<tr><td>");
            buf.append(fmt.format(new Date(time)));
            buf.append("</td><td>");
            if (isAll) {
                String[] s = event.split(" ", 2);
                String xs = this._xevents.get(s[0]);
                if (xs == null) {
                    xs = s[0];
                }
                buf.append(xs);
                buf.append("</td><td>");
                if (s.length > 1) {
                    buf.append(s[1]);
                }
            } else {
                buf.append(event);
            }
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }
}

