/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import net.i2p.apps.systray.UrlLauncher;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.LogsHelper;
import net.i2p.router.web.WrapperListener;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;
import org.tanukisoftware.wrapper.WrapperManager;

public class ConfigServiceHandler
extends FormHandler {
    private static WrapperListener _wrapperListener;
    private static final String LISTENER_AVAILABLE = "3.2.0";
    private static final String PROPERTIES_AVAILABLE = "3.2.0";

    private void registerWrapperNotifier(int code, boolean rekey) {
        ConfigServiceHandler.registerWrapperNotifier(this._context, code, rekey);
    }

    public static void registerWrapperNotifier(RouterContext ctx, int code, boolean rekey) {
        Runnable task = new UpdateWrapperOrRekeyTask(rekey, ctx.hasWrapper());
        ctx.addShutdownTask(task);
        if (ctx.hasWrapper()) {
            task = new FinalWrapperTask(code);
            ctx.addFinalShutdownTask(task);
        }
    }

    static synchronized void registerSignalHandler(RouterContext ctx) {
        String wv;
        if (ctx.hasWrapper() && _wrapperListener == null && !SystemVersion.isWindows() && (wv = System.getProperty("wrapper.version")) != null && VersionComparator.comp(wv, "3.2.0") >= 0) {
            try {
                _wrapperListener = new WrapperListener(ctx);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static synchronized void unregisterSignalHandler() {
        if (_wrapperListener != null) {
            _wrapperListener.unregister();
            _wrapperListener = null;
        }
    }

    public boolean shouldShowCancelGraceful() {
        return this._context.router().gracefulShutdownInProgress();
    }

    @Override
    protected void processForm() {
        if (this._action == null) {
            return;
        }
        if (this._("Shutdown gracefully").equals(this._action)) {
            if (this._context.hasWrapper()) {
                this.registerWrapperNotifier(2, false);
            }
            this._context.router().shutdownGracefully();
            this.addFormNotice(this._("Graceful shutdown initiated"));
        } else if (this._("Shutdown immediately").equals(this._action)) {
            if (this._context.hasWrapper()) {
                this.registerWrapperNotifier(3, false);
            }
            this._context.router().shutdown(3);
            this.addFormNotice(this._("Shutdown immediately"));
        } else if (this._("Cancel graceful shutdown").equals(this._action)) {
            this._context.router().cancelGracefulShutdown();
            this.addFormNotice(this._("Graceful shutdown cancelled"));
        } else if (this._("Graceful restart").equals(this._action)) {
            if (this._context.hasWrapper()) {
                this.registerWrapperNotifier(5, false);
            }
            this._context.router().shutdownGracefully(5);
            this.addFormNotice(this._("Graceful restart requested"));
        } else if (this._("Hard restart").equals(this._action)) {
            if (this._context.hasWrapper()) {
                this.registerWrapperNotifier(4, false);
            }
            this._context.router().shutdown(4);
            this.addFormNotice(this._("Hard restart requested"));
        } else if (this._("Rekey and Restart").equals(this._action)) {
            this.addFormNotice(this._("Rekeying after graceful restart"));
            this.registerWrapperNotifier(5, true);
            this._context.router().shutdownGracefully(5);
        } else if (this._("Rekey and Shutdown").equals(this._action)) {
            this.addFormNotice(this._("Rekeying after graceful shutdown"));
            this.registerWrapperNotifier(2, true);
            this._context.router().shutdownGracefully(2);
        } else if (this._("Run I2P on startup").equals(this._action)) {
            this.installService();
        } else if (this._("Don't run I2P on startup").equals(this._action)) {
            this.uninstallService();
        } else if (this._("Dump threads").equals(this._action)) {
            try {
                WrapperManager.requestThreadDump();
            }
            catch (Throwable t) {
                this.addFormError("Warning: unable to contact the service manager - " + t.getMessage());
            }
            File wlog = LogsHelper.wrapperLogFile(this._context);
            this.addFormNotice(this._("Threads dumped to {0}", wlog.getAbsolutePath()));
        } else if (this._("View console on startup").equals(this._action)) {
            this.browseOnStartup(true);
            this.addFormNotice(this._("Console is to be shown on startup"));
        } else if (this._("Do not view console on startup").equals(this._action)) {
            this.browseOnStartup(false);
            this.addFormNotice(this._("Console is not to be shown on startup"));
        } else if (this._("Force GC").equals(this._action)) {
            Runtime.getRuntime().gc();
            this.addFormNotice(this._("Full garbage collection requested"));
        }
    }

    private void installService() {
        try {
            Runtime.getRuntime().exec("install_i2p_service_winnt.bat");
            this.addFormNotice(this._("Service installed"));
        }
        catch (IOException ioe) {
            this.addFormError(this._("Warning: unable to install the service") + " - " + ioe.getMessage());
        }
    }

    private void uninstallService() {
        try {
            Runtime.getRuntime().exec("uninstall_i2p_service_winnt.bat");
            this.addFormNotice(this._("Service removed"));
        }
        catch (IOException ioe) {
            this.addFormError(this._("Warning: unable to remove the service") + " - " + ioe.getMessage());
        }
    }

    private void browseOnStartup(boolean shouldLaunchBrowser) {
        ClientAppConfig ca;
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        boolean found = false;
        for (int cur = 0; cur < clients.size(); ++cur) {
            ca = clients.get(cur);
            if (!UrlLauncher.class.getName().equals(ca.className)) continue;
            ca.disabled = !shouldLaunchBrowser;
            found = true;
            break;
        }
        if (shouldLaunchBrowser && !found) {
            int port = this._context.portMapper().getPort("console", 7657);
            ca = new ClientAppConfig(UrlLauncher.class.getName(), "consoleBrowser", "http://127.0.0.1:" + port + '/', 5L, false);
            clients.add(ca);
        }
        ClientAppConfig.writeClientAppConfig(this._context, clients);
    }

    private static class FinalWrapperTask
    implements Runnable {
        private final int _exitCode;
        private static final int HASHCODE = 123999871;

        public FinalWrapperTask(int exitCode) {
            this._exitCode = exitCode;
        }

        @Override
        public void run() {
            try {
                WrapperManager.signalStopped((int)this._exitCode);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public int hashCode() {
            return 123999871;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof FinalWrapperTask;
        }
    }

    private static class UpdateWrapperOrRekeyTask
    implements Runnable {
        private final boolean _rekey;
        private final boolean _tellWrapper;
        private static final int HASHCODE = -123999871;
        private static final int WAIT = SystemVersion.isARM() ? 240000 : 120000;

        public UpdateWrapperOrRekeyTask(boolean rekey, boolean tellWrapper) {
            this._rekey = rekey;
            this._tellWrapper = tellWrapper;
        }

        @Override
        public void run() {
            block9: {
                try {
                    int wait;
                    block10: {
                        if (this._rekey) {
                            ContextHelper.getContext(null).router().killKeys();
                        }
                        if (!this._tellWrapper) break block9;
                        wait = WAIT;
                        String wv = System.getProperty("wrapper.version");
                        if (wv != null && VersionComparator.comp(wv, "3.2.0") >= 0) {
                            try {
                                Properties props = WrapperManager.getProperties();
                                String tmout = props.getProperty("wrapper.jvm_exit.timeout");
                                if (tmout == null) break block10;
                                try {
                                    int cwait = Integer.parseInt(tmout) * 1000;
                                    if (cwait > wait) {
                                        wait = cwait;
                                    }
                                }
                                catch (NumberFormatException nfe) {}
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    WrapperManager.signalStopping((int)wait);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public int hashCode() {
            return -123999871;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof UpdateWrapperOrRekeyTask;
        }
    }
}

