/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.Messages;

public class ConfigReseedHandler
extends FormHandler {
    private final Map<String, String> changes = new HashMap<String, String>();
    private final List<String> removes = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processForm() {
        block39: {
            if (this._action.equals(this._("Save changes and reseed now"))) {
                this.saveChanges();
                if (!this._context.netDb().reseedChecker().requestReseed()) {
                    this.addFormError(this._("Reseeding is already in progress"));
                } else {
                    this.addFormNotice(this._("Starting reseed process"));
                }
            } else if (this._action.equals(this._("Reseed from URL"))) {
                URL url;
                String val = this.getJettyString("url");
                if (val != null) {
                    val = val.trim();
                }
                if (val == null || val.length() == 0) {
                    this.addFormError(this._("You must enter a URL"));
                    return;
                }
                try {
                    url = new URL(val);
                }
                catch (MalformedURLException mue) {
                    this.addFormError(this._("Bad URL {0}", val));
                    return;
                }
                try {
                    if (!this._context.netDb().reseedChecker().requestReseed(url)) {
                        this.addFormError(this._("Reseeding is already in progress"));
                        break block39;
                    }
                    for (int i = 0; i < 40; ++i) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        if (!this._context.netDb().reseedChecker().inProgress()) break;
                    }
                    String status = this._context.netDb().reseedChecker().getStatus();
                    String error = this._context.netDb().reseedChecker().getError();
                    if (error.length() > 0) {
                        this.addFormErrorNoEscape(error);
                        break block39;
                    }
                    if (status.length() > 0) {
                        this.addFormNoticeNoEscape(status);
                        break block39;
                    }
                    if (this._context.netDb().reseedChecker().inProgress()) {
                        this.addFormNotice(this._("Reseed in progress, check summary bar for status"));
                        break block39;
                    }
                    this.addFormNotice(this._("Reseed complete, check summary bar for status"));
                }
                catch (IllegalArgumentException iae) {
                    this.addFormError(this._("Bad URL {0}", val) + " - " + iae.getMessage());
                }
            } else if (this._action.equals(this._("Reseed from file"))) {
                InputStream in = this._requestWrapper.getInputStream("file");
                try {
                    if (in == null || in.available() <= 0) {
                        this.addFormError(this._("You must enter a file"));
                        return;
                    }
                    int count = this._context.netDb().reseedChecker().requestReseed(in);
                    if (count <= 0) {
                        this.addFormError(this._("Reseed from file failed"));
                    }
                    this.addFormNotice(this.ngettext("Reseed successful, loaded {0} router info from file", "Reseed successful, loaded {0} router infos from file", count));
                }
                catch (IOException ioe) {
                    this.addFormError(this._("Reseed from file failed") + " - " + ioe);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else if (this._action.equals(this._("Save changes"))) {
                this.saveChanges();
            }
        }
    }

    private void saveString(String config, String param) {
        String val = this.getJettyString(param);
        if (val != null && val.length() > 0) {
            this.changes.put(config, val);
        } else {
            this.removes.add(config);
        }
    }

    private void saveBoolean(String config, String param) {
        boolean val = this.getJettyString(param) != null;
        this.changes.put(config, Boolean.toString(val));
    }

    private void saveChanges() {
        this.saveString("router.reseedProxyPort", "port");
        this.saveString("router.reseedProxyHost", "host");
        this.saveString("router.reseedProxy.username", "username");
        this.saveString("router.reseedProxy.password", "password");
        this.saveBoolean("router.reseedProxy.authEnable", "auth");
        this.saveString("router.reseedSSLProxyPort", "sport");
        this.saveString("router.reseedSSLProxyHost", "shost");
        this.saveString("router.reseedSSLProxy.username", "susername");
        this.saveString("router.reseedSSLProxy.password", "spassword");
        this.saveBoolean("router.reseedSSLProxy.authEnable", "sauth");
        String url = this.getJettyString("reseedURL");
        if (url != null) {
            if ((url = url.trim().replace("\r\n", ",").replace("\n", ",")).length() <= 0) {
                this.addFormNotice("Restoring default URLs");
                this.removes.add("i2p.reseedURL");
            } else {
                this.changes.put("i2p.reseedURL", url);
            }
        }
        String mode = this.getJettyString("mode");
        boolean req = "1".equals(mode);
        boolean disabled = "2".equals(mode);
        this.changes.put("router.reseedSSLRequired", Boolean.toString(req));
        this.changes.put("router.reseedSSLDisable", Boolean.toString(disabled));
        this.saveBoolean("router.reseedProxyEnable", "enable");
        this.saveBoolean("router.reseedSSLProxyEnable", "senable");
        if (this._context.router().saveConfig(this.changes, this.removes)) {
            this.addFormNotice(this._("Configuration saved successfully."));
        } else {
            this.addFormError(this._("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
    }

    public String ngettext(String s, String p, int n) {
        return Messages.getString(n, s, p, (I2PAppContext)this._context);
    }
}

