/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import net.i2p.router.web.FormHandler;
import net.i2p.util.LogManager;

public class ConfigLoggingHandler
extends FormHandler {
    private boolean _shouldSave;
    private String _levels;
    private String _defaultLevel;
    private String _filename;
    private String _recordFormat;
    private String _dateFormat;
    private String _fileSize;
    private String _newLogClass;
    private String _newLogLevel = "WARN";

    @Override
    protected void processForm() {
        if (this._shouldSave) {
            this.saveChanges();
        }
    }

    public void setShouldsave(String moo) {
        this._shouldSave = true;
    }

    public void setLevels(String levels) {
        this._levels = levels != null ? levels.trim() : null;
    }

    public void setDefaultloglevel(String level) {
        this._defaultLevel = level != null ? level.trim() : null;
    }

    public void setLogfilename(String filename) {
        this._filename = filename != null ? filename.trim() : null;
    }

    public void setLogformat(String format) {
        this._recordFormat = format != null ? format.trim() : null;
    }

    public void setLogdateformat(String format) {
        this._dateFormat = format != null ? format.trim() : null;
    }

    public void setLogfilesize(String size) {
        this._fileSize = size != null ? size.trim() : null;
    }

    public void setNewlogclass(String s) {
        if (s != null && s.length() > 0) {
            this._newLogClass = s;
        }
    }

    public void setNewloglevel(String s) {
        if (s != null) {
            this._newLogLevel = s;
        }
    }

    private void saveChanges() {
        String oldDefault;
        boolean shouldSave = false;
        if (this._levels != null && this._levels.length() > 0 || this._newLogClass != null) {
            try {
                Properties props = new Properties();
                if (this._levels != null) {
                    props.load(new ByteArrayInputStream(this._levels.getBytes()));
                }
                if (this._newLogClass != null) {
                    props.setProperty(this._newLogClass, this._newLogLevel);
                }
                this._context.logManager().setLimits(props);
                shouldSave = true;
                this.addFormNotice(this._("Log overrides updated"));
            }
            catch (IOException ioe) {
                this._context.logManager().getLog(ConfigLoggingHandler.class).error("Error reading from the props?", ioe);
                this.addFormError("Error updating the log limits - levels not valid");
            }
        } else if (!this._context.logManager().getLimits().isEmpty()) {
            this._context.logManager().setLimits(null);
            shouldSave = true;
            this.addFormNotice("Log limits cleared");
        }
        if (this._defaultLevel != null && !this._defaultLevel.equals(oldDefault = this._context.logManager().getDefaultLimit())) {
            shouldSave = true;
            this._context.logManager().setDefaultLimit(this._defaultLevel);
            this.addFormNotice("Default log level updated from " + oldDefault + " to " + this._defaultLevel);
        }
        if (this._dateFormat != null && !this._dateFormat.equals(this._context.logManager().getDateFormatPattern())) {
            boolean valid = this._context.logManager().setDateFormat(this._dateFormat);
            if (valid) {
                shouldSave = true;
                this.addFormNotice("Date format updated");
            } else {
                this.addFormError("Specified date format is not valid (" + this._dateFormat + ") - not updated");
            }
        }
        if (this._fileSize != null) {
            this._context.logManager();
            int newBytes = LogManager.getFileSize(this._fileSize);
            int oldBytes = this._context.logManager().getFileSize();
            if (newBytes > 0) {
                if (oldBytes != newBytes) {
                    this._context.logManager().setFileSize(newBytes);
                    shouldSave = true;
                    this.addFormNotice("File size updated");
                }
            } else {
                this.addFormError("Specified file size limit is not valid (" + this._fileSize + ") - not updated");
            }
        }
        if (this._recordFormat != null && this._recordFormat.trim().length() > 0) {
            this._recordFormat = this._recordFormat.trim();
            String old = new String(this._context.logManager().getFormat());
            if (!this._recordFormat.equalsIgnoreCase(old)) {
                char[] fmt = new char[this._recordFormat.length()];
                for (int i = 0; i < fmt.length; ++i) {
                    fmt[i] = this._recordFormat.charAt(i);
                }
                this._context.logManager().setFormat(fmt);
                shouldSave = true;
                this.addFormNotice("Log record format updated");
            }
        }
        if (shouldSave) {
            boolean saved = this._context.logManager().saveConfig();
            if (saved) {
                this.addFormNotice(this._("Log configuration saved"));
            } else {
                this.addFormError("Error saving the configuration (applied but not saved) - please see the error logs");
            }
        }
    }
}

