/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.HomeHelper;

public class ConfigHomeHandler
extends FormHandler {
    @Override
    protected void processForm() {
        if (this._action == null) {
            return;
        }
        String group = this.getJettyString("group");
        boolean deleting = this._action.equals(this._("Delete selected"));
        boolean adding = this._action.equals(this._("Add item"));
        boolean restoring = this._action.equals(this._("Restore defaults"));
        if (this._action.equals(this._("Save")) && "0".equals(group)) {
            boolean nnew;
            boolean old = this._context.getBooleanProperty("routerconsole.oldHomePage");
            boolean bl = nnew = this.getJettyString("oldHome") != null;
            if (old != nnew) {
                this._context.router().saveConfig("routerconsole.oldHomePage", "" + nnew);
                this.addFormNotice(this._("Home page changed"));
            }
        } else if (adding || deleting || restoring) {
            String dflt;
            String prop;
            if ("1".equals(group)) {
                prop = "routerconsole.favorites";
                dflt = HomeHelper.DEFAULT_FAVORITES;
            } else if ("2".equals(group)) {
                prop = "routerconsole.services";
                dflt = HomeHelper.DEFAULT_SERVICES;
            } else if ("3".equals(group)) {
                prop = "routerconsole.searchEngines";
                dflt = "eepsites.i2p,http://eepsites.i2p/Content/Search/SearchResults.aspx?inpQuery=%s&amp;ref=console,epsilon.i2p,http://epsilon.i2p/search.jsp?q=%s&amp;ref=console,";
            } else {
                this.addFormError("Bad group");
                return;
            }
            if (restoring) {
                this._context.router().saveConfig(prop, null);
                this.addFormNotice(this._("Restored default settings"));
                return;
            }
            String config = this._context.getProperty(prop, dflt);
            Collection<HomeHelper.App> apps = "3".equals(group) ? HomeHelper.buildSearchApps(config) : HomeHelper.buildApps(this._context, config);
            if (adding) {
                String name = this.getJettyString("nofilter_name");
                if (name == null || name.length() <= 0) {
                    this.addFormError(this._("No name entered"));
                    return;
                }
                String url = this.getJettyString("nofilter_url");
                if (url == null || url.length() <= 0) {
                    this.addFormError(this._("No URL entered"));
                    return;
                }
                name = name.replace(",", ".");
                url = url.replace(",", ".");
                HomeHelper.App app = null;
                app = "1".equals(group) ? new HomeHelper.App(name, "", url, "/themes/console/images/eepsite.png") : ("2".equals(group) ? new HomeHelper.App(name, "", url, "/themes/console/images/title_window.png") : new HomeHelper.App(name, "", url, "/themes/console/images/question.png"));
                apps.add(app);
                this.addFormNotice(this._("Added") + ": " + app.name);
            } else {
                HashSet<String> toDelete = new HashSet<String>();
                for (Object o : this._settings.keySet()) {
                    String k;
                    if (!(o instanceof String) || !(k = (String)o).startsWith("delete_")) continue;
                    k = k.substring(7);
                    toDelete.add(k);
                }
                Iterator<HomeHelper.App> iter = apps.iterator();
                while (iter.hasNext()) {
                    HomeHelper.App app = iter.next();
                    if (!toDelete.contains(app.name)) continue;
                    iter.remove();
                    this.addFormNotice(this._("Removed") + ": " + app.name);
                }
            }
            HomeHelper.saveApps(this._context, prop, apps, !"3".equals(group));
        }
    }
}

