/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class ConnectionPacketHandler {
    private final I2PAppContext _context;
    private final Log _log;
    public static final int MAX_SLOW_START_WINDOW = 24;
    private static final int MAX_INITIAL_PACKETS = 6;

    public ConnectionPacketHandler(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(ConnectionPacketHandler.class);
        this._context.statManager().createRateStat("stream.con.receiveMessageSize", "Size of a message received on a connection", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.con.receiveDuplicateSize", "Size of a duplicate message received on a connection", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.con.packetsAckedPerMessageReceived", "Avg number of acks in a message", "Stream", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("stream.sendsBeforeAck", "How many times a message was sent before it was ACKed?", "Stream", new long[]{600000L, 3600000L});
        this._context.statManager().createRateStat("stream.resetReceived", "How many messages had we sent successfully before receiving a RESET?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.trend", "What direction the RTT is trending in (with period = windowsize)", "Stream", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("stream.con.initialRTT.in", "What is the actual RTT for the first packet of an inbound conn?", "Stream", new long[]{600000L, 3600000L});
        this._context.statManager().createRateStat("stream.con.initialRTT.out", "What is the actual RTT for the first packet of an outbound conn?", "Stream", new long[]{600000L, 3600000L});
        this._context.statManager().createFrequencyStat("stream.ack.dup.immediate", "How often duplicate packets get acked immediately", "Stream", new long[]{600000L, 3600000L});
        this._context.statManager().createRateStat("stream.ack.dup.sent", "Whether the ack for a duplicate packet was sent as scheduled", "Stream", new long[]{600000L, 3600000L});
    }

    void receivePacket(Packet packet, Connection con) throws I2PException {
        boolean ok = this.verifyPacket(packet, con);
        if (!ok) {
            boolean isTooFast;
            boolean bl = isTooFast = con.getSendStreamId() <= 0L;
            if (!packet.isFlagSet(4) && !isTooFast && this._log.shouldLog(30)) {
                this._log.warn("Packet does NOT verify: " + packet + " on " + con);
            }
            packet.releasePayload();
            return;
        }
        long seqNum = packet.getSequenceNum();
        if (con.getHardDisconnected()) {
            if (seqNum > 0L || packet.getPayloadSize() > 0 || packet.isFlagSet(3)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Received a data packet after hard disconnect: " + packet + " on " + con);
                }
                con.disconnect(false);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Received a packet after hard disconnect, ignoring: " + packet + " on " + con);
            }
            packet.releasePayload();
            return;
        }
        if (con.getCloseSentOn() > 0L && con.getUnackedPacketsSent() <= 0 && seqNum > 0L && packet.getPayloadSize() > 0 && this._log.shouldLog(20)) {
            this._log.info("Received new data when we've sent them data and all of our data is acked: " + packet + " on " + con + "");
        }
        if (packet.isFlagSet(128)) {
            int size = packet.getOptionalMaxSize();
            if (size < 512) {
                size = 512;
            }
            if (size < con.getOptions().getMaxMessageSize()) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Reducing our max message size to " + size + " from " + con.getOptions().getMaxMessageSize());
                }
                con.getOptions().setMaxMessageSize(size);
                con.getOutputStream().setBufferSize(size);
            }
        }
        con.packetReceived();
        boolean choke = false;
        if (packet.isFlagSet(64) && packet.getOptionalDelay() > 60000) {
            choke = true;
        }
        if (!con.getInputStream().canAccept(seqNum, packet.getPayloadSize())) {
            if (this._log.shouldWarn()) {
                this._log.warn("Inbound buffer exceeded on connection " + con + ", dropping " + packet);
            }
            con.getOptions().setChoke(61000);
            packet.releasePayload();
            con.ackImmediately();
            return;
        }
        con.getOptions().setChoke(0);
        this._context.statManager().addRateData("stream.con.receiveMessageSize", (long)packet.getPayloadSize());
        boolean allowAck = true;
        boolean isSYN = packet.isFlagSet(1);
        if (!isSYN && packet.getReceiveStreamId() <= 0L) {
            allowAck = false;
        }
        boolean isNew = seqNum > 0L || isSYN ? con.getInputStream().messageReceived(seqNum, packet.getPayload()) : false;
        if (!allowAck) {
            isNew = false;
        }
        if (this._log.shouldLog(10)) {
            String type = !allowAck ? "Non-SYN before SYN" : (isNew ? "New" : (packet.getPayloadSize() <= 0 ? "Ack-only" : "Dup"));
            this._log.debug(type + " IB pkt: " + packet + " on " + con);
        }
        boolean fastAck = false;
        boolean ackOnly = false;
        if (isNew) {
            con.incrementUnackedPacketsReceived();
            con.incrementBytesReceived(packet.getPayloadSize());
            if (packet.isFlagSet(64) && packet.getOptionalDelay() <= 0) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Scheduling immediate ack for " + packet);
                }
                con.setNextSendTime(this._context.clock().now() + 250L);
            } else {
                int delay = con.getOptions().getSendAckDelay();
                if (packet.isFlagSet(64)) {
                    delay = packet.getOptionalDelay();
                }
                con.setNextSendTime((long)delay + this._context.clock().now());
                if (this._log.shouldLog(10)) {
                    this._log.debug("Scheduling ack in " + delay + "ms for received packet " + packet);
                }
            }
        } else if (seqNum > 0L || packet.getPayloadSize() > 0 || isSYN) {
            long nextSendTime;
            this._context.statManager().addRateData("stream.con.receiveDuplicateSize", (long)packet.getPayloadSize());
            con.incrementDupMessagesReceived(1);
            long now = this._context.clock().now();
            int ackDelay = con.getOptions().getSendAckDelay();
            long lastSendTime = con.getLastSendTime();
            if (this._log.shouldLog(20)) {
                this._log.info(String.format("%s congestion.. dup packet %s ackDelay %d lastSend %s ago", con, packet, ackDelay, DataHelper.formatDuration((long)(now - lastSendTime))));
            }
            if ((nextSendTime = lastSendTime + (long)Math.min(ackDelay, con.getOptions().getRTT() / 2)) <= now) {
                if (this._log.shouldLog(20)) {
                    this._log.info("immediate ack");
                }
                con.ackImmediately();
                this._context.statManager().updateFrequency("stream.ack.dup.immediate");
            } else {
                long delay = nextSendTime - now;
                if (this._log.shouldLog(20)) {
                    this._log.info("scheduling ack in " + delay);
                }
                this._context.simpleTimer2().addEvent((SimpleTimer.TimedEvent)new AckDup(con), delay);
            }
        } else if (isSYN) {
            con.setNextSendTime(this._context.clock().now() + (long)con.getOptions().getSendAckDelay());
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("ACK only packet received: " + packet);
            }
            ackOnly = true;
        }
        if (!isSYN || packet.getSendStreamId() > 0L) {
            fastAck = this.ack(con, packet.getAckThrough(), packet.getNacks(), packet, isNew, choke);
        }
        con.eventOccurred();
        if (fastAck && isNew) {
            long timeSinceSend = this._context.clock().now() - con.getLastSendTime();
            if (timeSinceSend >= 2000L) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Fast ack for dup " + packet);
                }
                con.ackImmediately();
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Not fast acking dup " + packet + " since we last sent " + timeSinceSend + "ms ago");
            }
        }
        if (ackOnly || !isNew) {
            packet.releasePayload();
        }
        if (packet.isFlagSet(2) && packet.isFlagSet(8)) {
            con.closeReceived();
            if (isNew) {
                con.updateShareOpts();
            }
        }
    }

    private boolean ack(Connection con, long ackThrough, long[] nacks, Packet packet, boolean isNew, boolean choke) {
        if (ackThrough < 0L) {
            return false;
        }
        boolean firstAck = isNew && con.getHighestAckedThrough() < 0L;
        int numResends = 0;
        List<PacketLocal> acked = null;
        if (packet == null || packet.getSendStreamId() <= 0L || packet.getReceiveStreamId() <= 0L || con == null || con.getSendStreamId() <= 0L || con.getReceiveStreamId() <= 0L || packet.getSendStreamId() == 0L || packet.getReceiveStreamId() == 0L || con.getSendStreamId() == 0L || con.getReceiveStreamId() == 0L) {
            return false;
        }
        acked = con.ackPackets(ackThrough, nacks);
        boolean lastPacketAcked = false;
        boolean receivedAck = con.getOptions().receivedAck();
        if (acked != null && !acked.isEmpty()) {
            if (this._log.shouldLog(10)) {
                this._log.debug(acked.size() + " of our packets acked with " + packet);
            }
            int highestRTT = -1;
            for (int i = 0; i < acked.size(); ++i) {
                PacketLocal p = acked.get(i);
                int numSends = p.getNumSends();
                int ackTime = p.getAckTime();
                if (numSends > 1 && receivedAck) {
                    ++numResends;
                } else if (ackTime > highestRTT) {
                    highestRTT = ackTime;
                }
                this._context.statManager().addRateData("stream.sendsBeforeAck", (long)numSends, (long)ackTime);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Packet acked after " + ackTime + "ms: " + p);
            }
            if (highestRTT > 0) {
                if (this._log.shouldLog(20)) {
                    int oldrtt = con.getOptions().getRTT();
                    int oldrto = con.getOptions().getRTO();
                    int olddev = con.getOptions().getRTTDev();
                    con.getOptions().updateRTT(highestRTT);
                    this._log.info("acked: " + acked.size() + " highestRTT: " + highestRTT + " RTT: " + oldrtt + " -> " + con.getOptions().getRTT() + " RTO: " + oldrto + " -> " + con.getOptions().getRTO() + " Dev: " + olddev + " -> " + con.getOptions().getRTTDev());
                } else {
                    con.getOptions().updateRTT(highestRTT);
                }
                if (firstAck) {
                    if (con.isInbound()) {
                        this._context.statManager().addRateData("stream.con.initialRTT.in", (long)highestRTT);
                    } else {
                        this._context.statManager().addRateData("stream.con.initialRTT.out", (long)highestRTT);
                    }
                }
            }
            this._context.statManager().addRateData("stream.con.packetsAckedPerMessageReceived", (long)acked.size(), (long)highestRTT);
            if (con.getCloseSentOn() > 0L && con.getUnackedPacketsSent() <= 0) {
                lastPacketAcked = true;
            }
        }
        boolean rv = this.adjustWindow(con, isNew, packet.getSequenceNum(), numResends, acked != null ? acked.size() : 0, choke);
        if (lastPacketAcked) {
            con.notifyLastPacketAcked();
        }
        return rv;
    }

    private boolean adjustWindow(Connection con, boolean isNew, long sequenceNum, int numResends, int acked, boolean choke) {
        long lowest;
        boolean congested = false;
        if (!isNew && sequenceNum > 0L) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Congestion occurred on the sending side. Not adjusting window " + con);
            }
            congested = true;
        }
        if ((lowest = con.getHighestAckedThrough()) >= con.getCongestionWindowEnd() || acked > 1 || con.getUnackedPacketsSent() > 0) {
            int oldWindow;
            int newWindowSize = oldWindow = con.getOptions().getWindowSize();
            int trend = con.getOptions().getRTTTrend();
            this._context.statManager().addRateData("stream.trend", (long)trend, (long)newWindowSize);
            if (!congested && acked > 0 && numResends <= 0) {
                if (newWindowSize < con.getLastCongestionSeenAt() / 2) {
                    int factor = con.getOptions().getSlowStartGrowthRateFactor();
                    newWindowSize = factor <= 1 ? (newWindowSize >= 24 ? ++newWindowSize : Math.min(24, newWindowSize + acked)) : (acked < factor ? ++newWindowSize : (newWindowSize += acked / factor));
                    if (this._log.shouldLog(10)) {
                        this._log.debug("slow start acks = " + acked + " for " + con);
                    }
                } else {
                    int shouldIncrement = this._context.random().nextInt(con.getOptions().getCongestionAvoidanceGrowthRateFactor() * newWindowSize);
                    if (shouldIncrement < acked) {
                        ++newWindowSize;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("cong. avoid acks = " + acked + " for " + con);
                    }
                }
            } else if (this._log.shouldLog(10)) {
                this._log.debug("No change to window: " + con.getOptions().getWindowSize() + " congested? " + congested + " acked: " + acked + " resends: " + numResends);
            }
            if (newWindowSize <= 0) {
                newWindowSize = 1;
            }
            con.getOptions().setWindowSize(newWindowSize);
            con.setCongestionWindowEnd((long)newWindowSize + lowest);
            if (this._log.shouldLog(20)) {
                this._log.info("New window size " + newWindowSize + "/" + oldWindow + "/" + con.getOptions().getWindowSize() + " congestionSeenAt: " + con.getLastCongestionSeenAt() + " (#resends: " + numResends + ") for " + con);
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("No change to window: " + con.getOptions().getWindowSize() + " highestAckedThrough: " + lowest + " congestionWindowEnd: " + con.getCongestionWindowEnd() + " acked: " + acked + " unacked: " + con.getUnackedPacketsSent());
        }
        con.windowAdjusted();
        return congested;
    }

    private boolean verifyPacket(Packet packet, Connection con) throws I2PException {
        if (packet.isFlagSet(4)) {
            this.verifyReset(packet, con);
            return false;
        }
        this.verifySignature(packet, con);
        if (con.getSendStreamId() <= 0L) {
            if (packet.isFlagSet(1)) {
                con.setSendStreamId(packet.getReceiveStreamId());
                con.setRemotePeer(packet.getOptionalFrom());
                return true;
            }
            if (packet.getSequenceNum() < 6L) {
                return true;
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Packet without RST or SYN where we dont know stream ID: " + packet);
            }
            return false;
        }
        if (con.getSendStreamId() != packet.getReceiveStreamId()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Packet received with the wrong reply stream id: " + con + " / " + packet);
            }
            return false;
        }
        return true;
    }

    private void verifyReset(Packet packet, Connection con) {
        if (con.getReceiveStreamId() == packet.getSendStreamId()) {
            boolean ok;
            Destination from = con.getRemotePeer();
            if (from == null) {
                from = packet.getOptionalFrom();
            }
            if (!(ok = packet.verifySignature(this._context, from, null))) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Received unsigned / forged RST on " + con);
                }
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Reset received");
            }
            con.resetReceived();
            con.eventOccurred();
            this._context.statManager().addRateData("stream.resetReceived", con.getHighestAckedThrough(), con.getLifetime());
            return;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Received a packet for the wrong connection?  wtf: " + con + " / " + packet);
        }
    }

    private void verifySignature(Packet packet, Connection con) throws I2PException {
        if (con.getOptions().getRequireFullySigned() || packet.isFlagSet(3)) {
            boolean sigOk;
            Destination from = con.getRemotePeer();
            if (from == null) {
                from = packet.getOptionalFrom();
            }
            if (!(sigOk = packet.verifySignature(this._context, from, null))) {
                throw new I2PException("Received unsigned / forged packet: " + packet);
            }
        }
    }

    private class AckDup
    implements SimpleTimer.TimedEvent {
        private final long _created;
        private final Connection _con;

        public AckDup(Connection con) {
            this._created = ConnectionPacketHandler.this._context.clock().now();
            this._con = con;
        }

        public void timeReached() {
            boolean sent = false;
            if (this._con.getLastSendTime() <= this._created) {
                if (this._con.getResetReceived() || this._con.getResetSent()) {
                    if (ConnectionPacketHandler.this._log.shouldLog(10)) {
                        ConnectionPacketHandler.this._log.debug("Ack dup on " + this._con + ", but we have been reset");
                    }
                    return;
                }
                if (ConnectionPacketHandler.this._log.shouldLog(10)) {
                    ConnectionPacketHandler.this._log.debug("Last sent was a while ago, and we want to ack a dup on " + this._con);
                }
                this._con.ackImmediately();
                sent = true;
            } else if (ConnectionPacketHandler.this._log.shouldLog(10)) {
                ConnectionPacketHandler.this._log.debug("Ack dup on " + this._con + ", but we have sent (" + (this._con.getLastSendTime() - this._created) + ")");
            }
            ConnectionPacketHandler.this._context.statManager().addRateData("stream.ack.dup.sent", sent ? 1L : 0L);
        }
    }
}

