/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.util.SecureFileOutputStream;

public class EventLog {
    private final I2PAppContext _context;
    private final File _file;
    private final Map<String, SortedMap<Long, String>> _cache;
    private final Map<String, Long> _cacheTime;
    public static final String ABORTED = "aborted";
    public static final String BECAME_FLOODFILL = "becameFloodfill";
    public static final String CHANGE_IP = "changeIP";
    public static final String CHANGE_PORT = "changePort";
    public static final String CLOCK_SHIFT = "clockShift";
    public static final String CRASHED = "crashed";
    public static final String CRITICAL = "critical";
    public static final String INSTALLED = "installed";
    public static final String INSTALL_FAILED = "installFailed";
    public static final String NETWORK = "network";
    public static final String NEW_IDENT = "newIdent";
    public static final String NOT_FLOODFILL = "disabledFloodfill";
    public static final String OOM = "oom";
    public static final String REACHABILITY = "reachability";
    public static final String REKEYED = "rekeyed";
    public static final String RESEED = "reseed";
    public static final String SOFT_RESTART = "softRestart";
    public static final String STARTED = "started";
    public static final String STOPPED = "stopped";
    public static final String UPDATED = "updated";
    public static final String WATCHDOG = "watchdog";

    public EventLog(I2PAppContext ctx, File file) {
        this._context = ctx;
        this._file = file;
        this._cache = new HashMap<String, SortedMap<Long, String>>(4);
        this._cacheTime = new HashMap<String, Long>(4);
    }

    public void addEvent(String event) {
        this.addEvent(event, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEvent(String event, String info) {
        if (event.contains(" ") || event.contains("\n") || info != null && info.contains("\n")) {
            throw new IllegalArgumentException();
        }
        this._cache.remove(event);
        this._cacheTime.remove(event);
        SecureFileOutputStream out = null;
        try {
            out = new SecureFileOutputStream(this._file, true);
            StringBuilder buf = new StringBuilder(128);
            buf.append(this._context.clock().now()).append(' ').append(event);
            if (info != null && info.length() > 0) {
                buf.append(' ').append(info);
            }
            buf.append('\n');
            out.write(buf.toString().getBytes("UTF-8"));
        }
        catch (IOException ioe) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SortedMap<Long, String> getEvents(String event, long since) {
        Long cacheTime;
        SortedMap<Long, String> rv = this._cache.get(event);
        if (rv != null && (cacheTime = this._cacheTime.get(event)) != null && since >= cacheTime) {
            return rv.tailMap(since);
        }
        rv = new TreeMap<Long, String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                try {
                    long time;
                    String[] s = line.split(" ", 3);
                    if (!s[1].equals(event) || (time = Long.parseLong(s[0])) <= since) continue;
                    Long ltime = time;
                    String info = s.length > 2 ? s[2] : "";
                    rv.put(ltime, info);
                }
                catch (IndexOutOfBoundsException ioobe) {
                }
                catch (NumberFormatException nfe) {}
            }
            rv = Collections.unmodifiableSortedMap(rv);
            this._cache.put(event, rv);
            this._cacheTime.put(event, since);
        }
        catch (IOException ioe) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SortedMap<Long, String> getEvents(long since) {
        SortedMap<Long, String> rv = new TreeMap<Long, String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                try {
                    long time;
                    String[] s = line.split(" ", 2);
                    if (s.length < 2 || (time = Long.parseLong(s[0])) <= since) continue;
                    Long ltime = time;
                    rv.put(ltime, s[1]);
                }
                catch (IndexOutOfBoundsException ioobe) {
                }
                catch (NumberFormatException nfe) {}
            }
            rv = Collections.unmodifiableSortedMap(rv);
        }
        catch (IOException ioe) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
        return rv;
    }
}

