/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.TunnelId;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.tunnel.pool.TunnelPoolManager;

public class AliasedTunnelPool
extends TunnelPool {
    private final TunnelPool _aliasOf;

    AliasedTunnelPool(RouterContext ctx, TunnelPoolManager mgr, TunnelPoolSettings settings, TunnelPool aliasOf) {
        super(ctx, mgr, settings, null);
        if (settings.isExploratory()) {
            throw new IllegalArgumentException();
        }
        if (settings.getAliasOf() == null) {
            throw new IllegalArgumentException();
        }
        this._aliasOf = aliasOf;
    }

    @Override
    synchronized void startup() {
        if (this._log.shouldLog(20)) {
            this._log.info(this.toString() + ": Startup() called, was already alive? " + this._alive, (Throwable)new Exception());
        }
        this._alive = true;
        super.refreshLeaseSet();
    }

    @Override
    synchronized void shutdown() {
        if (this._log.shouldLog(30)) {
            this._log.warn(this.toString() + ": Shutdown called");
        }
        this._alive = false;
    }

    @Override
    TunnelInfo selectTunnel() {
        return this._aliasOf.selectTunnel();
    }

    @Override
    TunnelInfo selectTunnel(Hash closestTo) {
        return this._aliasOf.selectTunnel(closestTo);
    }

    @Override
    public TunnelInfo getTunnel(TunnelId gatewayId) {
        return this._aliasOf.getTunnel(gatewayId);
    }

    @Override
    public List<TunnelInfo> listTunnels() {
        return this._aliasOf.listTunnels();
    }

    @Override
    boolean needFallback() {
        return false;
    }

    @Override
    public List<PooledTunnelCreatorConfig> listPending() {
        return this._aliasOf.listPending();
    }

    @Override
    public boolean isAlive() {
        return this._alive && this._aliasOf.isAlive();
    }

    @Override
    public int size() {
        return this._aliasOf.size();
    }

    @Override
    void addTunnel(TunnelInfo info) {
        this._aliasOf.addTunnel(info);
    }

    @Override
    void removeTunnel(TunnelInfo info) {
        this._aliasOf.removeTunnel(info);
    }

    @Override
    void tunnelFailed(TunnelInfo cfg) {
        this._aliasOf.tunnelFailed(cfg);
    }

    @Override
    void tunnelFailed(TunnelInfo cfg, Hash blamePeer) {
        this._aliasOf.tunnelFailed(cfg, blamePeer);
    }

    @Override
    void refreshLeaseSet() {
    }

    @Override
    boolean buildFallback() {
        return this._aliasOf.buildFallback();
    }

    @Override
    protected LeaseSet locked_buildNewLeaseSet() {
        LeaseSet ls = this._context.netDb().lookupLeaseSetLocally(this._aliasOf.getSettings().getDestination());
        if (ls == null) {
            return null;
        }
        LeaseSet rv = new LeaseSet();
        for (int i = 0; i < ls.getLeaseCount(); ++i) {
            Lease old = ls.getLease(i);
            Lease lease = new Lease();
            lease.setEndDate(old.getEndDate());
            lease.setTunnelId(old.getTunnelId());
            lease.setGateway(old.getGateway());
            rv.addLease(lease);
        }
        return rv;
    }

    @Override
    public long getLifetimeProcessed() {
        return this._aliasOf.getLifetimeProcessed();
    }

    @Override
    int countHowManyToBuild() {
        return 0;
    }

    @Override
    PooledTunnelCreatorConfig configureNewTunnel() {
        return null;
    }

    @Override
    void buildComplete(PooledTunnelCreatorConfig cfg) {
    }

    @Override
    public String toString() {
        return "Aliased " + super.toString();
    }
}

