/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.ClientMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.message.GarlicMessageReceiver;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.Log;

class InboundMessageDistributor
implements GarlicMessageReceiver.CloveReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final Hash _client;
    private final GarlicMessageReceiver _receiver;

    public InboundMessageDistributor(RouterContext ctx, Hash client) {
        this._context = ctx;
        this._client = client;
        this._log = ctx.logManager().getLog(InboundMessageDistributor.class);
        this._receiver = new GarlicMessageReceiver(ctx, this, client);
    }

    public void distribute(I2NPMessage msg, Hash target) {
        this.distribute(msg, target, null);
    }

    public void distribute(I2NPMessage msg, Hash target, TunnelId tunnel) {
        DatabaseStoreMessage dsm;
        if (this._log.shouldLog(10)) {
            this._log.debug("IBMD for " + this._client + " to " + target + " / " + tunnel + " : " + msg);
        }
        int type = msg.getType();
        if (this._client != null) {
            switch (type) {
                case 3: {
                    break;
                }
                case 1: {
                    dsm = (DatabaseStoreMessage)msg;
                    if (dsm.getEntry().getType() == 0) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Dropping DSM down a tunnel for " + this._client + ": " + msg);
                        }
                        Hash key = dsm.getKey();
                        if (this._context.routerHash().equals((Object)key)) {
                            return;
                        }
                        RouterInfo ri = (RouterInfo)dsm.getEntry();
                        if (!key.equals((Object)ri.getIdentity().getHash())) {
                            return;
                        }
                        if (!ri.isValid()) {
                            return;
                        }
                        RouterInfo oldri = this._context.netDb().lookupRouterInfoLocally(key);
                        if (oldri != null && oldri.getPublished() < ri.getPublished() && !FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
                            if (this._log.shouldLog(30)) {
                                this._log.warn("Updating caps for RI " + key + " from \"" + oldri.getCapabilities() + "\" to \"" + ri.getCapabilities() + '\"');
                            }
                            this._context.peerManager().setCapabilities(key, ri.getCapabilities());
                        }
                        return;
                    }
                    if (dsm.getReplyToken() != 0L) {
                        this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, (long)type);
                        this._log.error("Dropping LS DSM w/ reply token down a tunnel for " + this._client + ": " + msg);
                        return;
                    }
                    ((LeaseSet)dsm.getEntry()).setReceivedAsReply();
                    break;
                }
                case 10: 
                case 11: 
                case 22: 
                case 24: {
                    break;
                }
                default: {
                    this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, (long)type);
                    this._log.error("Dropped dangerous message down a tunnel for " + this._client + ": " + msg, (Throwable)new Exception("cause"));
                    return;
                }
            }
        } else {
            switch (type) {
                case 1: {
                    dsm = (DatabaseStoreMessage)msg;
                    if (dsm.getReplyToken() != 0L) {
                        this._context.statManager().addRateData("tunnel.dropDangerousExplTunnelMessage", 1L, (long)type);
                        this._log.error("Dropping DSM w/ reply token down a expl. tunnel: " + msg);
                        return;
                    }
                    if (dsm.getEntry().getType() != 1) break;
                    ((LeaseSet)dsm.getEntry()).setReceivedAsReply();
                    break;
                }
                case 3: 
                case 10: 
                case 11: 
                case 22: 
                case 24: {
                    break;
                }
                default: {
                    this._context.statManager().addRateData("tunnel.dropDangerousExplTunnelMessage", 1L, (long)type);
                    this._log.error("Dropped dangerous message down expl tunnel: " + msg, (Throwable)new Exception("cause"));
                    return;
                }
            }
        }
        if (target == null || tunnel == null && this._context.routerHash().equals((Object)target)) {
            if (type == 11) {
                this._context.inNetMessagePool().handleReplies(msg);
                this._receiver.receive((GarlicMessage)msg);
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("distributing inbound tunnel message into our inNetMessagePool: " + msg);
                }
                this._context.inNetMessagePool().add(msg, null, null);
            }
        } else {
            TunnelId outId;
            TunnelInfo out = this._context.tunnelManager().selectOutboundTunnel(this._client, target);
            if (out == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("no outbound tunnel to send the client message for " + this._client + ": " + msg);
                }
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("distributing IB tunnel msg type " + type + " back out " + out + " targetting " + target);
            }
            if ((outId = out.getSendTunnelId(0)) == null) {
                if (this._log.shouldLog(40)) {
                    this._log.error("strange? outbound tunnel has no outboundId? " + out + " failing to distribute " + msg);
                }
                return;
            }
            long exp = this._context.clock().now() + 20000L;
            if (msg.getMessageExpiration() < exp) {
                msg.setMessageExpiration(exp);
            }
            this._context.tunnelDispatcher().dispatchOutbound(msg, outId, tunnel, target);
        }
    }

    @Override
    public void handleClove(DeliveryInstructions instructions, I2NPMessage data) {
        int type = data.getType();
        switch (instructions.getDeliveryMode()) {
            case 0: {
                if (this._log.shouldLog(10)) {
                    this._log.debug("local delivery instructions for clove: " + data.getClass().getSimpleName());
                }
                if (type == 11) {
                    this._receiver.receive((GarlicMessage)data);
                } else if (type == 1) {
                    DatabaseStoreMessage dsm = (DatabaseStoreMessage)data;
                    dsm.setReplyToken(0L);
                    dsm.setReplyTunnel(null);
                    dsm.setReplyGateway(null);
                    if (dsm.getEntry().getType() == 1) {
                        ((LeaseSet)dsm.getEntry()).setReceivedAsReply();
                        if (this._log.shouldLog(20)) {
                            this._log.info("Storing garlic LS down tunnel for: " + dsm.getKey() + " sent to: " + this._client);
                        }
                        this._context.inNetMessagePool().add(dsm, null, null);
                    } else {
                        if (this._client != null) {
                            this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, 1L);
                            this._log.error("Dropped dangerous message down a tunnel for " + this._client + ": " + dsm, (Throwable)new Exception("cause"));
                            return;
                        }
                        if (this._log.shouldLog(20)) {
                            this._log.info("Storing garlic RI down tunnel for: " + dsm.getKey() + " sent to: " + this._client);
                        }
                        this._context.inNetMessagePool().add(dsm, null, null);
                    }
                } else if (this._client != null && type == 3) {
                    DatabaseSearchReplyMessage orig = (DatabaseSearchReplyMessage)data;
                    this._context.inNetMessagePool().add(orig, null, null);
                } else if (type == 20) {
                    this._context.statManager().addRateData("tunnel.handleLoadClove", 1L);
                    data = null;
                } else if (this._client != null && type != 10) {
                    this._context.statManager().addRateData("tunnel.dropDangerousClientTunnelMessage", 1L, (long)data.getType());
                    this._log.error("Dropped dangerous message down a tunnel for " + this._client + ": " + data, (Throwable)new Exception("cause"));
                } else {
                    this._context.inNetMessagePool().add(data, null, null);
                }
                return;
            }
            case 1: {
                Hash to = instructions.getDestination();
                if (type != 20) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("cant send a " + data.getClass().getSimpleName() + " to a destination");
                    }
                } else if (this._client != null && this._client.equals((Object)to)) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("data message came down a tunnel for " + this._client);
                    }
                    DataMessage dm = (DataMessage)data;
                    Payload payload = new Payload();
                    payload.setEncryptedData(dm.getData());
                    ClientMessage m = new ClientMessage(this._client, payload);
                    this._context.clientManager().messageReceived(m);
                } else if (this._client != null) {
                    TunnelPoolSettings tgt = this._context.tunnelManager().getInboundSettings(to);
                    if (tgt != null && this._client.equals((Object)tgt.getAliasOf())) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("data message came down a tunnel for " + this._client + " targeting shared " + to);
                        }
                        DataMessage dm = (DataMessage)data;
                        Payload payload = new Payload();
                        payload.setEncryptedData(dm.getData());
                        ClientMessage m = new ClientMessage(to, payload);
                        this._context.clientManager().messageReceived(m);
                    } else if (this._log.shouldLog(40)) {
                        this._log.error("Data message came down a tunnel for " + this._client + " but targetted " + to);
                    }
                } else if (this._log.shouldLog(40)) {
                    this._log.error("Data message came down an exploratory tunnel targeting " + to);
                }
                return;
            }
            case 2: 
            case 3: {
                if (this._log.shouldLog(20)) {
                    this._log.info("clove targetted " + instructions.getRouter() + ":" + instructions.getTunnelId() + ", treat recursively to prevent leakage");
                }
                this.distribute(data, instructions.getRouter(), instructions.getTunnelId());
                return;
            }
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Unknown instruction " + instructions.getDeliveryMode() + ": " + (Object)((Object)instructions));
        }
    }
}

