/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.MessageQueue;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class TimedWeightedPriorityMessageQueue
implements MessageQueue,
OutboundMessageFragments.ActiveThrottle {
    private RouterContext _context;
    private Log _log;
    private List<OutNetMessage>[] _queue;
    private int[] _priorityLimits;
    private int[] _weighting;
    private long[] _bytesQueued;
    private int[] _messagesFlushed;
    private long[] _bytesTransferred;
    private final Object _nextLock;
    private boolean _alive;
    private int _nextQueue;
    private volatile boolean _addedSincePassBegan;
    private Expirer _expirer;
    private FailedListener _listener;
    private Set<Hash> _chokedPeers;

    public TimedWeightedPriorityMessageQueue(RouterContext ctx, int[] priorityLimits, int[] weighting, FailedListener lsnr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TimedWeightedPriorityMessageQueue.class);
        this._queue = new List[weighting.length];
        this._priorityLimits = new int[weighting.length];
        this._weighting = new int[weighting.length];
        this._bytesQueued = new long[weighting.length];
        this._bytesTransferred = new long[weighting.length];
        this._messagesFlushed = new int[weighting.length];
        for (int i = 0; i < weighting.length; ++i) {
            this._queue[i] = new ArrayList<OutNetMessage>(8);
            this._weighting[i] = weighting[i];
            this._priorityLimits[i] = priorityLimits[i];
            this._messagesFlushed[i] = 0;
            this._bytesQueued[i] = 0L;
            this._bytesTransferred[i] = 0L;
        }
        this._alive = true;
        this._nextLock = this;
        this._chokedPeers = Collections.synchronizedSet(new HashSet(16));
        this._listener = lsnr;
        this._context.statManager().createRateStat("udp.timeToEntrance", "Message lifetime until it reaches the UDP system", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.messageQueueSize", "How many messages are on the current class queue at removal", "udp", UDPTransport.RATES);
        this._expirer = new Expirer();
        I2PThread t = new I2PThread((Runnable)this._expirer, "UDP outbound expirer");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(OutNetMessage message) {
        if (message == null) {
            return;
        }
        this._context.statManager().addRateData("udp.timeToEntrance", message.getLifetime(), message.getLifetime());
        int queue = this.pickQueue(message);
        long size = message.getMessageSize();
        Object object = this._queue[queue];
        synchronized (object) {
            this._queue[queue].add(message);
            int n = queue;
            this._bytesQueued[n] = this._bytesQueued[n] + size;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Added a " + size + " byte message to queue " + queue);
        }
        object = this._nextLock;
        synchronized (object) {
            this._addedSincePassBegan = true;
            this._nextLock.notifyAll();
        }
        message.timestamp("added to queue " + queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutNetMessage getNext(long blockUntil) {
        while (this._alive) {
            Object object;
            this._addedSincePassBegan = false;
            for (int i = 0; i < this._queue.length; ++i) {
                int currentQueue = (this._nextQueue + i) % this._queue.length;
                object = this._queue[currentQueue];
                synchronized (object) {
                    for (int j = 0; j < this._queue[currentQueue].size(); ++j) {
                        OutNetMessage msg = this._queue[currentQueue].get(j);
                        Hash to = msg.getTarget().getIdentity().getHash();
                        if (this._chokedPeers.contains(to)) continue;
                        this._queue[currentQueue].remove(j);
                        long size = msg.getMessageSize();
                        int n = currentQueue;
                        this._bytesQueued[n] = this._bytesQueued[n] - size;
                        int n2 = currentQueue;
                        this._bytesTransferred[n2] = this._bytesTransferred[n2] + size;
                        int n3 = currentQueue;
                        this._messagesFlushed[n3] = this._messagesFlushed[n3] + 1;
                        if (this._messagesFlushed[currentQueue] >= this._weighting[currentQueue]) {
                            this._messagesFlushed[currentQueue] = 0;
                            this._nextQueue = (currentQueue + 1) % this._queue.length;
                        }
                        int sz = this._queue[currentQueue].size();
                        this._context.statManager().addRateData("udp.messageQueueSize", (long)sz, (long)currentQueue);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Pulling a message off queue " + currentQueue + " with " + sz + " remaining");
                        }
                        msg.timestamp("made active with remaining queue size " + sz);
                        return msg;
                    }
                    this._messagesFlushed[currentQueue] = 0;
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Nothing available on queue " + currentQueue);
                    }
                    continue;
                }
            }
            long remaining = blockUntil - this._context.clock().now();
            if (blockUntil > 0L && remaining < 0L) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Nonblocking, or block time has expired");
                }
                return null;
            }
            try {
                object = this._nextLock;
                synchronized (object) {
                    if (!this._addedSincePassBegan && this._alive) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Wait for activity (up to " + remaining + "ms)");
                        }
                        if (blockUntil < 0L) {
                            this._nextLock.wait();
                        } else {
                            this._nextLock.wait(remaining);
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._alive = false;
        Object object = this._nextLock;
        synchronized (object) {
            this._nextLock.notifyAll();
        }
    }

    @Override
    public void choke(Hash peer) {
    }

    @Override
    public void unchoke(Hash peer) {
    }

    @Override
    public boolean isChoked(Hash peer) {
        return this._chokedPeers.contains(peer);
    }

    private int pickQueue(OutNetMessage message) {
        int target = message.getPriority();
        for (int i = 0; i < this._priorityLimits.length; ++i) {
            if (this._priorityLimits[i] > target) continue;
            if (i == 0) {
                return 0;
            }
            return i - 1;
        }
        return this._priorityLimits.length - 1;
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<OutNetMessage> removed = new ArrayList<OutNetMessage>(1);
            while (TimedWeightedPriorityMessageQueue.this._alive) {
                int i;
                long now = TimedWeightedPriorityMessageQueue.this._context.clock().now();
                for (i = 0; i < TimedWeightedPriorityMessageQueue.this._queue.length; ++i) {
                    List list = TimedWeightedPriorityMessageQueue.this._queue[i];
                    synchronized (list) {
                        for (int j = 0; j < TimedWeightedPriorityMessageQueue.this._queue[i].size(); ++j) {
                            OutNetMessage m = (OutNetMessage)TimedWeightedPriorityMessageQueue.this._queue[i].get(j);
                            if (m.getExpiration() >= now) continue;
                            long[] lArray = TimedWeightedPriorityMessageQueue.this._bytesQueued;
                            int n = i;
                            lArray[n] = lArray[n] - m.getMessageSize();
                            removed.add(m);
                            TimedWeightedPriorityMessageQueue.this._queue[i].remove(j);
                            --j;
                        }
                        continue;
                    }
                }
                for (i = 0; i < removed.size(); ++i) {
                    OutNetMessage m = (OutNetMessage)removed.get(i);
                    m.timestamp("expirer killed it");
                    TimedWeightedPriorityMessageQueue.this._listener.failed(m, "expired before getting on the active pool");
                }
                removed.clear();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    public static interface FailedListener {
        public void failed(OutNetMessage var1, String var2);
    }
}

