/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.IPThrottler;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerTestState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class PeerTestManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder _packetBuilder;
    private final Map<Long, PeerTestState> _activeTests;
    private PeerTestState _currentTest;
    private boolean _currentTestComplete;
    private final Queue<Long> _recentTests;
    private final IPThrottler _throttle;
    private static final int MAX_RELAYED_PER_TEST_ALICE = 9;
    private static final int MAX_RELAYED_PER_TEST_BOB = 6;
    private static final int MAX_RELAYED_PER_TEST_CHARLIE = 6;
    private static final int MAX_CHARLIE_LIFETIME = 15000;
    private static final int MAX_ACTIVE_TESTS = 20;
    private static final int MAX_RECENT_TESTS = 40;
    private static final int MAX_PER_IP = 12;
    private static final long THROTTLE_CLEAN_TIME = 600000L;
    private static final int RESEND_TIMEOUT = 4000;
    private static final int MAX_TEST_TIME = 30000;
    private static final long MAX_NONCE = 0xFFFFFFFFL;
    private static final long CHARLIE_RECENT_PERIOD = 600000L;

    public PeerTestManager(RouterContext context, UDPTransport transport) {
        this._context = context;
        this._transport = transport;
        this._log = context.logManager().getLog(PeerTestManager.class);
        this._activeTests = new ConcurrentHashMap<Long, PeerTestState>();
        this._recentTests = new LinkedBlockingQueue<Long>();
        this._packetBuilder = new PacketBuilder(context, transport);
        this._throttle = new IPThrottler(12, 600000L);
        this._context.statManager().createRateStat("udp.statusKnownCharlie", "How often the bob we pick passes us to a charlie we already have a session with?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveTestReply", "How often we get a reply to our peer test?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveTest", "How often we get a packet requesting us to participate in a peer test?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.testBadIP", "Received IP or port was bad", "udp", UDPTransport.RATES);
    }

    public synchronized void runTest(InetAddress bobIP, int bobPort, SessionKey bobCipherKey, SessionKey bobMACKey) {
        if (this._currentTest != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("We are already running a test: " + this._currentTest + ", aborting test with bob = " + bobIP);
            }
            return;
        }
        if (this._transport.isTooClose(bobIP.getAddress())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not running test with Bob too close to us " + bobIP);
            }
            return;
        }
        PeerTestState test = new PeerTestState(PeerTestState.Role.ALICE, this._context.random().nextLong(0xFFFFFFFFL), this._context.clock().now());
        test.setBobIP(bobIP);
        test.setBobPort(bobPort);
        test.setBobCipherKey(bobCipherKey);
        test.setBobMACKey(bobMACKey);
        test.setLastSendTime(test.getBeginTime());
        this._currentTest = test;
        this._currentTestComplete = false;
        if (this._log.shouldLog(10)) {
            this._log.debug("Start new test: " + test);
        }
        while (this._recentTests.size() > 40) {
            this._recentTests.poll();
        }
        this._recentTests.offer(test.getNonce());
        test.incrementPacketsRelayed();
        this.sendTestToBob();
        this._context.simpleTimer2().addEvent((SimpleTimer.TimedEvent)new ContinueTest(test.getNonce()), 4000L);
    }

    private boolean expired() {
        PeerTestState state = this._currentTest;
        if (state != null) {
            return state.getBeginTime() + 30000L < this._context.clock().now();
        }
        return true;
    }

    private void sendTestToBob() {
        PeerTestState test = this._currentTest;
        if (!this.expired()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending test to Bob: " + test);
            }
            this._transport.send(this._packetBuilder.buildPeerTestFromAlice(test.getBobIP(), test.getBobPort(), test.getBobCipherKey(), test.getBobMACKey(), test.getNonce(), this._transport.getIntroKey()));
        } else {
            this._currentTest = null;
        }
    }

    private void sendTestToCharlie() {
        PeerTestState test = this._currentTest;
        if (!this.expired()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending test to Charlie: " + test);
            }
            this._transport.send(this._packetBuilder.buildPeerTestFromAlice(test.getCharlieIP(), test.getCharliePort(), test.getCharlieIntroKey(), test.getNonce(), this._transport.getIntroKey()));
        } else {
            this._currentTest = null;
        }
    }

    private synchronized void receiveTestReply(RemoteHostId from, UDPPacketReader.PeerTestReader testInfo) {
        this._context.statManager().addRateData("udp.receiveTestReply", 1L);
        PeerTestState test = this._currentTest;
        if (this.expired()) {
            return;
        }
        if (this._currentTestComplete) {
            return;
        }
        if (DataHelper.eq((byte[])from.getIP(), (byte[])test.getBobIP().getAddress()) && from.getPort() == test.getBobPort()) {
            int ipSize = testInfo.readIPSize();
            if (ipSize != 4) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Bad IP length " + ipSize + " from bob's reply: " + from + ", " + testInfo);
                }
                return;
            }
            byte[] ip = new byte[ipSize];
            testInfo.readIP(ip, 0);
            try {
                InetAddress addr = InetAddress.getByAddress(ip);
                test.setAliceIP(addr);
                test.setReceiveBobTime(this._context.clock().now());
                int testPort = testInfo.readPort();
                if (testPort == 0) {
                    throw new UnknownHostException("port 0");
                }
                test.setAlicePort(testPort);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Receive test reply from Bob: " + test);
                }
                if (test.getAlicePortFromCharlie() > 0) {
                    this.testComplete(false);
                }
            }
            catch (UnknownHostException uhe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to get our IP (length " + ipSize + ") from bob's reply: " + from + ", " + testInfo, (Throwable)uhe);
                }
                this._context.statManager().addRateData("udp.testBadIP", 1L);
            }
        } else {
            PeerState charlieSession = this._transport.getPeerState(from);
            long recentBegin = this._context.clock().now() - 600000L;
            if (charlieSession != null && (charlieSession.getLastACKSend() > recentBegin || charlieSession.getLastSendTime() > recentBegin)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Bob chose a charlie we already have a session to, cancelling the test and rerunning (bob: " + this._currentTest + ", charlie: " + from + ")");
                }
                this._currentTestComplete = true;
                this._context.statManager().addRateData("udp.statusKnownCharlie", 1L);
                this.honorStatus(CommSystemFacade.Status.UNKNOWN);
                this._currentTest = null;
                return;
            }
            if (test.getReceiveCharlieTime() > 0L) {
                try {
                    int testPort = testInfo.readPort();
                    if (testPort == 0) {
                        throw new UnknownHostException("port 0");
                    }
                    test.setAlicePortFromCharlie(testPort);
                    byte[] ip = new byte[testInfo.readIPSize()];
                    if (ip.length != 4) {
                        throw new UnknownHostException("not IPv4");
                    }
                    testInfo.readIP(ip, 0);
                    InetAddress addr = InetAddress.getByAddress(ip);
                    test.setAliceIPFromCharlie(addr);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Receive test reply from Charlie: " + test);
                    }
                    if (test.getReceiveBobTime() > 0L) {
                        this.testComplete(true);
                    }
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Charlie @ " + from + " said we were an invalid IP address: " + uhe.getMessage(), (Throwable)uhe);
                    }
                    this._context.statManager().addRateData("udp.testBadIP", 1L);
                }
            } else {
                if (test.incrementPacketsRelayed() > 9) {
                    this.testComplete(false);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Sent too many packets on the test: " + test);
                    }
                    return;
                }
                if (this._log.shouldLog(20) && charlieSession != null) {
                    this._log.info("Bob chose a charlie we last acked " + DataHelper.formatDuration((long)(this._context.clock().now() - charlieSession.getLastACKSend())) + " last sent " + DataHelper.formatDuration((long)(this._context.clock().now() - charlieSession.getLastSendTime())) + " (bob: " + this._currentTest + ", charlie: " + from + ")");
                }
                test.setReceiveCharlieTime(this._context.clock().now());
                SessionKey charlieIntroKey = new SessionKey(new byte[32]);
                testInfo.readIntroKey(charlieIntroKey.getData(), 0);
                test.setCharlieIntroKey(charlieIntroKey);
                try {
                    test.setCharlieIP(InetAddress.getByAddress(from.getIP()));
                    test.setCharliePort(from.getPort());
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Receive test from Charlie: " + test);
                    }
                    this.sendTestToCharlie();
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Charlie's IP is b0rked: " + from + ": " + testInfo);
                    }
                    this._context.statManager().addRateData("udp.testBadIP", 1L);
                }
            }
        }
    }

    private void testComplete(boolean forgetTest) {
        this._currentTestComplete = true;
        PeerTestState test = this._currentTest;
        CommSystemFacade.Status status = test.getAlicePortFromCharlie() > 0 ? (test.getAlicePort() == test.getAlicePortFromCharlie() && test.getAliceIP() != null && test.getAliceIPFromCharlie() != null && test.getAliceIP().equals(test.getAliceIPFromCharlie()) ? CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN : CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN) : (test.getReceiveCharlieTime() > 0L ? CommSystemFacade.Status.UNKNOWN : (test.getReceiveBobTime() > 0L ? CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN : CommSystemFacade.Status.UNKNOWN));
        if (this._log.shouldLog(20)) {
            this._log.info("Test complete: " + test);
        }
        this.honorStatus(status);
        if (forgetTest) {
            this._currentTest = null;
        }
    }

    private void honorStatus(CommSystemFacade.Status status) {
        if (this._log.shouldLog(20)) {
            this._log.info("Test results: status = " + (Object)((Object)status));
        }
        this._transport.setReachabilityStatus(status);
    }

    public void receiveTest(RemoteHostId from, UDPPacketReader reader) {
        this._context.statManager().addRateData("udp.receiveTest", 1L);
        byte[] fromIP = from.getIP();
        int fromPort = from.getPort();
        if (!TransportUtil.isValidPort(fromPort) || !this._transport.isValid(fromIP) || this._transport.isTooClose(fromIP) || this._context.blocklist().isBlocklisted(fromIP)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid PeerTest address: " + Addresses.toString((byte[])fromIP, (int)fromPort));
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
            return;
        }
        UDPPacketReader.PeerTestReader testInfo = reader.getPeerTestReader();
        byte[] testIP = null;
        int testPort = testInfo.readPort();
        if (testInfo.readIPSize() > 0) {
            testIP = new byte[testInfo.readIPSize()];
            testInfo.readIP(testIP, 0);
        }
        if (testPort > 0 && !TransportUtil.isValidPort(testPort) || testIP != null && (!this._transport.isValid(testIP) || testIP.length != 4 || this._context.blocklist().isBlocklisted(testIP))) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid address in PeerTest: " + Addresses.toString((byte[])testIP, (int)testPort));
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
            return;
        }
        long nonce = testInfo.readNonce();
        PeerTestState test = this._currentTest;
        if (test != null && test.getNonce() == nonce) {
            this.receiveTestReply(from, testInfo);
            return;
        }
        if (this._throttle.shouldThrottle(fromIP)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("PeerTest throttle from " + Addresses.toString((byte[])fromIP, (int)fromPort));
            }
            return;
        }
        if (testIP != null && this._throttle.shouldThrottle(testIP)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("PeerTest throttle to " + Addresses.toString((byte[])testIP, (int)testPort));
            }
            return;
        }
        Long lNonce = nonce;
        PeerTestState state = this._activeTests.get(lNonce);
        if (testIP != null && this._transport.isTooClose(testIP)) {
            if (this._recentTests.contains(lNonce)) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Got delayed reply on nonce " + nonce + " from: " + Addresses.toString((byte[])fromIP, (int)fromPort));
                }
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Nearby address in PeerTest: " + Addresses.toString((byte[])testIP, (int)testPort) + " from: " + Addresses.toString((byte[])fromIP, (int)fromPort) + " state? " + state);
                }
                this._context.statManager().addRateData("udp.testBadIP", 1L);
            }
            return;
        }
        if (state == null) {
            if (testIP == null || testPort <= 0) {
                if (this._activeTests.size() >= 20) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Too many active tests, droppping from Alice " + Addresses.toString((byte[])fromIP, (int)fromPort));
                    }
                    return;
                }
                if (this._transport.getPeerState(from) == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No session, dropping new test from Alice " + Addresses.toString((byte[])fromIP, (int)fromPort));
                    }
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("test IP/port are blank coming from " + from + ", assuming we are Bob and they are alice");
                }
                this.receiveFromAliceAsBob(from, testInfo, nonce, null);
            } else if (!this._recentTests.contains(lNonce)) {
                if (this._activeTests.size() >= 20) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Too many active tests, droppping from Bob " + Addresses.toString((byte[])fromIP, (int)fromPort));
                    }
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("We are charlie, as the testIP/port is " + Addresses.toString((byte[])testIP, (int)testPort) + " and the state is unknown for " + nonce);
                }
                this.receiveFromBobAsCharlie(from, testInfo, nonce, null);
            }
        } else if (state.getOurRole() == PeerTestState.Role.BOB) {
            if (DataHelper.eq((byte[])fromIP, (byte[])state.getAliceIP().getAddress()) && fromPort == state.getAlicePort()) {
                this.receiveFromAliceAsBob(from, testInfo, nonce, state);
            } else if (DataHelper.eq((byte[])fromIP, (byte[])state.getCharlieIP().getAddress()) && fromPort == state.getCharliePort()) {
                this.receiveFromCharlieAsBob(from, state);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Received from a fourth party as bob!  alice: " + state.getAliceIP() + ", charlie: " + state.getCharlieIP() + ", dave: " + from);
            }
        } else if (state.getOurRole() == PeerTestState.Role.CHARLIE) {
            if (testIP == null || testPort <= 0) {
                this.receiveFromAliceAsCharlie(from, testInfo, nonce, state);
            } else {
                this.receiveFromBobAsCharlie(from, testInfo, nonce, state);
            }
        }
    }

    private void receiveFromBobAsCharlie(RemoteHostId from, UDPPacketReader.PeerTestReader testInfo, long nonce, PeerTestState state) {
        long now = this._context.clock().now();
        boolean isNew = false;
        if (state == null) {
            isNew = true;
            state = new PeerTestState(PeerTestState.Role.CHARLIE, nonce, now);
        } else if (state.getReceiveBobTime() > now - 2000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too soon, not retransmitting: " + state);
            }
            return;
        }
        int sz = testInfo.readIPSize();
        byte[] aliceIPData = new byte[sz];
        try {
            testInfo.readIP(aliceIPData, 0);
            if (sz != 4) {
                throw new UnknownHostException("not IPv4");
            }
            int alicePort = testInfo.readPort();
            if (alicePort == 0) {
                throw new UnknownHostException("port 0");
            }
            InetAddress aliceIP = InetAddress.getByAddress(aliceIPData);
            InetAddress bobIP = InetAddress.getByAddress(from.getIP());
            SessionKey aliceIntroKey = new SessionKey(new byte[32]);
            testInfo.readIntroKey(aliceIntroKey.getData(), 0);
            state.setAliceIP(aliceIP);
            state.setAlicePort(alicePort);
            state.setAliceIntroKey(aliceIntroKey);
            state.setBobIP(bobIP);
            state.setBobPort(from.getPort());
            state.setLastSendTime(now);
            state.setReceiveBobTime(now);
            PeerState bob = this._transport.getPeerState(from);
            if (bob == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Received from bob (" + from + ") who hasn't established a session with us, refusing to help him test " + aliceIP + ":" + alicePort);
                }
                return;
            }
            state.setBobCipherKey(bob.getCurrentCipherKey());
            state.setBobMACKey(bob.getCurrentMACKey());
            if (state.incrementPacketsRelayed() > 6) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Too many, not retransmitting: " + state);
                }
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive from Bob: " + state);
            }
            if (isNew) {
                this._activeTests.put(nonce, state);
                this._context.simpleTimer2().addEvent((SimpleTimer.TimedEvent)new RemoveTest(nonce), 15000L);
            }
            UDPPacket packet = this._packetBuilder.buildPeerTestToBob(bobIP, from.getPort(), aliceIP, alicePort, aliceIntroKey, nonce, state.getBobCipherKey(), state.getBobMACKey());
            this._transport.send(packet);
            packet = this._packetBuilder.buildPeerTestToAlice(aliceIP, alicePort, aliceIntroKey, this._transport.getIntroKey(), nonce);
            this._transport.send(packet);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to build the aliceIP from " + from + ", ip size: " + sz + " ip val: " + Base64.encode((byte[])aliceIPData), (Throwable)uhe);
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
        }
    }

    private void receiveFromAliceAsBob(RemoteHostId from, UDPPacketReader.PeerTestReader testInfo, long nonce, PeerTestState state) {
        PeerState charlie;
        RouterInfo charlieInfo = null;
        if (state == null) {
            if (from.getIP().length != 4) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("PeerTest over IPv6 from Alice as Bob? " + from);
                }
                return;
            }
            charlie = this._transport.pickTestPeer(PeerTestState.Role.CHARLIE, from);
        } else {
            charlie = this._transport.getPeerState(new RemoteHostId(state.getCharlieIP().getAddress(), state.getCharliePort()));
        }
        if (charlie != null) {
            charlieInfo = this._context.netDb().lookupRouterInfoLocally(charlie.getRemotePeer());
        }
        if (charlie == null || charlieInfo == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to pick a charlie");
            }
            return;
        }
        InetAddress aliceIP = null;
        SessionKey aliceIntroKey = null;
        try {
            aliceIP = InetAddress.getByAddress(from.getIP());
            aliceIntroKey = new SessionKey(new byte[32]);
            testInfo.readIntroKey(aliceIntroKey.getData(), 0);
            RouterAddress raddr = this._transport.getTargetAddress(charlieInfo);
            if (raddr == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to pick a charlie");
                }
                return;
            }
            UDPAddress addr = new UDPAddress(raddr);
            byte[] ikey = addr.getIntroKey();
            if (ikey == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to pick a charlie");
                }
                return;
            }
            SessionKey charlieIntroKey = new SessionKey(ikey);
            long now = this._context.clock().now();
            boolean isNew = false;
            if (state == null) {
                isNew = true;
                state = new PeerTestState(PeerTestState.Role.BOB, nonce, now);
            } else if (state.getReceiveAliceTime() > now - 2000L) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Too soon, not retransmitting: " + state);
                }
                return;
            }
            state.setAliceIP(aliceIP);
            state.setAlicePort(from.getPort());
            state.setAliceIntroKey(aliceIntroKey);
            state.setCharlieIP(charlie.getRemoteIPAddress());
            state.setCharliePort(charlie.getRemotePort());
            state.setCharlieIntroKey(charlieIntroKey);
            state.setLastSendTime(now);
            state.setReceiveAliceTime(now);
            if (state.incrementPacketsRelayed() > 6) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Too many, not retransmitting: " + state);
                }
                return;
            }
            if (isNew) {
                this._activeTests.put(nonce, state);
                this._context.simpleTimer2().addEvent((SimpleTimer.TimedEvent)new RemoveTest(nonce), 15000L);
            }
            UDPPacket packet = this._packetBuilder.buildPeerTestToCharlie(aliceIP, from.getPort(), aliceIntroKey, nonce, charlie.getRemoteIPAddress(), charlie.getRemotePort(), charlie.getCurrentCipherKey(), charlie.getCurrentMACKey());
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive from Alice: " + state);
            }
            this._transport.send(packet);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to build the aliceIP from " + from, (Throwable)uhe);
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
        }
    }

    private void receiveFromCharlieAsBob(RemoteHostId from, PeerTestState state) {
        long now = this._context.clock().now();
        if (state.getReceiveCharlieTime() > now - 2000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too soon, not retransmitting: " + state);
            }
            return;
        }
        if (state.incrementPacketsRelayed() > 6) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too many, not retransmitting: " + state);
            }
            return;
        }
        state.setReceiveCharlieTime(now);
        UDPPacket packet = this._packetBuilder.buildPeerTestToAlice(state.getAliceIP(), state.getAlicePort(), state.getAliceIntroKey(), state.getCharlieIntroKey(), state.getNonce());
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive from Charlie, sending Alice back the OK: " + state);
        }
        this._transport.send(packet);
    }

    private void receiveFromAliceAsCharlie(RemoteHostId from, UDPPacketReader.PeerTestReader testInfo, long nonce, PeerTestState state) {
        long now = this._context.clock().now();
        if (state.getReceiveAliceTime() > now - 2000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too soon, not retransmitting: " + state);
            }
            return;
        }
        if (state.incrementPacketsRelayed() > 6) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too many, not retransmitting: " + state);
            }
            return;
        }
        state.setReceiveAliceTime(now);
        try {
            InetAddress aliceIP = InetAddress.getByAddress(from.getIP());
            SessionKey aliceIntroKey = new SessionKey(new byte[32]);
            testInfo.readIntroKey(aliceIntroKey.getData(), 0);
            UDPPacket packet = this._packetBuilder.buildPeerTestToAlice(aliceIP, from.getPort(), aliceIntroKey, this._transport.getIntroKey(), nonce);
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive from Alice: " + state);
            }
            this._transport.send(packet);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to build the aliceIP from " + from, (Throwable)uhe);
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
        }
    }

    private class ContinueTest
    implements SimpleTimer.TimedEvent {
        private final long _nonce;

        public ContinueTest(long nonce) {
            this._nonce = nonce;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            PeerTestManager peerTestManager = PeerTestManager.this;
            synchronized (peerTestManager) {
                PeerTestState state = PeerTestManager.this._currentTest;
                if (state == null || state.getNonce() != this._nonce) {
                    return;
                }
                if (PeerTestManager.this.expired()) {
                    PeerTestManager.this.testComplete(true);
                } else if (PeerTestManager.this._context.clock().now() - state.getLastSendTime() >= 4000L) {
                    int sent = state.incrementPacketsRelayed();
                    if (sent > 9) {
                        PeerTestManager.this.testComplete(false);
                        if (PeerTestManager.this._log.shouldLog(30)) {
                            PeerTestManager.this._log.warn("Sent too many packets: " + state);
                        }
                        return;
                    }
                    if (state.getReceiveBobTime() <= 0L) {
                        PeerTestManager.this.sendTestToBob();
                    } else if (state.getReceiveCharlieTime() <= 0L) {
                        PeerTestManager.this.sendTestToBob();
                    } else {
                        PeerTestManager.this.sendTestToCharlie();
                    }
                    PeerTestManager.this._context.simpleTimer2().addEvent((SimpleTimer.TimedEvent)this, (long)(4000 + sent * 1000));
                }
            }
        }
    }

    private class RemoveTest
    implements SimpleTimer.TimedEvent {
        private final long _nonce;

        public RemoveTest(long nonce) {
            this._nonce = nonce;
        }

        public void timeReached() {
            PeerTestManager.this._activeTests.remove(this._nonce);
        }
    }
}

