/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SipHash;

class IPThrottler {
    private ObjectCounter<Integer> _counter;
    private final int _max;

    public IPThrottler(int max, long time) {
        this._max = max;
        this._counter = new ObjectCounter();
        SimpleTimer2.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new Cleaner(), time);
    }

    public boolean shouldThrottle(byte[] ip) {
        Integer key = ip.length == 4 ? IPThrottler.toInt(ip) : Integer.valueOf(SipHash.hashCode((byte[])ip));
        return this._counter.increment((Object)key) > this._max;
    }

    private static Integer toInt(byte[] ip) {
        int rv = 0;
        for (int i = 0; i < 4; ++i) {
            rv |= (ip[i] & 0xFF) << (3 - i) * 8;
        }
        return rv;
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        public void timeReached() {
            IPThrottler.this._counter.clear();
        }
    }
}

