/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SystemVersion;

class EventPumper
implements Runnable {
    private final RouterContext _context;
    private final Log _log;
    private volatile boolean _alive;
    private Selector _selector;
    private final Set<NTCPConnection> _wantsWrite = new ConcurrentHashSet(32);
    private final Queue<NTCPConnection> _wantsRead = new ConcurrentLinkedQueue<NTCPConnection>();
    private final Queue<ServerSocketChannel> _wantsRegister = new ConcurrentLinkedQueue<ServerSocketChannel>();
    private final Queue<NTCPConnection> _wantsConRegister = new ConcurrentLinkedQueue<NTCPConnection>();
    private final NTCPTransport _transport;
    private final ObjectCounter<ByteArray> _blockedIPs;
    private long _expireIdleWriteTime;
    private boolean _useDirect;
    private static final int BUF_SIZE = 8192;
    private static final int MAX_CACHE_SIZE = 64;
    private static final LinkedBlockingQueue<ByteBuffer> _bufCache = new LinkedBlockingQueue(64);
    private static final long FAILSAFE_ITERATION_FREQ = 2000L;
    private static final long SELECTOR_LOOP_DELAY = 200L;
    private static final long BLOCKED_IP_FREQ = 180000L;
    private static final long MIN_EXPIRE_IDLE_TIME = 120000L;
    private static final long MAX_EXPIRE_IDLE_TIME = 660000L;
    private static final String PROP_DIRECT = "i2np.ntcp.useDirectBuffers";
    private static final int MIN_MINB = 4;
    private static final int MAX_MINB = 12;
    private static final int MIN_BUFS;
    private static int _numBufs;
    private static int __consecutiveExtra;
    private long _lastExpired;

    public EventPumper(RouterContext ctx, NTCPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._transport = transport;
        this._expireIdleWriteTime = 660000L;
        this._blockedIPs = new ObjectCounter();
        this._context.statManager().createRateStat("ntcp.pumperKeySetSize", "", "ntcp", new long[]{600000L});
        this._context.statManager().createRateStat("ntcp.pumperLoopsPerSecond", "", "ntcp", new long[]{600000L});
        this._context.statManager().createRateStat("ntcp.zeroRead", "", "ntcp", new long[]{600000L});
        this._context.statManager().createRateStat("ntcp.zeroReadDrop", "", "ntcp", new long[]{600000L});
        this._context.statManager().createRateStat("ntcp.dropInboundNoMessage", "", "ntcp", new long[]{600000L});
    }

    public synchronized void startPumping() {
        if (this._log.shouldLog(20)) {
            this._log.info("Starting pumper");
        }
        try {
            this._selector = Selector.open();
            this._alive = true;
            new I2PThread((Runnable)this, "NTCP Pumper", true).start();
        }
        catch (IOException ioe) {
            this._log.log(50, "Error opening the NTCP selector", (Throwable)ioe);
        }
        catch (InternalError jlie) {
            this._log.log(50, "Error opening the NTCP selector", (Throwable)jlie);
        }
    }

    public synchronized void stopPumping() {
        this._alive = false;
        if (this._selector != null && this._selector.isOpen()) {
            this._selector.wakeup();
        }
    }

    public boolean isAlive() {
        return this._alive || this._selector != null && this._selector.isOpen();
    }

    public void register(ServerSocketChannel chan) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Registering server socket channel");
        }
        this._wantsRegister.offer(chan);
        this._selector.wakeup();
    }

    public void registerConnect(NTCPConnection con) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Registering " + con);
        }
        this._context.statManager().addRateData("ntcp.registerConnect", 1L);
        this._wantsConRegister.offer(con);
        this._selector.wakeup();
    }

    @Override
    public void run() {
        long lastFailsafeIteration;
        int loopCount = 0;
        long lastBlockedIPClear = lastFailsafeIteration = System.currentTimeMillis();
        while (this._alive && this._selector.isOpen()) {
            try {
                boolean newUseDirect;
                long now;
                block36: {
                    block35: {
                        ++loopCount;
                        this.runDelayedEvents();
                        try {
                            int count = this._selector.select(200L);
                            if (count <= 0) break block35;
                            Set<SelectionKey> selected = this._selector.selectedKeys();
                            this.processKeys(selected);
                            selected.clear();
                        }
                        catch (ClosedSelectorException cse) {
                            continue;
                        }
                        catch (IOException ioe) {
                            if (!this._log.shouldLog(30)) break block35;
                            this._log.warn("Error selecting", (Throwable)ioe);
                        }
                        catch (CancelledKeyException cke) {
                            if (!this._log.shouldLog(30)) continue;
                            this._log.warn("Error selecting", (Throwable)cke);
                            continue;
                        }
                    }
                    now = System.currentTimeMillis();
                    if (lastFailsafeIteration + 2000L < now) {
                        lastFailsafeIteration = now;
                        try {
                            Set<SelectionKey> all = this._selector.keys();
                            this._context.statManager().addRateData("ntcp.pumperKeySetSize", (long)all.size());
                            this._context.statManager().addRateData("ntcp.pumperLoopsPerSecond", (long)loopCount / 2L);
                            loopCount = 0;
                            int failsafeWrites = 0;
                            int failsafeCloses = 0;
                            int failsafeInvalid = 0;
                            this._expireIdleWriteTime = this._transport.haveCapacity(33) ? Math.min(this._expireIdleWriteTime + 1000L, 660000L) : Math.max(this._expireIdleWriteTime - 3000L, 120000L);
                            for (SelectionKey key : all) {
                                try {
                                    Object att = key.attachment();
                                    if (!(att instanceof NTCPConnection)) continue;
                                    NTCPConnection con = (NTCPConnection)att;
                                    if (!key.isValid() && !((SocketChannel)key.channel()).isConnectionPending() && con.getTimeSinceCreated() > 20000L) {
                                        if (this._log.shouldLog(20)) {
                                            this._log.info("Removing invalid key for " + con);
                                        }
                                        con.close();
                                        ++failsafeInvalid;
                                        continue;
                                    }
                                    if (!con.isWriteBufEmpty() && (key.interestOps() & 4) == 0) {
                                        if (this._log.shouldLog(20)) {
                                            this._log.info("Failsafe write for " + con);
                                        }
                                        key.interestOps(4 | key.interestOps());
                                        ++failsafeWrites;
                                    }
                                    if (con.getTimeSinceSend() <= this._expireIdleWriteTime || con.getTimeSinceReceive() <= this._expireIdleWriteTime) continue;
                                    con.close();
                                    ++failsafeCloses;
                                }
                                catch (CancelledKeyException cke) {}
                            }
                            if (failsafeWrites > 0) {
                                this._context.statManager().addRateData("ntcp.failsafeWrites", (long)failsafeWrites);
                            }
                            if (failsafeCloses > 0) {
                                this._context.statManager().addRateData("ntcp.failsafeCloses", (long)failsafeCloses);
                            }
                            if (failsafeInvalid > 0) {
                                this._context.statManager().addRateData("ntcp.failsafeInvalid", (long)failsafeInvalid);
                            }
                            break block36;
                        }
                        catch (ClosedSelectorException cse) {
                            continue;
                        }
                    }
                    if (loopCount % 512 == 511) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("EventPumper throttle " + loopCount + " loops in " + (now - lastFailsafeIteration) + " ms");
                        }
                        this._context.statManager().addRateData("ntcp.failsafeThrottle", 1L);
                        try {
                            Thread.sleep(25L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
                if (lastBlockedIPClear + 180000L < now) {
                    this._blockedIPs.clear();
                    lastBlockedIPClear = now;
                }
                if (this._useDirect == (newUseDirect = this._context.getBooleanProperty(PROP_DIRECT))) continue;
                this._useDirect = newUseDirect;
                _bufCache.clear();
            }
            catch (RuntimeException re) {
                this._log.error("Error in the event pumper", (Throwable)re);
            }
        }
        try {
            if (this._selector.isOpen()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Closing down the event pumper with selection keys remaining");
                }
                Set<SelectionKey> keys = this._selector.keys();
                for (SelectionKey key : keys) {
                    try {
                        Object att = key.attachment();
                        if (att instanceof ServerSocketChannel) {
                            ServerSocketChannel chan = (ServerSocketChannel)att;
                            chan.close();
                            key.cancel();
                            continue;
                        }
                        if (!(att instanceof NTCPConnection)) continue;
                        NTCPConnection con = (NTCPConnection)att;
                        con.close();
                        key.cancel();
                    }
                    catch (Exception ke) {
                        this._log.error("Error closing key " + key + " on pumper shutdown", (Throwable)ke);
                    }
                }
                this._selector.close();
            } else if (this._log.shouldLog(10)) {
                this._log.debug("Closing down the event pumper with no selection keys remaining");
            }
        }
        catch (Exception e) {
            this._log.error("Error closing keys on pumper shutdown", (Throwable)e);
        }
        this._wantsConRegister.clear();
        this._wantsRead.clear();
        this._wantsRegister.clear();
        this._wantsWrite.clear();
        _bufCache.clear();
    }

    private void processKeys(Set<SelectionKey> selected) {
        for (SelectionKey key : selected) {
            try {
                boolean write;
                int ops = key.readyOps();
                boolean accept = (ops & 0x10) != 0;
                boolean connect = (ops & 8) != 0;
                boolean read = (ops & 1) != 0;
                boolean bl = write = (ops & 4) != 0;
                if (accept) {
                    this._context.statManager().addRateData("ntcp.accept", 1L);
                    this.processAccept(key);
                }
                if (connect) {
                    key.interestOps(key.interestOps() & 0xFFFFFFF7);
                    this.processConnect(key);
                }
                if (read) {
                    this.processRead(key);
                }
                if (!write) continue;
                this.processWrite(key);
            }
            catch (CancelledKeyException cke) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("key cancelled");
            }
        }
    }

    public void wantsWrite(NTCPConnection con, byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        FIFOBandwidthLimiter.Request req = this._context.bandwidthLimiter().requestOutbound(data.length, 0, "NTCP write");
        if (req.getPendingRequested() > 0) {
            if (this._log.shouldLog(20)) {
                this._log.info("queued write on " + con + " for " + data.length);
            }
            this._context.statManager().addRateData("ntcp.wantsQueuedWrite", 1L);
            con.queuedWrite(buf, req);
        } else {
            con.write(buf);
        }
    }

    public void wantsWrite(NTCPConnection con) {
        if (this._wantsWrite.add(con)) {
            this._selector.wakeup();
        }
    }

    public void wantsRead(NTCPConnection con) {
        this._wantsRead.offer(con);
        this._selector.wakeup();
    }

    private ByteBuffer acquireBuf() {
        ByteBuffer rv = _bufCache.poll();
        if (rv == null || rv.isDirect() != this._useDirect) {
            rv = this._useDirect ? ByteBuffer.allocateDirect(8192) : ByteBuffer.allocate(8192);
            ++_numBufs;
        }
        return rv;
    }

    public static void releaseBuf(ByteBuffer buf) {
        boolean cached;
        if (buf.capacity() < 8192) {
            I2PAppContext.getGlobalContext().logManager().getLog(EventPumper.class).error("Bad size " + buf.capacity(), (Throwable)new Exception());
            return;
        }
        buf.clear();
        int extra = _bufCache.size();
        boolean bl = cached = extra < _numBufs;
        if (cached) {
            _bufCache.offer(buf);
            if (extra > MIN_BUFS && ++__consecutiveExtra >= 20) {
                if (_numBufs > MIN_BUFS) {
                    --_numBufs;
                }
                __consecutiveExtra = 0;
            }
        }
    }

    private void processAccept(SelectionKey key) {
        ServerSocketChannel servChan = (ServerSocketChannel)key.attachment();
        try {
            SocketChannel chan = servChan.accept();
            if (chan == null) {
                return;
            }
            chan.configureBlocking(false);
            if (!this._transport.allowConnection()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Receive session request but at connection limit: " + chan.socket().getInetAddress());
                }
                try {
                    chan.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            byte[] ip = chan.socket().getInetAddress().getAddress();
            if (this._context.blocklist().isBlocklisted(ip)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Receive session request from blocklisted IP: " + chan.socket().getInetAddress());
                }
                try {
                    chan.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            ByteArray ba = new ByteArray(ip);
            int count = this._blockedIPs.count((Object)ba);
            if (count > 0) {
                count = this._blockedIPs.increment((Object)ba);
                if (this._log.shouldLog(30)) {
                    this._log.warn("Blocking accept of IP with count " + count + ": " + Addresses.toString((byte[])ip));
                }
                this._context.statManager().addRateData("ntcp.dropInboundNoMessage", (long)count);
                try {
                    chan.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return;
            }
            if (this.shouldSetKeepAlive(chan)) {
                chan.socket().setKeepAlive(true);
            }
            SelectionKey ckey = chan.register(this._selector, 1);
            new NTCPConnection(this._context, this._transport, chan, ckey);
        }
        catch (IOException ioe) {
            this._log.error("Error accepting", (Throwable)ioe);
        }
    }

    private void processConnect(SelectionKey key) {
        block8: {
            NTCPConnection con = (NTCPConnection)key.attachment();
            try {
                SocketChannel chan = con.getChannel();
                boolean connected = chan.finishConnect();
                if (this._log.shouldLog(10)) {
                    this._log.debug("processing connect for " + con + ": connected? " + connected);
                }
                if (connected) {
                    if (this.shouldSetKeepAlive(chan)) {
                        chan.socket().setKeepAlive(true);
                    }
                    con.setKey(key);
                    con.outboundConnected();
                    this._context.statManager().addRateData("ntcp.connectSuccessful", 1L);
                } else {
                    con.closeOnTimeout("connect failed", null);
                    this._transport.markUnreachable(con.getRemotePeer().calculateHash());
                    this._context.statManager().addRateData("ntcp.connectFailedTimeout", 1L);
                }
            }
            catch (IOException ioe) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Failed outbound " + con, (Throwable)ioe);
                }
                con.closeOnTimeout("connect failed", ioe);
                this._transport.markUnreachable(con.getRemotePeer().calculateHash());
                this._context.statManager().addRateData("ntcp.connectFailedTimeoutIOE", 1L);
            }
            catch (NoConnectionPendingException ncpe) {
                if (!this._log.shouldLog(30)) break block8;
                this._log.warn("error connecting on " + con, (Throwable)ncpe);
            }
        }
    }

    private boolean shouldSetKeepAlive(SocketChannel chan) {
        if (chan.socket().getInetAddress() instanceof Inet6Address) {
            return false;
        }
        CommSystemFacade.Status status = this._context.commSystem().getStatus();
        return status != CommSystemFacade.Status.OK && status != CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN && status != CommSystemFacade.Status.IPV4_OK_IPV6_FIREWALLED;
    }

    private void processRead(SelectionKey key) {
        block32: {
            NTCPConnection con = (NTCPConnection)key.attachment();
            ByteBuffer buf = this.acquireBuf();
            try {
                int read = con.getChannel().read(buf);
                if (read < 0) {
                    if (con.isInbound() && con.getMessagesReceived() <= 0L) {
                        int count;
                        InetAddress addr = con.getChannel().socket().getInetAddress();
                        if (addr != null) {
                            byte[] ip = addr.getAddress();
                            ByteArray ba = new ByteArray(ip);
                            count = this._blockedIPs.increment((Object)ba);
                            if (this._log.shouldLog(30)) {
                                this._log.warn("Blocking IP " + Addresses.toString((byte[])ip) + " with count " + count + ": " + con);
                            }
                        } else {
                            count = 1;
                            if (this._log.shouldLog(30)) {
                                this._log.warn("EOF on inbound before receiving any: " + con);
                            }
                        }
                        this._context.statManager().addRateData("ntcp.dropInboundNoMessage", (long)count);
                    } else if (this._log.shouldLog(10)) {
                        this._log.debug("EOF on " + con);
                    }
                    con.close();
                    EventPumper.releaseBuf(buf);
                } else if (read == 0) {
                    EventPumper.releaseBuf(buf);
                    int consec = con.gotZeroRead();
                    if (consec >= 5) {
                        this._context.statManager().addRateData("ntcp.zeroReadDrop", 1L);
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Fail safe zero read close " + con);
                        }
                        con.close();
                    } else {
                        this._context.statManager().addRateData("ntcp.zeroRead", (long)consec);
                        if (this._log.shouldLog(20)) {
                            this._log.info("nothing to read for " + con + ", but stay interested");
                        }
                    }
                } else {
                    con.clearZeroRead();
                    buf.flip();
                    FIFOBandwidthLimiter.Request req = this._context.bandwidthLimiter().requestInbound(read, "NTCP read");
                    if (req.getPendingRequested() > 0) {
                        key.interestOps(key.interestOps() & 0xFFFFFFFE);
                        this._context.statManager().addRateData("ntcp.queuedRecv", (long)read);
                        con.queuedRecv(buf, req);
                    } else {
                        con.recv(buf);
                        this._context.statManager().addRateData("ntcp.read", (long)read);
                    }
                }
            }
            catch (CancelledKeyException cke) {
                EventPumper.releaseBuf(buf);
                if (this._log.shouldLog(30)) {
                    this._log.warn("error reading on " + con, (Throwable)cke);
                }
                con.close();
                this._context.statManager().addRateData("ntcp.readError", 1L);
            }
            catch (IOException ioe) {
                EventPumper.releaseBuf(buf);
                if (con.isInbound() && con.getMessagesReceived() <= 0L) {
                    int count;
                    InetAddress addr = con.getChannel().socket().getInetAddress();
                    if (addr != null) {
                        byte[] ip = addr.getAddress();
                        ByteArray ba = new ByteArray(ip);
                        count = this._blockedIPs.increment((Object)ba);
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Blocking IP " + Addresses.toString((byte[])ip) + " with count " + count + ": " + con);
                        }
                    } else {
                        count = 1;
                        if (this._log.shouldLog(30)) {
                            this._log.warn("IOE on inbound before receiving any: " + con);
                        }
                    }
                    this._context.statManager().addRateData("ntcp.dropInboundNoMessage", (long)count);
                } else if (this._log.shouldLog(20)) {
                    this._log.info("error reading on " + con, (Throwable)ioe);
                }
                if (con.isEstablished()) {
                    this._context.statManager().addRateData("ntcp.readError", 1L);
                } else {
                    this._context.statManager().addRateData("ntcp.connectFailedTimeoutIOE", 1L);
                    RouterIdentity rem = con.getRemotePeer();
                    if (rem != null && !con.isInbound()) {
                        this._transport.markUnreachable(rem.calculateHash());
                    }
                }
                con.close();
            }
            catch (NotYetConnectedException nyce) {
                EventPumper.releaseBuf(buf);
                key.interestOps(key.interestOps() & 0xFFFFFFFE);
                if (!this._log.shouldLog(30)) break block32;
                this._log.warn("error reading on " + con, (Throwable)nyce);
            }
        }
    }

    private void processWrite(SelectionKey key) {
        block12: {
            NTCPConnection con = (NTCPConnection)key.attachment();
            try {
                ByteBuffer buf;
                while ((buf = con.getNextWriteBuf()) != null) {
                    if (buf.remaining() <= 0) {
                        con.removeWriteBuf(buf);
                        continue;
                    }
                    int written = con.getChannel().write(buf);
                    if (written == 0) {
                        if (buf.remaining() <= 0 && con.isWriteBufEmpty()) {
                            key.interestOps(key.interestOps() & 0xFFFFFFFB);
                        }
                    } else if (buf.remaining() <= 0) {
                        con.removeWriteBuf(buf);
                        continue;
                    }
                    break block12;
                }
                if (key.isValid()) {
                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                }
            }
            catch (CancelledKeyException cke) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("error writing on " + con, (Throwable)cke);
                }
                this._context.statManager().addRateData("ntcp.writeError", 1L);
                con.close();
            }
            catch (IOException ioe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("error writing on " + con, (Throwable)ioe);
                }
                this._context.statManager().addRateData("ntcp.writeError", 1L);
                con.close();
            }
        }
    }

    private void runDelayedEvents() {
        ServerSocketChannel chan;
        SelectionKey key;
        NTCPConnection con;
        while ((con = this._wantsRead.poll()) != null) {
            SelectionKey key2 = con.getKey();
            try {
                key2.interestOps(key2.interestOps() | 1);
            }
            catch (CancelledKeyException cke) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("RDE CKE 1", (Throwable)cke);
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("gnu?", (Throwable)iae);
            }
        }
        if (!this._wantsWrite.isEmpty()) {
            Iterator<NTCPConnection> iter = this._wantsWrite.iterator();
            while (iter.hasNext()) {
                con = iter.next();
                key = con.getKey();
                if (key == null) continue;
                iter.remove();
                try {
                    key.interestOps(key.interestOps() | 4);
                }
                catch (CancelledKeyException cke) {
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn("RDE CKE 2", (Throwable)cke);
                }
                catch (IllegalArgumentException iae) {
                    if (!this._log.shouldLog(30)) continue;
                    this._log.warn("gnu?", (Throwable)iae);
                }
            }
        }
        while ((chan = this._wantsRegister.poll()) != null) {
            try {
                key = chan.register(this._selector, 16);
                key.attach(chan);
            }
            catch (ClosedChannelException cce) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Error registering", (Throwable)cce);
            }
        }
        while ((con = this._wantsConRegister.poll()) != null) {
            try {
                key = con.getChannel().register(this._selector, 8);
                key.attach(con);
                con.setKey(key);
                RouterAddress naddr = con.getRemoteAddress();
                try {
                    if (naddr.getPort() <= 0) {
                        throw new IOException("Invalid NTCP address: " + (Object)((Object)naddr));
                    }
                    InetSocketAddress saddr = new InetSocketAddress(naddr.getHost(), naddr.getPort());
                    boolean connected = con.getChannel().connect(saddr);
                    if (!connected) continue;
                    key.interestOps(1);
                    this.processConnect(key);
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("error connecting to " + Addresses.toString((byte[])naddr.getIP(), (int)naddr.getPort()), (Throwable)ioe);
                    }
                    this._context.statManager().addRateData("ntcp.connectFailedIOE", 1L);
                    this._transport.markUnreachable(con.getRemotePeer().calculateHash());
                    con.close(true);
                }
                catch (UnresolvedAddressException uae) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("unresolved address connecting", (Throwable)uae);
                    }
                    this._context.statManager().addRateData("ntcp.connectFailedUnresolved", 1L);
                    this._transport.markUnreachable(con.getRemotePeer().calculateHash());
                    con.close(true);
                }
                catch (CancelledKeyException cke) {
                    con.close(false);
                }
            }
            catch (ClosedChannelException cce) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Error registering", (Throwable)cce);
            }
        }
        long now = System.currentTimeMillis();
        if (this._lastExpired + 1000L <= now) {
            this.expireTimedOut();
            this._lastExpired = now;
        }
    }

    private void expireTimedOut() {
        this._transport.expireTimedOut();
    }

    public long getIdleTimeout() {
        return this._expireIdleWriteTime;
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        _numBufs = MIN_BUFS = (int)Math.max(4L, Math.min(12L, 1L + maxMemory / 0x1000000L));
    }
}

