/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import net.i2p.data.router.RouterAddress;
import net.i2p.router.RouterContext;

public abstract class TransportUtil {
    public static final String NTCP_IPV6_CONFIG = "i2np.ntcp.ipv6";
    public static final String SSU_IPV6_CONFIG = "i2np.udp.ipv6";
    public static final String PROP_IPV4_FIREWALLED = "i2np.ipv4.firewalled";
    private static final Map<String, IPv6Config> BY_NAME = new HashMap<String, IPv6Config>();
    public static final IPv6Config DEFAULT_IPV6_CONFIG = IPv6Config.IPV6_PREFERRED;

    public static IPv6Config getIPv6Config(RouterContext ctx, String transportStyle) {
        String cfg;
        if (transportStyle.equals("NTCP")) {
            cfg = ctx.getProperty(NTCP_IPV6_CONFIG);
        } else if (transportStyle.equals("SSU")) {
            cfg = ctx.getProperty(SSU_IPV6_CONFIG);
        } else {
            return DEFAULT_IPV6_CONFIG;
        }
        return TransportUtil.getIPv6Config(cfg);
    }

    public static IPv6Config getIPv6Config(String cfg) {
        if (cfg == null) {
            return DEFAULT_IPV6_CONFIG;
        }
        IPv6Config c = BY_NAME.get(cfg);
        if (c != null) {
            return c;
        }
        return DEFAULT_IPV6_CONFIG;
    }

    public static boolean isIPv4Firewalled(RouterContext ctx, String transportStyle) {
        return ctx.getBooleanProperty(PROP_IPV4_FIREWALLED);
    }

    public static boolean isIPv6(RouterAddress addr) {
        String host = addr.getOption("host");
        return host != null && host.contains(":");
    }

    public static boolean isPubliclyRoutable(byte[] addr, boolean allowIPv6) {
        return TransportUtil.isPubliclyRoutable(addr, true, allowIPv6);
    }

    public static boolean isPubliclyRoutable(byte[] addr, boolean allowIPv4, boolean allowIPv6) {
        if (addr.length == 4) {
            if (!allowIPv4) {
                return false;
            }
            int a0 = addr[0] & 0xFF;
            if (a0 == 0) {
                return false;
            }
            if (a0 == 10) {
                return false;
            }
            if (a0 == 25) {
                return false;
            }
            if (a0 == 127) {
                return false;
            }
            int a1 = addr[1] & 0xFF;
            if (a0 == 100 && a1 >= 64 && a1 <= 127) {
                return false;
            }
            if (a0 == 169 && a1 == 254) {
                return false;
            }
            if (a0 == 172 && a1 >= 16 && a1 <= 31) {
                return false;
            }
            if (a0 == 192) {
                int a2;
                if (a1 == 168) {
                    return false;
                }
                if (a1 == 0 && ((a2 = addr[2] & 0xFF) == 0 || a2 == 2)) {
                    return false;
                }
                if (a1 == 88 && (addr[2] & 0xFF) == 99) {
                    return false;
                }
            }
            if (a0 == 198) {
                if (a1 == 18 || a1 == 19) {
                    return false;
                }
                if (a1 == 51 && (addr[2] & 0xFF) == 100) {
                    return false;
                }
            }
            if (a0 == 203 && a1 == 0 && (addr[2] & 0xFF) == 113) {
                return false;
            }
            return a0 < 224;
        }
        if (addr.length == 16 && allowIPv6) {
            if (addr[0] == 0) {
                return false;
            }
            if (addr[0] == 32) {
                if (addr[1] == 2) {
                    return false;
                }
                if (addr[1] == 1) {
                    if (addr[2] == 0 && addr[3] == 0) {
                        return false;
                    }
                    if (addr[2] == 13 && (addr[3] & 0xFF) == 184) {
                        return false;
                    }
                }
            }
            if ((addr[0] & 0xFE) == 252) {
                return false;
            }
            if (addr[0] == 38 && addr[1] == 32 && addr[2] == 0 && (addr[3] & 0xFF) == 155) {
                return false;
            }
            if (addr[0] == 63 && (addr[1] & 0xFF) == 254) {
                return false;
            }
            try {
                InetAddress ia = InetAddress.getByAddress(addr);
                return !ia.isLinkLocalAddress() && !ia.isMulticastAddress() && !ia.isAnyLocalAddress() && !ia.isLoopbackAddress() && !ia.isSiteLocalAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isValidPort(int port) {
        return port >= 1024 && port <= 65535 && port != 1900 && port != 2827 && port != 4444 && port != 4445 && port != 6668 && (port < 7650 || port > 7664) && port != 8998 && port != 31000 && port != 32000;
    }

    static {
        for (IPv6Config cfg : IPv6Config.values()) {
            BY_NAME.put(cfg.toConfigString(), cfg);
        }
        BY_NAME.put("true", IPv6Config.IPV6_ENABLED);
        BY_NAME.put("disable", IPv6Config.IPV6_DISABLED);
    }

    public static enum IPv6Config {
        IPV6_DISABLED("false"),
        IPV6_NOT_PREFERRED("preferIPv4"),
        IPV6_ENABLED("enable"),
        IPV6_PREFERRED("preferIPv6"),
        IPV6_ONLY("only");

        private final String cfgstr;

        private IPv6Config(String cfgstr) {
            this.cfgstr = cfgstr;
        }

        public String toConfigString() {
            return this.cfgstr;
        }
    }
}

