/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.i2p.crypto.SigType;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class CryptoChecker {
    private static String JRE6 = "http://www.oracle.com/technetwork/java/javase/downloads/index.html";

    public static void warnUnavailableCrypto(RouterContext ctx) {
        if (SystemVersion.isAndroid()) {
            return;
        }
        boolean unavail = false;
        Log log = null;
        for (SigType t : SigType.values()) {
            if (t.isAvailable()) continue;
            if (!unavail) {
                unavail = true;
                if (ctx != null) {
                    log = ctx.logManager().getLog(CryptoChecker.class);
                }
            }
            String s = "Crypto " + t + " is not available";
            if (log != null) {
                log.logAlways(30, s);
            }
            System.out.println("Warning: " + s);
        }
        if (unavail) {
            String s = "Java version: " + System.getProperty("java.version") + " OS: " + System.getProperty("os.name") + ' ' + System.getProperty("os.arch") + ' ' + System.getProperty("os.version");
            if (log != null) {
                log.logAlways(30, s);
            }
            System.out.println("Warning: " + s);
            if (!SystemVersion.isJava7()) {
                s = "Please consider upgrading to Java 7";
                if (log != null) {
                    log.logAlways(30, s);
                }
                System.out.println(s);
            }
            if (!CryptoChecker.isUnlimited()) {
                s = "Please consider installing the Java Cryptography Unlimited Strength Jurisdiction Policy Files from ";
                s = s + JRE6;
                if (log != null) {
                    log.logAlways(30, s);
                }
                System.out.println(s);
            }
            s = "This crypto will be required in a future release";
            if (log != null) {
                log.logAlways(30, s);
            }
            System.out.println("Warning: " + s);
        } else if (ctx == null) {
            System.out.println("All crypto available");
        }
    }

    private static boolean isUnlimited() {
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") < 256) {
                return false;
            }
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        catch (NoSuchMethodError e) {
            try {
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                SecretKeySpec key = new SecretKeySpec(new byte[32], "AES");
                cipher.init(1, key);
            }
            catch (GeneralSecurityException gse) {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        CryptoChecker.warnUnavailableCrypto(null);
    }
}

