/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SigType;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.data.router.RouterPrivateKeyFile;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.BootCommSystemJob;
import net.i2p.router.startup.CreateRouterInfoJob;
import net.i2p.router.startup.RebuildRouterInfoJob;
import net.i2p.util.Log;

class LoadRouterInfoJob
extends JobImpl {
    private final Log _log;
    private RouterInfo _us;
    private static final AtomicBoolean _keyLengthChecked = new AtomicBoolean();

    public LoadRouterInfoJob(RouterContext ctx) {
        super(ctx);
        this._log = ctx.logManager().getLog(LoadRouterInfoJob.class);
    }

    @Override
    public String getName() {
        return "Load Router Info";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        Object object = this.getContext().router().routerInfoFileLock;
        synchronized (object) {
            this.loadRouterInfo();
        }
        if (this._us == null) {
            RebuildRouterInfoJob r = new RebuildRouterInfoJob(this.getContext());
            r.rebuildRouterInfo(false);
            this.getContext().jobQueue().addJob(this);
            return;
        }
        this.getContext().router().setRouterInfo(this._us);
        this.getContext().messageHistory().initialize(true);
        this.getContext().jobQueue().addJob(new BootCommSystemJob(this.getContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRouterInfo() {
        block33: {
            RouterInfo info = null;
            File rif = new File(this.getContext().getRouterDir(), "router.info");
            boolean infoExists = rif.exists();
            File rkf = new File(this.getContext().getRouterDir(), "router.keys");
            boolean keysExist = rkf.exists();
            File rkf2 = new File(this.getContext().getRouterDir(), "router.keys.dat");
            boolean keys2Exist = rkf2.exists();
            InputStream fis1 = null;
            try {
                SigType cstype;
                boolean sigTypeChanged;
                if (infoExists && (keys2Exist || keysExist)) {
                    fis1 = new BufferedInputStream(new FileInputStream(rif));
                    info = new RouterInfo();
                    info.readBytes(fis1);
                    if (!info.isValid()) {
                        throw new DataFormatException("Our RouterInfo has a bad signature");
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Reading in routerInfo from " + rif.getAbsolutePath() + " and it has " + info.getAddresses().size() + " addresses");
                    }
                    this._us = info;
                }
                if (!keys2Exist && !keysExist) break block33;
                KeyData kd = LoadRouterInfoJob.readKeyData(rkf, rkf2);
                PublicKey pubkey = kd.routerIdentity.getPublicKey();
                SigningPublicKey signingPubKey = kd.routerIdentity.getSigningPublicKey();
                PrivateKey privkey = kd.privateKey;
                SigningPrivateKey signingPrivKey = kd.signingPrivateKey;
                SigType stype = signingPubKey.getType();
                boolean bl = sigTypeChanged = stype != (cstype = CreateRouterInfoJob.getSigTypeConfig(this.getContext()));
                if (sigTypeChanged || this.shouldRebuild(privkey)) {
                    if (sigTypeChanged) {
                        this._log.logAlways(30, "Rebuilding RouterInfo with new signature type " + cstype);
                    }
                    this._us = null;
                    if (fis1 != null) {
                        try {
                            fis1.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        fis1 = null;
                    }
                    rif.delete();
                    rkf.delete();
                    rkf2.delete();
                    return;
                }
                this.getContext().keyManager().setKeys(pubkey, privkey, signingPubKey, signingPrivKey);
            }
            catch (IOException ioe) {
                this._log.log(50, "Error reading the router info from " + rif.getAbsolutePath() + " and the keys from " + rkf.getAbsolutePath(), (Throwable)ioe);
                this._us = null;
                if (fis1 != null) {
                    try {
                        fis1.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    fis1 = null;
                }
                rif.delete();
                rkf.delete();
                rkf2.delete();
            }
            catch (DataFormatException dfe) {
                this._log.log(50, "Corrupt router info or keys at " + rif.getAbsolutePath() + " / " + rkf.getAbsolutePath(), (Throwable)dfe);
                this._us = null;
                if (fis1 != null) {
                    try {
                        fis1.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    fis1 = null;
                }
                rif.delete();
                rkf.delete();
                rkf2.delete();
            }
            finally {
                if (fis1 != null) {
                    try {
                        fis1.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    private boolean shouldRebuild(PrivateKey privkey) {
        boolean uselong;
        if (!_keyLengthChecked.compareAndSet(false, true)) {
            return false;
        }
        byte[] pkd = privkey.getData();
        boolean haslong = false;
        for (int i = 0; i < 8; ++i) {
            if (pkd[i] == 0) continue;
            haslong = true;
            break;
        }
        if ((uselong = this.getContext().keyGenerator().useLongElGamalExponent()) && !haslong) {
            this._log.logAlways(30, "Rebuilding RouterInfo with longer key");
        }
        if (!uselong && haslong) {
            this._log.logAlways(30, "Rebuilding RouterInfo with faster key");
        }
        return uselong != haslong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyData readKeyData(File rkf1, File rkf2) throws DataFormatException, IOException {
        SigningPrivateKey signingPrivKey;
        PrivateKey privkey;
        RouterIdentity ri;
        if (rkf2.exists()) {
            RouterPrivateKeyFile pkf = new RouterPrivateKeyFile(rkf2);
            ri = pkf.getRouterIdentity();
            if (!pkf.validateKeyPairs()) {
                throw new DataFormatException("Key pairs invalid");
            }
            privkey = pkf.getPrivKey();
            signingPrivKey = pkf.getSigningPrivKey();
        } else {
            InputStream fis = null;
            try {
                fis = new BufferedInputStream(new FileInputStream(rkf1));
                privkey = new PrivateKey();
                privkey.readBytes(fis);
                signingPrivKey = new SigningPrivateKey();
                signingPrivKey.readBytes(fis);
                PublicKey pubkey = new PublicKey();
                pubkey.readBytes(fis);
                SigningPublicKey signingPubKey = new SigningPublicKey();
                signingPubKey.readBytes(fis);
                try {
                    if (!pubkey.equals((Object)KeyGenerator.getPublicKey((PrivateKey)privkey))) {
                        throw new DataFormatException("Key pairs invalid");
                    }
                    if (!signingPubKey.equals((Object)KeyGenerator.getSigningPublicKey((SigningPrivateKey)signingPrivKey))) {
                        throw new DataFormatException("Key pairs invalid");
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new DataFormatException("Key pairs invalid", (Throwable)iae);
                }
                ri = new RouterIdentity();
                ri.setPublicKey(pubkey);
                ri.setSigningPublicKey(signingPubKey);
                ri.setCertificate(Certificate.NULL_CERT);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return new KeyData(ri, privkey, signingPrivKey);
    }

    public static class KeyData {
        public final RouterIdentity routerIdentity;
        public final PrivateKey privateKey;
        public final SigningPrivateKey signingPrivateKey;

        public KeyData(RouterIdentity ri, PrivateKey pk, SigningPrivateKey spk) {
            this.routerIdentity = ri;
            this.privateKey = pk;
            this.signingPrivateKey = spk;
        }
    }
}

