/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Map;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.LHMCache;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;

class NegativeLookupCache {
    private final ObjectCounter<Hash> counter = new ObjectCounter();
    private final Map<Hash, Destination> badDests = new LHMCache(128);
    private static final int MAX_FAILS = 3;
    private static final int MAX_BAD_DESTS = 128;
    private static final long CLEAN_TIME = 120000L;

    public NegativeLookupCache() {
        SimpleTimer2.getInstance().addPeriodicEvent((SimpleTimer.TimedEvent)new Cleaner(), 120000L);
    }

    public void lookupFailed(Hash h) {
        this.counter.increment((Object)h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(Hash h) {
        if (this.counter.count((Object)h) >= 3) {
            return true;
        }
        Map<Hash, Destination> map = this.badDests;
        synchronized (map) {
            return this.badDests.get(h) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failPermanently(Destination dest) {
        Hash h = dest.calculateHash();
        Map<Hash, Destination> map = this.badDests;
        synchronized (map) {
            this.badDests.put(h, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getBadDest(Hash h) {
        Map<Hash, Destination> map = this.badDests;
        synchronized (map) {
            return this.badDests.get(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.counter.clear();
        Map<Hash, Destination> map = this.badDests;
        synchronized (map) {
            this.badDests.clear();
        }
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        public void timeReached() {
            NegativeLookupCache.this.counter.clear();
        }
    }
}

