/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.DataHelper;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.JobQueueRunner;
import net.i2p.router.JobStats;
import net.i2p.router.JobTiming;
import net.i2p.router.MessageHistory;
import net.i2p.router.RouterContext;
import net.i2p.router.message.HandleGarlicMessageJob;
import net.i2p.router.networkdb.kademlia.HandleFloodfillDatabaseLookupMessageJob;
import net.i2p.util.Clock;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class JobQueue {
    private final Log _log;
    private final RouterContext _context;
    private final Map<Integer, JobQueueRunner> _queueRunners;
    private static final AtomicInteger _runnerId = new AtomicInteger(0);
    private final BlockingQueue<Job> _readyJobs;
    private final Set<Job> _timedJobs;
    private final ConcurrentHashMap<String, JobStats> _jobStats;
    private final QueuePumper _pumper;
    private volatile boolean _allowParallelOperation;
    private volatile boolean _alive;
    private final Object _jobLock;
    private volatile long _nextPumperRun;
    private static final int RUNNERS;
    private static final int DEFAULT_MAX_RUNNERS = 1;
    private static final String PROP_MAX_RUNNERS = "router.maxJobRunners";
    private static final long MAX_LIMIT_UPDATE_DELAY = 60000L;
    private long _lagWarning = 5000L;
    private static final long DEFAULT_LAG_WARNING = 5000L;
    private static final String PROP_LAG_WARNING = "router.jobLagWarning";
    private long _lagFatal = 30000L;
    private static final long DEFAULT_LAG_FATAL = 30000L;
    private static final String PROP_LAG_FATAL = "router.jobLagFatal";
    private long _runWarning = 5000L;
    private static final long DEFAULT_RUN_WARNING = 5000L;
    private static final String PROP_RUN_WARNING = "router.jobRunWarning";
    private long _runFatal = 30000L;
    private static final long DEFAULT_RUN_FATAL = 30000L;
    private static final String PROP_RUN_FATAL = "router.jobRunFatal";
    private long _warmupTime = 600000L;
    private static final long DEFAULT_WARMUP_TIME = 600000L;
    private static final String PROP_WARMUP_TIME = "router.jobWarmupTime";
    private int _maxWaitingJobs = 25;
    private static final int DEFAULT_MAX_WAITING_JOBS = 25;
    private static final long MIN_LAG_TO_DROP = 500L;
    private static final String PROP_MAX_WAITING_JOBS = "router.maxWaitingJobs";
    private final Object _runnerLock = new Object();
    private static final int POISON_ID = -99999;

    public JobQueue(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(JobQueue.class);
        this._context.statManager().createRateStat("jobQueue.readyJobs", "How many ready and waiting jobs there are?", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.droppedJobs", "How many jobs do we drop due to insane overload?", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.queuedJobs", "How many scheduled jobs are there?", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.jobRun", "How long jobs take", "JobQueue", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.jobRunSlow", "How long jobs that take over a second take", "JobQueue", new long[]{3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("jobQueue.jobLag", "Job run delay (ms)", "JobQueue", new long[]{60000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("jobQueue.jobWait", "How long does a job sit on the job queue?", "JobQueue", new long[]{3600000L, 86400000L});
        this._readyJobs = new LinkedBlockingQueue<Job>();
        this._timedJobs = new TreeSet<Job>(new JobComparator());
        this._jobLock = new Object();
        this._queueRunners = new ConcurrentHashMap<Integer, JobQueueRunner>(RUNNERS);
        this._jobStats = new ConcurrentHashMap();
        this._pumper = new QueuePumper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Job job) {
        long numReady;
        if (job == null || !this._alive) {
            return;
        }
        boolean alreadyExists = false;
        boolean dropped = false;
        long now = this._context.clock().now();
        long start = job.getTiming().getStartAfter();
        if (start > now + 259200000L && this._log.shouldLog(30)) {
            this._log.warn("Scheduling job far in the future: " + new Date(start) + ' ' + job);
        }
        Object object = this._jobLock;
        synchronized (object) {
            boolean removed;
            if (this._readyJobs.contains(job)) {
                alreadyExists = true;
            }
            numReady = this._readyJobs.size();
            if (!alreadyExists && (removed = this._timedJobs.remove(job)) && this._log.shouldLog(30)) {
                this._log.warn("Rescheduling job: " + job);
            }
            if (!alreadyExists && this.shouldDrop(job, numReady)) {
                job.dropped();
                dropped = true;
            } else if (!alreadyExists) {
                if (start <= now) {
                    job.getTiming().setStartAfter(now);
                    if (job instanceof JobImpl) {
                        ((JobImpl)job).madeReady();
                    }
                    this._readyJobs.offer(job);
                } else {
                    this._timedJobs.add(job);
                    if (start < this._nextPumperRun) {
                        this._jobLock.notifyAll();
                    }
                }
            }
        }
        this._context.statManager().addRateData("jobQueue.readyJobs", numReady);
        this._context.statManager().addRateData("jobQueue.queuedJobs", (long)this._timedJobs.size());
        if (dropped) {
            JobStats old;
            String key;
            JobStats stats;
            this._context.statManager().addRateData("jobQueue.droppedJobs", 1L);
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping job due to overload!  # ready jobs: " + numReady + ": job = " + job);
            }
            if ((stats = this._jobStats.get(key = job.getName())) == null && (old = this._jobStats.putIfAbsent(key, stats = new JobStats(key))) != null) {
                stats = old;
            }
            stats.jobDropped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(Job job) {
        Object object = this._jobLock;
        synchronized (object) {
            this._readyJobs.remove(job);
            this._timedJobs.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJobActive(Job job) {
        Object object = this._jobLock;
        synchronized (object) {
            if (this._readyJobs.contains(job) || this._timedJobs.contains(job)) {
                return true;
            }
        }
        for (JobQueueRunner runner : this._queueRunners.values()) {
            if (runner.getCurrentJob() != job) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timingUpdated() {
        Object object = this._jobLock;
        synchronized (object) {
            this._jobLock.notifyAll();
        }
    }

    public int getReadyCount() {
        return this._readyJobs.size();
    }

    public long getMaxLag() {
        Job j = (Job)this._readyJobs.peek();
        if (j == null) {
            return 0L;
        }
        JobTiming jt = j.getTiming();
        if (jt == null) {
            return 0L;
        }
        long startAfter = jt.getStartAfter();
        return this._context.clock().now() - startAfter;
    }

    private boolean shouldDrop(Job job, long numReady) {
        Class<?> cls;
        if (this._maxWaitingJobs <= 0) {
            return false;
        }
        if (!this._allowParallelOperation) {
            return false;
        }
        return numReady > (long)this._maxWaitingJobs && ((cls = job.getClass()) == HandleFloodfillDatabaseLookupMessageJob.class || cls == HandleGarlicMessageJob.class) && this.getMaxLag() >= 500L;
    }

    public void allowParallelOperation() {
        this._allowParallelOperation = true;
        this.runQueue(this._context.getProperty(PROP_MAX_RUNNERS, RUNNERS));
    }

    public void startup() {
        this._alive = true;
        I2PThread pumperThread = new I2PThread((Runnable)this._pumper, "Job Queue Pumper", true);
        pumperThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Object object = this._jobLock;
        synchronized (object) {
            this._timedJobs.clear();
            this._readyJobs.clear();
            this._jobLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this._alive = false;
        Object object = this._jobLock;
        synchronized (object) {
            this._timedJobs.clear();
            this._readyJobs.clear();
            this._jobLock.notifyAll();
        }
        PoisonJob poison = new PoisonJob();
        for (JobQueueRunner runner : this._queueRunners.values()) {
            runner.stopRunning();
            this._readyJobs.offer(poison);
        }
        this._queueRunners.clear();
        this._jobStats.clear();
        _runnerId.set(0);
    }

    boolean isAlive() {
        return this._alive;
    }

    public long getLastJobBegin() {
        long when = -1L;
        for (JobQueueRunner runner : this._queueRunners.values()) {
            long cur = runner.getLastBegin();
            if (cur <= when) continue;
            cur = when;
        }
        return when;
    }

    public long getLastJobEnd() {
        long when = -1L;
        for (JobQueueRunner runner : this._queueRunners.values()) {
            long cur = runner.getLastEnd();
            if (cur <= when) continue;
            cur = when;
        }
        return when;
    }

    public Job getLastJob() {
        Job j = null;
        long when = -1L;
        for (JobQueueRunner cur : this._queueRunners.values()) {
            if (cur.getLastBegin() <= when) continue;
            j = cur.getCurrentJob();
            when = cur.getLastBegin();
        }
        return j;
    }

    Job getNext() {
        while (this._alive) {
            try {
                Job j = this._readyJobs.take();
                if (j.getJobId() != -99999L) {
                    return j;
                }
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("No longer alive, returning null");
        }
        return null;
    }

    public synchronized void runQueue(int numThreads) {
        block5: {
            block4: {
                if (!this._queueRunners.isEmpty() && !this._allowParallelOperation) {
                    return;
                }
                if (this._queueRunners.size() >= numThreads) break block4;
                if (this._log.shouldLog(20)) {
                    this._log.info("Increasing the number of queue runners from " + this._queueRunners.size() + " to " + numThreads);
                }
                for (int i = this._queueRunners.size(); i < numThreads; ++i) {
                    JobQueueRunner runner = new JobQueueRunner(this._context, i);
                    this._queueRunners.put(i, runner);
                    runner.setName("JobQueue " + _runnerId.incrementAndGet() + '/' + numThreads);
                    runner.start();
                }
                break block5;
            }
            if (this._queueRunners.size() != numThreads) break block5;
            for (JobQueueRunner runner : this._queueRunners.values()) {
                runner.startRunning();
            }
        }
    }

    void removeRunner(int id) {
        this._queueRunners.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJobTimings(long delta) {
        Object object = this._jobLock;
        synchronized (object) {
            for (Job j : this._timedJobs) {
                j.getTiming().offsetChanged(delta);
            }
            for (Job j : this._readyJobs) {
                j.getTiming().offsetChanged(delta);
            }
        }
        object = this._runnerLock;
        synchronized (object) {
            for (JobQueueRunner runner : this._queueRunners.values()) {
                Job job = runner.getCurrentJob();
                if (job == null) continue;
                job.getTiming().offsetChanged(delta);
            }
        }
    }

    void updateStats(Job job, long doStart, long origStartAfter, long duration) {
        JobStats old;
        JobStats stats;
        if (this._context.router() == null) {
            return;
        }
        String key = job.getName();
        long lag = doStart - origStartAfter;
        MessageHistory hist = this._context.messageHistory();
        long uptime = this._context.router().getUptime();
        if (lag < 0L) {
            lag = 0L;
        }
        if (duration < 0L) {
            duration = 0L;
        }
        if ((stats = this._jobStats.get(key)) == null && (old = this._jobStats.putIfAbsent(key, stats = new JobStats(key))) != null) {
            stats = old;
        }
        stats.jobRan(duration, lag);
        String dieMsg = null;
        if (lag > this._lagWarning) {
            dieMsg = "Lag too long for job " + job.getName() + " [" + lag + "ms and a run time of " + duration + "ms]";
        } else if (duration > this._runWarning) {
            dieMsg = "Job run too long for job " + job.getName() + " [" + lag + "ms lag and run time of " + duration + "ms]";
        }
        if (dieMsg != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(dieMsg);
            }
            if (hist != null) {
                hist.messageProcessingError(-1L, JobQueue.class.getName(), dieMsg);
            }
        }
        if (lag > this._lagFatal && uptime > this._warmupTime) {
            if (this._log.shouldLog(30)) {
                this._log.log(30, "The router is either incredibly overloaded or (more likely) there's an error.", (Throwable)new Exception("ttttooooo mmmuuuccccchhhh llllaaagggg"));
            }
            return;
        }
        if (uptime > this._warmupTime && duration > this._runFatal) {
            if (this._log.shouldLog(30)) {
                this._log.log(30, "The router is incredibly overloaded - either you have a 386, or (more likely) there's an error. ", (Throwable)new Exception("ttttooooo sssllloooowww"));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJobs(Collection<Job> readyJobs, Collection<Job> timedJobs, Collection<Job> activeJobs, Collection<Job> justFinishedJobs) {
        for (JobQueueRunner runner : this._queueRunners.values()) {
            Job job = runner.getCurrentJob();
            if (job != null) {
                activeJobs.add(job);
                continue;
            }
            job = runner.getLastJob();
            if (job == null) continue;
            justFinishedJobs.add(job);
        }
        Object object = this._jobLock;
        synchronized (object) {
            readyJobs.addAll(this._readyJobs);
            timedJobs.addAll(this._timedJobs);
        }
        return this._queueRunners.size();
    }

    public Collection<JobStats> getJobStats() {
        return Collections.unmodifiableCollection(this._jobStats.values());
    }

    public void renderStatusHTML(Writer out) throws IOException {
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        RUNNERS = maxMemory < 0x4000000L ? 3 : (maxMemory < 0x10000000L ? 4 : 5);
    }

    private static class JobComparator
    implements Comparator<Job>,
    Serializable {
        private JobComparator() {
        }

        @Override
        public int compare(Job l, Job r) {
            if (l.equals(r)) {
                return 0;
            }
            long ld = l.getTiming().getStartAfter() - r.getTiming().getStartAfter();
            if (ld < 0L) {
                return -1;
            }
            if (ld > 0L) {
                return 1;
            }
            ld = l.getJobId() - r.getJobId();
            if (ld < 0L) {
                return -1;
            }
            if (ld > 0L) {
                return 1;
            }
            return l.hashCode() - r.hashCode();
        }
    }

    private static class PoisonJob
    implements Job {
        private PoisonJob() {
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public long getJobId() {
            return -99999L;
        }

        @Override
        public JobTiming getTiming() {
            return null;
        }

        @Override
        public void runJob() {
        }

        @Override
        public Exception getAddedBy() {
            return null;
        }

        @Override
        public void dropped() {
        }
    }

    private final class QueuePumper
    implements Runnable,
    Clock.ClockUpdateListener {
        public QueuePumper() {
            JobQueue.this._context.clock().addUpdateListener((Clock.ClockUpdateListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    while (JobQueue.this._alive) {
                        long now = JobQueue.this._context.clock().now();
                        long timeToWait = -1L;
                        try {
                            Object object = JobQueue.this._jobLock;
                            synchronized (object) {
                                Job lastJob = null;
                                long lastTime = Long.MIN_VALUE;
                                Iterator iter = JobQueue.this._timedJobs.iterator();
                                while (iter.hasNext()) {
                                    Job j = (Job)iter.next();
                                    long timeLeft = j.getTiming().getStartAfter() - now;
                                    if (lastJob != null && lastTime > j.getTiming().getStartAfter()) {
                                        JobQueue.this._log.error("Job " + lastJob + " out of order with job " + j + " difference of " + DataHelper.formatDuration((long)(lastTime - j.getTiming().getStartAfter())));
                                    }
                                    lastJob = j;
                                    lastTime = lastJob.getTiming().getStartAfter();
                                    if (timeLeft <= 0L) {
                                        if (j instanceof JobImpl) {
                                            ((JobImpl)j).madeReady();
                                        }
                                        JobQueue.this._readyJobs.offer(j);
                                        iter.remove();
                                        continue;
                                    }
                                    timeToWait = timeLeft;
                                    if (timeToWait <= 10000L || !iter.hasNext()) break;
                                    if (JobQueue.this._log.shouldLog(20)) {
                                        JobQueue.this._log.info("Failsafe re-sort job " + j + " with delay " + DataHelper.formatDuration((long)timeToWait));
                                    }
                                    iter.remove();
                                    Job nextJob = (Job)iter.next();
                                    JobQueue.this._timedJobs.add(j);
                                    long nextTimeLeft = nextJob.getTiming().getStartAfter() - now;
                                    if (timeToWait <= nextTimeLeft) break;
                                    JobQueue.this._log.error("Job " + j + " out of order with job " + nextJob + " difference of " + DataHelper.formatDuration((long)(timeToWait - nextTimeLeft)));
                                    timeToWait = Math.max(10L, nextTimeLeft);
                                    break;
                                }
                                if (timeToWait < 0L) {
                                    timeToWait = 1000L;
                                } else if (timeToWait < 10L) {
                                    timeToWait = 10L;
                                } else if (timeToWait > 10000L) {
                                    timeToWait = 10000L;
                                }
                                JobQueue.this._nextPumperRun = JobQueue.this._context.clock().now() + timeToWait;
                                JobQueue.this._jobLock.wait(timeToWait);
                                continue block7;
                            }
                        }
                        catch (InterruptedException ie) {
                        }
                    }
                    break;
                }
                catch (Throwable t) {
                    JobQueue.this._context.clock().removeUpdateListener((Clock.ClockUpdateListener)this);
                    if (!JobQueue.this._log.shouldLog(40)) break;
                    JobQueue.this._log.error("pumper killed?!", t);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void offsetChanged(long delta) {
            JobQueue.this.updateJobTimings(delta);
            Object object = JobQueue.this._jobLock;
            synchronized (object) {
                JobQueue.this._jobLock.notifyAll();
            }
        }
    }
}

