/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.i2np.UnknownI2NPMessage;
import net.i2p.data.i2np.VariableTunnelBuildMessage;
import net.i2p.data.i2np.VariableTunnelBuildReplyMessage;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

public abstract class I2NPMessageImpl
extends DataStructureImpl
implements I2NPMessage {
    protected final Log _log;
    protected final I2PAppContext _context;
    protected long _expiration;
    protected long _uniqueId = -1L;
    public static final long DEFAULT_EXPIRATION_MS = 60000L;
    public static final int CHECKSUM_LENGTH = 1;
    public static final int HEADER_LENGTH = 16;
    private static final Map<Integer, Builder> _builders = new ConcurrentHashMap<Integer, Builder>(1);

    public static final void registerBuilder(Builder builder, int type) {
        _builders.put(type, builder);
    }

    public I2NPMessageImpl(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(I2NPMessageImpl.class);
        this._expiration = this._context.clock().now() + 60000L;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        try {
            this.readBytes(in, -1, new byte[1024]);
        }
        catch (I2NPMessageException ime) {
            throw new DataFormatException("Bad bytes", (Throwable)((Object)ime));
        }
    }

    @Override
    public int readBytes(InputStream in, int type, byte[] buffer) throws I2NPMessageException, IOException {
        try {
            int numRead;
            if (type < 0) {
                type = (int)DataHelper.readLong((InputStream)in, (int)1);
            }
            this._uniqueId = DataHelper.readLong((InputStream)in, (int)4);
            this._expiration = DataHelper.readLong((InputStream)in, (int)8);
            int size = (int)DataHelper.readLong((InputStream)in, (int)2);
            byte[] checksum = new byte[1];
            int read = DataHelper.read((InputStream)in, (byte[])checksum);
            if (read != 1) {
                throw new I2NPMessageException("checksum is too small [" + read + "]");
            }
            if (buffer.length < size) {
                if (size > 65536) {
                    throw new I2NPMessageException("size=" + size);
                }
                buffer = new byte[size];
            }
            for (int cur = 0; cur < size; cur += numRead) {
                numRead = in.read(buffer, cur, size - cur);
                if (numRead != -1) continue;
                throw new I2NPMessageException("Payload is too short [" + numRead + ", wanted " + size + "]");
            }
            byte[] calc = SimpleByteCache.acquire((int)32);
            this._context.sha().calculateHash(buffer, 0, size, calc, 0);
            boolean eq = DataHelper.eq((byte[])checksum, (int)0, (byte[])calc, (int)0, (int)1);
            SimpleByteCache.release((byte[])calc);
            if (!eq) {
                throw new I2NPMessageException("Bad checksum on " + size + " byte I2NP " + this.getClass().getSimpleName());
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Reading bytes: type = " + type + " / uniqueId : " + this._uniqueId + " / expiration : " + this._expiration);
            }
            this.readMessage(buffer, 0, size, type);
            return 16 + size;
        }
        catch (DataFormatException dfe) {
            throw new I2NPMessageException("Error reading the message header", dfe);
        }
    }

    @Override
    public int readBytes(byte[] data, int type, int offset) throws I2NPMessageException {
        return this.readBytes(data, type, offset, data.length - offset);
    }

    @Override
    public int readBytes(byte[] data, int type, int offset, int maxLen) throws I2NPMessageException {
        int size;
        int headerSize = 16;
        if (type >= 0) {
            --headerSize;
        }
        if (maxLen < headerSize) {
            throw new I2NPMessageException("Payload is too short " + maxLen);
        }
        int cur = offset;
        if (type < 0) {
            type = (int)DataHelper.fromLong((byte[])data, (int)cur, (int)1);
            ++cur;
        }
        this._uniqueId = DataHelper.fromLong((byte[])data, (int)cur, (int)4);
        this._expiration = DataHelper.fromLong((byte[])data, (int)(cur += 4), (int)8);
        cur += 8;
        if ((cur += 2) + (size = (int)DataHelper.fromLong((byte[])data, (int)cur, (int)2)) > data.length || headerSize + size > maxLen) {
            throw new I2NPMessageException("Payload is too short [data.len=" + data.length + "maxLen=" + maxLen + " offset=" + offset + " cur=" + cur + " wanted=" + size + "]: " + this.getClass().getSimpleName());
        }
        int sz = Math.min(size, maxLen - headerSize);
        byte[] calc = SimpleByteCache.acquire((int)32);
        this._context.sha().calculateHash(data, cur + 1, sz, calc, 0);
        boolean eq = DataHelper.eq((byte[])data, (int)cur, (byte[])calc, (int)0, (int)1);
        ++cur;
        SimpleByteCache.release((byte[])calc);
        if (!eq) {
            throw new I2NPMessageException("Bad checksum on " + size + " byte I2NP " + this.getClass().getSimpleName());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Reading bytes: type = " + type + " / uniqueId : " + this._uniqueId + " / expiration : " + this._expiration);
        }
        this.readMessage(data, cur, sz, type);
        return (cur += sz) - offset;
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        int size = this.getMessageSize();
        if (size < 16) {
            throw new DataFormatException("Unable to build the message");
        }
        byte[] buf = new byte[size];
        int read = this.toByteArray(buf);
        if (read < 0) {
            throw new DataFormatException("Unable to build the message");
        }
        out.write(buf, 0, read);
    }

    @Override
    public long getUniqueId() {
        if (this._uniqueId < 0L) {
            this._uniqueId = this._context.random().nextLong(0xFFFFFFFFL);
        }
        return this._uniqueId;
    }

    @Override
    public void setUniqueId(long id) {
        this._uniqueId = id;
    }

    @Override
    public long getMessageExpiration() {
        return this._expiration;
    }

    @Override
    public void setMessageExpiration(long exp) {
        this._expiration = exp;
    }

    @Override
    public synchronized int getMessageSize() {
        return this.calculateWrittenLength() + 16;
    }

    @Override
    public synchronized int getRawMessageSize() {
        return this.calculateWrittenLength() + 5;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.getMessageSize()];
        int written = this.toByteArray(data);
        if (written != data.length) {
            this._log.log(50, "Error writing out " + data.length + " (written: " + written + ", msgSize: " + this.getMessageSize() + ", writtenLen: " + this.calculateWrittenLength() + ") for " + this.getClass().getSimpleName());
            return null;
        }
        return data;
    }

    @Override
    public int toByteArray(byte[] buffer) {
        try {
            int writtenLen = this.writeMessageBody(buffer, 16);
            int payloadLen = writtenLen - 16;
            byte[] h = SimpleByteCache.acquire((int)32);
            this._context.sha().calculateHash(buffer, 16, payloadLen, h, 0);
            int off = 0;
            DataHelper.toLong((byte[])buffer, (int)off, (int)1, (long)this.getType());
            ++off;
            if (this._uniqueId < 0L) {
                this._uniqueId = this._context.random().nextLong(0xFFFFFFFFL);
            }
            DataHelper.toLong((byte[])buffer, (int)off, (int)4, (long)this._uniqueId);
            DataHelper.toLong((byte[])buffer, (int)(off += 4), (int)8, (long)this._expiration);
            DataHelper.toLong((byte[])buffer, (int)(off += 8), (int)2, (long)payloadLen);
            System.arraycopy(h, 0, buffer, off += 2, 1);
            SimpleByteCache.release((byte[])h);
            return writtenLen;
        }
        catch (I2NPMessageException ime) {
            this._context.logManager().getLog(this.getClass()).log(50, "Error writing", (Throwable)((Object)ime));
            throw new IllegalStateException("Unable to serialize the message " + this.getClass().getSimpleName(), (Throwable)((Object)ime));
        }
    }

    protected abstract int calculateWrittenLength();

    protected abstract int writeMessageBody(byte[] var1, int var2) throws I2NPMessageException;

    @Override
    public int toRawByteArray(byte[] buffer) {
        try {
            int off = 0;
            DataHelper.toLong((byte[])buffer, (int)off, (int)1, (long)this.getType());
            DataHelper.toLong((byte[])buffer, (int)(++off), (int)4, (long)((this._expiration + 500L) / 1000L));
            return this.writeMessageBody(buffer, off += 4);
        }
        catch (I2NPMessageException ime) {
            this._context.logManager().getLog(this.getClass()).log(50, "Error writing", (Throwable)((Object)ime));
            throw new IllegalStateException("Unable to serialize the message " + this.getClass().getSimpleName(), (Throwable)((Object)ime));
        }
    }

    @Override
    public void readMessage(byte[] data, int offset, int dataSize, int type, I2NPMessageHandler handler) throws I2NPMessageException {
        try {
            this.readMessage(data, offset, dataSize, type);
        }
        catch (IllegalArgumentException iae) {
            throw new I2NPMessageException("Error reading the message", iae);
        }
    }

    public static I2NPMessage fromRawByteArray(I2PAppContext ctx, byte[] buffer, int offset, int len, I2NPMessageHandler handler) throws I2NPMessageException {
        int type = (int)DataHelper.fromLong((byte[])buffer, (int)offset, (int)1);
        ++offset;
        I2NPMessage msg = I2NPMessageImpl.createMessage(ctx, type);
        if (msg == null) {
            throw new I2NPMessageException("Unknown message type: " + type);
        }
        try {
            long expiration = DataHelper.fromLong((byte[])buffer, (int)offset, (int)4) * 1000L + 500L;
            int dataSize = len - 1 - 4;
            msg.readMessage(buffer, offset += 4, dataSize, type, handler);
            msg.setMessageExpiration(expiration);
            return msg;
        }
        catch (IllegalArgumentException iae) {
            throw new I2NPMessageException("Corrupt message (negative expiration)", iae);
        }
    }

    public static I2NPMessage createMessage(I2PAppContext context, int type) throws I2NPMessageException {
        switch (type) {
            case 1: {
                return new DatabaseStoreMessage(context);
            }
            case 2: {
                return new DatabaseLookupMessage(context);
            }
            case 3: {
                return new DatabaseSearchReplyMessage(context);
            }
            case 10: {
                return new DeliveryStatusMessage(context);
            }
            case 11: {
                return new GarlicMessage(context);
            }
            case 18: {
                return new TunnelDataMessage(context);
            }
            case 19: {
                return new TunnelGatewayMessage(context);
            }
            case 20: {
                return new DataMessage(context);
            }
            case 21: {
                return new TunnelBuildMessage(context);
            }
            case 22: {
                return new TunnelBuildReplyMessage(context);
            }
            case 23: {
                return new VariableTunnelBuildMessage(context);
            }
            case 24: {
                return new VariableTunnelBuildReplyMessage(context);
            }
        }
        Builder builder = _builders.get(type);
        if (builder != null) {
            return builder.build(context);
        }
        return new UnknownI2NPMessage(context, type);
    }

    public static interface Builder {
        public I2NPMessage build(I2PAppContext var1);
    }
}

