/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.BOB;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.BOB.NamedDB;
import net.i2p.BOB.TCPio;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;

public class TCPtoI2P
implements Runnable {
    private I2PSocket I2P;
    private NamedDB info;
    private NamedDB database;
    private Socket sock;
    private I2PSocketManager socketManager;
    private AtomicBoolean lives;

    TCPtoI2P(I2PSocketManager i2p, Socket socket, NamedDB info, NamedDB database, AtomicBoolean lives) {
        this.sock = socket;
        this.info = info;
        this.database = database;
        this.socketManager = i2p;
        this.lives = lives;
    }

    private static String lnRead(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        while (true) {
            int b;
            if ((b = in.read()) == 13) {
                continue;
            }
            if (b < 20 || b > 126) break;
            char c = (char)(b & 0x7F);
            builder.append(c);
        }
        return builder.toString();
    }

    private void Emsg(String e, OutputStream out) throws IOException {
        out.write("ERROR ".concat(e).getBytes("UTF-8"));
        out.write(13);
        out.write(10);
        out.flush();
    }

    private void rlock() {
        this.database.getReadLock();
        this.info.getReadLock();
    }

    private void runlock() {
        this.info.releaseReadLock();
        this.database.releaseReadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block66: {
            InputStream Iin = null;
            OutputStream Iout = null;
            InputStream in = null;
            OutputStream out = null;
            Thread t = null;
            Thread q = null;
            in = this.sock.getInputStream();
            out = this.sock.getOutputStream();
            String line = TCPtoI2P.lnRead(in);
            String input = line.toLowerCase(Locale.US);
            Destination dest = null;
            if (!input.endsWith(".i2p")) break block50;
            dest = I2PAppContext.getGlobalContext().namingService().lookup(input);
            if (dest != null) {
                line = dest.toBase64();
                break block50;
            }
            this.Emsg("Can't find destination: " + input, out);
            Object var13_14 = null;
            try {
                t.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                q.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Iin.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Iout.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.I2P.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            {
                block50: {
                    return;
                }
                try {
                    dest = new Destination();
                    dest.fromBase64(line);
                    try {
                        this.I2P = this.socketManager.connect(dest);
                        this.I2P.setReadTimeout(0L);
                        Iin = this.I2P.getInputStream();
                        Iout = this.I2P.getOutputStream();
                        TCPio conn_c = new TCPio(in, Iout, this.lives);
                        TCPio conn_a = new TCPio(Iin, out, this.lives);
                        t = new Thread((Runnable)conn_c, Thread.currentThread().getName() + " TCPioA");
                        q = new Thread((Runnable)conn_a, Thread.currentThread().getName() + " TCPioB");
                        t.start();
                        q.start();
                        while (t.isAlive() && q.isAlive() && this.lives.get()) {
                            Thread.sleep(10L);
                        }
                    }
                    catch (I2PException e) {
                        this.Emsg(e.toString(), out);
                    }
                    catch (ConnectException e) {
                        this.Emsg(e.toString(), out);
                    }
                    catch (NoRouteToHostException e) {
                        this.Emsg(e.toString(), out);
                    }
                }
                catch (InterruptedIOException e) {
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                    try {
                        this.Emsg(e.toString(), out);
                    }
                    catch (IOException ex) {}
                }
                catch (DataFormatException e) {
                    try {
                        this.Emsg(e.toString(), out);
                    }
                    catch (IOException ex) {
                    }
                }
            }
            Object var13_15 = null;
            try {
                t.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                q.interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Iin.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Iout.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.I2P.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (Exception e) {}
            break block66;
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    t.interrupt();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    q.interrupt();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Iin.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Iout.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.I2P.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.sock.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

