/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import org.klomp.snark.BitField;
import org.klomp.snark.DataLoader;
import org.klomp.snark.Message;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerState;
import org.klomp.snark.Request;

class PeerConnectionOut
implements Runnable {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(PeerConnectionOut.class);
    private final Peer peer;
    private final DataOutputStream dout;
    private Thread thread;
    private boolean quit;
    private final BlockingQueue<Message> sendQueue = new LinkedBlockingQueue<Message>();
    private static final AtomicLong __id = new AtomicLong();
    private final long _id;
    long lastSent;
    private static final int SEND_TIMEOUT = 180000;
    private static final int REQ_TIMEOUT = 420000;

    public PeerConnectionOut(Peer peer, DataOutputStream dout) {
        this.peer = peer;
        this.dout = dout;
        this._id = __id.incrementAndGet();
        this.lastSent = System.currentTimeMillis();
    }

    public void startup() {
        this.thread = new I2PAppThread(this, "Snark sender " + this._id + ": " + this.peer);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.quit && this.peer.isConnected()) {
                boolean shouldFlush;
                Message m = null;
                PeerState state = null;
                BlockingQueue<Message> blockingQueue = this.sendQueue;
                synchronized (blockingQueue) {
                    shouldFlush = !this.quit && this.peer.isConnected() && this.sendQueue.isEmpty();
                }
                if (shouldFlush) {
                    this.dout.flush();
                }
                blockingQueue = this.sendQueue;
                synchronized (blockingQueue) {
                    while (!this.quit && this.peer.isConnected() && this.sendQueue.isEmpty()) {
                        try {
                            this.sendQueue.wait(60000L);
                        }
                        catch (InterruptedException ie) {}
                    }
                    state = this.peer.state;
                    if (!this.quit && state != null && this.peer.isConnected()) {
                        Iterator it = this.sendQueue.iterator();
                        while (m == null && it.hasNext()) {
                            Message nm = (Message)it.next();
                            if (nm.type == 7) {
                                if (state.choking) {
                                    it.remove();
                                    if (this.peer.supportsFast()) {
                                        Message r = new Message();
                                        r.type = (byte)16;
                                        r.piece = nm.piece;
                                        r.begin = nm.begin;
                                        r.length = nm.length;
                                        if (this._log.shouldLog(10)) {
                                            this._log.debug("Send " + this.peer + ": " + r);
                                        }
                                        r.sendMessage(this.dout);
                                    }
                                }
                                nm = null;
                            } else if (nm.type == 6 && state.choked) {
                                it.remove();
                                nm = null;
                            }
                            if (nm == null) continue;
                            m = nm;
                            it.remove();
                        }
                        if (m == null) {
                            m = (Message)this.sendQueue.poll();
                        }
                    }
                }
                if (m == null) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Send " + this.peer + ": " + m);
                }
                this.lastSent = System.currentTimeMillis();
                if (m.type == 0) {
                    this.removeMessage(7);
                }
                int remainder = 0;
                if (m.type == 7) {
                    if (m.len <= 16384) {
                        state.uploaded(m.len);
                    } else {
                        state.uploaded(16384);
                        remainder = m.len - 16384;
                    }
                }
                m.sendMessage(this.dout);
                if (remainder > 0) {
                    state.uploaded(remainder);
                }
                m = null;
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(20)) {
                this._log.info("IOError sending to " + this.peer, ioe);
            }
        }
        catch (Throwable t) {
            this._log.error("Error sending to " + this.peer, t);
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
        }
        finally {
            this.quit = true;
            this.peer.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            this.quit = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.sendQueue.clear();
            this.sendQueue.notifyAll();
        }
        if (this.dout != null) {
            try {
                this.dout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(Message m) {
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            this.sendQueue.offer(m);
            this.sendQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMessage(int type) {
        boolean removed = false;
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            Iterator it = this.sendQueue.iterator();
            while (it.hasNext()) {
                Message m = (Message)it.next();
                if (m.type != type) continue;
                it.remove();
                removed = true;
                if (type != 7 || !this.peer.supportsFast()) continue;
                Message r = new Message();
                r.type = (byte)16;
                r.piece = m.piece;
                r.begin = m.begin;
                r.length = m.length;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Send " + this.peer + ": " + r);
                }
                try {
                    r.sendMessage(this.dout);
                }
                catch (IOException ioe) {}
            }
            this.sendQueue.notifyAll();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAlive() {
        Message m = new Message();
        m.type = (byte)-1;
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            if (this.sendQueue.isEmpty()) {
                this.sendQueue.offer(m);
            }
            this.sendQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendChoke(boolean choke) {
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            int inverseType;
            int n = inverseType = choke ? 1 : 0;
            if (!this.removeMessage(inverseType)) {
                Message m = new Message();
                m.type = choke ? (byte)0 : 1;
                this.addMessage(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInterest(boolean interest) {
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            int inverseType;
            int n = inverseType = interest ? 3 : 2;
            if (!this.removeMessage(inverseType)) {
                Message m = new Message();
                m.type = interest ? (byte)2 : (byte)3;
                this.addMessage(m);
            }
        }
    }

    void sendHave(int piece) {
        Message m = new Message();
        m.type = (byte)4;
        m.piece = piece;
        this.addMessage(m);
    }

    void sendBitfield(BitField bitfield) {
        boolean fast = this.peer.supportsFast();
        if (fast && bitfield.complete()) {
            this.sendHaveAll();
        } else if (fast && bitfield.count() <= 0) {
            this.sendHaveNone();
        } else {
            Message m = new Message();
            m.type = (byte)5;
            m.data = bitfield.getFieldBytes();
            m.off = 0;
            m.len = m.data.length;
            this.addMessage(m);
        }
    }

    void retransmitRequests(List<Request> requests) {
        long now = System.currentTimeMillis();
        for (Request req : requests) {
            if (now <= req.sendTime + 420000L) continue;
            if (this._log.shouldLog(10)) {
                this._log.debug("Retransmit request " + req + " to peer " + this.peer);
            }
            this.sendRequest(req);
        }
    }

    void sendRequests(List<Request> requests) {
        for (Request req : requests) {
            this.sendRequest(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRequest(Request req) {
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            for (Message m : this.sendQueue) {
                if (m.type != 6 || m.piece != req.getPiece() || m.begin != req.off || m.length != req.len) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Discarding duplicate request " + req + " to peer " + this.peer);
                }
                return;
            }
        }
        Message m = new Message();
        m.type = (byte)6;
        m.piece = req.getPiece();
        m.begin = req.off;
        m.length = req.len;
        this.addMessage(m);
        req.sendTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int queuedBytes() {
        int total = 0;
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            for (Message m : this.sendQueue) {
                if (m.type != 7) continue;
                total += m.length;
            }
        }
        return total;
    }

    void sendPiece(int piece, int begin, int length, DataLoader loader) {
        Message m = new Message();
        m.type = (byte)7;
        m.piece = piece;
        m.begin = begin;
        m.length = length;
        m.dataLoader = loader;
        m.off = 0;
        m.len = length;
        this.addMessage(m);
    }

    void sendPiece(int piece, int begin, int length, byte[] bytes) {
        Message m = new Message();
        m.type = (byte)7;
        m.piece = piece;
        m.begin = begin;
        m.length = length;
        m.data = bytes;
        m.off = 0;
        m.len = length;
        this.addMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCancel(Request req) {
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            Iterator it = this.sendQueue.iterator();
            while (it.hasNext()) {
                Message m = (Message)it.next();
                if (m.type != 6 || m.piece != req.getPiece() || m.begin != req.off || m.length != req.len) continue;
                it.remove();
            }
        }
        Message m = new Message();
        m.type = (byte)8;
        m.piece = req.getPiece();
        m.begin = req.off;
        m.length = req.len;
        this.addMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelRequestMessages() {
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            Iterator it = this.sendQueue.iterator();
            while (it.hasNext()) {
                if (((Message)it.next()).type != 6) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelRequest(int piece, int begin, int length) {
        BlockingQueue<Message> blockingQueue = this.sendQueue;
        synchronized (blockingQueue) {
            Iterator it = this.sendQueue.iterator();
            while (it.hasNext()) {
                Message m = (Message)it.next();
                if (m.type != 7 || m.piece != piece || m.begin != begin || m.length != length) continue;
                it.remove();
            }
        }
    }

    void sendExtension(int id, byte[] bytes) {
        Message m = new Message();
        m.type = (byte)20;
        m.piece = id;
        m.data = bytes;
        m.off = 0;
        m.len = bytes.length;
        this.addMessage(m);
    }

    void sendPort(int port) {
        Message m = new Message();
        m.type = (byte)9;
        m.piece = port;
        this.addMessage(m);
    }

    void sendSuggest(int piece) {
        Message m = new Message();
        m.type = (byte)13;
        m.piece = piece;
        this.addMessage(m);
    }

    private void sendHaveAll() {
        Message m = new Message();
        m.type = (byte)14;
        this.addMessage(m);
    }

    private void sendHaveNone() {
        Message m = new Message();
        m.type = (byte)15;
        this.addMessage(m);
    }

    void sendReject(int piece, int begin, int length) {
        Message m = new Message();
        m.type = (byte)16;
        m.piece = piece;
        m.begin = begin;
        m.length = length;
        this.addMessage(m);
    }

    void sendAllowedFast(int piece) {
        Message m = new Message();
        m.type = (byte)17;
        m.piece = piece;
        this.addMessage(m);
    }
}

