/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.i2p.data.Base32;
import org.klomp.snark.I2PSnarkUtil;

public class MagnetURI {
    private final String _tracker;
    private final String _name;
    private final byte[] _ih;
    public static final String MAGNET = "magnet:";
    public static final String MAGNET_FULL = "magnet:?xt=urn:btih:";
    public static final String MAGGOT = "maggot://";

    public MagnetURI(I2PSnarkUtil util, String url) throws IllegalArgumentException {
        String name;
        String ihash;
        String trackerURL = null;
        if (url.startsWith(MAGNET)) {
            String xt = MagnetURI.getParam("xt", url);
            if (xt == null || !xt.startsWith("urn:btih:")) {
                throw new IllegalArgumentException();
            }
            ihash = xt.substring("urn:btih:".length());
            trackerURL = MagnetURI.getTrackerParam(url);
            name = util.getString("Magnet") + ' ' + ihash;
            String dn = MagnetURI.getParam("dn", url);
            if (dn != null) {
                name = name + " (" + dn + ')';
            }
        } else if (url.startsWith(MAGGOT)) {
            ihash = url.substring(MAGGOT.length()).trim();
            int col = ihash.indexOf(58);
            if (col >= 0) {
                ihash = ihash.substring(0, col);
            }
            name = util.getString("Magnet") + ' ' + ihash;
        } else {
            throw new IllegalArgumentException();
        }
        byte[] ih = null;
        if (ihash.length() == 32) {
            ih = Base32.decode(ihash);
        } else if (ihash.length() == 40) {
            ih = new byte[20];
            try {
                for (int i = 0; i < 20; ++i) {
                    ih[i] = (byte)(Integer.parseInt(ihash.substring(i * 2, i * 2 + 2), 16) & 0xFF);
                }
            }
            catch (NumberFormatException nfe) {
                ih = null;
            }
        }
        if (ih == null || ih.length != 20) {
            throw new IllegalArgumentException();
        }
        this._ih = ih;
        this._name = name;
        this._tracker = trackerURL;
    }

    public byte[] getInfoHash() {
        return this._ih;
    }

    public String getName() {
        return this._name;
    }

    public String getTrackerURL() {
        return this._tracker;
    }

    private static String getParam(String key, String uri) {
        int idx = uri.indexOf('?' + key + '=');
        if (idx >= 0) {
            idx += key.length() + 2;
        } else {
            idx = uri.indexOf('&' + key + '=');
            if (idx >= 0) {
                idx += key.length() + 2;
            }
        }
        if (idx < 0 || idx > uri.length()) {
            return null;
        }
        String rv = uri.substring(idx);
        rv = (idx = rv.indexOf(38)) >= 0 ? rv.substring(0, idx) : rv.trim();
        return MagnetURI.decode(rv);
    }

    private static List<String> getMultiParam(String key, String uri) {
        int idx = uri.indexOf('?' + key + '=');
        if (idx >= 0) {
            idx += key.length() + 2;
        } else {
            idx = uri.indexOf('&' + key + '=');
            if (idx >= 0) {
                idx += key.length() + 2;
            }
        }
        if (idx < 0 || idx > uri.length()) {
            return null;
        }
        ArrayList<String> rv = new ArrayList<String>();
        while (true) {
            String p;
            uri = p = uri.substring(idx);
            idx = p.indexOf(38);
            p = idx >= 0 ? p.substring(0, idx) : p.trim();
            rv.add(MagnetURI.decode(p));
            idx = uri.indexOf('&' + key + '=');
            if (idx < 0) break;
            idx += key.length() + 2;
        }
        return rv;
    }

    private static String getTrackerParam(String uri) {
        List<String> trackers = MagnetURI.getMultiParam("tr", uri);
        if (trackers == null) {
            return null;
        }
        for (String t : trackers) {
            try {
                URI u = new URI(t);
                String protocol = u.getScheme();
                String host = u.getHost();
                if (protocol == null || host == null || !protocol.toLowerCase(Locale.US).equals("http") || !host.toLowerCase(Locale.US).endsWith(".i2p")) continue;
                return t;
            }
            catch (URISyntaxException use) {
            }
        }
        return null;
    }

    private static String decode(String s) {
        if (!s.contains("%") && !s.contains("+")) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        boolean utf8 = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '+') {
                buf.append(' ');
                continue;
            }
            if (c != '%') {
                buf.append(c);
                continue;
            }
            try {
                int val = Integer.parseInt(s.substring(++i, ++i + 1), 16);
                if ((val & 0x80) != 0) {
                    utf8 = true;
                }
                buf.append((char)val);
                continue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                break;
            }
            catch (NumberFormatException nfe) {
                break;
            }
        }
        if (utf8) {
            try {
                return new String(buf.toString().getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return buf.toString();
    }
}

