/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.net.SocketException;
import net.i2p.I2PAppContext;
import net.i2p.util.Translate;

public class I2PSocketException
extends SocketException {
    private final int _status;
    private static final int CUSTOM = -1;
    private static final String BUNDLE_NAME = "net.i2p.client.streaming.messages";
    public static final int STATUS_CONNECTION_RESET = 512;

    public I2PSocketException(int status) {
        this._status = status;
    }

    public I2PSocketException(String message) {
        super(message);
        this._status = -1;
    }

    public int getStatus() {
        return this._status;
    }

    @Override
    public String getMessage() {
        switch (this._status) {
            case 3: 
            case 5: {
                return I2PSocketException._x("Message timeout");
            }
            case 7: {
                return I2PSocketException._x("Failed delivery to local destination");
            }
            case 8: {
                return I2PSocketException._x("Local router failure");
            }
            case 9: {
                return I2PSocketException._x("Local network failure");
            }
            case 10: {
                return I2PSocketException._x("Session closed");
            }
            case 11: {
                return I2PSocketException._x("Invalid message");
            }
            case 12: {
                return I2PSocketException._x("Invalid message options");
            }
            case 13: {
                return I2PSocketException._x("Buffer overflow");
            }
            case 14: {
                return I2PSocketException._x("Message expired");
            }
            case 15: {
                return I2PSocketException._x("Local lease set invalid");
            }
            case 16: {
                return I2PSocketException._x("No local tunnels");
            }
            case 17: {
                return I2PSocketException._x("Unsupported encryption options");
            }
            case 18: {
                return I2PSocketException._x("Invalid destination");
            }
            case 19: {
                return I2PSocketException._x("Local router failure");
            }
            case 20: {
                return I2PSocketException._x("Destination lease set expired");
            }
            case 21: {
                return I2PSocketException._x("Destination lease set not found");
            }
            case 256: {
                return I2PSocketException._x("Local destination shutdown");
            }
            case 512: {
                return I2PSocketException._x("Connection was reset");
            }
            case -1: {
                return super.getMessage();
            }
        }
        return I2PSocketException._("Failure code") + ": " + this._status;
    }

    @Override
    public String getLocalizedMessage() {
        String s = this.getMessage();
        if (s == null) {
            return null;
        }
        return I2PSocketException._(s);
    }

    private static String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)I2PAppContext.getGlobalContext(), (String)BUNDLE_NAME);
    }

    private static String _x(String s) {
        return s;
    }
}

