/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udpTunnel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.udp.I2PSinkAnywhere;
import net.i2p.i2ptunnel.udp.I2PSource;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.util.EventDispatcher;
import net.i2p.util.Log;

public class I2PTunnelUDPServerBase
extends I2PTunnelTask
implements Source,
Sink {
    private final Log _log;
    private final Object lock = new Object();
    protected Object slock = new Object();
    protected Logging l;
    private static final long DEFAULT_READ_TIMEOUT = -1L;
    protected long readTimeout = -1L;
    private I2PSession _session;
    private Source _i2pSource;
    private Sink _i2pSink;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PTunnelUDPServerBase(boolean verify, File privkey, String privkeyname, Logging l, EventDispatcher notifyThis, I2PTunnel tunnel) {
        super("UDPServer <- " + privkeyname, notifyThis, tunnel);
        this._log = tunnel.getContext().logManager().getLog(I2PTunnelUDPServerBase.class);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(privkey);
            this.init(verify, fis, privkeyname, l);
        }
        catch (IOException ioe) {
            this._log.error("Error starting server", ioe);
            this.notifyEvent("openServerResult", "error");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private void init(boolean verify, InputStream privData, String privkeyname, Logging l) {
        this.l = l;
        I2PClient client = I2PClientFactory.createClient();
        try {
            this._session = client.createSession(privData, this.getTunnel().getClientOptions());
            this.connected(this._session);
        }
        catch (I2PSessionException exc) {
            throw new RuntimeException("failed to create session", exc);
        }
        this._i2pSource = new I2PSource(this._session, verify, false);
        this._i2pSink = new I2PSinkAnywhere(this._session, true);
    }

    public void startRunning() {
        try {
            this._session.connect();
        }
        catch (I2PSessionException exc) {
            throw new RuntimeException("failed to connect session", exc);
        }
        this.start();
        this.notifyEvent("openServerResult", "ok");
        this.open = true;
    }

    public void setReadTimeout(long ms) {
        this.readTimeout = ms;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(boolean forced) {
        if (!this.open) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            this.l.log("Shutting down server " + this.toString());
            try {
                if (this._session != null) {
                    this._session.destroySession();
                }
            }
            catch (I2PException ex) {
                this._log.error("Error destroying the session", ex);
            }
            this.l.log("Server shut down.");
            this.open = false;
            return true;
        }
    }

    @Override
    public void setSink(Sink s) {
        this._i2pSource.setSink(s);
    }

    @Override
    public void start() {
        this._i2pSource.start();
    }

    @Override
    public void send(Destination to, byte[] data) {
        this._i2pSink.send(to, data);
    }
}

