/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocketException;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.util.EepGet;
import net.i2p.util.EventDispatcher;
import net.i2p.util.InternalSocket;
import net.i2p.util.PasswordManager;
import net.i2p.util.Translate;
import net.i2p.util.TranslateReader;

public abstract class I2PTunnelHTTPClientBase
extends I2PTunnelClientBase
implements Runnable {
    private static final int PROXYNONCE_BYTES = 8;
    private static final int MD5_BYTES = 16;
    private static final int NONCE_BYTES = 24;
    private static final long MAX_NONCE_AGE = 3600000L;
    private static final int MAX_NONCE_COUNT = 1024;
    private static final String ERR_AUTH1 = "HTTP/1.1 407 Proxy Authentication Required\r\nContent-Type: text/html; charset=UTF-8\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\nAccept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.5\r\nProxy-Authenticate: ";
    private static final String ERR_AUTH2 = "\r\n\r\n<html><body><H1>I2P ERROR: PROXY AUTHENTICATION REQUIRED</H1>This proxy is configured to require authentication.";
    protected final List<String> _proxyList;
    protected static final String ERR_NO_OUTPROXY = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel";
    protected static final String ERR_DESTINATION_UNKNOWN = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>";
    protected static final String SUCCESS_RESPONSE = "HTTP/1.1 200 Connection Established\r\nProxy-agent: I2P\r\n\r\n";
    private final byte[] _proxyNonce;
    private final ConcurrentHashMap<String, NonceInfo> _nonces;
    private final AtomicInteger _nonceCleanCounter = new AtomicInteger();
    protected static final int DEFAULT_READ_TIMEOUT = 300000;
    protected static final AtomicLong __requestId = new AtomicLong();
    public static final String PROP_AUTH = "proxyAuth";
    public static final String PROP_USER = "proxyUsername";
    public static final String PROP_PW = "proxyPassword";
    public static final String PROP_PW_PREFIX = "proxyPassword.";
    public static final String PROP_OUTPROXY_AUTH = "outproxyAuth";
    public static final String PROP_OUTPROXY_USER = "outproxyUsername";
    public static final String PROP_OUTPROXY_PW = "outproxyPassword";
    public static final String PROP_OUTPROXY_USER_PREFIX = "outproxyUsername.";
    public static final String PROP_OUTPROXY_PW_PREFIX = "outproxyPassword.";
    public static final String PROP_PROXY_DIGEST_PREFIX = "proxy.auth.";
    public static final String PROP_PROXY_DIGEST_SUFFIX = ".md5";
    public static final String BASIC_AUTH = "basic";
    public static final String DIGEST_AUTH = "digest";
    private static final String BUNDLE_NAME = "net.i2p.i2ptunnel.proxy.messages";

    protected String getPrefix(long requestId) {
        return "HTTPClient[" + this._clientId + '/' + requestId + "]: ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String selectProxy() {
        List<String> list = this._proxyList;
        synchronized (list) {
            int size = this._proxyList.size();
            if (size <= 0) {
                return null;
            }
            int index = this._context.random().nextInt(size);
            return this._proxyList.get(index);
        }
    }

    public I2PTunnelHTTPClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, handlerName, tunnel);
        this._proxyList = new ArrayList<String>(4);
        this._proxyNonce = new byte[8];
        this._context.random().nextBytes(this._proxyNonce);
        this._nonces = new ConcurrentHashMap();
    }

    public I2PTunnelHTTPClientBase(int localPort, Logging l, I2PSocketManager sktMgr, I2PTunnel tunnel, EventDispatcher notifyThis, long clientId) throws IllegalArgumentException {
        super(localPort, l, sktMgr, tunnel, notifyThis, clientId);
        this._proxyList = new ArrayList<String>(4);
        this._proxyNonce = new byte[8];
        this._context.random().nextBytes(this._proxyNonce);
        this._nonces = new ConcurrentHashMap();
    }

    protected abstract String getRealm();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optionsUpdated(I2PTunnel tunnel) {
        if (this.getTunnel() != tunnel) {
            return;
        }
        Properties props = tunnel.getClientOptions();
        String proxies = props.getProperty("proxyList");
        if (proxies != null) {
            StringTokenizer tok = new StringTokenizer(proxies, ",; \r\n\t");
            List<String> list = this._proxyList;
            synchronized (list) {
                this._proxyList.clear();
                while (tok.hasMoreTokens()) {
                    String p = tok.nextToken().trim();
                    if (p.length() <= 0) continue;
                    this._proxyList.add(p);
                }
            }
        }
        List<String> list = this._proxyList;
        synchronized (list) {
            this._proxyList.clear();
        }
        super.optionsUpdated(tunnel);
    }

    protected boolean isDigestAuthRequired() {
        String authRequired = this.getTunnel().getClientOptions().getProperty(PROP_AUTH);
        if (authRequired == null) {
            return false;
        }
        return authRequired.toLowerCase(Locale.US).equals(DIGEST_AUTH);
    }

    protected AuthResult authorize(Socket s, long requestId, String method, String authorization) {
        String authRequired = this.getTunnel().getClientOptions().getProperty(PROP_AUTH);
        if (authRequired == null) {
            return AuthResult.AUTH_GOOD;
        }
        if ((authRequired = authRequired.toLowerCase(Locale.US)).equals("false")) {
            return AuthResult.AUTH_GOOD;
        }
        if (s instanceof InternalSocket) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix(requestId) + "Internal access, no auth required");
            }
            return AuthResult.AUTH_GOOD;
        }
        if (authorization == null) {
            return AuthResult.AUTH_BAD;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix(requestId) + "Auth: " + authorization);
        }
        String authLC = authorization.toLowerCase(Locale.US);
        if (authRequired.equals("true") || authRequired.equals(BASIC_AUTH)) {
            if (!authLC.startsWith("basic ")) {
                return AuthResult.AUTH_BAD;
            }
            byte[] decoded = Base64.decode((authorization = authorization.substring(6)).replace("/", "~").replace("+", "="));
            if (decoded != null) {
                try {
                    String configUser;
                    String dec = new String(decoded, "UTF-8");
                    String[] parts = dec.split(":");
                    String user = parts[0];
                    String pw = parts[1];
                    String configPW = this.getTunnel().getClientOptions().getProperty(PROP_PW_PREFIX + user);
                    if (configPW == null && user.equals(configUser = this.getTunnel().getClientOptions().getProperty(PROP_USER))) {
                        configPW = this.getTunnel().getClientOptions().getProperty(PROP_PW);
                    }
                    if (configPW != null && pw.equals(configPW)) {
                        if (this._log.shouldLog(20)) {
                            this._log.info(this.getPrefix(requestId) + "Good auth - user: " + user + " pw: " + pw);
                        }
                        return AuthResult.AUTH_GOOD;
                    }
                    this._log.logAlways(30, "PROXY AUTH FAILURE: user " + user);
                }
                catch (UnsupportedEncodingException uee) {
                    this._log.error(this.getPrefix(requestId) + "No UTF-8 support? B64: " + authorization, uee);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this.getPrefix(requestId) + "Bad auth B64: " + authorization, aioobe);
                    }
                    return AuthResult.AUTH_BAD_REQ;
                }
                return AuthResult.AUTH_BAD;
            }
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix(requestId) + "Bad auth B64: " + authorization);
            }
            return AuthResult.AUTH_BAD_REQ;
        }
        if (authRequired.equals(DIGEST_AUTH)) {
            if (!authLC.startsWith("digest ")) {
                return AuthResult.AUTH_BAD;
            }
            authorization = authorization.substring(7);
            Map<String, String> args = I2PTunnelHTTPClientBase.parseArgs(authorization);
            AuthResult rv = this.validateDigest(method, args);
            return rv;
        }
        this._log.error("Unknown proxy authorization type configured: " + authRequired);
        return AuthResult.AUTH_BAD_REQ;
    }

    private AuthResult validateDigest(String method, Map<String, String> args) {
        String user = args.get("username");
        String realm = args.get("realm");
        String nonce = args.get("nonce");
        String qop = args.get("qop");
        String uri = args.get("uri");
        String cnonce = args.get("cnonce");
        String nc = args.get("nc");
        String response = args.get("response");
        if (user == null || realm == null || nonce == null || qop == null || uri == null || cnonce == null || nc == null || response == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Bad digest request: " + DataHelper.toString(args));
            }
            return AuthResult.AUTH_BAD_REQ;
        }
        AuthResult check = this.verifyNonce(nonce, nc);
        if (check != AuthResult.AUTH_GOOD) {
            if (this._log.shouldLog(20)) {
                this._log.info("Bad digest nonce: " + (Object)((Object)check) + ' ' + DataHelper.toString(args));
            }
            return check;
        }
        String ha1 = this.getTunnel().getClientOptions().getProperty(PROP_PROXY_DIGEST_PREFIX + user + PROP_PROXY_DIGEST_SUFFIX);
        if (ha1 == null) {
            this._log.logAlways(30, "PROXY AUTH FAILURE: user " + user);
            return AuthResult.AUTH_BAD;
        }
        String a2 = method + ':' + uri;
        String ha2 = PasswordManager.md5Hex(a2);
        String kd = ha1 + ':' + nonce + ':' + nc + ':' + cnonce + ':' + qop + ':' + ha2;
        String hkd = PasswordManager.md5Hex(kd);
        if (!response.equals(hkd)) {
            this._log.logAlways(30, "PROXY AUTH FAILURE: user " + user);
            if (this._log.shouldLog(20)) {
                this._log.info("Bad digest auth: " + DataHelper.toString(args));
            }
            return AuthResult.AUTH_BAD;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Good digest auth - user: " + user);
        }
        return AuthResult.AUTH_GOOD;
    }

    private String getNonce() {
        byte[] b = new byte[16];
        byte[] n = new byte[24];
        long now = this._context.clock().now();
        DataHelper.toLong(b, 0, 8, now);
        System.arraycopy(this._proxyNonce, 0, b, 8, 8);
        System.arraycopy(b, 0, n, 0, 8);
        byte[] md5 = PasswordManager.md5Sum(b);
        System.arraycopy(md5, 0, n, 8, 16);
        String rv = Base64.encode(n);
        this._nonces.putIfAbsent(rv, new NonceInfo(now + 3600000L));
        return rv;
    }

    private AuthResult verifyNonce(String b64, String ncs) {
        long stamp;
        byte[] n;
        if (this._nonceCleanCounter.incrementAndGet() % 16 == 0) {
            this.cleanNonces();
        }
        if ((n = Base64.decode(b64)) == null || n.length != 24) {
            return AuthResult.AUTH_BAD;
        }
        long now = this._context.clock().now();
        if (now - (stamp = DataHelper.fromLong(n, 0, 8)) > 3600000L) {
            this._nonces.remove(b64);
            return AuthResult.AUTH_STALE;
        }
        NonceInfo info = this._nonces.get(b64);
        if (info == null) {
            return AuthResult.AUTH_STALE;
        }
        byte[] b = new byte[16];
        System.arraycopy(n, 0, b, 0, 8);
        System.arraycopy(this._proxyNonce, 0, b, 8, 8);
        byte[] md5 = PasswordManager.md5Sum(b);
        if (!DataHelper.eq(md5, 0, n, 8, 16)) {
            return AuthResult.AUTH_BAD;
        }
        try {
            int nc = Integer.parseInt(ncs, 16);
            return info.isValid(nc);
        }
        catch (NumberFormatException nfe) {
            return AuthResult.AUTH_BAD;
        }
    }

    private void cleanNonces() {
        long now = this._context.clock().now();
        Iterator<NonceInfo> iter = this._nonces.values().iterator();
        while (iter.hasNext()) {
            NonceInfo info = iter.next();
            if (info.getExpires() > now) continue;
            iter.remove();
        }
    }

    protected String getAuthError(boolean isStale) {
        boolean isDigest = this.isDigestAuthRequired();
        return ERR_AUTH1 + (isDigest ? "Digest" : "Basic") + " realm=\"" + this.getRealm() + '\"' + (isDigest ? ", nonce=\"" + this.getNonce() + "\"," + " algorithm=MD5," + " qop=\"auth\"" + (isStale ? ", stale=true" : "") : "") + ERR_AUTH2;
    }

    private static Map<String, String> parseArgs(String args) {
        return EepGet.parseAuthArgs(args);
    }

    protected String getErrorPage(String base, String backup) {
        return I2PTunnelHTTPClientBase.getErrorPage(this._context, base, backup);
    }

    protected static String getErrorPage(I2PAppContext ctx, String base, String backup) {
        File errorDir = new File(ctx.getBaseDir(), "docs");
        File file = new File(errorDir, base + "-header.ht");
        try {
            return I2PTunnelHTTPClientBase.readFile(ctx, file);
        }
        catch (IOException ioe) {
            return backup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(I2PAppContext ctx, File file) throws IOException {
        Reader reader = null;
        char[] buf = new char[512];
        StringBuilder out = new StringBuilder(2048);
        try {
            int len;
            reader = new TranslateReader(ctx, BUNDLE_NAME, new FileInputStream(file));
            while ((len = reader.read(buf)) > 0) {
                out.append(buf, 0, len);
            }
            String string = out.toString();
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException foo) {}
        }
    }

    protected void handleClientException(Exception ex, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy, long requestId) {
        if (out == null) {
            return;
        }
        String header = usingWWWProxy ? I2PTunnelHTTPClientBase.getErrorPage(I2PAppContext.getGlobalContext(), "dnfp", ERR_DESTINATION_UNKNOWN) : I2PTunnelHTTPClientBase.getErrorPage(I2PAppContext.getGlobalContext(), "dnf", ERR_DESTINATION_UNKNOWN);
        try {
            this.writeErrorMessage(header, out, targetRequest, usingWWWProxy, wwwProxy);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected void handleI2PSocketException(I2PSocketException ise, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy) {
        int status;
        if (out == null) {
            return;
        }
        int n = status = ise != null ? ise.getStatus() : -1;
        String error = status == 21 ? (usingWWWProxy ? "nolsp" : "nols") : (status == 17 ? (usingWWWProxy ? "encp" : "enc") : (status == 512 ? (usingWWWProxy ? "resetp" : "reset") : (usingWWWProxy ? "dnfp" : "dnf")));
        String header = this.getErrorPage(error, ERR_DESTINATION_UNKNOWN);
        String message = ise != null ? ise.getLocalizedMessage() : "unknown error";
        try {
            this.writeErrorMessage(header, message, out, targetRequest, usingWWWProxy, wwwProxy);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected void writeErrorMessage(String errMessage, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy) throws IOException {
        this.writeErrorMessage(errMessage, null, out, targetRequest, usingWWWProxy, wwwProxy, null);
    }

    protected void writeErrorMessage(String errMessage, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy, String jumpServers) throws IOException {
        this.writeErrorMessage(errMessage, null, out, targetRequest, usingWWWProxy, wwwProxy, jumpServers);
    }

    protected void writeErrorMessage(String errMessage, String extraMessage, OutputStream out, String targetRequest, boolean usingWWWProxy, String wwwProxy) throws IOException {
        this.writeErrorMessage(errMessage, extraMessage, out, targetRequest, usingWWWProxy, wwwProxy, null);
    }

    protected void writeErrorMessage(String errMessage, String extraMessage, OutputStream outs, String targetRequest, boolean usingWWWProxy, String wwwProxy, String jumpServers) throws IOException {
        if (outs == null) {
            return;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outs, "UTF-8"));
        out.write(errMessage);
        if (targetRequest != null) {
            String uri = DataHelper.escapeHTML(targetRequest);
            out.write("<a href=\"");
            out.write(uri);
            out.write("\">");
            if (targetRequest.length() > 80) {
                out.write(DataHelper.escapeHTML(targetRequest.substring(0, 75)) + "&hellip;");
            } else {
                out.write(uri);
            }
            out.write("</a>");
            if (usingWWWProxy) {
                out.write("<br><br><b>");
                out.write(this._("HTTP Outproxy"));
                out.write(":</b> " + wwwProxy);
            }
            if (extraMessage != null) {
                out.write("<br><br><b>" + DataHelper.escapeHTML(extraMessage) + "</b>");
            }
            if (jumpServers != null && jumpServers.length() > 0) {
                boolean first = true;
                if (uri.startsWith("http://")) {
                    uri = uri.substring(7);
                }
                StringTokenizer tok = new StringTokenizer(jumpServers, ", ");
                while (tok.hasMoreTokens()) {
                    Destination dest;
                    String jumphost;
                    String jurl = tok.nextToken();
                    try {
                        URI jURI = new URI(jurl);
                        String proto = jURI.getScheme();
                        jumphost = jURI.getHost();
                        if (proto == null || jumphost == null || !proto.toLowerCase(Locale.US).equals("http")) continue;
                        if (!(jumphost = jumphost.toLowerCase(Locale.US)).endsWith(".i2p")) {
                        }
                    }
                    catch (URISyntaxException use) {}
                    continue;
                    if (!jumphost.endsWith(".b32.i2p") && (dest = this._context.namingService().lookup(jumphost)) == null) continue;
                    if (first) {
                        first = false;
                        out.write("<br><br><h3>");
                        out.write(this._("Click a link below for an address helper from a jump service"));
                        out.write("</h3>\n");
                    } else {
                        out.write("<br>");
                    }
                    out.write("<a href=\"");
                    out.write(jurl);
                    out.write(uri);
                    out.write("\">");
                    out.write(this._("{0} jump service", jumphost));
                    out.write("</a>\n");
                }
            }
        }
        out.write("</div>");
        I2PTunnelHTTPClientBase.writeFooter(out);
    }

    public static void writeFooter(OutputStream out) throws IOException {
        out.write(I2PTunnelHTTPClientBase.getFooter().getBytes("UTF-8"));
        out.flush();
    }

    public static void writeFooter(Writer out) throws IOException {
        out.write(I2PTunnelHTTPClientBase.getFooter());
        out.flush();
    }

    private static String getFooter() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("<div class=\"proxyfooter\"><p><i>I2P HTTP Proxy Server<br>Generated on: ").append(new Date().toString()).append("</i></div></body></html>\n");
        return buf.toString();
    }

    protected String _(String key) {
        return Translate.getString(key, this._context, BUNDLE_NAME);
    }

    protected String _(String key, Object o) {
        return Translate.getString(key, o, this._context, BUNDLE_NAME);
    }

    protected String _(String key, Object o, Object o2) {
        return Translate.getString(key, o, o2, this._context, BUNDLE_NAME);
    }

    protected static enum AuthResult {
        AUTH_BAD_REQ,
        AUTH_BAD,
        AUTH_STALE,
        AUTH_GOOD;

    }

    private static class NonceInfo {
        private final long expires;
        private final BitSet counts;

        public NonceInfo(long exp) {
            this.expires = exp;
            this.counts = new BitSet(1024);
        }

        public long getExpires() {
            return this.expires;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthResult isValid(int nc) {
            if (nc <= 0) {
                return AuthResult.AUTH_BAD;
            }
            if (nc >= 1024) {
                return AuthResult.AUTH_STALE;
            }
            BitSet bitSet = this.counts;
            synchronized (bitSet) {
                if (this.counts.get(nc)) {
                    return AuthResult.AUTH_BAD;
                }
                this.counts.set(nc);
            }
            return AuthResult.AUTH_GOOD;
        }
    }

    protected class OnTimeout
    implements I2PTunnelRunner.FailCallback {
        private final Socket _socket;
        private final OutputStream _out;
        private final String _target;
        private final boolean _usingProxy;
        private final String _wwwProxy;
        private final long _requestId;

        public OnTimeout(Socket s, OutputStream out, String target, boolean usingProxy, String wwwProxy, long id) {
            this._socket = s;
            this._out = out;
            this._target = target;
            this._usingProxy = usingProxy;
            this._wwwProxy = wwwProxy;
            this._requestId = id;
        }

        @Override
        public void onFail(Exception ex) {
            Throwable cause;
            Throwable throwable = cause = ex != null ? ex.getCause() : null;
            if (cause != null && cause instanceof I2PSocketException) {
                I2PSocketException ise = (I2PSocketException)cause;
                I2PTunnelHTTPClientBase.this.handleI2PSocketException(ise, this._out, this._target, this._usingProxy, this._wwwProxy);
            } else {
                I2PTunnelHTTPClientBase.this.handleClientException(ex, this._out, this._target, this._usingProxy, this._wwwProxy, this._requestId);
            }
            I2PTunnelClientBase.closeSocket(this._socket);
        }
    }
}

