/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PException;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.Outproxy;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base32;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientBase;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientRunner;
import net.i2p.i2ptunnel.I2PTunnelOutproxyRunner;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.InternalSocketRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.localServer.LocalHTTPServer;
import net.i2p.util.EventDispatcher;

public class I2PTunnelHTTPClient
extends I2PTunnelHTTPClientBase
implements Runnable {
    private final ConcurrentHashMap<String, String> addressHelpers = new ConcurrentHashMap(8);
    private final String _proxyNonce = Long.toString(this._context.random().nextLong());
    public static final String AUTH_REALM = "I2P HTTP Proxy";
    private static final String ERR_REQUEST_DENIED = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>You attempted to connect to a non-I2P website or location.<BR>";
    private static final String ERR_NO_OUTPROXY = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel";
    private static final String ERR_AHELPER_CONFLICT = "HTTP/1.1 409 Conflict\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: Destination key conflict</H1>The addresshelper link you followed specifies a different destination key than a host entry in your host database. Someone could be trying to impersonate another website, or people have given two websites identical names.<p>You can resolve the conflict by considering which key you trust, and either discarding the addresshelper link, discarding the host entry from your host database, or naming one of them differently.<p>";
    private static final String ERR_AHELPER_NOTFOUND = "HTTP/1.1 404 Not Found\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: Helper key not resolvable.</H1>The helper key you put for i2paddresshelper= is not resolvable. It seems to be garbage data, or a mistyped b32. Check your URL to try and fix the helper key to be either a b32 or a base64.";
    private static final String ERR_AHELPER_NEW = "HTTP/1.1 409 New Address\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>New Host Name with Address Helper</H1>The address helper link you followed is for a new host name that is not in your address book. You may either save the destination for this host name to your address book, or remember it only until your router restarts. If you save it to your address book, you will not see this message again. If you do not wish to visit this host, click the \"back\" button on your browser.";
    private static final String ERR_BAD_PROTOCOL = "HTTP/1.1 403 Bad Protocol\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: NON-HTTP PROTOCOL</H1>The request uses a bad protocol. The I2P HTTP Proxy supports HTTP and HTTPS requests only. Other protocols such as FTP are not allowed.<BR>";
    private static final String ERR_BAD_URI = "HTTP/1.1 403 Bad URI\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: INVALID REQUEST URI</H1>The request URI is invalid, and probably contains illegal characters. If you clicked e.g. a forum link, check the end of the URI for any characters the browser has mistakenly added on.<BR>";
    private static final String ERR_LOCALHOST = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>Your browser is misconfigured. Do not use the proxy to access the router console or other localhost destinations.<BR>";
    private static final String ERR_INTERNAL_SSL = "HTTP/1.1 403 SSL Rejected\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: SSL to I2P address rejected</H1>SSL for to .i2p addresses denied by configuration.You may change the configuration in I2PTunnel";
    private InternalSocketRunner isr;
    private static final String HELPER_PARAM = "i2paddresshelper";
    public static final String LOCAL_SERVER = "proxy.i2p";
    private static final boolean DEFAULT_GZIP = true;
    public static final String PROP_REFERER = "i2ptunnel.httpclient.sendReferer";
    public static final String PROP_USER_AGENT = "i2ptunnel.httpclient.sendUserAgent";
    public static final String PROP_VIA = "i2ptunnel.httpclient.sendVia";
    public static final String PROP_JUMP_SERVERS = "i2ptunnel.httpclient.jumpServers";
    public static final String PROP_DISABLE_HELPER = "i2ptunnel.httpclient.disableAddressHelper";
    public static final String PROP_USE_OUTPROXY_PLUGIN = "i2ptunnel.useLocalOutproxy";
    public static final String PROP_SSL_OUTPROXIES = "i2ptunnel.httpclient.SSLOutproxies";
    public static final String PROP_ACCEPT = "i2ptunnel.httpclient.sendAccept";
    public static final String PROP_INTERNAL_SSL = "i2ptunnel.httpclient.allowInternalSSL";
    public static final String DEFAULT_JUMP_SERVERS = "http://i2host.i2p/cgi-bin/i2hostjump?,http://stats.i2p/cgi-bin/jump.cgi?a=,http://no.i2p/jump/,http://i2pjump.i2p/jump/";
    private static final String ERR_HELPER_DISABLED = "HTTP/1.1 403 Disabled\r\nContent-Type: text/plain\r\nConnection: close\r\nProxy-Connection: close\r\n\r\nAddress helpers disabled";

    public I2PTunnelHTTPClient(int localPort, Logging l, I2PSocketManager sockMgr, I2PTunnel tunnel, EventDispatcher notifyThis, long clientId) {
        super(localPort, l, sockMgr, tunnel, notifyThis, clientId);
        this.setName("HTTP Proxy on " + this.getTunnel().listenHost + ':' + localPort);
        this.notifyEvent("openHTTPClientResult", "ok");
    }

    public I2PTunnelHTTPClient(int localPort, Logging l, boolean ownDest, String wwwProxy, EventDispatcher notifyThis, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "HTTP Proxy on " + tunnel.listenHost + ':' + localPort, tunnel);
        if (wwwProxy != null) {
            StringTokenizer tok = new StringTokenizer(wwwProxy, ", ");
            while (tok.hasMoreTokens()) {
                this._proxyList.add(tok.nextToken().trim());
            }
        }
        this.setName("HTTP Proxy on " + tunnel.listenHost + ':' + localPort);
        this.notifyEvent("openHTTPClientResult", "ok");
    }

    @Override
    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "300000");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    @Override
    protected I2PSocketOptions getDefaultOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "300000");
        }
        if (!defaultOpts.contains("i2p.streaming.inactivityTimeout")) {
            defaultOpts.setProperty("i2p.streaming.inactivityTimeout", "300000");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    @Override
    public void startRunning() {
        this._context.statManager().createRateStat("i2ptunnel.httpCompressionRatio", "ratio of compressed size to decompressed size after transfer", "I2PTunnel", new long[]{3600000L});
        this._context.statManager().createRateStat("i2ptunnel.httpCompressed", "compressed size transferred", "I2PTunnel", new long[]{3600000L});
        this._context.statManager().createRateStat("i2ptunnel.httpExpanded", "size transferred after expansion", "I2PTunnel", new long[]{3600000L});
        super.startRunning();
        if (this.open) {
            this.isr = new InternalSocketRunner(this);
            this.isr.start();
            int port = this.getLocalPort();
            this._context.portMapper().register("HTTP", port);
            this._context.portMapper().register("HTTPS", port);
        }
    }

    @Override
    public boolean close(boolean forced) {
        int port = this.getLocalPort();
        int reg = this._context.portMapper().getPort("HTTP");
        if (reg == port) {
            this._context.portMapper().unregister("HTTP");
        }
        if ((reg = this._context.portMapper().getPort("HTTPS")) == port) {
            this._context.portMapper().unregister("HTTPS");
        }
        boolean rv = super.close(forced);
        if (this.isr != null) {
            this.isr.stopRunning();
        }
        return rv;
    }

    @Override
    protected String getRealm() {
        return AUTH_REALM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void clientConnectionRun(Socket s) {
        OutputStream out = null;
        String targetRequest = null;
        boolean usingWWWProxy = false;
        boolean usingInternalOutproxy = false;
        Outproxy outproxy = null;
        boolean usingInternalServer = false;
        String internalPath = null;
        String internalRawQuery = null;
        String currentProxy = null;
        long requestId = __requestId.incrementAndGet();
        boolean shout = false;
        try {
            void var35_69;
            String header;
            Destination clientDest;
            String referer;
            int remotePort;
            String userAgent;
            String ahelperKey;
            boolean ahelperNew;
            boolean ahelperPresent;
            StringBuilder newRequest;
            String destination;
            String method;
            block209: {
                block211: {
                    block210: {
                        String host;
                        block208: {
                            I2PTunnelHTTPClientBase.AuthResult result;
                            String line;
                            out = s.getOutputStream();
                            InputReader reader = new InputReader(s.getInputStream());
                            method = null;
                            String protocol = null;
                            host = null;
                            destination = null;
                            newRequest = new StringBuilder();
                            ahelperPresent = false;
                            ahelperNew = false;
                            ahelperKey = null;
                            userAgent = null;
                            String authorization = null;
                            remotePort = 0;
                            referer = null;
                            while ((line = reader.readLine(method)) != null) {
                                block207: {
                                    String lowercaseLine;
                                    block200: {
                                        boolean bl;
                                        String protocolVersion;
                                        URI requestURI;
                                        block198: {
                                            String request;
                                            block206: {
                                                ClientApp op;
                                                ClientAppManager clientAppManager;
                                                String hostLowerCase;
                                                int port;
                                                block202: {
                                                    String addressHelper;
                                                    String query;
                                                    String newURI;
                                                    block203: {
                                                        String header2;
                                                        boolean ahelperConflict;
                                                        block204: {
                                                            String destB64;
                                                            block205: {
                                                                block201: {
                                                                    String[] params;
                                                                    line = line.trim();
                                                                    if (this._log.shouldLog(10)) {
                                                                        this._log.debug(this.getPrefix(requestId) + "Line=[" + line + "]");
                                                                    }
                                                                    if ((lowercaseLine = line.toLowerCase(Locale.US)).startsWith("connection: ") || lowercaseLine.startsWith("keep-alive: ") || lowercaseLine.startsWith("proxy-connection: ")) continue;
                                                                    if (method != null) break block200;
                                                                    if (this._log.shouldLog(10)) {
                                                                        this._log.debug(this.getPrefix(requestId) + "First line [" + line + "]");
                                                                    }
                                                                    if ((params = line.split(" ", 3)).length != 3) break;
                                                                    request = params[1];
                                                                    if (request.startsWith("/") && this.getTunnel().getClientOptions().getProperty("i2ptunnel.noproxy") != null) {
                                                                        request = "http://i2p" + request;
                                                                    } else if (request.startsWith("/eepproxy/")) {
                                                                        String subRequest = request.substring("/eepproxy/".length());
                                                                        if (subRequest.indexOf("/") == -1) {
                                                                            subRequest = subRequest + "/";
                                                                        }
                                                                        request = "http://" + subRequest;
                                                                    }
                                                                    method = params[0];
                                                                    if (method.toUpperCase(Locale.US).equals("CONNECT")) {
                                                                        request = "https://" + request + '/';
                                                                    }
                                                                    try {
                                                                        requestURI = new URI(request);
                                                                        if (requestURI.getRawUserInfo() != null || requestURI.getRawFragment() != null) {
                                                                            if (this._log.shouldLog(30)) {
                                                                                this._log.warn(this.getPrefix(requestId) + "Removing userinfo or fragment [" + request + "]");
                                                                            }
                                                                            requestURI = I2PTunnelHTTPClient.changeURI(requestURI, null, 0, null);
                                                                        }
                                                                        if (requestURI.getPath() == null || requestURI.getPath().length() <= 0) {
                                                                            if (this._log.shouldLog(30)) {
                                                                                this._log.warn(this.getPrefix(requestId) + "Adding / path to [" + request + "]");
                                                                            }
                                                                            requestURI = I2PTunnelHTTPClient.changeURI(requestURI, null, 0, "/");
                                                                        }
                                                                    }
                                                                    catch (URISyntaxException use) {
                                                                        if (this._log.shouldLog(30)) {
                                                                            this._log.warn(this.getPrefix(requestId) + "Bad request [" + request + "]", use);
                                                                        }
                                                                        try {
                                                                            out.write(this.getErrorPage("baduri", ERR_BAD_URI).getBytes("UTF-8"));
                                                                            I2PTunnelHTTPClient.writeFooter(out);
                                                                            reader.drain();
                                                                            return;
                                                                        }
                                                                        catch (IOException ioe) {
                                                                            return;
                                                                        }
                                                                        finally {
                                                                            I2PTunnelHTTPClient.closeSocket(s);
                                                                        }
                                                                    }
                                                                    protocolVersion = params[2];
                                                                    protocol = requestURI.getScheme();
                                                                    host = requestURI.getHost();
                                                                    if (protocol == null || host == null) {
                                                                        this._log.warn("Null protocol or host: " + request + ' ' + protocol + ' ' + host);
                                                                        method = null;
                                                                        break;
                                                                    }
                                                                    port = requestURI.getPort();
                                                                    hostLowerCase = host.toLowerCase(Locale.US);
                                                                    if (!hostLowerCase.equals(LOCAL_SERVER)) break block201;
                                                                    destination = host;
                                                                    usingInternalServer = true;
                                                                    internalPath = requestURI.getPath();
                                                                    internalRawQuery = requestURI.getRawQuery();
                                                                    break block198;
                                                                }
                                                                if (hostLowerCase.equals("i2p")) {
                                                                    void var35_61;
                                                                    String string = requestURI.getPath().substring(1);
                                                                    int slash = string.indexOf("/");
                                                                    if (slash < 0) {
                                                                        slash = string.length();
                                                                        String string2 = string + "/";
                                                                    }
                                                                    String _dest = var35_61.substring(0, slash);
                                                                    if (slash >= 516 && !_dest.contains(".")) {
                                                                        destination = _dest;
                                                                        host = this.getHostName(destination);
                                                                        targetRequest = requestURI.toASCIIString();
                                                                        newURI = var35_61.substring(slash);
                                                                        String query2 = requestURI.getRawQuery();
                                                                        if (query2 != null) {
                                                                            newURI = newURI + '?' + query2;
                                                                        }
                                                                        try {
                                                                            requestURI = new URI(newURI);
                                                                            break block198;
                                                                        }
                                                                        catch (URISyntaxException use) {
                                                                            this._log.warn(request, use);
                                                                            method = null;
                                                                            break;
                                                                        }
                                                                    }
                                                                    this._log.warn("Bad http://i2p/b64dest " + request);
                                                                    host = null;
                                                                    break;
                                                                }
                                                                if (!hostLowerCase.endsWith(".i2p")) break block202;
                                                                destination = host;
                                                                host = this.getHostName(destination);
                                                                int n = requestURI.getPort();
                                                                remotePort = n > 0 ? n : ("https".equals(protocol) || method.toUpperCase(Locale.US).equals("CONNECT") ? 443 : 80);
                                                                query = requestURI.getRawQuery();
                                                                if (query == null) break block203;
                                                                ahelperConflict = false;
                                                                String[] helperStrings = I2PTunnelHTTPClient.removeHelper(query);
                                                                if (helperStrings == null || Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_DISABLE_HELPER))) break block204;
                                                                query = helperStrings[0];
                                                                if (query.equals("")) {
                                                                    query = null;
                                                                }
                                                                try {
                                                                    requestURI = I2PTunnelHTTPClient.replaceQuery(requestURI, query);
                                                                }
                                                                catch (URISyntaxException use) {
                                                                    this._log.warn(request, use);
                                                                    method = null;
                                                                    break;
                                                                }
                                                                ahelperKey = helperStrings[1];
                                                                if (ahelperKey.length() <= 0) break block204;
                                                                if (ahelperKey.endsWith(".i2p")) {
                                                                    Destination _dest = this._context.namingService().lookup(ahelperKey);
                                                                    if (_dest == null) {
                                                                        if (this._log.shouldLog(30)) {
                                                                            this._log.warn(this.getPrefix(requestId) + "Could not find destination for " + ahelperKey);
                                                                        }
                                                                        header2 = this.getErrorPage("ahelper-notfound", ERR_AHELPER_NOTFOUND);
                                                                        try {
                                                                            out.write(header2.getBytes("UTF-8"));
                                                                            out.write(("<p>" + this._("This seems to be a bad destination:") + " " + ahelperKey + " " + this._("i2paddresshelper cannot help you with a destination like that!") + "</p>").getBytes("UTF-8"));
                                                                            I2PTunnelHTTPClient.writeFooter(out);
                                                                            reader.drain();
                                                                            return;
                                                                        }
                                                                        catch (IOException ioe) {
                                                                            return;
                                                                        }
                                                                        finally {
                                                                            I2PTunnelHTTPClient.closeSocket(s);
                                                                        }
                                                                    }
                                                                    ahelperKey = _dest.toBase64();
                                                                }
                                                                ahelperPresent = true;
                                                                if (host != null && !"i2p".equals(host)) break block205;
                                                                String old = this.addressHelpers.putIfAbsent(destination.toLowerCase(Locale.US), ahelperKey);
                                                                boolean bl2 = ahelperNew = old == null;
                                                                if (!ahelperNew && !old.replace("=", "").equals(ahelperKey.replace("=", ""))) {
                                                                    ahelperConflict = true;
                                                                    if (this._log.shouldLog(30)) {
                                                                        this._log.warn(this.getPrefix(requestId) + "Addresshelper key conflict for site [" + destination + "], trusted key [" + old + "], specified key [" + ahelperKey + "].");
                                                                    }
                                                                }
                                                                break block204;
                                                            }
                                                            Destination hostDest = this._context.namingService().lookup(destination);
                                                            if (hostDest != null && (destB64 = hostDest.toBase64()) != null && !destB64.equals(ahelperKey)) {
                                                                ahelperConflict = true;
                                                                if (this._log.shouldLog(30)) {
                                                                    this._log.warn(this.getPrefix(requestId) + "Addresshelper key conflict for site [" + destination + "], trusted key [" + destB64 + "], specified key [" + ahelperKey + "].");
                                                                }
                                                            }
                                                        }
                                                        if (ahelperConflict) {
                                                            try {
                                                                String alias = this.getHostName(ahelperKey);
                                                                if (alias.equals("i2p")) {
                                                                    header2 = this.getErrorPage("dnfb", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                                                                    this.writeErrorMessage(header2, out, targetRequest, false, destination);
                                                                } else {
                                                                    URI conflictURI;
                                                                    String trustedURL = requestURI.toASCIIString();
                                                                    try {
                                                                        conflictURI = I2PTunnelHTTPClient.changeURI(requestURI, alias, 0, null);
                                                                    }
                                                                    catch (URISyntaxException use) {
                                                                        this._log.warn(request, use);
                                                                        method = null;
                                                                        I2PTunnelHTTPClient.closeSocket(s);
                                                                        break;
                                                                    }
                                                                    String conflictURL = conflictURI.toASCIIString();
                                                                    String header3 = this.getErrorPage("ahelper-conflict", ERR_AHELPER_CONFLICT);
                                                                    out.write(header3.getBytes("UTF-8"));
                                                                    out.write(this._("To visit the destination in your host database, click <a href=\"{0}\">here</a>. To visit the conflicting addresshelper destination, click <a href=\"{1}\">here</a>.", trustedURL, conflictURL).getBytes("UTF-8"));
                                                                    out.write("</p></div>".getBytes("UTF-8"));
                                                                    I2PTunnelHTTPClient.writeFooter(out);
                                                                }
                                                                reader.drain();
                                                                return;
                                                            }
                                                            catch (IOException ioe) {
                                                                return;
                                                                catch (Throwable throwable) {
                                                                    throw throwable;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    if ((addressHelper = this.addressHelpers.get(destination)) != null) {
                                                        host = this.getHostName(addressHelper);
                                                    }
                                                    targetRequest = requestURI.toASCIIString();
                                                    newURI = requestURI.getRawPath();
                                                    if (query != null) {
                                                        newURI = newURI + '?' + query;
                                                    }
                                                    try {
                                                        requestURI = new URI(newURI);
                                                        break block198;
                                                    }
                                                    catch (URISyntaxException use) {
                                                        this._log.warn(request, use);
                                                        method = null;
                                                        break;
                                                    }
                                                }
                                                if (hostLowerCase.equals("localhost") || host.equals("127.0.0.1") || host.startsWith("192.168.") || host.equals("[::1]")) {
                                                    try {
                                                        out.write(this.getErrorPage("localhost", ERR_LOCALHOST).getBytes("UTF-8"));
                                                        I2PTunnelHTTPClient.writeFooter(out);
                                                        reader.drain();
                                                        return;
                                                    }
                                                    catch (IOException iOException) {
                                                        return;
                                                    }
                                                    finally {
                                                        I2PTunnelHTTPClient.closeSocket(s);
                                                    }
                                                }
                                                if (!host.contains(".") && !host.startsWith("[")) break block206;
                                                if (Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_USE_OUTPROXY_PLUGIN, "true")) && (clientAppManager = this._context.clientAppManager()) != null && (op = clientAppManager.getRegisteredApp("outproxy")) != null) {
                                                    outproxy = (Outproxy)((Object)op);
                                                    int rPort = requestURI.getPort();
                                                    remotePort = rPort > 0 ? rPort : ("https".equals(protocol) || method.toUpperCase(Locale.US).equals("CONNECT") ? 443 : 80);
                                                    usingInternalOutproxy = true;
                                                    targetRequest = requestURI.toASCIIString();
                                                    if (this._log.shouldLog(10)) {
                                                        this._log.debug(this.getPrefix(requestId) + " [" + host + "]: outproxy!");
                                                    }
                                                }
                                                if (!usingInternalOutproxy) {
                                                    if (port >= 0) {
                                                        host = host + ':' + port;
                                                    }
                                                    if (this._log.shouldLog(10)) {
                                                        this._log.debug("Before selecting outproxy for " + host);
                                                    }
                                                    currentProxy = "https".equals(protocol) || method.toUpperCase(Locale.US).equals("CONNECT") ? this.selectSSLProxy() : this.selectProxy();
                                                    if (this._log.shouldLog(10)) {
                                                        this._log.debug("After selecting outproxy for " + host + ": " + currentProxy);
                                                    }
                                                    if (currentProxy == null) {
                                                        if (this._log.shouldLog(30)) {
                                                            this._log.warn(this.getPrefix(requestId) + "Host wants to be outproxied, but we dont have any!");
                                                        }
                                                        this.l.log("No outproxy found for the request.");
                                                        try {
                                                            out.write(this.getErrorPage("noproxy", ERR_NO_OUTPROXY).getBytes("UTF-8"));
                                                            I2PTunnelHTTPClient.writeFooter(out);
                                                            reader.drain();
                                                            return;
                                                        }
                                                        catch (IOException iOException) {
                                                            return;
                                                        }
                                                        finally {
                                                            I2PTunnelHTTPClient.closeSocket(s);
                                                        }
                                                    }
                                                    destination = currentProxy;
                                                    usingWWWProxy = true;
                                                    targetRequest = requestURI.toASCIIString();
                                                    if (this._log.shouldLog(10)) {
                                                        this._log.debug(this.getPrefix(requestId) + " [" + host + "]: wwwProxy!");
                                                    }
                                                }
                                                break block198;
                                            }
                                            if (this._log.shouldLog(30)) {
                                                this._log.warn("NODOTS, NOI2P: " + request);
                                            }
                                            try {
                                                out.write(this.getErrorPage("denied", ERR_REQUEST_DENIED).getBytes("UTF-8"));
                                                I2PTunnelHTTPClient.writeFooter(out);
                                                reader.drain();
                                                return;
                                            }
                                            catch (IOException iOException) {
                                                return;
                                            }
                                            finally {
                                                I2PTunnelHTTPClient.closeSocket(s);
                                            }
                                        }
                                        boolean bl3 = bl = usingInternalOutproxy || usingWWWProxy || usingInternalServer || I2PTunnelHTTPClient.isSupportedAddress(host, protocol);
                                        if (!bl) {
                                            if (this._log.shouldLog(20)) {
                                                this._log.info(this.getPrefix(requestId) + "notValid(" + host + ")");
                                            }
                                            method = null;
                                            destination = null;
                                            break;
                                        }
                                        line = method.toUpperCase(Locale.US).equals("CONNECT") ? method + ' ' + requestURI.getHost() + ':' + requestURI.getPort() + ' ' + protocolVersion : method + ' ' + requestURI.toASCIIString() + ' ' + protocolVersion;
                                        if (this._log.shouldLog(10)) {
                                            this._log.debug(this.getPrefix(requestId) + "NEWREQ: \"" + line + "\"");
                                            this._log.debug(this.getPrefix(requestId) + "HOST  : \"" + host + "\"");
                                            this._log.debug(this.getPrefix(requestId) + "DEST  : \"" + destination + "\"");
                                        }
                                        break block207;
                                    }
                                    if (lowercaseLine.startsWith("host: ") && !usingWWWProxy && !usingInternalOutproxy) {
                                        line = "Host: " + host;
                                        if (this._log.shouldLog(20)) {
                                            this._log.info(this.getPrefix(requestId) + "Setting host = " + host);
                                        }
                                    } else if (lowercaseLine.startsWith("user-agent: ")) {
                                        userAgent = lowercaseLine.substring(12);
                                        if (!Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_USER_AGENT))) {
                                            line = null;
                                            continue;
                                        }
                                    } else if (lowercaseLine.startsWith("accept")) {
                                        if (!Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_ACCEPT))) {
                                            line = null;
                                            continue;
                                        }
                                    } else if (lowercaseLine.startsWith("referer: ")) {
                                        referer = line.substring(9);
                                        if (!Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_REFERER))) {
                                            line = null;
                                            continue;
                                        }
                                    } else {
                                        if (lowercaseLine.startsWith("via: ") && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_VIA))) {
                                            line = null;
                                            continue;
                                        }
                                        if (lowercaseLine.startsWith("from: ")) {
                                            line = null;
                                            continue;
                                        }
                                        if (lowercaseLine.startsWith("authorization: ntlm ")) {
                                            line = null;
                                            continue;
                                        }
                                        if (lowercaseLine.startsWith("proxy-authorization: ")) {
                                            authorization = line.substring(21);
                                            line = null;
                                            continue;
                                        }
                                        if (lowercaseLine.startsWith("icy")) {
                                            shout = true;
                                        }
                                    }
                                }
                                if (line.length() == 0) {
                                    String ok = this.getTunnel().getClientOptions().getProperty("i2ptunnel.gzip");
                                    boolean gzip = true;
                                    if (ok != null) {
                                        gzip = Boolean.parseBoolean(ok);
                                    }
                                    if (gzip && !usingInternalServer && !method.toUpperCase(Locale.US).equals("CONNECT")) {
                                        if (!Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_ACCEPT))) {
                                            newRequest.append("Accept-Encoding: \r\n");
                                        }
                                        if (!usingInternalOutproxy) {
                                            newRequest.append("X-Accept-Encoding: x-i2p-gzip;q=1.0, identity;q=0.5, deflate;q=0, gzip;q=0, *;q=0\r\n");
                                        }
                                    }
                                    if (!(shout || method.toUpperCase(Locale.US).equals("CONNECT") || Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_USER_AGENT)))) {
                                        if (usingWWWProxy || usingInternalOutproxy) {
                                            newRequest.append("User-Agent: Mozilla/5.0 (Windows NT 6.1; rv:24.0) Gecko/20100101 Firefox/24.0\r\n");
                                        } else {
                                            newRequest.append("User-Agent: MYOB/6.66 (AN/ON)\r\n");
                                        }
                                    }
                                    if (usingWWWProxy && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("outproxyAuth"))) {
                                        String user = this.getTunnel().getClientOptions().getProperty("outproxyUsername." + currentProxy);
                                        String pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword." + currentProxy);
                                        if (user == null || pw == null) {
                                            user = this.getTunnel().getClientOptions().getProperty("outproxyUsername");
                                            pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword");
                                        }
                                        if (user != null && pw != null) {
                                            newRequest.append("Proxy-Authorization: Basic ").append(Base64.encode((user + ':' + pw).getBytes("UTF-8"), true)).append("\r\n");
                                        }
                                    }
                                    newRequest.append("Connection: close\r\n\r\n");
                                    break;
                                }
                                newRequest.append(line).append("\r\n");
                            }
                            if (this._log.shouldLog(10)) {
                                this._log.debug(this.getPrefix(requestId) + "NewRequest header: [" + newRequest.toString() + "]");
                            }
                            if (method == null || destination == null && !usingInternalOutproxy) {
                                try {
                                    if (protocol != null && "http".equals(protocol.toLowerCase(Locale.US))) {
                                        out.write(this.getErrorPage("denied", ERR_REQUEST_DENIED).getBytes("UTF-8"));
                                    } else {
                                        out.write(this.getErrorPage("protocol", ERR_BAD_PROTOCOL).getBytes("UTF-8"));
                                    }
                                    I2PTunnelHTTPClient.writeFooter(out);
                                    return;
                                }
                                catch (IOException ioe) {
                                    return;
                                }
                                finally {
                                    I2PTunnelHTTPClient.closeSocket(s);
                                }
                            }
                            if (this._log.shouldLog(10)) {
                                this._log.debug(this.getPrefix(requestId) + "Destination: " + destination);
                            }
                            if ((result = this.authorize(s, requestId, method, authorization)) != I2PTunnelHTTPClientBase.AuthResult.AUTH_GOOD) {
                                if (this._log.shouldLog(30)) {
                                    if (authorization != null) {
                                        this._log.warn(this.getPrefix(requestId) + "Auth failed, sending 407 again");
                                    } else {
                                        this._log.warn(this.getPrefix(requestId) + "Auth required, sending 407");
                                    }
                                }
                                try {
                                    out.write(this.getAuthError(result == I2PTunnelHTTPClientBase.AuthResult.AUTH_STALE).getBytes("UTF-8"));
                                    I2PTunnelHTTPClient.writeFooter(out);
                                    return;
                                }
                                catch (IOException ioe) {
                                    return;
                                }
                                finally {
                                    I2PTunnelHTTPClient.closeSocket(s);
                                }
                            }
                            if (usingInternalServer) {
                                try {
                                    if (internalPath.equals("/add") && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_DISABLE_HELPER))) {
                                        out.write(ERR_HELPER_DISABLED.getBytes("UTF-8"));
                                        return;
                                    }
                                    LocalHTTPServer.serveLocalFile(out, method, internalPath, internalRawQuery, this._proxyNonce);
                                    return;
                                }
                                catch (IOException ioe) {
                                    return;
                                }
                                finally {
                                    I2PTunnelHTTPClient.closeSocket(s);
                                }
                            }
                            if (usingInternalOutproxy) {
                                byte[] response;
                                byte[] data;
                                Socket outSocket = outproxy.connect(host, remotePort);
                                I2PTunnelHTTPClientBase.OnTimeout onTimeout = new I2PTunnelHTTPClientBase.OnTimeout(this, s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId);
                                if (method.toUpperCase(Locale.US).equals("CONNECT")) {
                                    data = null;
                                    response = "HTTP/1.1 200 Connection Established\r\nProxy-agent: I2P\r\n\r\n".getBytes("UTF-8");
                                } else {
                                    data = newRequest.toString().getBytes("ISO-8859-1");
                                    response = null;
                                }
                                I2PTunnelOutproxyRunner t = new I2PTunnelOutproxyRunner(s, outSocket, this.sockLock, data, response, onTimeout);
                                ((Thread)t).run();
                                return;
                            }
                            clientDest = null;
                            String addressHelper = this.addressHelpers.get(destination.toLowerCase(Locale.US));
                            if (addressHelper == null) break block208;
                            clientDest = this._context.namingService().lookup(addressHelper);
                            if (clientDest == null) {
                                this.addressHelpers.remove(destination.toLowerCase(Locale.US));
                                if (this._log.shouldLog(30)) {
                                    this._log.warn(this.getPrefix(requestId) + "Could not find destination for " + addressHelper);
                                }
                                header = this.getErrorPage("ahelper-notfound", ERR_AHELPER_NOTFOUND);
                                try {
                                    this.writeErrorMessage(header, out, targetRequest, false, destination);
                                    return;
                                }
                                catch (IOException ioe) {
                                    return;
                                }
                                finally {
                                    I2PTunnelHTTPClient.closeSocket(s);
                                }
                            }
                            break block209;
                        }
                        if (!"i2p".equals(host)) break block210;
                        clientDest = null;
                        break block209;
                    }
                    if (destination.length() != 60 || !destination.toLowerCase(Locale.US).endsWith(".b32.i2p")) break block211;
                    this.verifySocketManager();
                    I2PSession sess = this.sockMgr.getSession();
                    if (!sess.isClosed()) {
                        byte[] hData = Base32.decode(destination.substring(0, 52));
                        if (hData != null) {
                            if (this._log.shouldLog(20)) {
                                this._log.info("lookup in-session " + destination);
                            }
                            Hash hash = Hash.create(hData);
                            clientDest = sess.lookupDest(hash, 20000L);
                        }
                        break block209;
                    } else {
                        clientDest = this._context.namingService().lookup(destination);
                    }
                    break block209;
                }
                clientDest = this._context.namingService().lookup(destination);
            }
            if (clientDest == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to resolve " + destination + " (proxy? " + usingWWWProxy + ", request: " + targetRequest);
                }
                String jumpServers = null;
                String extraMessage = null;
                if (usingWWWProxy) {
                    header = this.getErrorPage("dnfp", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                } else if (ahelperPresent) {
                    header = this.getErrorPage("dnfb", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                } else if (destination.length() == 60 && destination.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
                    header = this.getErrorPage("nols", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                    extraMessage = this._("Destination lease set not found");
                } else {
                    header = this.getErrorPage("dnfh", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                    jumpServers = this.getTunnel().getClientOptions().getProperty(PROP_JUMP_SERVERS);
                    if (jumpServers == null) {
                        jumpServers = DEFAULT_JUMP_SERVERS;
                    }
                }
                try {
                    this.writeErrorMessage(header, extraMessage, out, targetRequest, usingWWWProxy, destination, jumpServers);
                    return;
                }
                catch (IOException ioe) {
                    return;
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
            }
            if (method.toUpperCase(Locale.US).equals("CONNECT") && !usingWWWProxy && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_INTERNAL_SSL))) {
                try {
                    this.writeErrorMessage(ERR_INTERNAL_SSL, out, targetRequest, false, destination);
                }
                catch (IOException ioe) {
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
                if (!this._log.shouldLog(30)) return;
                this._log.warn("SSL to i2p destinations denied by configuration: " + targetRequest);
                return;
            }
            if (ahelperNew && "GET".equals(method) && (userAgent == null || !userAgent.startsWith("Wget")) && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty(PROP_DISABLE_HELPER))) {
                try {
                    this.writeHelperSaveForm(out, destination, ahelperKey, targetRequest, referer);
                    return;
                }
                catch (IOException ioe) {
                    return;
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
            }
            if (ahelperPresent && !"POST".equals(method)) {
                String uri = targetRequest;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Auto redirecting to " + uri);
                }
                try {
                    out.write(("HTTP/1.1 301 Address Helper Accepted\r\nLocation: " + uri + "\r\n" + "Connection: close\r\n" + "Proxy-Connection: close\r\n" + "\r\n").getBytes("UTF-8"));
                    return;
                }
                catch (IOException ioe) {
                    return;
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
            }
            Properties opts = new Properties();
            I2PSocketOptions sktOpts = this.getDefaultOptions(opts);
            if (remotePort > 0) {
                sktOpts.setPort(remotePort);
            }
            I2PSocket i2ps = this.createI2PSocket(clientDest, sktOpts);
            I2PTunnelHTTPClientBase.OnTimeout onTimeout = new I2PTunnelHTTPClientBase.OnTimeout(this, s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId);
            if (method.toUpperCase(Locale.US).equals("CONNECT")) {
                byte[] response;
                byte[] data;
                if (usingWWWProxy) {
                    data = newRequest.toString().getBytes("ISO-8859-1");
                    response = null;
                } else {
                    data = null;
                    response = "HTTP/1.1 200 Connection Established\r\nProxy-agent: I2P\r\n\r\n".getBytes("UTF-8");
                }
                I2PTunnelRunner i2PTunnelRunner = new I2PTunnelRunner(s, i2ps, this.sockLock, data, response, (List<I2PSocket>)this.mySockets, onTimeout);
            } else {
                byte[] data = newRequest.toString().getBytes("ISO-8859-1");
                I2PTunnelHTTPClientRunner i2PTunnelHTTPClientRunner = new I2PTunnelHTTPClientRunner(s, i2ps, this.sockLock, data, (List<I2PSocket>)this.mySockets, onTimeout);
            }
            var35_69.run();
            return;
        }
        catch (IOException ex) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            }
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
            return;
        }
        catch (I2PException ex) {
            if (this._log.shouldLog(20)) {
                this._log.info("getPrefix(requestId) + Error trying to connect", ex);
            }
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
            return;
        }
        catch (OutOfMemoryError oom) {
            IOException ex = new IOException("OOM");
            this._log.error("getPrefix(requestId) + Error trying to connect", oom);
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
    }

    private String selectSSLProxy() {
        String s = this.getTunnel().getClientOptions().getProperty(PROP_SSL_OUTPROXIES);
        if (s == null) {
            return null;
        }
        String[] p = s.split("[,; \r\n\t]");
        if (p.length == 0) {
            return null;
        }
        if (p.length == 1) {
            return p[0];
        }
        int i = this._context.random().nextInt(p.length);
        return p[i];
    }

    private void writeHelperSaveForm(OutputStream outs, String destination, String ahelperKey, String targetRequest, String referer) throws IOException {
        if (outs == null) {
            return;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outs, "UTF-8"));
        String header = this.getErrorPage("ahelper-new", ERR_AHELPER_NEW);
        out.write(header);
        out.write("<table><tr><td class=\"mediumtags\" align=\"right\">" + this._("Host") + "</td><td class=\"mediumtags\">" + destination + "</td></tr>\n");
        try {
            String b32 = Base32.encode(SHA256Generator.getInstance().calculateHash(Base64.decode(ahelperKey)).getData());
            out.write("<tr><td class=\"mediumtags\" align=\"right\">" + this._("Base 32") + "</td>" + "<td><a href=\"http://" + b32 + ".b32.i2p/\">" + b32 + ".b32.i2p</a></td></tr>");
        }
        catch (Exception e) {
            // empty catch block
        }
        out.write("<tr><td class=\"mediumtags\" align=\"right\">" + this._("Destination") + "</td><td>" + "<textarea rows=\"1\" style=\"height: 4em; min-width: 0; min-height: 0;\" cols=\"70\" wrap=\"off\" readonly=\"readonly\" >" + ahelperKey + "</textarea></td></tr></table>\n" + "<hr><div class=\"formaction\">" + "<form method=\"GET\" action=\"" + targetRequest + "\">" + "<button type=\"submit\" class=\"go\">" + this._("Continue to {0} without saving", destination) + "</button>" + "</form>\n<form method=\"GET\" action=\"http://" + LOCAL_SERVER + "/add\">" + "<input type=\"hidden\" name=\"host\" value=\"" + destination + "\">\n" + "<input type=\"hidden\" name=\"dest\" value=\"" + ahelperKey + "\">\n" + "<input type=\"hidden\" name=\"nonce\" value=\"" + this._proxyNonce + "\">\n" + "<button type=\"submit\" class=\"accept\" name=\"router\" value=\"router\">" + this._("Save {0} to router address book and continue to website", destination) + "</button><br>\n");
        if (this._context.namingService().getName().equals("BlockfileNamingService")) {
            out.write("<br><button type=\"submit\" name=\"master\" value=\"master\">" + this._("Save {0} to master address book and continue to website", destination) + "</button><br>\n");
            out.write("<button type=\"submit\" name=\"private\" value=\"private\">" + this._("Save {0} to private address book and continue to website", destination) + "</button>\n");
        }
        if (referer != null) {
            out.write("<input type=\"hidden\" name=\"referer\" value=\"" + referer + "\">\n");
        }
        out.write("<input type=\"hidden\" name=\"url\" value=\"" + targetRequest + "\">\n" + "</form></div></div>");
        I2PTunnelHTTPClient.writeFooter(out);
    }

    private final String getHostName(String host) {
        if (host == null) {
            return null;
        }
        if (host.length() == 60 && host.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
            return host;
        }
        Destination dest = this._context.namingService().lookup(host);
        if (dest == null) {
            return "i2p";
        }
        return dest.toBase32();
    }

    private static boolean isSupportedAddress(String host, String protocol) {
        if (host == null || protocol == null) {
            return false;
        }
        String lc = protocol.toLowerCase(Locale.US);
        return lc.equals("http") || lc.equals("https");
    }

    private static URI changeURI(URI uri, String host, int port, String path) throws URISyntaxException {
        return new URI(uri.getScheme(), null, host != null ? host : uri.getHost(), port != 0 ? port : uri.getPort(), path != null ? path : uri.getPath(), uri.getQuery(), null);
    }

    private static URI replaceQuery(URI uri, String query) throws URISyntaxException {
        URI rv = uri;
        if (rv.getRawQuery() != null) {
            rv = new URI(rv.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
        }
        if (query != null) {
            String newURI = rv.toASCIIString() + '?' + query;
            rv = new URI(newURI);
        }
        return rv;
    }

    private static String[] removeHelper(String query) {
        int keystart = 0;
        int valstart = -1;
        String key = null;
        for (int i = 0; i <= query.length(); ++i) {
            int c;
            int n = c = i < query.length() ? (int)query.charAt(i) : 38;
            if (c == 59 || c == 38) {
                String decodedKey;
                if (valstart < 0) {
                    key = query.substring(keystart, i);
                }
                if ((decodedKey = LocalHTTPServer.decode(key)).equals(HELPER_PARAM)) {
                    String newQuery;
                    String string = newQuery = keystart > 0 ? query.substring(0, keystart - 1) : "";
                    if (i < query.length() - 1) {
                        newQuery = keystart > 0 ? newQuery + query.substring(i) : newQuery + query.substring(i + 1);
                    }
                    String value = valstart >= 0 ? query.substring(valstart, i) : "";
                    String helperValue = LocalHTTPServer.decode(value);
                    return new String[]{newQuery, helperValue};
                }
                keystart = i + 1;
                valstart = -1;
                continue;
            }
            if (c != 61 || valstart >= 0) continue;
            key = query.substring(keystart, i);
            valstart = i + 1;
        }
        return null;
    }

    private static class InputReader {
        InputStream _s;

        public InputReader(InputStream s) {
            this._s = s;
        }

        String readLine(String method) throws IOException {
            return DataHelper.readLine(this._s);
        }

        public void drain() {
            try {
                String line;
                while ((line = DataHelper.readLine(this._s)) != null && line.length() > 1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

