/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.sam.SAMBridge;
import net.i2p.sam.SAMException;
import net.i2p.sam.SAMUtils;
import net.i2p.sam.SAMv1Handler;
import net.i2p.sam.SAMv3DatagramSession;
import net.i2p.sam.SAMv3RawSession;
import net.i2p.sam.SAMv3StreamSession;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

class SAMv3Handler
extends SAMv1Handler {
    private Session session;
    public static final SessionsDB sSessionsHash = new SessionsDB();
    private volatile boolean stolenSocket;
    private volatile boolean streamForwardingSocket;

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor, SAMBridge parent) throws SAMException, IOException {
        this(s, verMajor, verMinor, new Properties(), parent);
    }

    public SAMv3Handler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps, SAMBridge parent) throws SAMException, IOException {
        super(s, verMajor, verMinor, i2cpProps, parent);
        if (this._log.shouldLog(10)) {
            this._log.debug("SAM version 3 handler instantiated");
        }
    }

    @Override
    public boolean verifVersion() {
        return this.verMajor == 3;
    }

    public String getClientIP() {
        return this.socket.socket().getInetAddress().getHostAddress();
    }

    public void stealSocket() {
        this.stolenSocket = true;
        this.stopHandling();
    }

    SAMBridge getBridge() {
        return this.bridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() {
        String msg = null;
        String domain = null;
        String opcode = null;
        boolean canContinue = false;
        this.thread.setName("SAMv3Handler " + this._id);
        if (this._log.shouldLog(10)) {
            this._log.debug("SAMv3 handling started");
        }
        try {
            InputStream in = this.getClientSocket().socket().getInputStream();
            while (true) {
                if (this.shouldStop()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Stop request found");
                    }
                    break;
                }
                String line = DataHelper.readLine(in);
                if (line == null) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Connection closed by client (line read : null)");
                    }
                    break;
                }
                msg = line.trim();
                if (this._log.shouldLog(10) && this._log.shouldLog(10)) {
                    this._log.debug("New message received: [" + msg + "]");
                }
                if (msg.equals("")) {
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Ignoring newline");
                    continue;
                }
                StringTokenizer tok = new StringTokenizer(msg, " ");
                if (tok.countTokens() < 2) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Error in message format");
                    }
                    break;
                }
                domain = tok.nextToken();
                opcode = tok.nextToken();
                if (this._log.shouldLog(10)) {
                    this._log.debug("Parsing (domain: \"" + domain + "\"; opcode: \"" + opcode + "\")");
                }
                Properties props = SAMUtils.parseParams(tok);
                if (domain.equals("STREAM")) {
                    canContinue = this.execStreamMessage(opcode, props);
                } else if (domain.equals("SESSION")) {
                    if (this.i2cpProps != null) {
                        props.putAll((Map<?, ?>)this.i2cpProps);
                    }
                    canContinue = this.execSessionMessage(opcode, props);
                } else if (domain.equals("DEST")) {
                    canContinue = this.execDestMessage(opcode, props);
                } else if (domain.equals("NAMING")) {
                    canContinue = this.execNamingMessage(opcode, props);
                } else if (domain.equals("DATAGRAM")) {
                    canContinue = this.execDatagramMessage(opcode, props);
                } else {
                    if (!domain.equals("RAW")) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Unrecognized message domain: \"" + domain + "\"");
                        }
                        break;
                    }
                    canContinue = this.execRawMessage(opcode, props);
                }
                if (!canContinue) break;
            }
        }
        catch (IOException e) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Caught IOException for message [" + msg + "]", e);
            }
        }
        catch (Exception e) {
            this._log.error("Unexpected exception for message [" + msg + "]", e);
        }
        finally {
            block58: {
                block57: {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Stopping handler");
                    }
                    if (!this.stolenSocket) {
                        try {
                            this.closeClientSocket();
                        }
                        catch (IOException e) {
                            if (!this._log.shouldWarn()) break block57;
                            this._log.warn("Error closing socket", e);
                        }
                    }
                }
                if (this.streamForwardingSocket && this.getStreamSession() != null) {
                    try {
                        ((SAMv3StreamSession)this.streamSession).stopForwardingIncoming();
                    }
                    catch (SAMException e) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Error while stopping forwarding connections", e);
                        }
                    }
                    catch (InterruptedIOException e) {
                        if (!this._log.shouldWarn()) break block58;
                        this._log.warn("Interrupted while stopping forwarding connections", e);
                    }
                }
            }
            this.die();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopHandling() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopHandler = true;
        }
        if (!this.stolenSocket) {
            try {
                this.closeClientSocket();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.bridge.unregister(this);
    }

    private void die() {
        SessionRecord rec = null;
        if (this.session != null) {
            this.session.close();
            rec = sSessionsHash.get(this.session.getNick());
        }
        if (rec != null) {
            rec.getThreadGroup().interrupt();
            while (rec.getThreadGroup().activeCount() > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            rec.getThreadGroup().destroy();
            sSessionsHash.del(this.session.getNick());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean execSessionMessage(String opcode, Properties props) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 57[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SAMv3StreamSession newSAMStreamSession(String login) throws IOException, DataFormatException, SAMException {
        return new SAMv3StreamSession(login);
    }

    private static SAMv3RawSession newSAMRawSession(String login) throws IOException, DataFormatException, SAMException, I2PSessionException {
        return new SAMv3RawSession(login);
    }

    private static SAMv3DatagramSession newSAMDatagramSession(String login) throws IOException, DataFormatException, SAMException, I2PSessionException {
        return new SAMv3DatagramSession(login);
    }

    @Override
    protected boolean execStreamMessage(String opcode, Properties props) {
        String nick = null;
        SessionRecord rec = null;
        if (this.session != null) {
            this._log.error("STREAM message received, but this session is a master session");
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "master session cannot be used for streams");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        nick = props.getProperty("ID");
        if (nick == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("SESSION ID parameter not specified");
            }
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "ID not specified");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        props.remove("ID");
        rec = sSessionsHash.get(nick);
        if (rec == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("STREAM SESSION ID does not exist");
            }
            try {
                this.notifyStreamResult(true, "INVALID_ID", "STREAM SESSION ID does not exist");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        this.streamSession = rec.getHandler().streamSession;
        if (this.streamSession == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("specified ID is not a stream session");
            }
            try {
                this.notifyStreamResult(true, "I2P_ERROR", "specified ID is not a STREAM session");
            }
            catch (IOException e) {
                // empty catch block
            }
            return false;
        }
        if (opcode.equals("CONNECT")) {
            return this.execStreamConnect(props);
        }
        if (opcode.equals("ACCEPT")) {
            return this.execStreamAccept(props);
        }
        if (opcode.equals("FORWARD")) {
            return this.execStreamForwardIncoming(props);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Unrecognized STREAM message opcode: \"" + opcode + "\"");
        }
        try {
            this.notifyStreamResult(true, "I2P_ERROR", "Unrecognized STREAM message opcode: " + opcode);
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected boolean execStreamConnect(Properties props) {
        try {
            if (props.isEmpty()) {
                this.notifyStreamResult(true, "I2P_ERROR", "No parameters specified in STREAM CONNECT message");
                if (this._log.shouldLog(10)) {
                    this._log.debug("No parameters specified in STREAM CONNECT message");
                }
                return false;
            }
            boolean verbose = props.getProperty("SILENT", "false").equals("false");
            String dest = props.getProperty("DESTINATION");
            if (dest == null) {
                this.notifyStreamResult(verbose, "I2P_ERROR", "Destination not specified in STREAM CONNECT message");
                if (this._log.shouldLog(10)) {
                    this._log.debug("Destination not specified in STREAM CONNECT message");
                }
                return false;
            }
            props.remove("DESTINATION");
            try {
                ((SAMv3StreamSession)this.streamSession).connect(this, dest, props);
                return true;
            }
            catch (DataFormatException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Invalid destination in STREAM CONNECT message");
                }
                this.notifyStreamResult(verbose, "INVALID_KEY", null);
            }
            catch (ConnectException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "CONNECTION_REFUSED", null);
            }
            catch (NoRouteToHostException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "CANT_REACH_PEER", null);
            }
            catch (InterruptedIOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "TIMEOUT", null);
            }
            catch (I2PException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM CONNECT failed", e);
                }
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean execStreamForwardIncoming(Properties props) {
        try {
            try {
                this.streamForwardingSocket = true;
                ((SAMv3StreamSession)this.streamSession).startForwardingIncoming(props);
                this.notifyStreamResult(true, "OK", null);
                return true;
            }
            catch (SAMException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Forwarding STREAM connections failed", e);
                }
                this.notifyStreamResult(true, "I2P_ERROR", "Forwarding failed : " + e.getMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean execStreamAccept(Properties props) {
        boolean verbose = props.getProperty("SILENT", "false").equals("false");
        try {
            try {
                this.notifyStreamResult(verbose, "OK", null);
                ((SAMv3StreamSession)this.streamSession).accept(this, verbose);
                return true;
            }
            catch (InterruptedIOException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM ACCEPT failed", e);
                }
                this.notifyStreamResult(verbose, "TIMEOUT", e.getMessage());
            }
            catch (I2PException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM ACCEPT failed", e);
                }
                this.notifyStreamResult(verbose, "I2P_ERROR", e.getMessage());
            }
            catch (SAMException e) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("STREAM ACCEPT failed", e);
                }
                this.notifyStreamResult(verbose, "ALREADY_ACCEPTING", null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void notifyStreamResult(boolean verbose, String result, String message) throws IOException {
        if (!verbose) {
            return;
        }
        String msgString = SAMv3Handler.createMessageString(message);
        String out = "STREAM STATUS RESULT=" + result + msgString + '\n';
        if (!this.writeString(out)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public void notifyStreamIncomingConnection(Destination d) throws IOException {
        if (this.getStreamSession() == null) {
            this._log.error("BUG! Received stream connection, but session is null!");
            throw new NullPointerException("BUG! STREAM session is null!");
        }
        if (!this.writeString(d.toBase64() + "\n")) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static void notifyStreamIncomingConnection(SocketChannel client, Destination d) throws IOException {
        if (!SAMv3Handler.writeString(d.toBase64() + "\n", client)) {
            throw new IOException("Error notifying connection to SAM client");
        }
    }

    public static class DatagramServer {
        private static DatagramServer _instance;
        private static DatagramChannel server;

        public static DatagramServer getInstance() throws IOException {
            return DatagramServer.getInstance(new Properties());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DatagramServer getInstance(Properties props) throws IOException {
            Class<DatagramServer> clazz = DatagramServer.class;
            synchronized (DatagramServer.class) {
                if (_instance == null) {
                    _instance = new DatagramServer(props);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return _instance;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DatagramServer(Properties props) throws IOException {
            Class<DatagramServer> clazz = DatagramServer.class;
            synchronized (DatagramServer.class) {
                int port;
                if (server == null) {
                    server = DatagramChannel.open();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                String host = props.getProperty("sam.udp.host", "0.0.0.0");
                String portStr = props.getProperty("sam.udp.port", "7655");
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    port = Integer.parseInt("7655");
                }
                server.socket().bind(new InetSocketAddress(host, port));
                new I2PAppThread(new Listener(server), "DatagramListener").start();
                return;
            }
        }

        public void send(SocketAddress addr, ByteBuffer msg) throws IOException {
            server.send(msg, addr);
        }

        static class Listener
        implements Runnable {
            private final DatagramChannel server;

            public Listener(DatagramChannel server) {
                this.server = server;
            }

            @Override
            public void run() {
                ByteBuffer inBuf = ByteBuffer.allocateDirect(33792);
                while (!Thread.interrupted()) {
                    inBuf.clear();
                    try {
                        this.server.receive(inBuf);
                    }
                    catch (IOException e) {
                        break;
                    }
                    inBuf.flip();
                    ByteBuffer outBuf = ByteBuffer.wrap(new byte[inBuf.remaining()]);
                    outBuf.put(inBuf);
                    outBuf.flip();
                    new MessageDispatcher(outBuf.array()).run();
                }
            }
        }
    }

    private static class MessageDispatcher
    implements Runnable {
        private final ByteArrayInputStream is;

        public MessageDispatcher(byte[] buf) {
            this.is = new ByteArrayInputStream(buf);
        }

        @Override
        public void run() {
            block7: {
                try {
                    String header = DataHelper.readLine(this.is).trim();
                    StringTokenizer tok = new StringTokenizer(header, " ");
                    if (tok.countTokens() != 3) {
                        return;
                    }
                    String version = tok.nextToken();
                    if (!"3.0".equals(version)) {
                        return;
                    }
                    String nick = tok.nextToken();
                    String dest = tok.nextToken();
                    byte[] data = new byte[this.is.available()];
                    this.is.read(data);
                    SessionRecord rec = sSessionsHash.get(nick);
                    if (rec != null) {
                        rec.getHandler().session.sendBytes(dest, data);
                    } else {
                        Log log = I2PAppContext.getGlobalContext().logManager().getLog(SAMv3Handler.class);
                        if (log.shouldLog(30)) {
                            log.warn("Dropping datagram, no session for " + nick);
                        }
                    }
                }
                catch (Exception e) {
                    Log log = I2PAppContext.getGlobalContext().logManager().getLog(SAMv3Handler.class);
                    if (!log.shouldLog(30)) break block7;
                    log.warn("Error handling datagram", e);
                }
            }
        }
    }

    static interface Session {
        public String getNick();

        public void close();

        public boolean sendBytes(String var1, byte[] var2) throws DataFormatException, I2PSessionException;
    }

    public static class SessionRecord {
        private final String m_dest;
        private final Properties m_props;
        private ThreadGroup m_threadgroup;
        private final SAMv3Handler m_handler;

        public SessionRecord(String dest, Properties props, SAMv3Handler handler) {
            this.m_dest = dest;
            this.m_props = new Properties();
            this.m_props.putAll((Map<?, ?>)props);
            this.m_handler = handler;
        }

        public SessionRecord(SessionRecord in) {
            this.m_dest = in.getDest();
            this.m_props = in.getProps();
            this.m_threadgroup = in.getThreadGroup();
            this.m_handler = in.getHandler();
        }

        public String getDest() {
            return this.m_dest;
        }

        public synchronized Properties getProps() {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)this.m_props);
            return this.m_props;
        }

        public SAMv3Handler getHandler() {
            return this.m_handler;
        }

        public synchronized ThreadGroup getThreadGroup() {
            return this.m_threadgroup;
        }

        public synchronized void createThreadGroup(String name) {
            if (this.m_threadgroup == null) {
                this.m_threadgroup = new ThreadGroup(name);
            }
        }
    }

    public static class SessionsDB {
        private static final long serialVersionUID = 1L;
        private final HashMap<String, SessionRecord> map = new HashMap();

        public synchronized boolean put(String nick, SessionRecord session) throws ExistingIdException, ExistingDestException {
            if (this.map.containsKey(nick)) {
                throw new ExistingIdException();
            }
            for (SessionRecord r : this.map.values()) {
                if (!r.getDest().equals(session.getDest())) continue;
                throw new ExistingDestException();
            }
            if (!this.map.containsKey(nick)) {
                session.createThreadGroup("SAM session " + nick);
                this.map.put(nick, session);
                return true;
            }
            return false;
        }

        public synchronized boolean del(String nick) {
            return this.map.remove(nick) != null;
        }

        public synchronized SessionRecord get(String nick) {
            return this.map.get(nick);
        }

        public synchronized boolean containsKey(String nick) {
            return this.map.containsKey(nick);
        }

        static class ExistingDestException
        extends Exception {
            private static final long serialVersionUID = 1L;

            ExistingDestException() {
            }
        }

        static class ExistingIdException
        extends Exception {
            private static final long serialVersionUID = 1L;

            ExistingIdException() {
            }
        }
    }
}

