/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.sam.Handler;
import net.i2p.sam.SAMBridge;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

abstract class SAMHandler
implements Runnable,
Handler {
    protected final Log _log;
    protected I2PAppThread thread;
    protected final SAMBridge bridge;
    private final Object socketWLock = new Object();
    protected final SocketChannel socket;
    protected final int verMajor;
    protected final int verMinor;
    protected final Properties i2cpProps;
    protected final Object stopLock = new Object();
    protected boolean stopHandler;

    protected SAMHandler(SocketChannel s, int verMajor, int verMinor, Properties i2cpProps, SAMBridge parent) throws IOException {
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(this.getClass());
        this.socket = s;
        this.verMajor = verMajor;
        this.verMinor = verMinor;
        this.i2cpProps = i2cpProps;
        this.bridge = parent;
    }

    public final void startHandling() {
        this.thread = new I2PAppThread(this, this.getClass().getSimpleName());
        this.thread.start();
    }

    protected abstract void handle();

    protected final SocketChannel getClientSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeBytes(ByteBuffer data) throws IOException {
        Object object = this.socketWLock;
        synchronized (object) {
            SAMHandler.writeBytes(data, this.socket);
        }
    }

    public static void writeBytes(ByteBuffer data, SocketChannel out) throws IOException {
        while (data.hasRemaining()) {
            out.write(data);
        }
        out.socket().getOutputStream().flush();
    }

    protected Object getWriteLock() {
        return this.socketWLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean writeString(String str) {
        Object object = this.socketWLock;
        synchronized (object) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending the client: [" + str + "]");
            }
            return SAMHandler.writeString(str, this.socket);
        }
    }

    public static boolean writeString(String str, SocketChannel out) {
        try {
            SAMHandler.writeBytes(ByteBuffer.wrap(DataHelper.getASCII(str)), out);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected final void closeClientSocket() throws IOException {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopHandling() {
        Object object = this.stopLock;
        synchronized (object) {
            this.stopHandler = true;
        }
        try {
            this.closeClientSocket();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bridge.unregister(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean shouldStop() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.stopHandler;
        }
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "; SAM version: " + this.verMajor + "." + this.verMinor + "; client: " + this.socket.socket().getInetAddress().toString() + ":" + this.socket.socket().getPort() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.bridge.register(this);
        try {
            this.handle();
        }
        finally {
            this.bridge.unregister(this);
        }
    }
}

