/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;

public class SimpleTimer2 {
    private static final int MIN_THREADS = 2;
    private static final int MAX_THREADS = 4;
    private final ScheduledThreadPoolExecutor _executor;
    private final String _name;
    private volatile int _count;
    private final int _threads;

    public static SimpleTimer2 getInstance() {
        return I2PAppContext.getGlobalContext().simpleTimer2();
    }

    public SimpleTimer2(I2PAppContext context) {
        this(context, "SimpleTimer2");
    }

    protected SimpleTimer2(I2PAppContext context, String name) {
        this(context, name, true);
    }

    protected SimpleTimer2(I2PAppContext context, String name, boolean prestartAllThreads) {
        this._name = name;
        long maxMemory = SystemVersion.getMaxMemory();
        this._threads = (int)Math.max(2L, Math.min(4L, 1L + maxMemory / 0x2000000L));
        this._executor = new CustomScheduledThreadPoolExecutor(this._threads, new CustomThreadFactory());
        if (prestartAllThreads) {
            this._executor.prestartAllCoreThreads();
        }
        context.addShutdownTask(new Shutdown());
    }

    public void stop() {
        this._executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        this._executor.shutdownNow();
    }

    private ScheduledFuture schedule(TimedEvent t, long timeoutMs) {
        return this._executor.schedule(t, timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void addEvent(final SimpleTimer.TimedEvent event, long timeoutMs) {
        if (event == null) {
            throw new IllegalArgumentException("addEvent null");
        }
        new TimedEvent(this, timeoutMs){

            @Override
            public void timeReached() {
                event.timeReached();
            }

            public String toString() {
                return event.toString();
            }
        };
    }

    public void addPeriodicEvent(SimpleTimer.TimedEvent event, long timeoutMs) {
        this.addPeriodicEvent(event, timeoutMs, timeoutMs);
    }

    public void addPeriodicEvent(final SimpleTimer.TimedEvent event, long delay, long timeoutMs) {
        new PeriodicTimedEvent(this, delay, timeoutMs){

            @Override
            public void timeReached() {
                event.timeReached();
            }

            public String toString() {
                return event.toString();
            }
        };
    }

    public String toString() {
        return this._name;
    }

    private long getCompletedTaskCount() {
        return this._executor.getCompletedTaskCount();
    }

    private String debug() {
        this._executor.purge();
        return " Pool: " + this._name + " Active: " + this._executor.getActiveCount() + '/' + this._executor.getPoolSize() + " Completed: " + this._executor.getCompletedTaskCount() + " Queued: " + this._executor.getQueue().size();
    }

    private static class CustomScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        public CustomScheduledThreadPoolExecutor(int threads, ThreadFactory factory) {
            super(threads, factory);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(SimpleTimer2.class);
                log.log(50, "wtf, event borked: " + r, t);
            }
        }
    }

    private class CustomThreadFactory
    implements ThreadFactory {
        private CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread rv = Executors.defaultThreadFactory().newThread(r);
            rv.setName(SimpleTimer2.this._name + ' ' + ++SimpleTimer2.this._count + '/' + SimpleTimer2.this._threads);
            rv.setDaemon(true);
            return rv;
        }
    }

    private static abstract class PeriodicTimedEvent
    extends TimedEvent {
        private long _timeoutMs;

        public PeriodicTimedEvent(SimpleTimer2 pool, long delay, long timeoutMs) {
            super(pool, delay);
            this._timeoutMs = timeoutMs;
        }

        @Override
        public void run() {
            super.run();
            this.schedule(this._timeoutMs);
        }
    }

    private class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            SimpleTimer2.this.stop();
        }
    }

    public static abstract class TimedEvent
    implements Runnable {
        private final Log _log;
        private final SimpleTimer2 _pool;
        private int _fuzz;
        protected static final int DEFAULT_FUZZ = 3;
        private ScheduledFuture _future;
        private TimedEventState _state;
        private long _nextRun;
        private boolean _rescheduleAfterRun;

        public TimedEvent(SimpleTimer2 pool) {
            this._pool = pool;
            this._fuzz = 3;
            this._log = I2PAppContext.getGlobalContext().logManager().getLog(SimpleTimer2.class);
            this._state = TimedEventState.IDLE;
        }

        public TimedEvent(SimpleTimer2 pool, long timeoutMs) {
            this(pool);
            this.schedule(timeoutMs);
        }

        public synchronized void setFuzz(int fuzz) {
            this._fuzz = fuzz;
        }

        public synchronized void schedule(long timeoutMs) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Scheduling: " + this + " timeout = " + timeoutMs + " state: " + (Object)((Object)this._state));
            }
            if (timeoutMs <= 0L && this._log.shouldLog(30)) {
                timeoutMs = 1L;
            }
            this._nextRun = timeoutMs + System.currentTimeMillis();
            switch (this._state) {
                case RUNNING: {
                    this._rescheduleAfterRun = true;
                    break;
                }
                case IDLE: 
                case CANCELLED: {
                    this._future = this._pool.schedule(this, timeoutMs);
                    this._state = TimedEventState.SCHEDULED;
                    break;
                }
            }
        }

        public void reschedule(long timeoutMs) {
            this.reschedule(timeoutMs, true);
        }

        public synchronized void reschedule(long timeoutMs, boolean useEarliestTime) {
            long now = System.currentTimeMillis();
            boolean scheduled = this._state == TimedEventState.SCHEDULED;
            long oldTimeout = scheduled ? this._nextRun - now : timeoutMs;
            if (oldTimeout - (long)this._fuzz > timeoutMs && useEarliestTime || oldTimeout + (long)this._fuzz < timeoutMs && !useEarliestTime || !scheduled) {
                if (scheduled && now + timeoutMs < this._nextRun) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Re-scheduling: " + this + " timeout = " + timeoutMs + " old timeout was " + oldTimeout + " state: " + (Object)((Object)this._state));
                    }
                    this.cancel();
                }
                this.schedule(timeoutMs);
            }
        }

        public synchronized void forceReschedule(long timeoutMs) {
            this.cancel();
            this.schedule(timeoutMs);
        }

        public synchronized boolean cancel() {
            this._rescheduleAfterRun = false;
            switch (this._state) {
                case IDLE: 
                case CANCELLED: {
                    break;
                }
                case RUNNING: 
                case SCHEDULED: {
                    boolean cancelled = this._future.cancel(false);
                    if (cancelled) {
                        this._state = TimedEventState.CANCELLED;
                    }
                    return cancelled;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long completed;
            if (this._log.shouldLog(10)) {
                this._log.debug("Running: " + this);
            }
            long before = System.currentTimeMillis();
            long delay = 0L;
            TimedEvent timedEvent = this;
            synchronized (timedEvent) {
                if (this._rescheduleAfterRun) {
                    throw new IllegalStateException("rescheduleAfterRun cannot be true here");
                }
                switch (this._state) {
                    case CANCELLED: {
                        return;
                    }
                    case RUNNING: 
                    case IDLE: {
                        throw new IllegalStateException("not possible to be in " + (Object)((Object)this._state));
                    }
                    case SCHEDULED: {
                        this._state = TimedEventState.IDLE;
                    }
                }
                int difference = (int)(this._nextRun - before);
                if (difference > this._fuzz) {
                    this.schedule(difference);
                    return;
                }
                this._state = TimedEventState.RUNNING;
            }
            if (this._future != null) {
                delay = this._future.getDelay(TimeUnit.MILLISECONDS);
            } else if (this._log.shouldLog(30)) {
                this._log.warn(this._pool + " wtf, no _future " + this);
            }
            if (this._log.shouldLog(30) && delay > 100L) {
                this._log.warn(this._pool + " wtf, early execution " + delay + ": " + this);
            } else if (this._log.shouldLog(30) && delay < -1000L) {
                this._log.warn(" wtf, late execution " + (0L - delay) + ": " + this + this._pool.debug());
            }
            try {
                this.timeReached();
            }
            catch (Throwable t) {
                this._log.log(50, this._pool + ": Timed task " + this + " exited unexpectedly, please report", t);
            }
            finally {
                timedEvent = this;
                synchronized (timedEvent) {
                    switch (this._state) {
                        case IDLE: 
                        case SCHEDULED: {
                            throw new IllegalStateException("can't be " + (Object)((Object)this._state));
                        }
                        case CANCELLED: {
                            break;
                        }
                        case RUNNING: {
                            this._state = TimedEventState.IDLE;
                            if (!this._rescheduleAfterRun) break;
                            this._rescheduleAfterRun = false;
                            this.schedule(this._nextRun - System.currentTimeMillis());
                        }
                    }
                }
            }
            long time = System.currentTimeMillis() - before;
            if (time > 500L && this._log.shouldLog(30)) {
                this._log.warn(this._pool + " wtf, event execution took " + time + ": " + this);
            }
            if (this._log.shouldLog(20) && (completed = this._pool.getCompletedTaskCount()) % 250L == 0L) {
                this._log.info(this._pool.debug());
            }
        }

        public abstract void timeReached();
    }

    private static enum TimedEventState {
        IDLE,
        SCHEDULED,
        RUNNING,
        CANCELLED;

    }
}

