/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;

public class PortMapper {
    private final ConcurrentHashMap<String, InetSocketAddress> _dir = new ConcurrentHashMap(8);
    public static final String SVC_CONSOLE = "console";
    public static final String SVC_HTTPS_CONSOLE = "https_console";
    public static final String SVC_HTTP_PROXY = "HTTP";
    public static final String SVC_HTTPS_PROXY = "HTTPS";
    public static final String SVC_EEPSITE = "eepsite";
    public static final String SVC_IRC = "irc";
    public static final String SVC_SOCKS = "socks";
    public static final String SVC_TAHOE = "tahoe-lafs";
    public static final String SVC_SMTP = "SMTP";
    public static final String SVC_POP = "POP3";
    public static final String SVC_SAM = "SAM";
    public static final String SVC_BOB = "BOB";
    public static final String SVC_I2CP = "I2CP";

    public PortMapper(I2PAppContext context) {
    }

    public boolean register(String service, int port) {
        return this.register(service, "127.0.0.1", port);
    }

    public boolean register(String service, String host, int port) {
        if (port <= 0 || port > 65535) {
            return false;
        }
        return this._dir.putIfAbsent(service, InetSocketAddress.createUnresolved(host, port)) == null;
    }

    public void unregister(String service) {
        this._dir.remove(service);
    }

    public int getPort(String service) {
        int port = this.getPort(service, -1);
        return port;
    }

    public int getPort(String service, int def) {
        InetSocketAddress ia = this._dir.get(service);
        if (ia == null) {
            return def;
        }
        return ia.getPort();
    }

    public String getHost(String service, String def) {
        InetSocketAddress ia = this._dir.get(service);
        if (ia == null) {
            return def;
        }
        return ia.getHostName();
    }

    public void renderStatusHTML(Writer out) throws IOException {
        ArrayList services = new ArrayList(this._dir.keySet());
        out.write("<h2>Port Mapper</h2><table><tr><th>Service<th>Host<th>Port\n");
        Collections.sort(services);
        for (String s : services) {
            InetSocketAddress ia = this._dir.get(s);
            if (ia == null) continue;
            out.write("<tr><td>" + s + "<td>" + ia.getHostName() + "<td>" + ia.getPort() + '\n');
        }
        out.write("</table>\n");
    }
}

