/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.i2p.util.SystemVersion;

public class I2PThread
extends Thread {
    private static final Set<OOMEventListener> _listeners = new CopyOnWriteArraySet<OOMEventListener>();

    public I2PThread() {
        this.setPriority(5);
    }

    public I2PThread(String name) {
        super(name);
        this.setPriority(5);
    }

    public I2PThread(Runnable r) {
        super(r);
        this.setPriority(5);
    }

    public I2PThread(Runnable r, String name) {
        super(r, name);
        this.setPriority(5);
    }

    public I2PThread(Runnable r, String name, boolean isDaemon) {
        super(r, name);
        this.setDaemon(isDaemon);
        this.setPriority(5);
    }

    public I2PThread(ThreadGroup g, Runnable r) {
        super(g, r);
        this.setPriority(5);
    }

    @Override
    public void start() {
        try {
            super.start();
        }
        catch (OutOfMemoryError oom) {
            System.out.println("ERROR: Thread could not be started: " + this.getName());
            if (!SystemVersion.isWindows() && !SystemVersion.isAndroid()) {
                System.out.println("Check ulimit -u, /etc/security/limits.conf, or /proc/sys/kernel/threads-max");
            }
            oom.printStackTrace();
            throw new RuntimeException("Thread could not be started", oom);
        }
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                this.fireOOM((OutOfMemoryError)t);
            }
            System.out.println("Thread terminated unexpectedly: " + this.getName());
            t.printStackTrace();
        }
    }

    protected void fireOOM(OutOfMemoryError oom) {
        for (OOMEventListener listener : _listeners) {
            listener.outOfMemory(oom);
        }
    }

    public static void addOOMEventListener(OOMEventListener lsnr) {
        _listeners.add(lsnr);
    }

    public static void removeOOMEventListener(OOMEventListener lsnr) {
        _listeners.remove(lsnr);
    }

    public static interface OOMEventListener {
        public void outOfMemory(OutOfMemoryError var1);
    }
}

