/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.SessionId;

public abstract class I2CPMessageImpl
extends DataStructureImpl
implements I2CPMessage {
    @Override
    public void readMessage(InputStream in) throws I2CPMessageException, IOException {
        int length = 0;
        try {
            length = (int)DataHelper.readLong(in, 4);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error reading the length bytes", dfe);
        }
        if (length < 0) {
            throw new I2CPMessageException("Invalid message length specified");
        }
        int type = -1;
        try {
            type = (int)DataHelper.readLong(in, 1);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error reading the type byte", dfe);
        }
        this.readMessage(in, length, type);
    }

    @Override
    public void readMessage(InputStream in, int length, int type) throws I2CPMessageException, IOException {
        if (type != this.getType()) {
            throw new I2CPMessageException("Invalid message type (found: " + type + " supported: " + this.getType() + " class: " + this.getClass().getName() + ")");
        }
        if (length < 0) {
            throw new IOException("Negative payload size");
        }
        this.doReadMessage(in, length);
    }

    protected abstract void doReadMessage(InputStream var1, int var2) throws I2CPMessageException, IOException;

    protected abstract byte[] doWriteMessage() throws I2CPMessageException, IOException;

    @Override
    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        byte[] data = this.doWriteMessage();
        try {
            DataHelper.writeLong(out, 4, data.length);
            DataHelper.writeLong(out, 1, this.getType());
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to write the message length or type", dfe);
        }
        out.write(data);
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        try {
            this.readMessage(in);
        }
        catch (I2CPMessageException ime) {
            throw new DataFormatException("Error reading the message", ime);
        }
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        try {
            this.writeMessage(out);
        }
        catch (I2CPMessageException ime) {
            throw new DataFormatException("Error writing the message", ime);
        }
    }

    @Override
    public SessionId sessionId() {
        return null;
    }
}

