/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import net.i2p.util.RandomSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomIterator<E>
implements Iterator<E> {
    private final BitSet served;
    private int servedCount = 0;
    private final List<E> list;
    private final int LIST_SIZE;
    private final Random rand = RandomSource.getInstance();
    private int lower;
    private int upper;
    private static final boolean isAndroid = System.getProperty("java.vendor").contains("Android");

    public RandomIterator(List<E> list) {
        this.list = list;
        this.LIST_SIZE = list.size();
        this.served = new BitSet(this.LIST_SIZE);
        this.upper = this.LIST_SIZE - 1;
    }

    @Override
    public boolean hasNext() {
        return this.servedCount < this.LIST_SIZE;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int range = this.upper - this.lower + 1;
        int start = this.lower + this.rand.nextInt(range);
        int index = start % 2 == 0 ? this.served.nextClearBit(start) : this.previousClearBit(start);
        if (index < 0) {
            throw new NoSuchElementException("shouldn't happen");
        }
        ++this.servedCount;
        this.served.set(index);
        if (this.hasNext()) {
            if (index == this.lower) {
                this.lower = isAndroid ? this.nextClearBit(index) : this.served.nextClearBit(index);
            } else if (index == this.upper) {
                this.upper = this.previousClearBit(index - 1);
            }
        }
        return this.list.get(index);
    }

    private int previousClearBit(int n) {
        for (int i = n; i >= this.lower; --i) {
            if (this.served.get(i)) continue;
            return i;
        }
        return -1;
    }

    private int nextClearBit(int n) {
        for (int i = n; i <= this.upper; ++i) {
            if (this.served.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        RandomIterator.testAndroid();
        RandomIterator.test(0);
        RandomIterator.test(1);
        RandomIterator.test(2);
        RandomIterator.test(1000);
    }

    private static void test(int n) {
        System.out.println("testing with " + n);
        ArrayList<Integer> l = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            l.add(i);
        }
        RandomIterator iter = new RandomIterator(l);
        while (iter.hasNext()) {
            System.out.println(((Integer)iter.next()).toString());
        }
    }

    private static void testAndroid() {
        System.out.println("checking for Android bug");
        BitSet theBitSet = new BitSet(864);
        for (int exp = 0; exp < 864; ++exp) {
            int act = theBitSet.nextClearBit(0);
            if (exp != act) {
                System.err.println(String.format("Test failed for: exp=%d, act=%d", exp, act));
                System.err.println("Android BitSet bug detected, workaround implemented!");
                return;
            }
            theBitSet.set(exp);
        }
        System.err.println("Android BitSet bug NOT detected, no workaround needed!");
    }

    static {
        if (isAndroid) {
            RandomIterator.testAndroid();
        }
    }
}

