/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.HashDistance;
import net.i2p.router.tunnel.pool.ClientPeerSelector;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TunnelPeerSelector {
    protected final RouterContext ctx;
    private static final String MIN_VERSION = "0.7.9";
    private static final VersionComparator _versionComparator = new VersionComparator();
    private static final String PROP_OUTBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = "router.outboundExploratoryExcludeUnreachable";
    private static final String PROP_OUTBOUND_CLIENT_EXCLUDE_UNREACHABLE = "router.outboundClientExcludeUnreachable";
    private static final String PROP_INBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = "router.inboundExploratoryExcludeUnreachable";
    private static final String PROP_INBOUND_CLIENT_EXCLUDE_UNREACHABLE = "router.inboundClientExcludeUnreachable";
    private static final String DEFAULT_OUTBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = "false";
    private static final String DEFAULT_OUTBOUND_CLIENT_EXCLUDE_UNREACHABLE = "false";
    private static final String DEFAULT_INBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = "true";
    private static final String DEFAULT_INBOUND_CLIENT_EXCLUDE_UNREACHABLE = "true";
    private static final String PROP_OUTBOUND_EXPLORATORY_EXCLUDE_SLOW = "router.outboundExploratoryExcludeSlow";
    private static final String PROP_OUTBOUND_CLIENT_EXCLUDE_SLOW = "router.outboundClientExcludeSlow";
    private static final String PROP_INBOUND_EXPLORATORY_EXCLUDE_SLOW = "router.inboundExploratoryExcludeSlow";
    private static final String PROP_INBOUND_CLIENT_EXCLUDE_SLOW = "router.inboundClientExcludeSlow";
    private static final String PROP_OUTBOUND_EXPLORATORY_EXCLUDE_UPTIME = "router.outboundExploratoryExcludeUptime";
    private static final String PROP_OUTBOUND_CLIENT_EXCLUDE_UPTIME = "router.outboundClientExcludeUptime";
    private static final String PROP_INBOUND_EXPLORATORY_EXCLUDE_UPTIME = "router.inboundExploratoryExcludeUptime";
    private static final String PROP_INBOUND_CLIENT_EXCLUDE_UPTIME = "router.inboundClientExcludeUptime";

    protected TunnelPeerSelector(RouterContext context) {
        this.ctx = context;
    }

    public abstract List<Hash> selectPeers(TunnelPoolSettings var1);

    protected int getLength(TunnelPoolSettings settings) {
        int length = settings.getLength();
        int override = settings.getLengthOverride();
        if (override >= 0) {
            length = override;
        } else if (settings.getLengthVariance() != 0) {
            int skew = settings.getLengthVariance();
            if (skew > 0) {
                length += this.ctx.random().nextInt(skew + 1);
            } else {
                skew = 1 - skew;
                int off = this.ctx.random().nextInt(skew);
                length = this.ctx.random().nextBoolean() ? (length += off) : (length -= off);
            }
        }
        if (length < 0) {
            length = 0;
        } else if (length > 7) {
            length = 7;
        }
        return length;
    }

    protected boolean shouldSelectExplicit(TunnelPoolSettings settings) {
        if (settings.isExploratory()) {
            return false;
        }
        Properties opts = settings.getUnknownOptions();
        if (opts != null) {
            String peers = opts.getProperty("explicitPeers");
            if (peers == null) {
                peers = I2PAppContext.getGlobalContext().getProperty("explicitPeers");
            }
            if (peers != null) {
                return true;
            }
        }
        return false;
    }

    protected List<Hash> selectExplicit(TunnelPoolSettings settings, int length) {
        String peers = null;
        Properties opts = settings.getUnknownOptions();
        if (opts != null) {
            peers = opts.getProperty("explicitPeers");
        }
        if (peers == null) {
            peers = I2PAppContext.getGlobalContext().getProperty("explicitPeers");
        }
        Log log = this.ctx.logManager().getLog(ClientPeerSelector.class);
        ArrayList<Hash> rv = new ArrayList<Hash>();
        StringTokenizer tok = new StringTokenizer(peers, ",");
        while (tok.hasMoreTokens()) {
            String peerStr = tok.nextToken();
            Hash peer = new Hash();
            try {
                peer.fromBase64(peerStr);
                if (this.ctx.profileOrganizer().isSelectable(peer)) {
                    rv.add(peer);
                    continue;
                }
                if (!log.shouldLog(10)) continue;
                log.debug("Explicit peer is not selectable: " + peerStr);
            }
            catch (DataFormatException dfe) {
                if (!log.shouldLog(40)) continue;
                log.error("Explicit peer is improperly formatted (" + peerStr + ")", (Throwable)dfe);
            }
        }
        int sz = rv.size();
        Collections.shuffle(rv, (Random)this.ctx.random());
        while (rv.size() > length) {
            rv.remove(0);
        }
        if (log.shouldLog(20)) {
            StringBuilder buf = new StringBuilder();
            if (settings.getDestinationNickname() != null) {
                buf.append("peers for ").append(settings.getDestinationNickname());
            } else if (settings.getDestination() != null) {
                buf.append("peers for ").append(settings.getDestination().toBase64());
            } else {
                buf.append("peers for exploratory ");
            }
            if (settings.isInbound()) {
                buf.append(" inbound");
            } else {
                buf.append(" outbound");
            }
            buf.append(" peers: ").append(rv);
            buf.append(", out of ").append(sz).append(" (not including self)");
            log.info(buf.toString());
        }
        if (settings.isInbound()) {
            rv.add(0, this.ctx.routerHash());
        } else {
            rv.add(this.ctx.routerHash());
        }
        return rv;
    }

    public Set<Hash> getExclude(boolean isInbound, boolean isExploratory) {
        HashSet<Hash> peers = new HashSet<Hash>(1);
        peers.addAll(this.ctx.profileOrganizer().selectPeersRecentlyRejecting());
        peers.addAll(this.ctx.tunnelManager().selectPeersInTooManyTunnels());
        if (this.filterUnreachable(isInbound, isExploratory)) {
            Collection<Hash> caps = this.ctx.peerManager().getPeersByCapability('U');
            if (caps != null) {
                peers.addAll(caps);
            }
            if ((caps = this.ctx.profileOrganizer().selectPeersLocallyUnreachable()) != null) {
                peers.addAll(caps);
            }
        }
        if (this.filterSlow(this.ctx, isInbound, isExploratory)) {
            FloodfillNetworkDatabaseFacade fac;
            List<RouterInfo> known;
            Log log = this.ctx.logManager().getLog(TunnelPeerSelector.class);
            char[] excl = TunnelPeerSelector.getExcludeCaps(this.ctx);
            if (excl != null && (known = (fac = (FloodfillNetworkDatabaseFacade)this.ctx.netDb()).getKnownRouterData()) != null) {
                for (int i = 0; i < known.size(); ++i) {
                    RouterInfo peer = known.get(i);
                    boolean shouldExclude = TunnelPeerSelector.shouldExclude(this.ctx, log, peer, excl);
                    if (!shouldExclude) continue;
                    peers.add(peer.getIdentity().calculateHash());
                }
            }
        }
        return peers;
    }

    public static boolean shouldExclude(RouterContext ctx, RouterInfo peer) {
        Log log = ctx.logManager().getLog(TunnelPeerSelector.class);
        return TunnelPeerSelector.shouldExclude(ctx, log, peer, TunnelPeerSelector.getExcludeCaps(ctx));
    }

    private static char[] getExcludeCaps(RouterContext ctx) {
        String excludeCaps = ctx.getProperty("router.excludePeerCaps", String.valueOf('K'));
        if (excludeCaps != null) {
            char[] excl = excludeCaps.toCharArray();
            return excl;
        }
        return null;
    }

    private static boolean shouldExclude(RouterContext ctx, Log log, RouterInfo peer, char[] excl) {
        String cap = peer.getCapabilities();
        if (cap == null) {
            return true;
        }
        for (int j = 0; j < excl.length; ++j) {
            if (cap.indexOf(excl[j]) < 0) continue;
            return true;
        }
        int maxLen = 0;
        if (cap.indexOf(102) >= 0) {
            ++maxLen;
        }
        if (cap.indexOf(82) >= 0) {
            ++maxLen;
        }
        if (cap.indexOf(85) >= 0) {
            ++maxLen;
        }
        if (cap.length() <= maxLen) {
            return true;
        }
        String v = peer.getOption("router.version");
        return v == null || _versionComparator.compare(v, MIN_VERSION) < 0;
    }

    protected boolean filterUnreachable(boolean isInbound, boolean isExploratory) {
        boolean def = false;
        String val = null;
        val = isExploratory ? (isInbound ? this.ctx.getProperty(PROP_INBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE, "true") : this.ctx.getProperty(PROP_OUTBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE, "false")) : (isInbound ? this.ctx.getProperty(PROP_INBOUND_CLIENT_EXCLUDE_UNREACHABLE, "true") : this.ctx.getProperty(PROP_OUTBOUND_CLIENT_EXCLUDE_UNREACHABLE, "false"));
        boolean rv = val != null ? Boolean.valueOf(val) : def;
        return rv;
    }

    protected boolean filterSlow(RouterContext ctx, boolean isInbound, boolean isExploratory) {
        boolean def = true;
        String val = null;
        val = isExploratory ? (isInbound ? ctx.getProperty(PROP_INBOUND_EXPLORATORY_EXCLUDE_SLOW) : ctx.getProperty(PROP_OUTBOUND_EXPLORATORY_EXCLUDE_SLOW)) : (isInbound ? ctx.getProperty(PROP_INBOUND_CLIENT_EXCLUDE_SLOW) : ctx.getProperty(PROP_OUTBOUND_CLIENT_EXCLUDE_SLOW));
        boolean rv = val != null ? Boolean.valueOf(val) : def;
        return rv;
    }

    protected boolean filterUptime(RouterContext ctx, boolean isInbound, boolean isExploratory) {
        boolean def = true;
        String val = null;
        val = isExploratory ? (isInbound ? ctx.getProperty(PROP_INBOUND_EXPLORATORY_EXCLUDE_UPTIME) : ctx.getProperty(PROP_OUTBOUND_EXPLORATORY_EXCLUDE_UPTIME)) : (isInbound ? ctx.getProperty(PROP_INBOUND_CLIENT_EXCLUDE_UPTIME) : ctx.getProperty(PROP_OUTBOUND_CLIENT_EXCLUDE_UPTIME));
        boolean rv = val != null ? Boolean.valueOf(val) : def;
        return rv;
    }

    protected void orderPeers(List rv, Hash hash) {
        Collections.sort(rv, new HashComparator(hash));
    }

    private static class HashComparator
    implements Comparator {
        private Hash _hash;

        private HashComparator(Hash h) {
            this._hash = h;
        }

        public int compare(Object l, Object r) {
            byte[] data = new byte[64];
            System.arraycopy(this._hash.getData(), 0, data, 32, 32);
            System.arraycopy(((Hash)l).getData(), 0, data, 0, 32);
            Hash lh = SHA256Generator.getInstance().calculateHash(data);
            System.arraycopy(((Hash)r).getData(), 0, data, 0, 32);
            Hash rh = SHA256Generator.getInstance().calculateHash(data);
            BigInteger ll = HashDistance.getDistance(this._hash, lh);
            BigInteger rr = HashDistance.getDistance(this._hash, rh);
            return ll.compareTo(rr);
        }
    }
}

