/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class TunnelGateway {
    protected final RouterContext _context;
    protected final Log _log;
    protected final List<Pending> _queue;
    protected final QueuePreprocessor _preprocessor;
    protected final Sender _sender;
    protected final Receiver _receiver;
    protected long _lastFlush;
    protected final DelayedFlush _delayedFlush;
    protected int _messagesSent;

    public TunnelGateway(RouterContext context, QueuePreprocessor preprocessor, Sender sender, Receiver receiver) {
        this._context = context;
        this._log = context.logManager().getLog(this.getClass());
        this._queue = new ArrayList<Pending>(4);
        this._preprocessor = preprocessor;
        this._sender = sender;
        this._receiver = receiver;
        this._delayedFlush = new DelayedFlush();
        this._lastFlush = this._context.clock().now();
        this._context.statManager().createRateStat("tunnel.lockedGatewayAdd", "How long do we block when adding a message to a tunnel gateway's queue", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.lockedGatewayCheck", "How long do we block when flushing a tunnel gateway's queue", "Tunnels", new long[]{60000L, 600000L});
    }

    public void add(TunnelGatewayMessage msg) {
        this.add(msg.getMessage(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
        ++this._messagesSent;
        long startAdd = System.currentTimeMillis();
        boolean delayedFlush = false;
        long delayAmount = -1L;
        int remaining = 0;
        PendingImpl cur = new PendingImpl(msg, toRouter, toTunnel);
        long beforeLock = System.currentTimeMillis();
        long afterAdded = -1L;
        long afterPreprocess = 0L;
        long afterExpire = 0L;
        List<Pending> list = this._queue;
        synchronized (list) {
            this._queue.add(cur);
            afterAdded = System.currentTimeMillis();
            if (this._log.shouldLog(10)) {
                this._log.debug("Added before direct flush preprocessing: " + this._queue);
            }
            delayedFlush = this._preprocessor.preprocessQueue(this._queue, this._sender, this._receiver);
            afterPreprocess = System.currentTimeMillis();
            if (delayedFlush) {
                delayAmount = this._preprocessor.getDelayAmount();
            }
            this._lastFlush = this._context.clock().now();
            for (int i = 0; i < this._queue.size(); ++i) {
                Pending m = this._queue.get(i);
                if (m.getExpiration() + 60000L >= this._lastFlush) continue;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Expire on the queue (size=" + this._queue.size() + "): " + m);
                }
                this._queue.remove(i);
                --i;
            }
            afterExpire = System.currentTimeMillis();
            remaining = this._queue.size();
            if (remaining > 0 && this._log.shouldLog(10)) {
                this._log.debug("Remaining after preprocessing: " + this._queue);
            }
        }
        if (delayedFlush) {
            this._context.simpleTimer().addEvent((SimpleTimer.TimedEvent)this._delayedFlush, delayAmount);
        }
        this._context.statManager().addRateData("tunnel.lockedGatewayAdd", afterAdded - beforeLock, (long)remaining);
        if (this._log.shouldLog(10)) {
            long complete = System.currentTimeMillis();
            this._log.debug("Time to add the message " + msg.getUniqueId() + ": " + (complete - startAdd) + " delayed? " + delayedFlush + " remaining: " + remaining + " prepare: " + (beforeLock - startAdd) + " add: " + (afterAdded - beforeLock) + " preprocess: " + (afterPreprocess - afterAdded) + " expire: " + (afterExpire - afterPreprocess) + " queue flush: " + (complete - afterExpire));
        }
    }

    public int getMessagesSent() {
        return this._messagesSent;
    }

    private class DelayedFlush
    implements SimpleTimer.TimedEvent {
        private DelayedFlush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            boolean wantRequeue = false;
            int remaining = 0;
            long beforeLock = TunnelGateway.this._context.clock().now();
            long afterChecked = -1L;
            long delayAmount = -1L;
            List<Pending> list = TunnelGateway.this._queue;
            synchronized (list) {
                afterChecked = TunnelGateway.this._context.clock().now();
                if (!TunnelGateway.this._queue.isEmpty()) {
                    if (remaining > 0 && TunnelGateway.this._log.shouldLog(10)) {
                        TunnelGateway.this._log.debug("Remaining before delayed flush preprocessing: " + TunnelGateway.this._queue);
                    }
                    if (wantRequeue = TunnelGateway.this._preprocessor.preprocessQueue(TunnelGateway.this._queue, TunnelGateway.this._sender, TunnelGateway.this._receiver)) {
                        delayAmount = TunnelGateway.this._preprocessor.getDelayAmount();
                    }
                    if (TunnelGateway.this._log.shouldLog(10)) {
                        TunnelGateway.this._log.debug("Remaining after delayed flush preprocessing (requeue? " + wantRequeue + "): " + TunnelGateway.this._queue);
                    }
                }
                remaining = TunnelGateway.this._queue.size();
            }
            if (wantRequeue) {
                TunnelGateway.this._context.simpleTimer().addEvent((SimpleTimer.TimedEvent)TunnelGateway.this._delayedFlush, delayAmount);
            } else {
                TunnelGateway.this._lastFlush = TunnelGateway.this._context.clock().now();
            }
            TunnelGateway.this._context.statManager().addRateData("tunnel.lockedGatewayCheck", afterChecked - beforeLock, (long)remaining);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pending {
        protected final Hash _toRouter;
        protected final TunnelId _toTunnel;
        protected final long _messageId;
        protected final long _expiration;
        protected final byte[] _remaining;
        protected int _offset;
        protected int _fragmentNumber;
        protected final long _created;
        private List<Long> _messageIds;

        public Pending(I2NPMessage message, Hash toRouter, TunnelId toTunnel) {
            this(message, toRouter, toTunnel, System.currentTimeMillis());
        }

        public Pending(I2NPMessage message, Hash toRouter, TunnelId toTunnel, long now) {
            this._toRouter = toRouter;
            this._toTunnel = toTunnel;
            this._messageId = message.getUniqueId();
            this._expiration = message.getMessageExpiration();
            this._remaining = message.toByteArray();
            this._created = now;
        }

        public Hash getToRouter() {
            return this._toRouter;
        }

        public TunnelId getToTunnel() {
            return this._toTunnel;
        }

        public long getMessageId() {
            return this._messageId;
        }

        public long getExpiration() {
            return this._expiration;
        }

        public byte[] getData() {
            return this._remaining;
        }

        public int getOffset() {
            return this._offset;
        }

        public void setOffset(int offset) {
            this._offset = offset;
        }

        public long getLifetime() {
            return System.currentTimeMillis() - this._created;
        }

        public int getFragmentNumber() {
            return this._fragmentNumber;
        }

        public void incrementFragmentNumber() {
            ++this._fragmentNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMessageId(long id) {
            Pending pending = this;
            synchronized (pending) {
                if (this._messageIds == null) {
                    this._messageIds = new ArrayList<Long>();
                }
                this._messageIds.add(id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Long> getMessageIds() {
            Pending pending = this;
            synchronized (pending) {
                if (this._messageIds != null) {
                    return new ArrayList<Long>(this._messageIds);
                }
                return new ArrayList<Long>();
            }
        }
    }

    class PendingImpl
    extends Pending {
        public PendingImpl(I2NPMessage message, Hash toRouter, TunnelId toTunnel) {
            super(message, toRouter, toTunnel, TunnelGateway.this._context.clock().now());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Message ").append(this._messageId).append(" on ");
            buf.append(TunnelGateway.this.toString());
            if (this._toRouter != null) {
                buf.append(" targetting ");
                buf.append(this._toRouter.toBase64()).append(" ");
                if (this._toTunnel != null) {
                    buf.append(this._toTunnel.getTunnelId());
                }
            }
            long now = TunnelGateway.this._context.clock().now();
            buf.append(" actual lifetime ");
            buf.append(now - this._created).append("ms");
            buf.append(" potential lifetime ");
            buf.append(this._expiration - this._created).append("ms");
            buf.append(" size ").append(this._remaining.length);
            buf.append(" offset ").append(this._offset);
            buf.append(" frag ").append(this._fragmentNumber);
            return buf.toString();
        }

        public long getLifetime() {
            return TunnelGateway.this._context.clock().now() - this._created;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface QueuePreprocessor {
        public boolean preprocessQueue(List<Pending> var1, Sender var2, Receiver var3);

        public long getDelayAmount();
    }

    public static interface Receiver {
        public long receiveEncrypted(byte[] var1);
    }

    public static interface Sender {
        public long sendPreprocessed(byte[] var1, Receiver var2);
    }
}

