/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class UDPReceiver {
    private final RouterContext _context;
    private final Log _log;
    private final DatagramSocket _socket;
    private String _name;
    private final BlockingQueue<UDPPacket> _inboundQueue;
    private volatile boolean _keepRunning;
    private final Runner _runner;
    private final UDPTransport _transport;
    private static int __id;
    private final int _id;
    private static final boolean _isAndroid;
    private static final int TYPE_POISON = -99999;
    private static final int MIN_QUEUE_SIZE = 16;
    private static final int MAX_QUEUE_SIZE = 192;
    private static final long MAX_QUEUE_PERIOD = 2000L;

    public UDPReceiver(RouterContext ctx, UDPTransport transport, DatagramSocket socket, String name) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPReceiver.class);
        this._id = ++__id;
        this._name = name;
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x6000000L;
        }
        int qsize = (int)Math.max(16L, Math.min(192L, maxMemory / 0x200000L));
        this._inboundQueue = new LinkedBlockingQueue<UDPPacket>(qsize);
        this._socket = socket;
        this._transport = transport;
        this._runner = new Runner();
        this._context.statManager().createRateStat("udp.receivePacketSize", "How large packets received are", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveRemaining", "How many packets are left sitting on the receiver's queue", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.droppedInbound", "How many packet are queued up but not yet received when we drop", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveHolePunch", "How often we receive a NAT hole punch", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.ignorePacketFromDroplist", "Packet lifetime for those dropped on the drop list", "udp", UDPTransport.RATES);
    }

    public void startup() {
        this._keepRunning = true;
        I2PThread t = new I2PThread((Runnable)this._runner, this._name + '.' + this._id, true);
        t.start();
    }

    public void shutdown() {
        int i;
        this._keepRunning = false;
        this._inboundQueue.clear();
        for (i = 0; i < this._transport.getPacketHandlerCount(); ++i) {
            UDPPacket poison = UDPPacket.acquire(this._context, false);
            poison.setMessageType(-99999);
            this._inboundQueue.offer(poison);
        }
        for (i = 1; i <= 5 && !this._inboundQueue.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._inboundQueue.clear();
    }

    private int receive(UDPPacket packet) {
        return this.doReceive(packet);
    }

    private final int doReceive(UDPPacket packet) {
        RemoteHostId from;
        if (!this._keepRunning) {
            return 0;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Received: " + packet);
        }
        if (this._transport.isInDropList(from = packet.getRemoteHost())) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring packet from the drop-listed peer: " + from);
            }
            this._context.statManager().addRateData("udp.ignorePacketFromDroplist", packet.getLifetime(), 0L);
            packet.release();
            return 0;
        }
        if (Arrays.equals(from.getIP(), this._transport.getExternalIP())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping (spoofed?) packet from ourselves");
            }
            packet.release();
            return 0;
        }
        packet.enqueue();
        boolean rejected = false;
        int queueSize = 0;
        long headPeriod = 0L;
        UDPPacket head = (UDPPacket)this._inboundQueue.peek();
        if (head != null && (headPeriod = head.getLifetime()) > 2000L) {
            rejected = true;
        }
        if (!rejected) {
            try {
                this._inboundQueue.put(packet);
            }
            catch (InterruptedException ie) {
                packet.release();
                this._keepRunning = false;
            }
            return 0;
        }
        packet.release();
        this._context.statManager().addRateData("udp.droppedInbound", (long)queueSize, headPeriod);
        if (this._log.shouldLog(30)) {
            queueSize = this._inboundQueue.size();
            StringBuilder msg = new StringBuilder();
            msg.append("Dropping inbound packet with ");
            msg.append(queueSize);
            msg.append(" queued for ");
            msg.append(headPeriod);
            msg.append(" packet handlers: ").append(this._transport.getPacketHandlerStatus());
            this._log.warn(msg.toString());
        }
        return queueSize;
    }

    public UDPPacket receiveNext() {
        UDPPacket rv = null;
        while (this._keepRunning && rv == null) {
            try {
                rv = this._inboundQueue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (rv == null || rv.getMessageType() != -99999) continue;
            return null;
        }
        return rv;
    }

    static {
        _isAndroid = System.getProperty("java.vendor").contains("Android");
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        public void run() {
            FIFOBandwidthLimiter.Request req = UDPReceiver.this._context.bandwidthLimiter().createRequest();
            while (UDPReceiver.this._keepRunning) {
                UDPPacket packet = UDPPacket.acquire(UDPReceiver.this._context, true);
                if (_isAndroid) {
                    packet.getPacket().setLength(1572);
                }
                while (!UDPReceiver.this._context.throttle().acceptNetworkMessage()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {}
                }
                try {
                    UDPReceiver.this._socket.receive(packet.getPacket());
                    int size = packet.getPacket().getLength();
                    if (UDPReceiver.this._log.shouldLog(20)) {
                        UDPReceiver.this._log.info("After blocking socket.receive: packet is " + size + " bytes on " + System.identityHashCode(packet));
                    }
                    packet.resetBegin();
                    if (size >= 1572) {
                        throw new IOException("packet too large! truncated and dropped from: " + packet.getRemoteHost());
                    }
                    if (size > 0) {
                        req = UDPReceiver.this._context.bandwidthLimiter().requestInbound(size, "UDP receiver");
                        while (req.getPendingInboundRequested() > 0) {
                            req.waitForNextAllocation();
                        }
                        int queued = UDPReceiver.this.receive(packet);
                        UDPReceiver.this._context.statManager().addRateData("udp.receivePacketSize", (long)size, (long)queued);
                        continue;
                    }
                    UDPReceiver.this._context.statManager().addRateData("udp.receiveHolePunch", 1L, 0L);
                    if (UDPReceiver.this._log.shouldLog(20)) {
                        UDPReceiver.this._log.info("Received a 0 byte udp packet from " + packet.getPacket().getAddress() + ":" + packet.getPacket().getPort());
                    }
                    packet.release();
                }
                catch (IOException ioe) {
                    if (UDPReceiver.this._log.shouldLog(30)) {
                        UDPReceiver.this._log.warn("Error receiving", (Throwable)ioe);
                    }
                    packet.release();
                }
            }
            if (UDPReceiver.this._log.shouldLog(10)) {
                UDPReceiver.this._log.debug("Stop receiving...");
            }
        }
    }
}

