/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.i2p.data.Base64;
import net.i2p.data.RouterAddress;
import net.i2p.router.transport.udp.MTU;

public class UDPAddress {
    private String _host;
    private InetAddress _hostAddress;
    private int _port;
    private byte[] _introKey;
    private String[] _introHosts;
    private InetAddress[] _introAddresses;
    private int[] _introPorts;
    private byte[][] _introKeys;
    private long[] _introTags;
    private int _mtu;
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST = "host";
    public static final String PROP_INTRO_KEY = "key";
    public static final String PROP_MTU = "mtu";
    public static final String PROP_CAPACITY = "caps";
    public static final char CAPACITY_TESTING = 'B';
    public static final char CAPACITY_INTRODUCER = 'C';
    public static final String PROP_INTRO_HOST_PREFIX = "ihost";
    public static final String PROP_INTRO_PORT_PREFIX = "iport";
    public static final String PROP_INTRO_KEY_PREFIX = "ikey";
    public static final String PROP_INTRO_TAG_PREFIX = "itag";
    static final int MAX_INTRODUCERS = 3;

    public UDPAddress(RouterAddress addr) {
        if (addr == null) {
            return;
        }
        this._host = addr.getOption(PROP_HOST);
        if (this._host != null) {
            this._host = this._host.trim();
        }
        try {
            String port = addr.getOption(PROP_PORT);
            if (port != null) {
                this._port = Integer.parseInt(port);
            }
        }
        catch (NumberFormatException nfe) {
            this._port = -1;
        }
        try {
            String mtu = addr.getOption(PROP_MTU);
            if (mtu != null) {
                this._mtu = MTU.rectify(Integer.parseInt(mtu));
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String key = addr.getOption(PROP_INTRO_KEY);
        if (key != null) {
            this._introKey = Base64.decode((String)key.trim());
        }
        for (int i = 3; i >= 0; --i) {
            String t;
            byte[] ikey;
            String k;
            String port;
            String host = addr.getOption(PROP_INTRO_HOST_PREFIX + i);
            if (host == null || (port = addr.getOption(PROP_INTRO_PORT_PREFIX + i)) == null || (k = addr.getOption(PROP_INTRO_KEY_PREFIX + i)) == null || (ikey = Base64.decode((String)k)) == null || ikey.length != 32 || (t = addr.getOption(PROP_INTRO_TAG_PREFIX + i)) == null) continue;
            int p = -1;
            try {
                p = Integer.parseInt(port);
                if (p <= 0) continue;
                if (p > 65535) {
                }
            }
            catch (NumberFormatException nfe) {}
            continue;
            long tag = -1L;
            try {
                tag = Long.parseLong(t);
                if (tag <= 0L) {
                }
            }
            catch (NumberFormatException nfe) {}
            continue;
            if (this._introHosts == null) {
                this._introHosts = new String[i + 1];
                this._introPorts = new int[i + 1];
                this._introAddresses = new InetAddress[i + 1];
                this._introKeys = new byte[i + 1][];
                this._introTags = new long[i + 1];
            }
            this._introHosts[i] = host;
            this._introPorts[i] = p;
            this._introKeys[i] = ikey;
            this._introTags[i] = tag;
        }
        int numOK = 0;
        if (this._introHosts != null) {
            for (int i = 0; i < this._introHosts.length; ++i) {
                if (this._introKeys[i] == null || this._introPorts[i] <= 0 || this._introTags[i] <= 0L || this._introHosts[i] == null) continue;
                ++numOK;
            }
            if (numOK != this._introHosts.length) {
                String[] hosts = new String[numOK];
                int[] ports = new int[numOK];
                long[] tags = new long[numOK];
                byte[][] keys = new byte[numOK][];
                int cur = 0;
                for (int i = 0; i < this._introHosts.length; ++i) {
                    if (this._introKeys[i] == null || this._introPorts[i] <= 0 || this._introTags[i] <= 0L || this._introHosts[i] == null) continue;
                    hosts[cur] = this._introHosts[i];
                    ports[cur] = this._introPorts[i];
                    tags[cur] = this._introTags[i];
                    keys[cur] = this._introKeys[i];
                }
                this._introKeys = keys;
                this._introTags = tags;
                this._introPorts = ports;
                this._introHosts = hosts;
                this._introAddresses = new InetAddress[numOK];
            }
        }
    }

    public String getHost() {
        return this._host;
    }

    InetAddress getHostAddress() {
        if (this._hostAddress == null) {
            try {
                this._hostAddress = InetAddress.getByName(this._host);
            }
            catch (UnknownHostException uhe) {
                this._hostAddress = null;
            }
        }
        return this._hostAddress;
    }

    public int getPort() {
        return this._port;
    }

    byte[] getIntroKey() {
        return this._introKey;
    }

    int getIntroducerCount() {
        return this._introAddresses == null ? 0 : this._introAddresses.length;
    }

    InetAddress getIntroducerHost(int i) {
        if (this._introAddresses[i] == null) {
            try {
                this._introAddresses[i] = InetAddress.getByName(this._introHosts[i]);
            }
            catch (UnknownHostException uhe) {
                this._introAddresses[i] = null;
            }
        }
        return this._introAddresses[i];
    }

    int getIntroducerPort(int i) {
        return this._introPorts[i];
    }

    byte[] getIntroducerKey(int i) {
        return this._introKeys[i];
    }

    long getIntroducerTag(int i) {
        return this._introTags[i];
    }

    int getMTU() {
        return this._mtu;
    }

    public String toString() {
        StringBuilder rv = new StringBuilder(64);
        if (this._introHosts != null) {
            for (int i = 0; i < this._introHosts.length; ++i) {
                rv.append("ssu://");
                rv.append(this._introTags[i]).append('@');
                rv.append(this._introHosts[i]).append(':').append(this._introPorts[i]);
                if (i + 1 >= this._introKeys.length) continue;
                rv.append(", ");
            }
        } else if (this._host != null && this._port > 0) {
            rv.append("ssu://").append(this._host).append(':').append(this._port);
        } else {
            rv.append("ssu://autodetect.not.yet.complete:").append(this._port);
        }
        return rv.toString();
    }
}

