/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerTestState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class PeerTestManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder _packetBuilder;
    private final Map<Long, PeerTestState> _activeTests;
    private PeerTestState _currentTest;
    private boolean _currentTestComplete;
    private final Queue<Long> _recentTests;
    private static final int MAX_CHARLIE_LIFETIME = 10000;
    private static final int RESEND_TIMEOUT = 5000;
    private static final int MAX_TEST_TIME = 30000;
    private static final long MAX_NONCE = 0xFFFFFFFFL;
    private static final long CHARLIE_RECENT_PERIOD = 600000L;
    private static final int MAX_RELAYED_PER_TEST = 5;

    public PeerTestManager(RouterContext context, UDPTransport transport) {
        this._context = context;
        this._transport = transport;
        this._log = context.logManager().getLog(PeerTestManager.class);
        this._activeTests = new ConcurrentHashMap<Long, PeerTestState>();
        this._recentTests = new LinkedBlockingQueue<Long>();
        this._packetBuilder = new PacketBuilder(context, transport);
        this._context.statManager().createRateStat("udp.statusKnownCharlie", "How often the bob we pick passes us to a charlie we already have a session with?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveTestReply", "How often we get a reply to our peer test?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.receiveTest", "How often we get a packet requesting us to participate in a peer test?", "udp", UDPTransport.RATES);
    }

    public synchronized void runTest(InetAddress bobIP, int bobPort, SessionKey bobCipherKey, SessionKey bobMACKey) {
        if (this._currentTest != null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("We are already running a test with bob = " + this._currentTest.getBobIP() + ", aborting test with bob = " + bobIP);
            }
            return;
        }
        PeerTestState test = new PeerTestState();
        test.setNonce(this._context.random().nextLong(0xFFFFFFFFL));
        test.setBobIP(bobIP);
        test.setBobPort(bobPort);
        test.setBobCipherKey(bobCipherKey);
        test.setBobMACKey(bobMACKey);
        test.setBeginTime(this._context.clock().now());
        test.setLastSendTime(test.getBeginTime());
        test.setOurRole((short)1);
        this._currentTest = test;
        this._currentTestComplete = false;
        if (this._log.shouldLog(10)) {
            this._log.debug("Running test with bob = " + bobIP + ":" + bobPort + " " + test.getNonce());
        }
        while (this._recentTests.size() > 16) {
            this._recentTests.poll();
        }
        this._recentTests.offer(test.getNonce());
        this.sendTestToBob();
        this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)new ContinueTest(), 5000L);
    }

    private boolean expired() {
        PeerTestState state = this._currentTest;
        if (state != null) {
            return state.getBeginTime() + 30000L < this._context.clock().now();
        }
        return true;
    }

    private void sendTestToBob() {
        PeerTestState test = this._currentTest;
        if (!this.expired()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending test to bob: " + test.getBobIP() + ":" + test.getBobPort());
            }
            this._transport.send(this._packetBuilder.buildPeerTestFromAlice(test.getBobIP(), test.getBobPort(), test.getBobCipherKey(), test.getBobMACKey(), test.getNonce(), this._transport.getIntroKey()));
        } else {
            this._currentTest = null;
        }
    }

    private void sendTestToCharlie() {
        PeerTestState test = this._currentTest;
        if (!this.expired()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending test to charlie: " + test.getCharlieIP() + ":" + test.getCharliePort());
            }
            this._transport.send(this._packetBuilder.buildPeerTestFromAlice(test.getCharlieIP(), test.getCharliePort(), test.getCharlieIntroKey(), test.getNonce(), this._transport.getIntroKey()));
        } else {
            this._currentTest = null;
        }
    }

    private synchronized void receiveTestReply(RemoteHostId from, UDPPacketReader.PeerTestReader testInfo) {
        block24: {
            this._context.statManager().addRateData("udp.receiveTestReply", 1L, 0L);
            PeerTestState test = this._currentTest;
            if (this.expired()) {
                return;
            }
            if (this._currentTestComplete) {
                return;
            }
            if (DataHelper.eq((byte[])from.getIP(), (byte[])test.getBobIP().getAddress()) && from.getPort() == test.getBobPort()) {
                int ipSize = testInfo.readIPSize();
                if (ipSize != 4 && ipSize != 16) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Bad IP length " + ipSize + " from bob's reply: " + from + ", " + testInfo);
                    }
                    return;
                }
                byte[] ip = new byte[ipSize];
                testInfo.readIP(ip, 0);
                try {
                    InetAddress addr = InetAddress.getByAddress(ip);
                    test.setAliceIP(addr);
                    test.setReceiveBobTime(this._context.clock().now());
                    test.setAlicePort(testInfo.readPort());
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Receive test reply from bob @ " + from + " via our " + test.getAlicePort() + "/" + test.getAlicePortFromCharlie());
                    }
                    if (test.getAlicePortFromCharlie() > 0) {
                        this.testComplete(false);
                    }
                    break block24;
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Unable to get our IP (length " + ipSize + ") from bob's reply: " + from + ", " + testInfo, (Throwable)uhe);
                    }
                    break block24;
                }
            }
            PeerState charlieSession = this._transport.getPeerState(from);
            long recentBegin = this._context.clock().now() - 600000L;
            if (charlieSession != null && (charlieSession.getLastACKSend() > recentBegin || charlieSession.getLastSendTime() > recentBegin)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Bob chose a charlie we already have a session to, cancelling the test and rerunning (bob: " + this._currentTest + ", charlie: " + from + ")");
                }
                this._currentTestComplete = true;
                this._context.statManager().addRateData("udp.statusKnownCharlie", 1L, 0L);
                this.honorStatus((short)4);
                this._currentTest = null;
                return;
            }
            if (test.getReceiveCharlieTime() > 0L) {
                test.setAlicePortFromCharlie(testInfo.readPort());
                byte[] ip = new byte[testInfo.readIPSize()];
                testInfo.readIP(ip, 0);
                try {
                    InetAddress addr = InetAddress.getByAddress(ip);
                    test.setAliceIPFromCharlie(addr);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Receive test reply from charlie @ " + test.getCharlieIP() + " via our " + test.getAlicePort() + "/" + test.getAlicePortFromCharlie());
                    }
                    if (test.getReceiveBobTime() > 0L) {
                        this.testComplete(true);
                    }
                    break block24;
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Charlie @ " + from + " said we were an invalid IP address: " + uhe.getMessage(), (Throwable)uhe);
                    }
                    break block24;
                }
            }
            if (test.getPacketsRelayed() > 5) {
                this.testComplete(false);
                if (this._log.shouldLog(30)) {
                    this._log.warn("Received too many packets on the test: " + test);
                }
                return;
            }
            if (this._log.shouldLog(20) && charlieSession != null) {
                this._log.info("Bob chose a charlie we last acked " + DataHelper.formatDuration((long)(this._context.clock().now() - charlieSession.getLastACKSend())) + " last sent " + DataHelper.formatDuration((long)(this._context.clock().now() - charlieSession.getLastSendTime())) + " (bob: " + this._currentTest + ", charlie: " + from + ")");
            }
            test.setReceiveCharlieTime(this._context.clock().now());
            SessionKey charlieIntroKey = new SessionKey(new byte[32]);
            testInfo.readIntroKey(charlieIntroKey.getData(), 0);
            test.setCharlieIntroKey(charlieIntroKey);
            try {
                test.setCharlieIP(InetAddress.getByAddress(from.getIP()));
                test.setCharliePort(from.getPort());
                if (this._log.shouldLog(10)) {
                    this._log.debug("Receive test from charlie @ " + from);
                }
                this.sendTestToCharlie();
            }
            catch (UnknownHostException uhe) {
                if (!this._log.shouldLog(30)) break block24;
                this._log.warn("Charlie's IP is b0rked: " + from + ": " + testInfo);
            }
        }
    }

    private void testComplete(boolean forgetTest) {
        this._currentTestComplete = true;
        short status = -1;
        PeerTestState test = this._currentTest;
        status = test.getAlicePortFromCharlie() > 0 ? (test.getAlicePort() == test.getAlicePortFromCharlie() && test.getAliceIP() != null && test.getAliceIPFromCharlie() != null && test.getAliceIP().equals(test.getAliceIPFromCharlie()) ? (short)0 : 1) : (test.getReceiveCharlieTime() > 0L ? (short)4 : (test.getReceiveBobTime() > 0L ? (short)2 : 4));
        if (this._log.shouldLog(20)) {
            this._log.info("Test complete: " + test);
        }
        this.honorStatus(status);
        if (forgetTest) {
            this._currentTest = null;
        }
    }

    private void honorStatus(short status) {
        if (this._log.shouldLog(20)) {
            this._log.info("Test results: status = " + status);
        }
        this._transport.setReachabilityStatus(status);
    }

    public void receiveTest(RemoteHostId from, UDPPacketReader reader) {
        PeerTestState state;
        this._context.statManager().addRateData("udp.receiveTest", 1L, 0L);
        UDPPacketReader.PeerTestReader testInfo = reader.getPeerTestReader();
        byte[] testIP = null;
        int testPort = testInfo.readPort();
        long nonce = testInfo.readNonce();
        PeerTestState test = this._currentTest;
        if (test != null && test.getNonce() == nonce) {
            this.receiveTestReply(from, testInfo);
            return;
        }
        if (testInfo.readIPSize() > 0 && testPort > 0) {
            testIP = new byte[testInfo.readIPSize()];
            testInfo.readIP(testIP, 0);
        }
        if ((state = this._activeTests.get(nonce)) == null) {
            if (testIP == null || testPort <= 0) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("test IP/port are blank coming from " + from + ", assuming we are Bob and they are alice");
                }
                this.receiveFromAliceAsBob(from, testInfo, nonce, null);
            } else if (!this._recentTests.contains(nonce)) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("We are charlie, as the testIP/port is " + Addresses.toString((byte[])testIP, (int)testPort) + " and the state is unknown for " + nonce);
                }
                this.receiveFromBobAsCharlie(from, testInfo, nonce, null);
            }
        } else if (state.getOurRole() == 2) {
            if (DataHelper.eq((byte[])from.getIP(), (byte[])state.getAliceIP().getAddress()) && from.getPort() == state.getAlicePort()) {
                this.receiveFromAliceAsBob(from, testInfo, nonce, state);
            } else if (DataHelper.eq((byte[])from.getIP(), (byte[])state.getCharlieIP().getAddress()) && from.getPort() == state.getCharliePort()) {
                this.receiveFromCharlieAsBob(from, state);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Received from a fourth party as bob!  alice: " + state.getAliceIP() + ", charlie: " + state.getCharlieIP() + ", dave: " + from);
            }
        } else if (state.getOurRole() == 3) {
            if (testIP == null || testPort <= 0) {
                this.receiveFromAliceAsCharlie(from, testInfo, nonce);
            } else {
                this.receiveFromBobAsCharlie(from, testInfo, nonce, state);
            }
        }
    }

    private void receiveFromBobAsCharlie(RemoteHostId from, UDPPacketReader.PeerTestReader testInfo, long nonce, PeerTestState state) {
        block10: {
            boolean isNew = false;
            if (state == null) {
                isNew = true;
                state = new PeerTestState();
                state.setOurRole((short)3);
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive test as charlie nonce " + nonce);
            }
            int sz = testInfo.readIPSize();
            byte[] aliceIPData = new byte[sz];
            try {
                testInfo.readIP(aliceIPData, 0);
                int alicePort = testInfo.readPort();
                InetAddress aliceIP = InetAddress.getByAddress(aliceIPData);
                InetAddress bobIP = InetAddress.getByAddress(from.getIP());
                SessionKey aliceIntroKey = new SessionKey(new byte[32]);
                testInfo.readIntroKey(aliceIntroKey.getData(), 0);
                state.setAliceIP(aliceIP);
                state.setAlicePort(alicePort);
                state.setAliceIntroKey(aliceIntroKey);
                state.setNonce(nonce);
                state.setBobIP(bobIP);
                state.setBobPort(from.getPort());
                state.setLastSendTime(this._context.clock().now());
                state.setOurRole((short)3);
                state.setReceiveBobTime(this._context.clock().now());
                PeerState bob = this._transport.getPeerState(from);
                if (bob == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Received from bob (" + from + ") who hasn't established a session with us, refusing to help him test " + aliceIP + ":" + alicePort);
                    }
                    return;
                }
                state.setBobCipherKey(bob.getCurrentCipherKey());
                state.setBobMACKey(bob.getCurrentMACKey());
                state.incrementPacketsRelayed();
                if (state.getPacketsRelayed() > 5) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Receive from bob (" + from + ") as charlie with alice @ " + aliceIP + ":" + alicePort + ", but we've already relayed too many packets to that test, so we're dropping it");
                    }
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Receive from bob (" + from + ") as charlie, sending back to bob and sending to alice @ " + aliceIP + ":" + alicePort);
                }
                if (isNew) {
                    this._activeTests.put(nonce, state);
                    this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)new RemoveTest(nonce), 10000L);
                }
                UDPPacket packet = this._packetBuilder.buildPeerTestToBob(bobIP, from.getPort(), aliceIP, alicePort, aliceIntroKey, nonce, state.getBobCipherKey(), state.getBobMACKey());
                this._transport.send(packet);
                packet = this._packetBuilder.buildPeerTestToAlice(aliceIP, alicePort, aliceIntroKey, this._transport.getIntroKey(), nonce);
                this._transport.send(packet);
            }
            catch (UnknownHostException uhe) {
                if (!this._log.shouldLog(30)) break block10;
                this._log.warn("Unable to build the aliceIP from " + from + ", ip size: " + sz + " ip val: " + Base64.encode((byte[])aliceIPData), (Throwable)uhe);
            }
        }
    }

    private void receiveFromAliceAsBob(RemoteHostId from, UDPPacketReader.PeerTestReader testInfo, long nonce, PeerTestState state) {
        block13: {
            PeerState charlie = null;
            RouterInfo charlieInfo = null;
            if (state == null) {
                charlie = this._transport.pickTestPeer(from);
                if (charlie != null) {
                    charlieInfo = this._context.netDb().lookupRouterInfoLocally(charlie.getRemotePeer());
                }
            } else {
                charlie = this._transport.getPeerState(new RemoteHostId(state.getCharlieIP().getAddress(), state.getCharliePort()));
                if (charlie != null) {
                    charlieInfo = this._context.netDb().lookupRouterInfoLocally(charlie.getRemotePeer());
                }
            }
            if (charlie == null || charlieInfo == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to pick a charlie");
                }
                return;
            }
            InetAddress aliceIP = null;
            SessionKey aliceIntroKey = null;
            try {
                aliceIP = InetAddress.getByAddress(from.getIP());
                aliceIntroKey = new SessionKey(new byte[32]);
                testInfo.readIntroKey(aliceIntroKey.getData(), 0);
                UDPAddress addr = new UDPAddress(charlieInfo.getTargetAddress("SSU"));
                SessionKey charlieIntroKey = new SessionKey(addr.getIntroKey());
                boolean isNew = false;
                if (state == null) {
                    isNew = true;
                    state = new PeerTestState();
                    state.setBeginTime(this._context.clock().now());
                }
                state.setAliceIP(aliceIP);
                state.setAlicePort(from.getPort());
                state.setAliceIntroKey(aliceIntroKey);
                state.setNonce(nonce);
                state.setCharlieIP(charlie.getRemoteIPAddress());
                state.setCharliePort(charlie.getRemotePort());
                state.setCharlieIntroKey(charlieIntroKey);
                state.setLastSendTime(this._context.clock().now());
                state.setOurRole((short)2);
                state.setReceiveAliceTime(this._context.clock().now());
                state.incrementPacketsRelayed();
                if (state.getPacketsRelayed() > 5) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Receive from alice (" + aliceIP + ":" + from.getPort() + ") as bob, but we've already relayed too many packets to that test, so we're dropping it");
                    }
                    return;
                }
                if (isNew) {
                    this._activeTests.put(nonce, state);
                    this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)new RemoveTest(nonce), 10000L);
                }
                UDPPacket packet = this._packetBuilder.buildPeerTestToCharlie(aliceIP, from.getPort(), aliceIntroKey, nonce, charlie.getRemoteIPAddress(), charlie.getRemotePort(), charlie.getCurrentCipherKey(), charlie.getCurrentMACKey());
                if (this._log.shouldLog(10)) {
                    this._log.debug("Receive from alice as bob for " + nonce + ", picking charlie @ " + charlie.getRemoteIPAddress() + ":" + charlie.getRemotePort() + " for alice @ " + aliceIP + ":" + from.getPort());
                }
                this._transport.send(packet);
            }
            catch (UnknownHostException uhe) {
                if (!this._log.shouldLog(30)) break block13;
                this._log.warn("Unable to build the aliceIP from " + from, (Throwable)uhe);
            }
        }
    }

    private void receiveFromCharlieAsBob(RemoteHostId from, PeerTestState state) {
        state.setReceiveCharlieTime(this._context.clock().now());
        state.incrementPacketsRelayed();
        if (state.getPacketsRelayed() > 5) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Received from charlie (" + from + ") as bob (" + state + "), but we've already relayed too many, so drop it");
            }
            return;
        }
        UDPPacket packet = this._packetBuilder.buildPeerTestToAlice(state.getAliceIP(), state.getAlicePort(), state.getAliceIntroKey(), state.getCharlieIntroKey(), state.getNonce());
        if (this._log.shouldLog(10)) {
            this._log.debug("Receive from charlie @ " + from + " as bob, sending alice back the ok @ " + state.getAliceIP() + ":" + state.getAlicePort());
        }
        this._transport.send(packet);
    }

    private void receiveFromAliceAsCharlie(RemoteHostId from, UDPPacketReader.PeerTestReader testInfo, long nonce) {
        block3: {
            try {
                InetAddress aliceIP = InetAddress.getByAddress(from.getIP());
                SessionKey aliceIntroKey = new SessionKey(new byte[32]);
                testInfo.readIntroKey(aliceIntroKey.getData(), 0);
                UDPPacket packet = this._packetBuilder.buildPeerTestToAlice(aliceIP, from.getPort(), aliceIntroKey, this._transport.getIntroKey(), nonce);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Receive from alice as charlie, w/ alice @ " + aliceIP + ":" + from.getPort() + " and nonce " + nonce);
                }
                this._transport.send(packet);
            }
            catch (UnknownHostException uhe) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Unable to build the aliceIP from " + from, (Throwable)uhe);
            }
        }
    }

    private class ContinueTest
    implements SimpleTimer.TimedEvent {
        private ContinueTest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            PeerTestManager peerTestManager = PeerTestManager.this;
            synchronized (peerTestManager) {
                PeerTestState state = PeerTestManager.this._currentTest;
                if (state == null) {
                    return;
                }
                if (PeerTestManager.this.expired()) {
                    PeerTestManager.this.testComplete(true);
                } else if (PeerTestManager.this._context.clock().now() - state.getLastSendTime() >= 5000L) {
                    if (state.getReceiveBobTime() <= 0L) {
                        PeerTestManager.this.sendTestToBob();
                    } else if (state.getReceiveCharlieTime() <= 0L) {
                        PeerTestManager.this.sendTestToBob();
                    } else {
                        PeerTestManager.this.sendTestToCharlie();
                    }
                    PeerTestManager.this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)this, 5000L);
                }
            }
        }
    }

    private class RemoveTest
    implements SimpleTimer.TimedEvent {
        private long _nonce;

        public RemoveTest(long nonce) {
            this._nonce = nonce;
        }

        public void timeReached() {
            PeerTestManager.this._activeTests.remove(this._nonce);
        }
    }
}

