/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.OutboundMessageFragments;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPSender;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class PacketPusher
implements Runnable {
    private final Log _log;
    private final OutboundMessageFragments _fragments;
    private final UDPSender _sender;
    private volatile boolean _alive;

    public PacketPusher(RouterContext ctx, OutboundMessageFragments fragments, UDPSender sender) {
        this._log = ctx.logManager().getLog(PacketPusher.class);
        this._fragments = fragments;
        this._sender = sender;
    }

    public void startup() {
        this._alive = true;
        I2PThread t = new I2PThread((Runnable)this, "UDP packet pusher", true);
        t.start();
    }

    public void shutdown() {
        this._alive = false;
    }

    public void run() {
        while (this._alive) {
            try {
                UDPPacket[] packets = this._fragments.getNextVolley();
                if (packets == null) continue;
                for (int i = 0; i < packets.length; ++i) {
                    if (packets[i] == null) continue;
                    this._sender.add(packets[i]);
                }
            }
            catch (Exception e) {
                this._log.error("SSU Output Queue Error", (Throwable)e);
            }
        }
    }
}

