/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

class OutboundMessageState {
    private final I2PAppContext _context;
    private final Log _log;
    private OutNetMessage _message;
    private long _messageId;
    private PeerState _peer;
    private long _expiration;
    private ByteArray _messageBuf;
    private int _fragmentSize;
    private short[] _fragmentSends;
    private long _startedOn;
    private long _nextSendTime;
    private int _pushCount;
    private short _maxSends;
    private boolean _released;
    private Exception _releasedBy;
    public static final int MAX_MSG_SIZE = 32768;
    private static final int MAX_ENTRIES = 64;
    private static final ByteCache _cache = ByteCache.getInstance((int)64, (int)32768);
    private static final long EXPIRATION = 10000L;

    public OutboundMessageState(I2PAppContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(OutboundMessageState.class);
    }

    public boolean initialize(I2NPMessage msg, PeerState peer) {
        if (msg == null) {
            return false;
        }
        try {
            return this.initialize(null, msg, peer);
        }
        catch (OutOfMemoryError oom) {
            throw oom;
        }
        catch (Exception e) {
            this._log.log(50, "Error initializing " + msg, (Throwable)e);
            return false;
        }
    }

    public boolean initialize(OutNetMessage m, I2NPMessage msg) {
        if (m == null || msg == null) {
            return false;
        }
        try {
            return this.initialize(m, msg, null);
        }
        catch (OutOfMemoryError oom) {
            throw oom;
        }
        catch (Exception e) {
            this._log.log(50, "Error initializing " + msg, (Throwable)e);
            return false;
        }
    }

    private boolean initialize(OutNetMessage m, I2NPMessage msg, PeerState peer) {
        this._message = m;
        this._peer = peer;
        if (this._messageBuf != null) {
            _cache.release(this._messageBuf);
            this._messageBuf = null;
        }
        this._messageBuf = _cache.acquire();
        int size = msg.getRawMessageSize();
        if (size > this._messageBuf.getData().length) {
            throw new IllegalArgumentException("Size too large!  " + size + " in " + msg);
        }
        try {
            int len = msg.toRawByteArray(this._messageBuf.getData());
            this._messageBuf.setValid(len);
            this._messageId = msg.getUniqueId();
            this._nextSendTime = this._startedOn = this._context.clock().now();
            this._expiration = this._startedOn + 10000L;
            if (this._log.shouldLog(10)) {
                this._log.debug("Raw byte array for " + this._messageId + ": " + Base64.encode((byte[])this._messageBuf.getData(), (int)0, (int)len));
            }
            return true;
        }
        catch (IllegalStateException ise) {
            _cache.release(this._messageBuf);
            this._messageBuf = null;
            this._released = true;
            return false;
        }
    }

    public synchronized void releaseResources() {
        if (this._messageBuf != null && !this._released) {
            _cache.release(this._messageBuf);
            this._released = true;
            if (this._log.shouldLog(30)) {
                this._releasedBy = new Exception("Released on " + new Date() + " by:");
            }
        }
    }

    public OutNetMessage getMessage() {
        return this._message;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public PeerState getPeer() {
        return this._peer;
    }

    public void setPeer(PeerState peer) {
        this._peer = peer;
    }

    public boolean isExpired() {
        return this._expiration < this._context.clock().now();
    }

    public boolean isComplete() {
        short[] sends = this._fragmentSends;
        if (sends == null) {
            return false;
        }
        for (int i = 0; i < sends.length; ++i) {
            if (sends[i] < 0) continue;
            return false;
        }
        return true;
    }

    public int getUnackedSize() {
        short[] fragmentSends = this._fragmentSends;
        ByteArray messageBuf = this._messageBuf;
        int rv = 0;
        if (messageBuf != null && fragmentSends != null) {
            int totalSize = messageBuf.getValid();
            int lastSize = totalSize % this._fragmentSize;
            if (lastSize == 0) {
                lastSize = this._fragmentSize;
            }
            for (int i = 0; i < fragmentSends.length; ++i) {
                if (fragmentSends[i] < 0) continue;
                if (i + 1 == fragmentSends.length) {
                    rv += lastSize;
                    continue;
                }
                rv += this._fragmentSize;
            }
        }
        return rv;
    }

    public boolean needsSending(int fragment) {
        short[] sends = this._fragmentSends;
        if (sends == null || fragment >= sends.length || fragment < 0) {
            return false;
        }
        return sends[fragment] >= 0;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._startedOn;
    }

    public boolean acked(ACKBitfield bitfield) {
        short[] sends = this._fragmentSends;
        if (sends != null) {
            for (int i = 0; i < bitfield.fragmentCount() && i < sends.length; ++i) {
                if (!bitfield.received(i)) continue;
                sends[i] = -1;
            }
        }
        boolean rv = this.isComplete();
        return rv;
    }

    public long getNextSendTime() {
        return this._nextSendTime;
    }

    public void setNextSendTime(long when) {
        this._nextSendTime = when;
    }

    public int getMaxSends() {
        return this._maxSends;
    }

    public int getPushCount() {
        return this._pushCount;
    }

    public void push() {
        ++this._pushCount;
        if (this._pushCount > this._maxSends) {
            this._maxSends = (short)this._pushCount;
        }
        if (this._fragmentSends != null) {
            for (int i = 0; i < this._fragmentSends.length; ++i) {
                if (this._fragmentSends[i] < 0) continue;
                this._fragmentSends[i] = (short)(1 + this._fragmentSends[i]);
            }
        }
    }

    public boolean isFragmented() {
        return this._fragmentSends != null;
    }

    public void fragment(int fragmentSize) {
        int totalSize = this._messageBuf.getValid();
        int numFragments = totalSize / fragmentSize;
        if (numFragments * fragmentSize < totalSize) {
            ++numFragments;
        }
        if (numFragments > 64) {
            throw new IllegalArgumentException("Fragmenting a " + totalSize + " message into " + numFragments + " fragments - too many!");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Fragmenting a " + totalSize + " message into " + numFragments + " fragments");
        }
        this._fragmentSends = new short[numFragments];
        this._fragmentSize = fragmentSize;
    }

    public int getFragmentCount() {
        if (this._fragmentSends == null) {
            return -1;
        }
        return this._fragmentSends.length;
    }

    public int getFragmentSize() {
        return this._fragmentSize;
    }

    public boolean shouldSend(int fragmentNum) {
        return this._fragmentSends[fragmentNum] >= 0;
    }

    public int fragmentSize(int fragmentNum) {
        if (this._messageBuf == null) {
            return -1;
        }
        if (fragmentNum + 1 == this._fragmentSends.length) {
            int valid = this._messageBuf.getValid();
            if (valid <= this._fragmentSize) {
                return valid;
            }
            int mod = valid % this._fragmentSize;
            return mod == 0 ? this._fragmentSize : mod;
        }
        return this._fragmentSize;
    }

    public synchronized int writeFragment(byte[] out, int outOffset, int fragmentNum) {
        if (this._messageBuf == null) {
            return -1;
        }
        if (this._released) {
            if (this._log.shouldLog(30)) {
                this._log.log(30, "SSU OMS Use after free: " + this.toString(), (Throwable)this._releasedBy);
            }
            return -1;
        }
        int start = this._fragmentSize * fragmentNum;
        int end = start + this.fragmentSize(fragmentNum);
        int toSend = end - start;
        byte[] buf = this._messageBuf.getData();
        if (buf != null && start + toSend < buf.length && out != null && outOffset + toSend < out.length) {
            System.arraycopy(this._messageBuf.getData(), start, out, outOffset, toSend);
            if (this._log.shouldLog(10)) {
                this._log.debug("Raw fragment[" + fragmentNum + "] for " + this._messageId + "[" + start + "-" + (start + toSend) + "/" + this._messageBuf.getValid() + "/" + this._fragmentSize + "]: " + Base64.encode((byte[])out, (int)outOffset, (int)toSend));
            }
            return toSend;
        }
        return -1;
    }

    public String toString() {
        short[] sends = this._fragmentSends;
        ByteArray messageBuf = this._messageBuf;
        StringBuilder buf = new StringBuilder(256);
        buf.append("OB Message ").append(this._messageId);
        if (sends != null) {
            buf.append(" with ").append(sends.length).append(" fragments");
        }
        if (messageBuf != null) {
            buf.append(" of size ").append(messageBuf.getValid());
        }
        buf.append(" volleys: ").append(this._maxSends);
        buf.append(" lifetime: ").append(this.getLifetime());
        if (sends != null) {
            buf.append(" pending fragments: ");
            for (int i = 0; i < sends.length; ++i) {
                if (sends[i] < 0) continue;
                buf.append(i).append(' ');
            }
        }
        return buf.toString();
    }
}

