/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class Reader {
    private final RouterContext _context;
    private final Log _log;
    private final Set<NTCPConnection> _pendingConnections;
    private final Set<NTCPConnection> _liveReads;
    private final Set<NTCPConnection> _readAfterLive;
    private final List<Runner> _runners;

    public Reader(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._pendingConnections = new LinkedHashSet<NTCPConnection>(16);
        this._runners = new ArrayList<Runner>(8);
        this._liveReads = new HashSet<NTCPConnection>(8);
        this._readAfterLive = new HashSet<NTCPConnection>(8);
    }

    public void startReading(int numReaders) {
        for (int i = 1; i <= numReaders; ++i) {
            Runner r = new Runner();
            I2PThread t = new I2PThread((Runnable)r, "NTCP reader " + i + '/' + numReaders, true);
            this._runners.add(r);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReading() {
        while (!this._runners.isEmpty()) {
            Runner r = this._runners.remove(0);
            r.stop();
        }
        Set<NTCPConnection> set = this._pendingConnections;
        synchronized (set) {
            this._readAfterLive.clear();
            this._pendingConnections.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsRead(NTCPConnection con) {
        boolean already = false;
        Set<NTCPConnection> set = this._pendingConnections;
        synchronized (set) {
            if (this._liveReads.contains(con)) {
                this._readAfterLive.add(con);
                already = true;
            } else {
                this._pendingConnections.add(con);
            }
            this._pendingConnections.notify();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("wantsRead: " + con + " already live? " + already);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(NTCPConnection con) {
        Set<NTCPConnection> set = this._pendingConnections;
        synchronized (set) {
            this._readAfterLive.remove(con);
            this._pendingConnections.remove(con);
            this._pendingConnections.notify();
        }
    }

    private void processRead(NTCPConnection con) {
        if (con.isClosed()) {
            return;
        }
        ByteBuffer buf = null;
        while (!con.isClosed() && !con.isEstablished() && (buf = con.getNextReadBuf()) != null) {
            EstablishState est = con.getEstablishState();
            if (this._log.shouldLog(10)) {
                this._log.debug("Processing read buffer as an establishment for " + con + " with [" + est + "]");
            }
            if (est == null) {
                EventPumper.releaseBuf(buf);
                if (!con.isEstablished()) {
                    throw new RuntimeException("connection was not established, yet the establish state is null for " + con);
                }
                this._log.error("no establishment state but " + con + " is established... race?");
                break;
            }
            if (est.isComplete()) {
                this._log.error("establishment state [" + est + "] is complete, yet the connection isn't established? " + con.isEstablished() + " (inbound? " + con.isInbound() + " " + con + ")");
                EventPumper.releaseBuf(buf);
                break;
            }
            est.receive(buf);
            EventPumper.releaseBuf(buf);
            if (est.isCorrupt()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("closing connection on establishment because: " + est.getError(), (Throwable)est.getException());
                }
                if (!est.getFailedBySkew()) {
                    this._context.statManager().addRateData("ntcp.receiveCorruptEstablishment", 1L);
                }
                con.close();
                return;
            }
            if (!est.isComplete() || est.getExtraBytes() == null) continue;
            con.recvEncryptedI2NP(ByteBuffer.wrap(est.getExtraBytes()));
        }
        if (!con.isEstablished()) {
            return;
        }
        while (!con.isClosed() && (buf = con.getNextReadBuf()) != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Processing read buffer as part of an i2np message (" + buf.remaining() + " bytes)");
            }
            con.recvEncryptedI2NP(buf);
            EventPumper.releaseBuf(buf);
        }
    }

    private class Runner
    implements Runnable {
        private volatile boolean _stop;

        public void stop() {
            this._stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (Reader.this._log.shouldLog(20)) {
                Reader.this._log.info("Starting reader");
            }
            NTCPConnection con = null;
            while (!this._stop) {
                try {
                    Set set = Reader.this._pendingConnections;
                    synchronized (set) {
                        boolean keepReading;
                        boolean bl = keepReading = con != null && Reader.this._readAfterLive.remove(con);
                        if (!keepReading) {
                            Reader.this._liveReads.remove(con);
                            con = null;
                            if (Reader.this._pendingConnections.isEmpty()) {
                                Reader.this._pendingConnections.wait();
                            } else {
                                Iterator iter = Reader.this._pendingConnections.iterator();
                                con = (NTCPConnection)iter.next();
                                iter.remove();
                                Reader.this._liveReads.add(con);
                            }
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (this._stop || con == null) continue;
                if (Reader.this._log.shouldLog(10)) {
                    Reader.this._log.debug("begin read for " + con);
                }
                try {
                    Reader.this.processRead(con);
                }
                catch (RuntimeException re) {
                    Reader.this._log.log(50, "Error in the ntcp reader", (Throwable)re);
                }
                if (!Reader.this._log.shouldLog(10)) continue;
                Reader.this._log.debug("end read for " + con);
            }
            if (Reader.this._log.shouldLog(20)) {
                Reader.this._log.info("Stopping reader");
            }
        }
    }
}

