/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.Job;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportEventListener;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public abstract class TransportImpl
implements Transport {
    private final Log _log;
    private TransportEventListener _listener;
    private RouterAddress _currentAddress;
    private final List _sendPool;
    protected final RouterContext _context;
    private final Map<Hash, Long> _unreachableEntries;
    private final Set<Hash> _wasUnreachableEntries;
    private static final Map<Hash, byte[]> _IPMap = new ConcurrentHashMap<Hash, byte[]>(128);
    private static final int DEFAULT_MAX_CONNECTIONS = 425;
    private static final int MAX_CONNECTION_FACTOR = 50;
    private static final int DEFAULT_CAPACITY_PCT = 75;
    public static final boolean ADJUST_COST = true;
    private static final long UNREACHABLE_PERIOD = 300000L;

    public TransportImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(TransportImpl.class);
        this._context.statManager().createRateStat("transport.sendMessageFailureLifetime", "How long the lifetime of messages that fail are?", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.sendMessageSize", "Size of sent messages (bytes)", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.receiveMessageSize", "Size of received messages (bytes)", "Transport", new long[]{60000L, 300000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.receiveMessageTime", "How long it takes to read a message?", "Transport", new long[]{60000L, 300000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.receiveMessageTimeSlow", "How long it takes to read a message (when it takes more than a second)?", "Transport", new long[]{60000L, 300000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRequiredRateStat("transport.sendProcessingTime", "Time to process and send a message (ms)", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._context.statManager().createRateStat("transport.expiredOnQueueLifetime", "How long a message that expires on our outbound queue is processed", "Transport", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._sendPool = new ArrayList(16);
        this._unreachableEntries = new HashMap<Hash, Long>(16);
        this._wasUnreachableEntries = new ConcurrentHashSet(16);
        this._context.simpleScheduler().addPeriodicEvent((SimpleTimer.TimedEvent)new CleanupUnreachable(), 600000L, 150000L);
    }

    public int countPeers() {
        return this.countActivePeers();
    }

    public int countActivePeers() {
        return 0;
    }

    public int countActiveSendPeers() {
        return 0;
    }

    public int getMaxConnections() {
        char bw;
        String style = this.getStyle();
        String maxProp = style.equals("SSU") ? "i2np.udp.maxConnections" : (style.equals("NTCP") ? "i2np.ntcp.maxConnections" : "i2np." + style.toLowerCase(Locale.US) + ".maxConnections");
        int def = 425;
        RouterInfo ri = this._context.router().getRouterInfo();
        if (ri != null && (bw = ri.getBandwidthTier().charAt(0)) != 'U' && !((FloodfillNetworkDatabaseFacade)this._context.netDb()).floodfillEnabled()) {
            def = 50 * ('\u0001' + bw - 75);
        }
        if (style.equals("udp")) {
            def *= 3;
        }
        return this._context.getProperty(maxProp, def);
    }

    public boolean haveCapacity() {
        return this.haveCapacity(75);
    }

    public boolean haveCapacity(int pct) {
        return this.countPeers() < this.getMaxConnections() * pct / 100;
    }

    public Vector getClockSkews() {
        return new Vector();
    }

    public List getMostRecentErrorMessages() {
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutNetMessage getNextMessage() {
        OutNetMessage msg = null;
        List list = this._sendPool;
        synchronized (list) {
            if (this._sendPool.isEmpty()) {
                return null;
            }
            msg = (OutNetMessage)this._sendPool.remove(0);
        }
        msg.beginSend();
        return msg;
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful) {
        this.afterSend(msg, sendSuccessful, true, 0L);
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue) {
        this.afterSend(msg, sendSuccessful, allowRequeue, 0L);
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful, long msToSend) {
        this.afterSend(msg, sendSuccessful, true, msToSend);
    }

    protected void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue, long msToSend) {
        long lifetime;
        boolean log = false;
        if (sendSuccessful) {
            msg.timestamp("afterSend(successful)");
        } else {
            msg.timestamp("afterSend(failed)");
        }
        if (!sendSuccessful) {
            msg.transportFailed(this.getStyle());
        }
        if (msToSend > 1000L && this._log.shouldLog(30)) {
            this._log.warn(this.getStyle() + " afterSend slow: " + (sendSuccessful ? "success " : "FAIL ") + msg.getMessageSize() + " byte " + msg.getMessageType() + ' ' + msg.getMessageId() + " to " + msg.getTarget().getIdentity().calculateHash().toBase64().substring(0, 6) + " took " + msToSend + " ms");
        }
        if ((lifetime = msg.getLifetime()) > 3000L) {
            int level = 30;
            if (!sendSuccessful) {
                level = 20;
            }
            if (this._log.shouldLog(level)) {
                this._log.log(level, this.getStyle() + " afterSend slow (" + (sendSuccessful ? "success " : "FAIL ") + lifetime + "/" + msToSend + "): " + msg.getMessageSize() + " byte " + msg.getMessageType() + " " + msg.getMessageId() + " from " + this._context.routerHash().toBase64().substring(0, 6) + " to " + msg.getTarget().getIdentity().calculateHash().toBase64().substring(0, 6) + ": " + msg.toString());
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info(this.getStyle() + " afterSend: " + (sendSuccessful ? "success " : "FAIL ") + msg.getMessageSize() + " byte " + msg.getMessageType() + " " + msg.getMessageId() + " from " + this._context.routerHash().toBase64().substring(0, 6) + " to " + msg.getTarget().getIdentity().calculateHash().toBase64().substring(0, 6) + "\n" + msg.toString());
        }
        if (sendSuccessful) {
            Job j;
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getStyle() + " Sent " + msg.getMessageType() + " successfully to " + msg.getTarget().getIdentity().getHash().toBase64());
            }
            if ((j = msg.getOnSendJob()) != null) {
                this._context.jobQueue().addJob(j);
            }
            log = true;
            msg.discardData();
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getStyle() + " Failed to send " + msg.getMessageType() + " to " + msg.getTarget().getIdentity().getHash().toBase64() + " (details: " + msg + ')');
            }
            if (msg.getExpiration() < this._context.clock().now()) {
                this._context.statManager().addRateData("transport.expiredOnQueueLifetime", lifetime, lifetime);
            }
            if (allowRequeue) {
                if ((msg.getExpiration() <= 0L || msg.getExpiration() > this._context.clock().now()) && msg.getMessage() != null) {
                    this._context.outNetMessagePool().add(msg);
                } else {
                    MessageSelector selector;
                    if (this._log.shouldLog(20)) {
                        this._log.info("No more time left (" + new Date(msg.getExpiration()) + ", expiring without sending successfully the " + msg.getMessageType());
                    }
                    if (msg.getOnFailedSendJob() != null) {
                        this._context.jobQueue().addJob(msg.getOnFailedSendJob());
                    }
                    if ((selector = msg.getReplySelector()) != null) {
                        this._context.messageRegistry().unregisterPending(msg);
                    }
                    log = true;
                    msg.discardData();
                }
            } else {
                MessageSelector selector = msg.getReplySelector();
                if (this._log.shouldLog(20)) {
                    this._log.info("Failed and no requeue allowed for a " + msg.getMessageSize() + " byte " + msg.getMessageType() + " message with selector " + selector, (Throwable)new Exception("fail cause"));
                }
                if (msg.getOnFailedSendJob() != null) {
                    this._context.jobQueue().addJob(msg.getOnFailedSendJob());
                }
                if (msg.getOnFailedReplyJob() != null) {
                    this._context.jobQueue().addJob(msg.getOnFailedReplyJob());
                }
                if (selector != null) {
                    this._context.messageRegistry().unregisterPending(msg);
                }
                log = true;
                msg.discardData();
            }
        }
        if (log) {
            // empty if block
        }
        long now = this._context.clock().now();
        long sendTime = now - msg.getSendBegin();
        long allTime = now - msg.getCreated();
        if (allTime > 5000L) {
            if (this._log.shouldLog(20)) {
                this._log.info("Took too long from preperation to afterSend(ok? " + sendSuccessful + "): " + allTime + "ms/" + sendTime + "ms after failing on: " + msg.getFailedTransports() + " and succeeding on " + this.getStyle());
            }
            if (allTime > 60000L && sendSuccessful) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("WTF, more than a minute slow? " + msg.getMessageType() + " of id " + msg.getMessageId() + " (send begin on " + new Date(msg.getSendBegin()) + " / created on " + new Date(msg.getCreated()) + "): " + msg);
                }
                this._context.messageHistory().messageProcessingError(msg.getMessageId(), msg.getMessageType(), "Took too long to send [" + allTime + "ms]");
            }
        }
        if (sendSuccessful) {
            this._context.statManager().addRateData("transport.sendProcessingTime", lifetime, lifetime);
            this._context.profileManager().messageSent(msg.getTarget().getIdentity().getHash(), this.getStyle(), sendTime, msg.getMessageSize());
            this._context.statManager().addRateData("transport.sendMessageSize", msg.getMessageSize(), sendTime);
        } else {
            this._context.profileManager().messageFailed(msg.getTarget().getIdentity().getHash(), this.getStyle());
            this._context.statManager().addRateData("transport.sendMessageFailureLifetime", lifetime, lifetime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(OutNetMessage msg) {
        if (msg.getTarget() == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error - bad message enqueued [target is null]: " + msg, (Throwable)new Exception("Added by"));
            }
            return;
        }
        boolean duplicate = false;
        List list = this._sendPool;
        synchronized (list) {
            if (this._sendPool.contains(msg)) {
                duplicate = true;
            } else {
                this._sendPool.add(msg);
            }
        }
        if (duplicate && this._log.shouldLog(40)) {
            this._log.error("Message already is in the queue?  wtf.  msg = " + msg, (Throwable)new Exception("wtf, requeued?"));
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Message added to send pool");
        }
        msg.timestamp("send on " + this.getStyle());
        this.outboundMessageReady();
        if (this._log.shouldLog(20)) {
            this._log.debug("OutboundMessageReady called");
        }
    }

    protected abstract void outboundMessageReady();

    public void messageReceived(I2NPMessage inMsg, RouterIdentity remoteIdent, Hash remoteIdentHash, long msToReceive, int bytesReceived) {
        int level = 20;
        if (msToReceive > 5000L) {
            level = 30;
        }
        if (this._log.shouldLog(level)) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Message received: ").append(inMsg.getClass().getName());
            buf.append(" / ").append(inMsg.getUniqueId());
            buf.append(" in ").append(msToReceive).append("ms containing ");
            buf.append(bytesReceived).append(" bytes ");
            buf.append(" from ");
            if (remoteIdentHash != null) {
                buf.append(remoteIdentHash.toBase64());
            } else if (remoteIdent != null) {
                buf.append(remoteIdent.getHash().toBase64());
            } else {
                buf.append("[unknown]");
            }
            buf.append(" and forwarding to listener: ");
            if (this._listener != null) {
                buf.append(this._listener);
            }
            this._log.log(level, buf.toString());
        }
        if (remoteIdent != null) {
            remoteIdentHash = remoteIdent.getHash();
        }
        if (remoteIdentHash != null) {
            this._context.profileManager().messageReceived(remoteIdentHash, this.getStyle(), msToReceive, bytesReceived);
            this._context.statManager().addRateData("transport.receiveMessageSize", (long)bytesReceived, msToReceive);
        }
        this._context.statManager().addRateData("transport.receiveMessageTime", msToReceive, msToReceive);
        if (msToReceive > 1000L) {
            this._context.statManager().addRateData("transport.receiveMessageTimeSlow", msToReceive, msToReceive);
        }
        if (this._listener != null) {
            this._listener.messageReceived(inMsg, remoteIdent, remoteIdentHash);
        } else if (this._log.shouldLog(40)) {
            this._log.error("WTF! Null listener! this = " + this.toString(), (Throwable)new Exception("Null listener"));
        }
    }

    public RouterAddress getCurrentAddress() {
        return this._currentAddress;
    }

    public RouterAddress updateAddress() {
        return this._currentAddress;
    }

    protected void replaceAddress(RouterAddress address) {
        this._currentAddress = address;
        if (this._listener != null) {
            this._listener.transportAddressChanged();
        }
    }

    public void externalAddressReceived(String source, byte[] ip, int port) {
    }

    public void forwardPortStatus(int port, int externalPort, boolean success, String reason) {
    }

    public int getRequestedPort() {
        return -1;
    }

    public void setListener(TransportEventListener listener) {
        this._listener = listener;
    }

    public void renderStatusHTML(Writer out) throws IOException {
    }

    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        this.renderStatusHTML(out);
    }

    public RouterContext getContext() {
        return this._context;
    }

    public short getReachabilityStatus() {
        return 4;
    }

    public void recheckReachability() {
    }

    public boolean isBacklogged(Hash dest) {
        return false;
    }

    public boolean isEstablished(Hash dest) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnreachable(Hash peer) {
        long now = this._context.clock().now();
        Map<Hash, Long> map = this._unreachableEntries;
        synchronized (map) {
            Long when = this._unreachableEntries.get(peer);
            if (when == null) {
                return false;
            }
            if (when + 300000L < now) {
                this._unreachableEntries.remove(peer);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUnreachable(Hash peer) {
        long now = this._context.clock().now();
        Map<Hash, Long> map = this._unreachableEntries;
        synchronized (map) {
            this._unreachableEntries.put(peer, now);
        }
        this.markWasUnreachable(peer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markReachable(Hash peer, boolean isInbound) {
        this._context.shitlist().unshitlistRouter(peer);
        Map<Hash, Long> map = this._unreachableEntries;
        synchronized (map) {
            this._unreachableEntries.remove(peer);
        }
        if (!isInbound) {
            this.markWasUnreachable(peer, false);
        }
    }

    public boolean wasUnreachable(Hash peer) {
        if (this._wasUnreachableEntries.contains(peer)) {
            return true;
        }
        RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
        if (ri == null) {
            return false;
        }
        return null == ri.getTargetAddress(this.getStyle());
    }

    public void markWasUnreachable(Hash peer, boolean yes) {
        if (yes) {
            this._wasUnreachableEntries.add(peer);
        } else {
            this._wasUnreachableEntries.remove(peer);
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getStyle() + " setting wasUnreachable to " + yes + " for " + peer);
        }
    }

    public void setIP(Hash peer, byte[] ip) {
        _IPMap.put(peer, ip);
        this._context.commSystem().queueLookup(ip);
    }

    public static byte[] getIP(Hash peer) {
        return _IPMap.get(peer);
    }

    public static boolean isPubliclyRoutable(byte[] addr) {
        if (addr.length == 4) {
            int a0 = addr[0] & 0xFF;
            if (a0 == 127) {
                return false;
            }
            if (a0 == 10) {
                return false;
            }
            int a1 = addr[1] & 0xFF;
            if (a0 == 172 && a1 >= 16 && a1 <= 31) {
                return false;
            }
            if (a0 == 192 && a1 == 168) {
                return false;
            }
            if (a0 >= 224) {
                return false;
            }
            if (a0 == 0) {
                return false;
            }
            return a0 != 169 || a1 != 254;
        }
        if (addr.length == 16) {
            return false;
        }
        return false;
    }

    private class CleanupUnreachable
    implements SimpleTimer.TimedEvent {
        private CleanupUnreachable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            long now = TransportImpl.this._context.clock().now();
            Map map = TransportImpl.this._unreachableEntries;
            synchronized (map) {
                Iterator iter = TransportImpl.this._unreachableEntries.keySet().iterator();
                while (iter.hasNext()) {
                    Hash peer = (Hash)iter.next();
                    Long when = (Long)TransportImpl.this._unreachableEntries.get(peer);
                    if (when + 300000L >= now) continue;
                    iter.remove();
                }
            }
        }
    }
}

