/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

class GeoIP {
    private final Log _log;
    private final RouterContext _context;
    private final Map<String, String> _codeToName;
    private final Map<String, String> _codeCache;
    private final Map<Long, String> _IPToCountry;
    private final Set<Long> _pendingSearch;
    private final Set<Long> _notFound;
    private final AtomicBoolean _lock;
    private int _lookupRunCount;
    static final String PROP_GEOIP_ENABLED = "routerconsole.geoip.enable";
    static final String GEOIP_DIR_DEFAULT = "geoip";
    static final String GEOIP_FILE_DEFAULT = "geoip.txt";
    static final String COUNTRY_FILE_DEFAULT = "countries.txt";
    public static final String PROP_IP_COUNTRY = "i2np.lastCountry";

    public GeoIP(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(GeoIP.class);
        this._codeToName = new ConcurrentHashMap<String, String>(256);
        this._codeCache = new ConcurrentHashMap<String, String>(256);
        this._IPToCountry = new ConcurrentHashMap<Long, String>();
        this._pendingSearch = new ConcurrentHashSet();
        this._notFound = new ConcurrentHashSet();
        this._lock = new AtomicBoolean();
        this.readCountryFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockingLookup() {
        if (!Boolean.valueOf(this._context.getProperty(PROP_GEOIP_ENABLED, "true")).booleanValue()) {
            this._pendingSearch.clear();
            return;
        }
        int pri = Thread.currentThread().getPriority();
        if (pri > 1) {
            Thread.currentThread().setPriority(pri - 1);
        }
        try {
            LookupJob j = new LookupJob();
            j.run();
            this.updateOurCountry();
        }
        finally {
            if (pri > 1) {
                Thread.currentThread().setPriority(pri);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCountryFile() {
        File GeoFile = new File(this._context.getBaseDir(), GEOIP_DIR_DEFAULT);
        if (!(GeoFile = new File(GeoFile, COUNTRY_FILE_DEFAULT)).exists()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Country file not found: " + GeoFile.getAbsolutePath());
            }
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(GeoFile);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                try {
                    if (line.charAt(0) == '#') continue;
                    String[] s = line.split(",");
                    String lc = s[0].toLowerCase(Locale.US);
                    this._codeToName.put(lc, s[1]);
                    this._codeCache.put(lc, lc);
                }
                catch (IndexOutOfBoundsException ioobe) {}
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the Country File", (Throwable)ioe);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readGeoIPFile(Long[] search) {
        File GeoFile = new File(this._context.getBaseDir(), GEOIP_DIR_DEFAULT);
        if (!(GeoFile = new File(GeoFile, GEOIP_FILE_DEFAULT)).exists()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("GeoIP file not found: " + GeoFile.getAbsolutePath());
            }
            return new String[0];
        }
        String[] rv = new String[search.length];
        int idx = 0;
        long start = this._context.clock().now();
        FileInputStream in = null;
        try {
            in = new FileInputStream(GeoFile);
            String buf = null;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "ISO-8859-1"));
            while ((buf = br.readLine()) != null && idx < search.length) {
                try {
                    if (buf.charAt(0) == '#') continue;
                    String[] s = buf.split(",");
                    long ip1 = Long.parseLong(s[0]);
                    long ip2 = Long.parseLong(s[1]);
                    while (idx < search.length && search[idx] < ip1) {
                        ++idx;
                    }
                    while (idx < search.length && search[idx] >= ip1 && search[idx] <= ip2) {
                        String lc = s[2].toLowerCase(Locale.US);
                        String cached = this._codeCache.get(lc);
                        if (cached == null) {
                            cached = lc;
                        }
                        rv[idx++] = cached;
                    }
                }
                catch (IndexOutOfBoundsException ioobe) {
                }
                catch (NumberFormatException nfe) {
                }
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error reading the GeoFile", (Throwable)ioe);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("GeoIP processing finished, time: " + (this._context.clock().now() - start));
        }
        return rv;
    }

    private void updateOurCountry() {
        String oldCountry = this._context.router().getConfigSetting(PROP_IP_COUNTRY);
        Hash ourHash = this._context.routerHash();
        if (ourHash == null) {
            return;
        }
        String country = this._context.commSystem().getCountry(ourHash);
        if (country != null && !country.equals(oldCountry)) {
            this._context.router().saveConfig(PROP_IP_COUNTRY, country);
            if (this._context.commSystem().isInBadCountry() && this._context.getProperty("router.isHidden") == null) {
                String name = this.fullName(country);
                if (name == null) {
                    name = country;
                }
                this._log.logAlways(30, "Setting hidden mode to protect you in " + name + ", you may override on the network configuration page");
                this._context.router().rebuildRouterInfo();
            }
        }
    }

    public void add(String ip) {
        InetAddress pi;
        try {
            pi = InetAddress.getByName(ip);
        }
        catch (UnknownHostException uhe) {
            return;
        }
        if (pi == null) {
            return;
        }
        byte[] pib = pi.getAddress();
        this.add(pib);
    }

    public void add(byte[] ip) {
        if (ip.length != 4) {
            return;
        }
        this.add(GeoIP.toLong(ip));
    }

    private void add(long ip) {
        Long li = ip;
        if (!this._IPToCountry.containsKey(li) && !this._notFound.contains(li)) {
            this._pendingSearch.add(li);
        }
    }

    public String get(String ip) {
        InetAddress pi;
        try {
            pi = InetAddress.getByName(ip);
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        if (pi == null) {
            return null;
        }
        byte[] pib = pi.getAddress();
        return this.get(pib);
    }

    public String get(byte[] ip) {
        if (ip.length != 4) {
            return null;
        }
        return this.get(GeoIP.toLong(ip));
    }

    private String get(long ip) {
        return this._IPToCountry.get(ip);
    }

    private static long toLong(byte[] ip) {
        int rv = 0;
        for (int i = 0; i < 4; ++i) {
            rv |= (ip[i] & 0xFF) << (3 - i) * 8;
        }
        return (long)rv & 0xFFFFFFFFL;
    }

    public String fullName(String code) {
        return this._codeToName.get(code);
    }

    private class LookupJob
    implements Runnable {
        private static final int CLEAR = 8;

        private LookupJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (GeoIP.this._lock.getAndSet(true)) {
                return;
            }
            try {
                Object[] search;
                if (++GeoIP.this._lookupRunCount % 8 == 0) {
                    GeoIP.this._notFound.clear();
                }
                if ((search = GeoIP.this._pendingSearch.toArray(new Long[GeoIP.this._pendingSearch.size()])).length <= 0) {
                    return;
                }
                GeoIP.this._pendingSearch.clear();
                Arrays.sort(search);
                String[] countries = GeoIP.this.readGeoIPFile((Long[])search);
                for (int i = 0; i < countries.length; ++i) {
                    if (countries[i] != null) {
                        GeoIP.this._IPToCountry.put(search[i], countries[i]);
                        continue;
                    }
                    GeoIP.this._notFound.add(search[i]);
                }
            }
            finally {
                GeoIP.this._lock.set(false);
            }
        }
    }
}

