/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.BadCountries;
import net.i2p.router.transport.GeoIP;
import net.i2p.router.transport.GetBidsJob;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.Translate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommSystemFacadeImpl
extends CommSystemFacade {
    private final Log _log;
    private final RouterContext _context;
    private TransportManager _manager;
    private GeoIP _geoIP;
    public static final String PROP_I2NP_NTCP_HOSTNAME = "i2np.ntcp.hostname";
    public static final String PROP_I2NP_NTCP_PORT = "i2np.ntcp.port";
    public static final String PROP_I2NP_NTCP_AUTO_PORT = "i2np.ntcp.autoport";
    public static final String PROP_I2NP_NTCP_AUTO_IP = "i2np.ntcp.autoip";
    private static final int START_DELAY = 300000;
    private static final int LOOKUP_TIME = 1800000;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";
    private static final int TIME_START_DELAY = 300000;
    private static final int TIME_REPEAT_DELAY = 600000;

    public CommSystemFacadeImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(CommSystemFacadeImpl.class);
        this._context.statManager().createRateStat("transport.getBidsJobTime", "How long does it take?", "Transport", new long[]{600000L});
        this.startGeoIP();
    }

    @Override
    public void startup() {
        this._log.info("Starting up the comm system");
        this._manager = new TransportManager(this._context);
        this._manager.startListening();
        this.startTimestamper();
    }

    @Override
    public void shutdown() {
        if (this._manager != null) {
            this._manager.shutdown();
        }
    }

    @Override
    public void restart() {
        if (this._manager == null) {
            this.startup();
        } else {
            this._manager.restart();
        }
    }

    @Override
    public int countActivePeers() {
        return this._manager == null ? 0 : this._manager.countActivePeers();
    }

    @Override
    public int countActiveSendPeers() {
        return this._manager == null ? 0 : this._manager.countActiveSendPeers();
    }

    @Override
    public boolean haveInboundCapacity(int pct) {
        return this._manager == null ? false : this._manager.haveInboundCapacity(pct);
    }

    @Override
    public boolean haveOutboundCapacity(int pct) {
        return this._manager == null ? false : this._manager.haveOutboundCapacity(pct);
    }

    @Override
    public boolean haveHighOutboundCapacity() {
        return this._manager == null ? false : this._manager.haveHighOutboundCapacity();
    }

    @Override
    public long getFramedAveragePeerClockSkew(int percentToInclude) {
        if (this._manager == null) {
            return this._context.clock().getOffset();
        }
        Vector skews = this._manager.getClockSkews();
        if (skews == null || skews.isEmpty() || skews.size() < 5 && this._context.clock().getUpdatedSuccessfully()) {
            return this._context.clock().getOffset();
        }
        Collections.sort(skews);
        if (this._log.shouldLog(10)) {
            this._log.debug("Clock skews: " + skews);
        }
        int frameSize = Math.max(skews.size() * percentToInclude / 100, 1);
        int first = skews.size() / 2 - frameSize / 2;
        int last = Math.min(skews.size() / 2 + frameSize / 2, skews.size() - 1);
        long sum = 0L;
        for (int i = first; i <= last; ++i) {
            long value = (Long)skews.get(i);
            sum += value;
        }
        return sum * 1000L / (long)frameSize;
    }

    public List<TransportBid> getBids(OutNetMessage msg) {
        return this._manager.getBids(msg);
    }

    public TransportBid getBid(OutNetMessage msg) {
        return this._manager.getBid(msg);
    }

    public TransportBid getNextBid(OutNetMessage msg) {
        return this._manager.getNextBid(msg);
    }

    int getTransportCount() {
        return this._manager.getTransportCount();
    }

    @Override
    public void processMessage(OutNetMessage msg) {
        long before = this._context.clock().now();
        GetBidsJob.getBids(this._context, this, msg);
        this._context.statManager().addRateData("transport.getBidsJobTime", this._context.clock().now() - before, 0L);
    }

    @Override
    public boolean isBacklogged(Hash dest) {
        return this._manager != null && this._manager.isBacklogged(dest);
    }

    @Override
    public boolean isEstablished(Hash dest) {
        return this._manager != null && this._manager.isEstablished(dest);
    }

    @Override
    public boolean wasUnreachable(Hash dest) {
        return this._manager != null && this._manager.wasUnreachable(dest);
    }

    @Override
    public byte[] getIP(Hash dest) {
        return this._manager.getIP(dest);
    }

    @Override
    public List getMostRecentErrorMessages() {
        return this._manager.getMostRecentErrorMessages();
    }

    @Override
    public short getReachabilityStatus() {
        if (this._manager == null) {
            return 4;
        }
        if (this._context.router().isHidden()) {
            return 0;
        }
        return this._manager.getReachabilityStatus();
    }

    @Override
    public void recheckReachability() {
        this._manager.recheckReachability();
    }

    @Override
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        this._manager.renderStatusHTML(out, urlBase, sortFlags);
    }

    @Override
    public Set<RouterAddress> createAddresses() {
        Map<String, RouterAddress> addresses = null;
        boolean newCreated = false;
        if (this._manager != null) {
            addresses = this._manager.getAddresses();
        } else {
            addresses = new HashMap<String, RouterAddress>(1);
            newCreated = true;
        }
        if (!addresses.containsKey("NTCP")) {
            RouterAddress addr = CommSystemFacadeImpl.createNTCPAddress(this._context);
            if (this._log.shouldLog(20)) {
                this._log.info("NTCP address: " + addr);
            }
            if (addr != null) {
                addresses.put("NTCP", addr);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Creating addresses: " + addresses + " isNew? " + newCreated, (Throwable)new Exception("creator"));
        }
        return new HashSet<RouterAddress>(addresses.values());
    }

    public static RouterAddress createNTCPAddress(RouterContext ctx) {
        if (!TransportManager.isNTCPEnabled(ctx)) {
            return null;
        }
        String name = ctx.router().getConfigSetting(PROP_I2NP_NTCP_HOSTNAME);
        String port = ctx.router().getConfigSetting(PROP_I2NP_NTCP_PORT);
        if (name == null || port == null || name.trim().length() <= 0 || "null".equals(name)) {
            return null;
        }
        try {
            int p = Integer.parseInt(port);
            if (p <= 0 || p > 65536) {
                return null;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        Properties props = new Properties();
        props.setProperty("host", name);
        props.setProperty("port", port);
        RouterAddress addr = new RouterAddress();
        addr.setCost(10);
        addr.setExpiration(null);
        addr.setOptions(props);
        addr.setTransportStyle("NTCP");
        HashMap<String, String> changes = new HashMap<String, String>();
        changes.put(PROP_I2NP_NTCP_HOSTNAME, name);
        changes.put(PROP_I2NP_NTCP_PORT, port);
        ctx.router().saveConfig(changes, null);
        return addr;
    }

    @Override
    public synchronized void notifyReplaceAddress(RouterAddress UDPAddr) {
        if (UDPAddr == null) {
            return;
        }
        NTCPTransport t = (NTCPTransport)this._manager.getTransport("NTCP");
        if (t == null) {
            return;
        }
        RouterAddress oldAddr = t.getCurrentAddress();
        if (this._log.shouldLog(20)) {
            this._log.info("Changing NTCP Address? was " + oldAddr);
        }
        RouterAddress newAddr = new RouterAddress();
        newAddr.setTransportStyle("NTCP");
        Properties newProps = new Properties();
        if (oldAddr == null) {
            newAddr.setCost(10);
        } else {
            newAddr.setCost(oldAddr.getCost());
            newProps.putAll((Map<?, ?>)oldAddr.getOptionsMap());
        }
        boolean changed = false;
        String oport = newProps.getProperty("port");
        String nport = null;
        String cport = this._context.getProperty(PROP_I2NP_NTCP_PORT);
        if (cport != null && cport.length() > 0) {
            nport = cport;
        } else if (this._context.getBooleanPropertyDefaultTrue(PROP_I2NP_NTCP_AUTO_PORT)) {
            nport = UDPAddr.getOption("port");
        }
        if (this._log.shouldLog(20)) {
            this._log.info("old: " + oport + " config: " + cport + " new: " + nport);
        }
        if (nport == null || nport.length() <= 0) {
            return;
        }
        if (oport == null || !oport.equals(nport)) {
            newProps.setProperty("port", nport);
            changed = true;
        }
        String ohost = newProps.getProperty("host");
        String enabled = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "true").toLowerCase(Locale.US);
        String name = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        if (name != null && name.length() > 0) {
            enabled = "false";
        }
        Transport udp = this._manager.getTransport("SSU");
        int status = 4;
        if (udp != null) {
            status = udp.getReachabilityStatus();
        }
        if (this._log.shouldLog(20)) {
            this._log.info("old: " + ohost + " config: " + name + " auto: " + enabled + " status: " + status);
        }
        if (enabled.equals("always") || Boolean.valueOf(enabled).booleanValue() && status == 0) {
            String nhost = UDPAddr.getOption("host");
            if (this._log.shouldLog(20)) {
                this._log.info("old: " + ohost + " config: " + name + " new: " + nhost);
            }
            if (nhost == null || nhost.length() <= 0) {
                return;
            }
            if (ohost == null || !ohost.equalsIgnoreCase(nhost)) {
                newProps.setProperty("host", nhost);
                changed = true;
            }
        } else if (enabled.equals("false") && name != null && name.length() > 0 && !name.equals(ohost) && nport != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("old: " + ohost + " config: " + name + " new: " + name);
            }
            newProps.setProperty("host", name);
            changed = true;
        } else {
            if (ohost == null || ohost.length() <= 0) {
                return;
            }
            if (Boolean.valueOf(enabled).booleanValue() && status != 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("old: " + ohost + " config: " + name + " new: null");
                }
                newAddr = null;
                changed = true;
            }
        }
        if (!changed) {
            if (oldAddr != null) {
                int oldCost = oldAddr.getCost();
                int newCost = 10;
                if (!t.haveCapacity()) {
                    ++newCost;
                }
                if (newCost != oldCost) {
                    oldAddr.setCost(newCost);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Changing NTCP cost from " + oldCost + " to " + newCost);
                    }
                } else {
                    this._log.info("No change to NTCP Address");
                }
            } else {
                this._log.info("No change to NTCP Address");
            }
            return;
        }
        this._log.warn("Halting NTCP to change address");
        t.stopListening();
        if (newAddr != null) {
            newAddr.setOptions(newProps);
        }
        while (t.isAlive()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {}
        }
        t.restartListening(newAddr);
        this._log.warn("Changed NTCP Address and started up, address is now " + newAddr);
    }

    private void startGeoIP() {
        this._geoIP = new GeoIP(this._context);
        this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)new QueueAll(), 300000L);
    }

    @Override
    public void queueLookup(byte[] ip) {
        this._geoIP.add(ip);
    }

    @Override
    public String getOurCountry() {
        return this._context.getProperty("i2np.lastCountry");
    }

    @Override
    public boolean isInBadCountry() {
        String us = this.getOurCountry();
        return us != null && (BadCountries.contains(us) || this._context.getBooleanProperty("router.forceBadCountry"));
    }

    @Override
    public String getCountry(Hash peer) {
        byte[] ip = TransportImpl.getIP(peer);
        if (ip != null) {
            return this._geoIP.get(ip);
        }
        RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
        if (ri == null) {
            return null;
        }
        String s = this.getIPString(ri);
        if (s != null) {
            return this._geoIP.get(s);
        }
        return null;
    }

    private String getIPString(RouterInfo ri) {
        RouterAddress ra = ri.getTargetAddress("SSU");
        if (ra == null) {
            return null;
        }
        return ra.getOption("host");
    }

    @Override
    public String getCountryName(String c) {
        if (this._geoIP == null) {
            return c;
        }
        String n = this._geoIP.fullName(c);
        if (n == null) {
            return c;
        }
        return n;
    }

    @Override
    public String renderPeerHTML(Hash peer) {
        boolean found;
        String h = peer.toBase64().substring(0, 4);
        StringBuilder buf = new StringBuilder(128);
        String c = this.getCountry(peer);
        if (c != null) {
            String countryName = this.getCountryName(c);
            if (countryName.length() > 2) {
                countryName = Translate.getString((String)countryName, (I2PAppContext)this._context, (String)BUNDLE_NAME);
            }
            buf.append("<img height=\"11\" width=\"16\" alt=\"").append(c.toUpperCase(Locale.US)).append("\" title=\"");
            buf.append(countryName);
            buf.append("\" src=\"/flags.jsp?c=").append(c).append("\"> ");
        }
        buf.append("<tt>");
        boolean bl = found = this._context.netDb().lookupRouterInfoLocally(peer) != null;
        if (found) {
            buf.append("<a title=\"").append(this._("NetDb entry")).append("\" href=\"netdb?r=").append(h).append("\">");
        }
        buf.append(h);
        if (found) {
            buf.append("</a>");
        }
        buf.append("</tt>");
        return buf.toString();
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    private final String _(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)BUNDLE_NAME);
    }

    private void startTimestamper() {
        this._context.simpleScheduler().addPeriodicEvent((SimpleTimer.TimedEvent)new Timestamper(), 300000L, 600000L);
    }

    private class Lookup
    implements SimpleTimer.TimedEvent {
        private Lookup() {
        }

        public void timeReached() {
            CommSystemFacadeImpl.this._geoIP.blockingLookup();
        }
    }

    private class QueueAll
    implements SimpleTimer.TimedEvent {
        private QueueAll() {
        }

        public void timeReached() {
            Iterator<Hash> iter = CommSystemFacadeImpl.this._context.netDb().getAllRouters().iterator();
            while (iter.hasNext()) {
                String host;
                RouterInfo ri = CommSystemFacadeImpl.this._context.netDb().lookupRouterInfoLocally(iter.next());
                if (ri == null || (host = CommSystemFacadeImpl.this.getIPString(ri)) == null) continue;
                CommSystemFacadeImpl.this._geoIP.add(host);
            }
            CommSystemFacadeImpl.this._context.simpleScheduler().addPeriodicEvent((SimpleTimer.TimedEvent)new Lookup(), 5000L, 1800000L);
        }
    }

    private class Timestamper
    implements SimpleTimer.TimedEvent {
        private Timestamper() {
        }

        public void timeReached() {
            long peerOffset = CommSystemFacadeImpl.this.getFramedAveragePeerClockSkew(50);
            if (peerOffset == 0L) {
                return;
            }
            long currentOffset = CommSystemFacadeImpl.this._context.clock().getOffset();
            long newOffset = currentOffset - peerOffset;
            CommSystemFacadeImpl.this._context.clock().setOffset(newOffset);
        }
    }
}

