/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import net.i2p.data.Destination;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.util.Log;

class MessageReceivedJob
extends JobImpl {
    private final Log _log;
    private final ClientConnectionRunner _runner;
    private final Payload _payload;

    public MessageReceivedJob(RouterContext ctx, ClientConnectionRunner runner, Destination toDest, Destination fromDest, Payload payload) {
        super(ctx);
        this._log = ctx.logManager().getLog(MessageReceivedJob.class);
        this._runner = runner;
        this._payload = payload;
    }

    public String getName() {
        return "Deliver New Message";
    }

    public void runJob() {
        if (this._runner.isDead()) {
            return;
        }
        MessageId id = new MessageId();
        id.setMessageId((long)this._runner.getNextMessageId());
        this._runner.setPayload(id, this._payload);
        this.messageAvailable(id, this._payload.getSize());
    }

    public void messageAvailable(MessageId id, long size) {
        block3: {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending message available: " + id + " to sessionId " + this._runner.getSessionId() + " (with nonce=1)", (Throwable)new Exception("available"));
            }
            MessageStatusMessage msg = new MessageStatusMessage();
            msg.setMessageId(id.getMessageId());
            msg.setSessionId((long)this._runner.getSessionId().getSessionId());
            msg.setSize(size);
            msg.setNonce(1L);
            msg.setStatus(0);
            try {
                this._runner.doSend((I2CPMessage)msg);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(40)) break block3;
                this._log.error("Error writing out the message status message", (Throwable)ime);
            }
        }
    }
}

